/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.springframework.security.web.header.HeaderWriter;

public class XRobotsTagHeaderWriter
implements HeaderWriter {
    public static final String X_ROBOTS_TAG_HEADER = "X-Robots-Tag";
    private List<XRobotsTagMode> modes;

    public XRobotsTagHeaderWriter(XRobotsTagMode ... modes) {
        this.modes = Arrays.asList(modes);
    }

    public void writeHeaders(HttpServletRequest request, @NonNull HttpServletResponse response) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        ArrayList<String> values = new ArrayList<String>();
        for (XRobotsTagMode mode : this.modes) {
            values.add(mode.getValue());
        }
        response.addHeader(X_ROBOTS_TAG_HEADER, String.join((CharSequence)", ", values));
    }

    public static enum XRobotsTagMode {
        ALL,
        NOINDEX,
        NOFOLLOW,
        NONE,
        NOARCHIVE,
        NOSNIPPET,
        NOODP,
        NOTRANSLATE,
        NOIMAGEINDEX;


        protected String getValue() {
            return this.name().toLowerCase();
        }
    }
}

