/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import lombok.NonNull;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.RedirectView;

public class XView
extends ModelAndView {
    private static final String PATH_SEPARATOR = "/";
    private static final String PATH_SEPARATOR_PATTERN = "/+";

    protected XView(String path) {
        super(path);
    }

    protected XView(View view) {
        super(view);
    }

    public static XView template(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return new XView(path.replaceFirst("^/+", ""));
    }

    public static XView template(@NonNull Object controller, String path) {
        if (controller == null) {
            throw new NullPointerException("controller");
        }
        return XView.template(controller.getClass(), path);
    }

    public static XView template(Class<?> controllerClass, String path) {
        return XView.template(XView.getRequestMappingPath(controllerClass, path));
    }

    public static XView redirect(String path) {
        RedirectView delegate = new RedirectView(path);
        delegate.setHttp10Compatible(false);
        delegate.setExposeModelAttributes(false);
        return new XView((View)delegate);
    }

    public static XView redirect(HttpStatus status, String path) {
        RedirectView delegate = new RedirectView(path);
        delegate.setStatusCode(status);
        delegate.setHttp10Compatible(false);
        delegate.setExposeModelAttributes(false);
        return new XView((View)delegate);
    }

    public static XView redirect(@NonNull Object controller, String path) {
        if (controller == null) {
            throw new NullPointerException("controller");
        }
        return XView.redirect(controller.getClass(), path);
    }

    public static XView redirect(Class<?> controllerClass, String path) {
        return XView.redirect(XView.getRequestMappingPath(controllerClass, path));
    }

    public static XView forward(String path) {
        return new XView((View)new InternalResourceView(path));
    }

    protected static String getRequestMappingPath(Class<?> controllerClass, String path) {
        String url = path;
        if (controllerClass != null) {
            url = XView.getRequestMappingPath(controllerClass) + PATH_SEPARATOR + path;
        }
        return url.replaceAll(PATH_SEPARATOR_PATTERN, PATH_SEPARATOR);
    }

    protected static String getRequestMappingPath(Class<?> controllerClass) {
        RequestMapping annotation = (RequestMapping)AnnotationUtils.getAnnotation(controllerClass, RequestMapping.class);
        if (annotation == null) {
            return "";
        }
        String[] paths = annotation.value();
        if (paths.length == 0) {
            return "";
        }
        return paths[0];
    }
}

