/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.LoggingInterceptor;
import org.springframework.web.client.RestTemplate;

public class LoggingInterceptorCustomizer
implements RestTemplateCustomizer {
    @NonNull
    private final Logger logger;

    public LoggingInterceptorCustomizer() {
        this(LoggerFactory.getLogger(RestTemplate.class));
    }

    public void customize(RestTemplate restTemplate) {
        new RestTemplateBuilder(new RestTemplateCustomizer[0]).additionalInterceptors(new ClientHttpRequestInterceptor[]{new LoggingInterceptor(this.logger).setShowBody(this.isShowBody())}).configure(restTemplate);
    }

    protected boolean isShowBody() {
        Logger showBody = LoggerFactory.getLogger((String)(this.logger.getName() + ".showBody"));
        return showBody.isTraceEnabled() || showBody.isDebugEnabled() || showBody.isInfoEnabled() || showBody.isWarnEnabled() || showBody.isErrorEnabled();
    }

    public LoggingInterceptorCustomizer(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked @NonNull but is null");
        }
        this.logger = logger;
    }
}

