/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.CustomClientHttpResponse;
import org.springframework.util.FileCopyUtils;

public class ContentCachingClientHttpResponse
extends CustomClientHttpResponse {
    private byte[] body;

    public ContentCachingClientHttpResponse(ClientHttpResponse delegate) {
        super(delegate);
    }

    @Override
    public InputStream getBody() throws IOException {
        if (this.body == null) {
            try (InputStream stream = super.getBody();){
                this.body = FileCopyUtils.copyToByteArray((InputStream)stream);
            }
            catch (HttpRetryException e) {
                this.body = String.format("(Failed to get body: %s)", e.getMessage()).getBytes();
            }
        }
        return new ByteArrayInputStream(this.body);
    }
}

