/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpResponses;
import org.springframework.http.client.SimpleClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponses;
import org.springframework.util.StreamUtils;

public class CustomClientHttpResponse
extends AbstractClientHttpResponse {
    @NonNull
    private final ClientHttpResponse delegate;

    public String getStatusLine() throws IOException {
        if (this.delegate instanceof SimpleClientHttpResponse) {
            return SimpleClientHttpResponses.getStatusLine((SimpleClientHttpResponse)this.delegate);
        }
        if (this.delegate instanceof HttpComponentsClientHttpResponse) {
            return HttpComponentsClientHttpResponses.getStatusLine((HttpComponentsClientHttpResponse)this.delegate);
        }
        throw new IOException(String.format("Unsupported client: %s", this.delegate.getClass()));
    }

    public String getHttpVersion() throws IOException {
        String statusLine = this.getStatusLine();
        Matcher matcher = Pattern.compile("(HTTP/[0-9.]+)").matcher(statusLine);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IOException(String.format("HTTP version not found: %s", statusLine));
    }

    public int getRawStatusCode() throws IOException {
        return this.delegate.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.delegate.getStatusText();
    }

    public HttpHeaders getHeaders() {
        return this.delegate.getHeaders();
    }

    public InputStream getBody() throws IOException {
        return this.delegate.getBody();
    }

    public String getBodyAsString() throws IOException {
        return this.getBodyAsString(StandardCharsets.UTF_8);
    }

    public String getBodyAsString(Charset charset) throws IOException {
        return StreamUtils.copyToString((InputStream)this.getBody(), (Charset)charset);
    }

    public void close() {
        this.delegate.close();
    }

    public CustomClientHttpResponse(@NonNull ClientHttpResponse delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked @NonNull but is null");
        }
        this.delegate = delegate;
    }
}

