/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.ContentCachingClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class LoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final String DEFAULT_LOG_START_SEPARATOR = "-->";
    private static final String DEFAULT_LOG_END_SEPARATOR = "<--";
    @NonNull
    private final InternalLogger logger;
    private boolean showBody;
    @NonNull
    private Charset defaultBodyCharset = StandardCharsets.UTF_8;
    @NonNull
    private String logStartSeparator = "-->";
    @NonNull
    private String logEndSeparator = "<--";

    public LoggingInterceptor(Logger logger) {
        this.logger = new InternalLogger(logger);
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        if (execution == null) {
            throw new NullPointerException("execution is marked @NonNull but is null");
        }
        if (this.logger.isEnabled()) {
            this.logRequest(request, body);
        }
        Object response = execution.execute(request, body);
        if (this.logger.isEnabled()) {
            if (!ContentCachingClientHttpResponse.class.isInstance(response)) {
                response = new ContentCachingClientHttpResponse((ClientHttpResponse)response);
            }
            this.logResponse((ContentCachingClientHttpResponse)((Object)response));
        }
        return response;
    }

    protected synchronized void logRequest(@NonNull HttpRequest request, @NonNull byte[] body) {
        if (request == null) {
            throw new NullPointerException("request is marked @NonNull but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked @NonNull but is null");
        }
        if (StringUtils.hasText((String)this.logStartSeparator)) {
            this.logger.log(this.logStartSeparator);
        }
        this.logger.log(String.join((CharSequence)" ", request.getMethod().name(), request.getURI().toString()));
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.logger.log(String.join((CharSequence)": ", (CharSequence)entry.getKey(), value));
            }
        }
        if (this.showBody && body.length > 0) {
            this.logger.log("");
            this.logger.log(new String(body, this.defaultBodyCharset));
        }
        if (StringUtils.hasText((String)this.logEndSeparator)) {
            this.logger.log(this.logEndSeparator);
        }
    }

    protected synchronized void logResponse(@NonNull ContentCachingClientHttpResponse response) throws IOException {
        byte[] body;
        if (response == null) {
            throw new NullPointerException("response is marked @NonNull but is null");
        }
        if (StringUtils.hasText((String)this.logStartSeparator)) {
            this.logger.log(this.logStartSeparator);
        }
        this.logger.log(response.getStatusLine());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.logger.log(String.join((CharSequence)": ", (CharSequence)entry.getKey(), value));
            }
        }
        MediaType mediaType = response.getHeaders().getContentType();
        if (this.showBody && mediaType != null && (body = FileCopyUtils.copyToByteArray((InputStream)response.getBody())).length > 0) {
            Charset charset = mediaType.getCharset();
            if (charset == null) {
                charset = this.defaultBodyCharset;
            }
            this.logger.log("");
            this.logger.log(new String(body, charset));
        }
        if (StringUtils.hasText((String)this.logEndSeparator)) {
            this.logger.log(this.logEndSeparator);
        }
    }

    public LoggingInterceptor setShowBody(boolean showBody) {
        this.showBody = showBody;
        return this;
    }

    public LoggingInterceptor setDefaultBodyCharset(@NonNull Charset defaultBodyCharset) {
        if (defaultBodyCharset == null) {
            throw new NullPointerException("defaultBodyCharset is marked @NonNull but is null");
        }
        this.defaultBodyCharset = defaultBodyCharset;
        return this;
    }

    public LoggingInterceptor setLogStartSeparator(@NonNull String logStartSeparator) {
        if (logStartSeparator == null) {
            throw new NullPointerException("logStartSeparator is marked @NonNull but is null");
        }
        this.logStartSeparator = logStartSeparator;
        return this;
    }

    public LoggingInterceptor setLogEndSeparator(@NonNull String logEndSeparator) {
        if (logEndSeparator == null) {
            throw new NullPointerException("logEndSeparator is marked @NonNull but is null");
        }
        this.logEndSeparator = logEndSeparator;
        return this;
    }

    protected static class InternalLogger {
        @NonNull
        private final Logger logger;

        public boolean isEnabled() {
            return this.logger.isTraceEnabled() || this.logger.isDebugEnabled() || this.logger.isInfoEnabled() || this.logger.isWarnEnabled() || this.logger.isErrorEnabled();
        }

        public void log(String message) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(message);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug(message);
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info(message);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn(message);
            } else if (this.logger.isErrorEnabled()) {
                this.logger.error(message);
            }
        }

        public InternalLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked @NonNull but is null");
            }
            this.logger = logger;
        }
    }
}

