/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import lombok.NonNull;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.CustomRestOperations;
import org.springframework.web.client.RestTemplate;

public class CustomRestTemplate
extends RestTemplate
implements CustomRestOperations {
    public static MappingJackson2HttpMessageConverter getMappingJackson2HttpMessageConverter(@NonNull RestTemplate restTemplate) throws IllegalStateException {
        if (restTemplate == null) {
            throw new NullPointerException("restTemplate is marked @NonNull but is null");
        }
        for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            return (MappingJackson2HttpMessageConverter)converter;
        }
        throw new IllegalStateException("'MappingJackson2HttpMessageConverter' not found in 'RestTemplate'");
    }
}

