/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.sampullara.mustache.Code;
import com.sampullara.mustache.CodeFactory;
import com.sampullara.mustache.FunctionIterator;
import com.sampullara.mustache.Mustache;
import com.sampullara.mustache.MustacheException;
import com.sampullara.mustache.Scope;
import com.sampullara.mustache.WriteCode;
import com.sampullara.util.FutureWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class BuilderCodeFactory
implements CodeFactory {
    @Override
    public Code iterable(Mustache m, String variable, List<Code> codes, String file, int line) {
        return new IterableCode(m, variable, codes, file, line);
    }

    @Override
    public Code function(Mustache m, String variable, List<Code> codes, String file, int line) {
        return new FunctionCode(m, variable, codes, file, line);
    }

    @Override
    public Code ifIterable(Mustache m, String variable, List<Code> codes, String file, int line) {
        return new IfIterableCode(m, variable, codes, file, line);
    }

    @Override
    public Code notIterable(Mustache m, String variable, List<Code> codes, String file, int line) {
        return new InvertedIterableCode(m, variable, codes, file, line);
    }

    @Override
    public Code partial(Mustache m, String variable, String file, int line) throws MustacheException {
        return new PartialCode(m, variable, file, line);
    }

    @Override
    public Code value(Mustache m, String name, boolean encode, int line) {
        return new WriteValueCode(m, name, encode, line);
    }

    @Override
    public Code write(String s, int line) {
        return new DefaultWriteCode(s, line);
    }

    @Override
    public Code eof(int line) {
        return new EOFCode(line);
    }

    @Override
    public Code extend(Mustache m, String variable, List<Code> codes, String file, int i) throws MustacheException {
        return new ExtendCode(m, variable, codes, file, i);
    }

    @Override
    public Code name(Mustache m, String variable, List<Code> codes, String file, int i) {
        return new ExtendNameCode(m, variable, codes, file, i);
    }

    private static String unexecuteValueCode(Mustache m, Scope current, String text, AtomicInteger position, Code[] next, boolean encoded) throws MustacheException {
        AtomicInteger probePosition = new AtomicInteger(position.get());
        Code[] truncate = Mustache.truncate((Code[])next, (int)1, null);
        Scope result = null;
        int lastposition = position.get();
        while (next.length > 0 && probePosition.get() < text.length()) {
            lastposition = probePosition.get();
            result = next[0].unexecute(current, text, probePosition, truncate);
            if (result != null) break;
            probePosition.incrementAndGet();
        }
        if (result != null) {
            String value = text.substring(position.get(), lastposition);
            if (encoded) {
                value = m.decode(value);
            }
            position.set(lastposition);
            return value;
        }
        return null;
    }

    private static void put(Scope result, String name, Object value) {
        String[] splits = name.split("[.]");
        Scope depth = result;
        for (int i = 0; i < splits.length; ++i) {
            if (i < splits.length - 1) {
                Scope tmp = (Scope)result.get((Object)splits[i]);
                if (tmp == null) {
                    tmp = new Scope();
                }
                depth.put((Object)splits[i], (Object)tmp);
                depth = tmp;
                continue;
            }
            depth.put((Object)splits[i], value);
        }
    }

    private static class DefaultWriteCode
    implements WriteCode {
        private final StringBuffer rest;
        private final int line;

        public DefaultWriteCode(String rest, int line) {
            this.rest = new StringBuffer(rest);
            this.line = line;
        }

        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            try {
                fw.write(this.rest.toString());
            }
            catch (IOException e) {
                throw new MustacheException("Failed to write", (Exception)e);
            }
        }

        public int getLine() {
            return this.line;
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            if (position.get() + this.rest.length() <= text.length()) {
                String substring = text.substring(position.get(), position.get() + this.rest.length());
                if (this.rest.toString().equals(substring)) {
                    position.addAndGet(this.rest.length());
                    return current;
                }
            }
            return null;
        }

        public void identity(FutureWriter fw) throws MustacheException {
            this.execute(fw, null);
        }

        @Override
        public void append(String append) {
            this.rest.append(append);
        }
    }

    private static class EOFCode
    implements Code {
        private final int line;

        public EOFCode(int line) {
            this.line = line;
        }

        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
        }

        public int getLine() {
            return this.line;
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            position.set(text.length());
            return current;
        }

        public void identity(FutureWriter fw) throws MustacheException {
        }
    }

    private static class WriteValueCode
    implements Code {
        private final Mustache m;
        private final String name;
        private final boolean encoded;
        private final int line;

        public WriteValueCode(Mustache m, String name, boolean encoded, int line) {
            this.m = m;
            this.name = name;
            this.encoded = encoded;
            this.line = line;
        }

        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            this.m.write((Writer)fw, scope, this.name, this.encoded);
        }

        public int getLine() {
            return this.line;
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            String value = BuilderCodeFactory.unexecuteValueCode(this.m, current, text, position, next, this.encoded);
            if (value != null) {
                BuilderCodeFactory.put(current, this.name, value);
                return current;
            }
            return null;
        }

        public void identity(FutureWriter fw) throws MustacheException {
            try {
                if (!this.encoded) {
                    fw.append((CharSequence)"{");
                }
                fw.append((CharSequence)"{{").append(this.name).append("}}");
                if (!this.encoded) {
                    fw.append((CharSequence)"}");
                }
            }
            catch (IOException e) {
                throw new MustacheException((Exception)e);
            }
        }
    }

    private static class ExtendNameCode
    extends ExtendBaseCode {
        public ExtendNameCode(Mustache m, String variable, List<Code> codes, String file, int line) {
            super(m, variable, codes, file, line);
        }

        @Override
        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            this.execute(fw, Arrays.asList(scope));
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            for (int i = 0; i < this.codes.length; ++i) {
                if (Mustache.debug) {
                    Mustache.line.set(this.codes[i].getLine());
                }
                Code[] truncate = Mustache.truncate((Code[])this.codes, (int)(i + 1), (Code[])next);
                current = this.codes[i].unexecute(current, text, position, truncate);
            }
            return current;
        }
    }

    private static class ExtendCode
    extends ExtendBaseCode {
        private Mustache partial;

        public ExtendCode(Mustache m, String variable, List<Code> codes, String file, int line) throws MustacheException {
            super(m, variable, codes, file, line);
            HashMap<String, ExtendNameCode> replaceMap = new HashMap<String, ExtendNameCode>();
            for (Code code : codes) {
                if (code instanceof ExtendNameCode) {
                    ExtendNameCode erc = (ExtendNameCode)code;
                    replaceMap.put(erc.getName(), erc);
                    continue;
                }
                if (code instanceof WriteCode) continue;
                throw new IllegalArgumentException("Illegal code in extend section: " + code.getClass().getName());
            }
            HashMap<String, ExtendNameCode> debugMap = null;
            if (Mustache.debug) {
                debugMap = new HashMap<String, ExtendNameCode>(replaceMap);
            }
            this.partial = m.partial(variable);
            Code[] supercodes = this.partial.getCompiled();
            this.replaceCode(supercodes, replaceMap, debugMap);
            if (Mustache.debug && debugMap != null && debugMap.size() > 0) {
                throw new MustacheException("Replacement sections failed to match named sections: " + debugMap.keySet());
            }
        }

        private void replaceCode(Code[] supercodes, Map<String, ExtendNameCode> replaceMap, Map<String, ExtendNameCode> debugMap) {
            for (int i = 0; i < supercodes.length; ++i) {
                Code code = supercodes[i];
                if (code instanceof ExtendNameCode) {
                    ExtendNameCode enc = (ExtendNameCode)code;
                    ExtendNameCode extendReplaceCode = replaceMap.get(enc.getName());
                    if (extendReplaceCode != null) {
                        supercodes[i] = extendReplaceCode;
                        continue;
                    }
                    if (Mustache.debug) {
                        debugMap.remove(enc.getName());
                    }
                    this.replaceCode(enc.codes, replaceMap, debugMap);
                    continue;
                }
                if (!(code instanceof SubCode)) continue;
                SubCode subcode = (SubCode)code;
                this.replaceCode(subcode.codes, replaceMap, debugMap);
            }
        }

        @Override
        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            Code[] supercodes;
            for (Code code : supercodes = this.partial.getCompiled()) {
                code.execute(fw, scope);
            }
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            Code[] supercodes = this.partial.getCompiled();
            for (int i = 0; i < supercodes.length; ++i) {
                Code[] truncate = Mustache.truncate((Code[])supercodes, (int)(i + 1), (Code[])next);
                supercodes[i].unexecute(current, text, position, truncate);
            }
            return current;
        }
    }

    private static abstract class ExtendBaseCode
    extends SubCode {
        public ExtendBaseCode(Mustache m, String variable, List<Code> codes, String file, int line) {
            super("<", m, variable, codes, file, line);
        }

        public String getName() {
            return this.variable;
        }
    }

    private static class PartialCode
    implements Code {
        private final String variable;
        private Mustache m;
        private final String file;
        private final int line;
        private volatile Mustache partial;

        public PartialCode(Mustache m, String variable, String file, int line) throws MustacheException {
            this.variable = variable;
            this.m = m;
            this.file = file;
            this.line = line;
            this.partial = m.partial(variable);
        }

        public void execute(FutureWriter fw, final Scope scope) throws MustacheException {
            try {
                fw.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        FutureWriter fw = new FutureWriter();
                        PartialCode.this.partial.partial(fw, scope, PartialCode.this.variable, PartialCode.this.partial);
                        return fw;
                    }
                });
            }
            catch (IOException e) {
                throw new MustacheException("Execution failed: " + this.file + ":" + this.line, (Exception)e);
            }
        }

        public int getLine() {
            return this.line;
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            Mustache partial = this.m.partial(this.variable);
            Code[] compiled = partial.getCompiled();
            Scope unexecuted = new Scope();
            for (int i = 0; i < compiled.length && unexecuted != null && !(compiled[i] instanceof EOFCode); ++i) {
                Code[] truncate = Mustache.truncate((Code[])compiled, (int)(i + 1), (Code[])new Code[0]);
                unexecuted = compiled[i].unexecute(unexecuted, text, position, truncate);
            }
            if (unexecuted != null) {
                BuilderCodeFactory.put(current, this.variable, unexecuted);
            }
            return current;
        }

        public void identity(FutureWriter fw) throws MustacheException {
            try {
                fw.append((CharSequence)"{{>").append(this.variable).append("}}");
            }
            catch (IOException e) {
                throw new MustacheException("Failed", (Exception)e);
            }
        }
    }

    private static class InvertedIterableCode
    extends SubCode {
        public InvertedIterableCode(Mustache m, String variable, List<Code> codes, String file, int line) {
            super("^", m, variable, codes, file, line);
        }

        @Override
        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            fw = this.m.pushWriter(fw);
            this.execute(fw, this.m.inverted(scope, this.variable));
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            Scope result = new Scope();
            for (int i = 0; i < this.codes.length && result != null; ++i) {
                if (Mustache.debug) {
                    Mustache.line.set(this.codes[i].getLine());
                }
                Code[] truncate = Mustache.truncate((Code[])this.codes, (int)(i + 1), (Code[])next);
                result = this.codes[i].unexecute(result, text, position, truncate);
            }
            if (result != null) {
                current.putAll((Map)result);
                BuilderCodeFactory.put(current, this.variable, false);
            }
            return current;
        }
    }

    private static class IfIterableCode
    extends SubCode {
        public IfIterableCode(Mustache m, String variable, List<Code> codes, String file, int line) {
            super("?", m, variable, codes, file, line);
        }

        @Override
        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            fw = this.m.pushWriter(fw);
            this.execute(fw, this.m.ifiterable(scope, this.variable));
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            Scope result = new Scope();
            for (int i = 0; i < this.codes.length && result != null; ++i) {
                if (Mustache.debug) {
                    Mustache.line.set(this.codes[i].getLine());
                }
                Code[] truncate = Mustache.truncate((Code[])this.codes, (int)(i + 1), (Code[])next);
                result = this.codes[i].unexecute(result, text, position, truncate);
            }
            if (result != null && result.size() > 0) {
                BuilderCodeFactory.put(current, this.variable, result);
            }
            return current;
        }
    }

    private static class FunctionCode
    extends SubCode {
        public FunctionCode(Mustache m, String variable, List<Code> codes, String file, int line) {
            super("_", m, variable, codes, file, line);
        }

        @Override
        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            Object function = this.m.getValue(scope, this.variable);
            if (function instanceof Function) {
                this.execute(fw, (Iterable<Scope>)this.m.function(scope, (Function)function));
            } else if (function == null) {
                this.execute(fw, Lists.newArrayList((Object[])new Scope[]{scope}));
            } else {
                throw new MustacheException("Not a function: " + function);
            }
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            String value = BuilderCodeFactory.unexecuteValueCode(this.m, current, text, position, next, false);
            if (value == null) {
                return null;
            }
            Scope function = (Scope)current.get((Object)this.variable);
            if (function == null) {
                function = new UnexecuteFunction();
                BuilderCodeFactory.put(current, this.variable, function);
            }
            StringWriter sw = new StringWriter();
            FutureWriter fw = new FutureWriter((Writer)sw);
            try {
                for (Code code : this.codes) {
                    code.execute(fw, current);
                }
                fw.flush();
            }
            catch (IOException e) {
                throw new MustacheException("Failed to evaluate function body", (Exception)e);
            }
            function.put((Object)sw.toString(), (Object)value);
            return current;
        }

        private static class UnexecuteFunction
        extends Scope
        implements Function<String, String> {
            private UnexecuteFunction() {
            }

            public String apply(String input) {
                Object o = this.get(input);
                return o == null ? "" : o.toString();
            }
        }
    }

    private static class IterableCode
    extends SubCode {
        public IterableCode(Mustache m, String variable, List<Code> codes, String file, int line) {
            super("#", m, variable, codes, file, line);
        }

        @Override
        public void execute(FutureWriter fw, Scope scope) throws MustacheException {
            this.execute(fw, this.m.iterable(scope, this.variable));
        }

        public Scope unexecute(Scope current, String text, AtomicInteger position, Code[] next) throws MustacheException {
            int start;
            ArrayList<Scope> results = new ArrayList<Scope>();
            while (true) {
                start = position.get();
                Scope result = new Scope();
                for (int i = 0; i < this.codes.length && result != null; ++i) {
                    if (Mustache.debug) {
                        Mustache.line.set(this.codes[i].getLine());
                    }
                    Code[] truncate = Mustache.truncate((Code[])this.codes, (int)(i + 1), (Code[])next);
                    result = this.codes[i].unexecute(result, text, position, truncate);
                }
                if (result == null || result.size() <= 0) break;
                results.add(result);
            }
            position.set(start);
            if (results.size() != 0) {
                current.put((Object)this.variable, results);
            }
            return current;
        }
    }

    private static abstract class SubCode
    implements Code {
        protected final String marker;
        protected final Mustache m;
        protected final String variable;
        protected final Code[] codes;
        protected final int line;
        protected final String file;

        public SubCode(String marker, Mustache m, String variable, List<Code> codes, String file, int line) {
            this.marker = marker;
            this.m = m;
            this.variable = variable;
            this.codes = new ArrayList<Code>(codes).toArray(new Code[codes.size()]);
            this.line = line;
            this.file = file;
        }

        public abstract void execute(FutureWriter var1, Scope var2) throws MustacheException;

        protected void execute(FutureWriter fw, final Iterable<Scope> iterable) throws MustacheException {
            if (iterable != null) {
                for (final Scope subScope : iterable) {
                    try {
                        fw = this.m.pushWriter(fw);
                        fw.enqueue((Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                FutureWriter writer = new FutureWriter();
                                for (Code code : SubCode.this.codes) {
                                    if (Mustache.debug) {
                                        Mustache.line.set(code.getLine());
                                    }
                                    if (iterable instanceof FunctionIterator && ((FunctionIterator)iterable).isTemplateFunction()) {
                                        code.identity(writer);
                                        continue;
                                    }
                                    code.execute(writer, subScope);
                                }
                                return writer;
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new MustacheException("Execution failed: " + this.file + ":" + this.line, (Exception)e);
                    }
                }
            }
        }

        public int getLine() {
            return this.line;
        }

        public void identity(FutureWriter fw) throws MustacheException {
            try {
                fw.append((CharSequence)"{{").append(this.marker).append(this.variable).append("}}");
                for (Code code : this.codes) {
                    if (Mustache.debug) {
                        Mustache.line.set(code.getLine());
                    }
                    code.identity(fw);
                }
                fw.append((CharSequence)"{{/").append(this.variable).append("}}");
            }
            catch (IOException e) {
                throw new MustacheException("Failed to write", (Exception)e);
            }
        }
    }
}

