/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import redis.netty4.Reply;
import redis.util.Encoding;

public class InlineReply
implements Reply<Object> {
    private final Object o;

    public InlineReply(Object o) {
        this.o = o;
    }

    @Override
    public Object data() {
        return this.o;
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        if (this.o == null) {
            os.writeBytes(CRLF);
        } else if (this.o instanceof String) {
            os.writeByte(43);
            os.writeBytes(((String)this.o).getBytes(Charsets.US_ASCII));
            os.writeBytes(CRLF);
        } else if (this.o instanceof ByteBuf) {
            os.writeByte(43);
            os.writeBytes(((ByteBuf)this.o).array());
            os.writeBytes(CRLF);
        } else if (this.o instanceof byte[]) {
            os.writeByte(43);
            os.writeBytes((byte[])this.o);
            os.writeBytes(CRLF);
        } else if (this.o instanceof Long) {
            os.writeByte(58);
            os.writeBytes(Encoding.numToBytes((long)((Long)this.o), (boolean)true));
        } else {
            os.writeBytes("ERR invalid inline response".getBytes(Charsets.US_ASCII));
            os.writeBytes(CRLF);
        }
    }
}

