/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import redis.netty4.Reply;
import redis.util.Encoding;

public class IntegerReply
implements Reply<Long> {
    public static final char MARKER = ':';
    private final long integer;
    private static IntegerReply[] replies = new IntegerReply[512];

    public static IntegerReply integer(long integer) {
        if (integer > -256L && integer < 256L) {
            return replies[(int)(integer + 255L)];
        }
        return new IntegerReply(integer);
    }

    public IntegerReply(long integer) {
        this.integer = integer;
    }

    @Override
    public Long data() {
        return this.integer;
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(58);
        os.writeBytes(Encoding.numToBytes((long)this.integer, (boolean)true));
    }

    public String toString() {
        return this.data().toString();
    }

    static {
        for (int i = -255; i < 256; ++i) {
            IntegerReply.replies[i + 255] = new IntegerReply(i);
        }
    }
}

