/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.netty4.BulkReply;
import redis.netty4.RedisReplyDecoder;
import redis.netty4.Reply;
import redis.util.Encoding;

public class MultiBulkReply
implements Reply<Reply[]> {
    public static final char MARKER = '*';
    public static final MultiBulkReply EMPTY = new MultiBulkReply(new Reply[0]);
    private final Reply[] replies;
    private final int size;
    private int index = 0;

    public MultiBulkReply(RedisReplyDecoder rd, ByteBuf is) throws IOException {
        long l = RedisReplyDecoder.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        this.size = (int)l;
        if (this.size == -1) {
            this.replies = null;
        } else {
            if (this.size < 0) {
                throw new IllegalArgumentException("Invalid size: " + this.size);
            }
            this.replies = new Reply[this.size];
            this.read(rd, is);
        }
    }

    public void read(RedisReplyDecoder rd, ByteBuf is) throws IOException {
        for (int i = this.index; i < this.size; ++i) {
            this.replies[i] = rd.receive(is);
            this.index = i + 1;
            rd.checkpoint();
        }
    }

    public MultiBulkReply(Reply[] replies) {
        this.replies = replies;
        this.size = replies.length;
    }

    @Override
    public Reply[] data() {
        return this.replies;
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(42);
        if (this.replies == null) {
            os.writeBytes(Encoding.NEG_ONE_WITH_CRLF);
        } else {
            os.writeBytes(Encoding.numToBytes((long)this.replies.length, (boolean)true));
            for (Reply reply : this.replies) {
                reply.write(os);
            }
        }
    }

    public List<String> asStringList(Charset charset) {
        if (this.replies == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(this.replies.length);
        for (Reply reply : this.replies) {
            if (!(reply instanceof BulkReply)) {
                throw new IllegalArgumentException("Could not convert " + reply + " to a string");
            }
            strings.add(((BulkReply)reply).asString(charset));
        }
        return strings;
    }

    public Set<String> asStringSet(Charset charset) {
        if (this.replies == null) {
            return null;
        }
        HashSet<String> strings = new HashSet<String>(this.replies.length);
        for (Reply reply : this.replies) {
            if (!(reply instanceof BulkReply)) {
                throw new IllegalArgumentException("Could not convert " + reply + " to a string");
            }
            strings.add(((BulkReply)reply).asString(charset));
        }
        return strings;
    }

    public Map<String, String> asStringMap(Charset charset) {
        if (this.replies == null) {
            return null;
        }
        int length = this.replies.length;
        HashMap<String, String> map = new HashMap<String, String>(length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of replies");
        }
        for (int i = 0; i < length; i += 2) {
            Reply key = this.replies[i];
            Reply value = this.replies[i + 1];
            if (key instanceof BulkReply) {
                if (!(value instanceof BulkReply)) {
                    throw new IllegalArgumentException("Could not convert value: " + value + " to a string");
                }
            } else {
                throw new IllegalArgumentException("Could not convert key: " + key + " to a string");
            }
            map.put(((BulkReply)key).asString(charset), ((BulkReply)value).asString(charset));
        }
        return map;
    }

    public String toString() {
        return this.asStringList(Charsets.UTF_8).toString();
    }
}

