/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufIndexFinder;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.io.IOException;
import redis.netty4.BulkReply;
import redis.netty4.ErrorReply;
import redis.netty4.IntegerReply;
import redis.netty4.MultiBulkReply;
import redis.netty4.Reply;
import redis.netty4.StatusReply;

public class RedisReplyDecoder
extends ReplayingDecoder<Void> {
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final char ZERO = '0';
    private MultiBulkReply reply;
    private boolean checkpointEnabled;

    public RedisReplyDecoder() {
        this(true);
    }

    public RedisReplyDecoder(boolean checkpointEnabled) {
        this.checkpointEnabled = checkpointEnabled;
    }

    public ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = RedisReplyDecoder.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    public static long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }

    public Reply receive(ByteBuf is) throws IOException {
        byte code = is.readByte();
        switch (code) {
            case 43: {
                String status = is.readBytes(is.bytesBefore(ByteBufIndexFinder.CRLF)).toString(Charsets.UTF_8);
                is.skipBytes(2);
                return new StatusReply(status);
            }
            case 45: {
                String error = is.readBytes(is.bytesBefore(ByteBufIndexFinder.CRLF)).toString(Charsets.UTF_8);
                is.skipBytes(2);
                return new ErrorReply(error);
            }
            case 58: {
                return new IntegerReply(RedisReplyDecoder.readLong(is));
            }
            case 36: {
                return new BulkReply(this.readBytes(is));
            }
            case 42: {
                return this.decodeMultiBulkReply(is);
            }
        }
        throw new IOException("Unexpected character in stream: " + code);
    }

    public void checkpoint() {
        if (this.checkpointEnabled) {
            super.checkpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiBulkReply decodeMultiBulkReply(ByteBuf is) throws IOException {
        try {
            if (this.reply == null) {
                this.reply = new MultiBulkReply(this, is);
            } else {
                this.reply.read(this, is);
            }
            MultiBulkReply multiBulkReply = this.reply;
            return multiBulkReply;
        }
        finally {
            this.reply = null;
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, MessageBuf<Object> out) throws Exception {
        out.add((Object)this.receive(in));
    }
}

