/*
 * Decompiled with CFR 0.152.
 */
package com.github.spyhunter99.pdf.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.text.AttributeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.AbstractDocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Writer;
import org.apache.maven.doxia.index.IndexEntry;
import org.apache.maven.doxia.index.IndexingSink;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pdf.DocumentDescriptorReader;
import org.apache.maven.plugins.pdf.DocumentModelBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.reporting.exec.MavenReportExecutor;
import org.apache.maven.reporting.exec.MavenReportExecutorRequest;
import org.apache.maven.settings.Settings;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="pdf", threadSafe=true)
public class PdfMojo
extends AbstractMojo
implements Contextualizable {
    private static final String EOL = System.getProperty("line.separator");
    @Component(hint="fo")
    private PdfRenderer foRenderer;
    @Component
    private I18N i18n;
    @Component(hint="itext")
    private PdfRenderer itextRenderer;
    @Parameter(property="locales")
    private String locales;
    @Component
    private Renderer siteRenderer;
    @Component
    private SiteTool siteTool;
    @Component(role=PluginManager.class)
    private PluginManager pluginManager;
    @Component
    private Doxia doxia;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${basedir}/src/site", required=true)
    private File siteDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-site", required=true)
    private File generatedSiteDirectory;
    @Parameter(defaultValue="${project.build.directory}/pdf", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/pdf", required=true)
    private File workingDirectory;
    @Parameter(defaultValue="src/site/pdf.xml")
    private File docDescriptor;
    @Parameter(property="implementation", defaultValue="fo", required=true)
    private String implementation;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="aggregate", defaultValue="true")
    private boolean aggregate;
    @Parameter(defaultValue="${plugin.version}", readonly=true)
    private String pluginVersion;
    @Parameter(property="includeReports", defaultValue="true")
    private boolean includeReports;
    @Parameter(property="generateTOC", defaultValue="start")
    private String generateTOC;
    @Parameter(property="validate", defaultValue="false")
    private boolean validate;
    @Parameter(defaultValue="${reports}", required=true, readonly=true)
    private MavenReport[] reports;
    @Parameter(readonly=true)
    private org.apache.maven.reporting.exec.ReportPlugin[] reportPlugins;
    @Parameter(property="executiveSummaryName", defaultValue="Executive Summary", readonly=false)
    private String executiveSummaryName;
    @Parameter(property="titleHeader", defaultValue="", readonly=false)
    private String titleHeader;
    @Parameter(property="distributionStatement", defaultValue="", readonly=false)
    private String distributionStatement;
    @Parameter(property="pdfHeader")
    private String pdfHeader;
    @Parameter(property="pdfFooter")
    private String pdfFooter;
    @Parameter(property="tocMaxDepthToPrint")
    private String tocMaxDepthToPrint = null;
    @Parameter(property="pdfCoverDate")
    private String pdfCoverDate;
    @Parameter(property="foStylesOverride")
    private File foStylesOverride;
    private DocumentRenderer docRenderer;
    private Locale defaultLocale;
    private List<Locale> localesList;
    private DecorationModel defaultDecorationModel;
    private File siteDirectoryTmp;
    private File generatedSiteDirectoryTmp;
    private Map<Locale, List<MavenReport>> generatedMavenReports;
    private PlexusContainer container;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        try {
            this.generatePdf();
        }
        catch (IOException e) {
            this.debugLogGeneratedModel(this.getDocumentModel(Locale.ENGLISH));
            throw new MojoExecutionException("Error during document generation: " + e.getMessage(), (Exception)e);
        }
        try {
            this.copyGeneratedPdf();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated PDF: " + e.getMessage(), (Exception)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private void init() {
        if ("fo".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.foRenderer;
        } else if ("itext".equalsIgnoreCase(this.implementation)) {
            this.docRenderer = this.itextRenderer;
        } else {
            this.getLog().warn((CharSequence)("Invalid 'implementation' parameter: '" + this.implementation + "', using 'fo' as default."));
            this.docRenderer = this.foRenderer;
        }
        if (!("none".equalsIgnoreCase(this.generateTOC) || "start".equalsIgnoreCase(this.generateTOC) || "end".equalsIgnoreCase(this.generateTOC))) {
            this.getLog().warn((CharSequence)("Invalid 'generateTOC' parameter: '" + this.generateTOC + "', using 'start' as default."));
            this.generateTOC = "start";
        }
    }

    private void copyGeneratedPdf() throws MojoExecutionException, IOException {
        if (this.outputDirectory.getCanonicalPath().equals(this.workingDirectory.getCanonicalPath())) {
            return;
        }
        String outputName = this.getDocumentModel(this.getDefaultLocale()).getOutputName().trim();
        if (!outputName.endsWith(".pdf")) {
            outputName = outputName.concat(".pdf");
        }
        for (Locale locale : this.getAvailableLocales()) {
            File generatedPdfSource = new File(this.getLocaleDirectory(this.workingDirectory, locale), outputName);
            if (!generatedPdfSource.exists()) {
                this.getLog().warn((CharSequence)("Unable to find the generated pdf: " + generatedPdfSource.getAbsolutePath()));
                continue;
            }
            File generatedPdfDest = new File(this.getLocaleDirectory(this.outputDirectory, locale), outputName);
            FileUtils.copyFile((File)generatedPdfSource, (File)generatedPdfDest);
            generatedPdfSource.delete();
        }
    }

    private void generatePdf() throws MojoExecutionException, IOException {
        Locale.setDefault(this.getDefaultLocale());
        for (Locale locale : this.getAvailableLocales()) {
            File workingDir = this.getLocaleDirectory(this.workingDirectory, locale);
            File siteDirectoryFile = this.getLocaleDirectory(this.getSiteDirectoryTmp(), locale);
            this.copyResources(locale);
            this.generateMavenReports(locale);
            DocumentRendererContext context = new DocumentRendererContext();
            context.put("project", this.project);
            context.put("settings", this.settings);
            context.put("PathTool", new PathTool());
            context.put("FileUtils", new FileUtils());
            context.put("StringUtils", new StringUtils());
            context.put("i18n", this.i18n);
            context.put("generateTOC", this.generateTOC);
            context.put("validate", this.validate);
            context.put("executiveSummaryName", this.executiveSummaryName);
            context.put("titleHeader", this.titleHeader);
            context.put("distributionStatement", this.distributionStatement);
            context.put("pdfHeader", this.pdfHeader);
            context.put("pdfFooter", this.pdfFooter);
            context.put("coverDate", this.pdfCoverDate);
            if (this.foStylesOverride != null && this.foStylesOverride.exists()) {
                context.put("foStylesOverride", this.foStylesOverride);
            }
            if (this.tocMaxDepthToPrint != null && !this.tocMaxDepthToPrint.trim().isEmpty()) {
                context.put("tocMaxDepthToPrint", this.tocMaxDepthToPrint);
            }
            for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
                context.put((String)entry.getKey(), entry.getValue());
            }
            DocumentModel model = this.aggregate ? this.getDocumentModel(locale) : null;
            try {
                ((AbstractDocumentRenderer)this.docRenderer).render(siteDirectoryFile, workingDir, model, context);
            }
            catch (DocumentRendererException e) {
                throw new MojoExecutionException("Error during document generation: " + e.getMessage(), (Exception)e);
            }
        }
    }

    private File getSiteDirectoryTmp() throws IOException {
        if (this.siteDirectoryTmp == null) {
            File tmpSiteDir = new File(this.workingDirectory, "site.tmp");
            this.prepareTempSiteDirectory(tmpSiteDir);
            this.siteDirectoryTmp = tmpSiteDir;
        }
        return this.siteDirectoryTmp;
    }

    private File getGeneratedSiteDirectoryTmp() {
        if (this.generatedSiteDirectoryTmp == null) {
            this.generatedSiteDirectoryTmp = new File(this.workingDirectory, "generated-site.tmp");
        }
        return this.generatedSiteDirectoryTmp;
    }

    private void prepareTempSiteDirectory(File tmpSiteDir) throws IOException {
        tmpSiteDir.mkdirs();
        if (this.siteDirectory.exists()) {
            FileUtils.copyDirectoryStructure((File)this.siteDirectory, (File)tmpSiteDir);
        }
        List files = FileUtils.getFileAndDirectoryNames((File)tmpSiteDir, (String)FileUtils.getDefaultExcludesAsString(), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        for (String fileName : files) {
            File file = new File(fileName);
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
                continue;
            }
            file.delete();
        }
        this.copySiteDir(this.generatedSiteDirectory, tmpSiteDir);
    }

    private void copySiteDir(File from, File to) throws IOException {
        if (from == null || !from.exists()) {
            return;
        }
        for (Locale locale : this.getAvailableLocales()) {
            String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
            List siteFiles = FileUtils.getFileNames((File)this.siteDirectory, (String)"**/*", (String)excludes, (boolean)false);
            File siteDirectoryLocale = new File(this.siteDirectory, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && siteDirectoryLocale.exists()) {
                siteFiles = FileUtils.getFileNames((File)siteDirectoryLocale, (String)"**/*", (String)excludes, (boolean)false);
            }
            List generatedSiteFiles = FileUtils.getFileNames((File)from, (String)"**/*", (String)excludes, (boolean)false);
            File fromLocale = new File(from, locale.getLanguage());
            if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage()) && fromLocale.exists()) {
                generatedSiteFiles = FileUtils.getFileNames((File)fromLocale, (String)"**/*", (String)excludes, (boolean)false);
            }
            for (String generatedSiteFile : generatedSiteFiles) {
                File out;
                File in;
                if (siteFiles.contains(generatedSiteFile)) {
                    this.getLog().warn((CharSequence)("Generated-site already contains a file in site: " + generatedSiteFile + ". Ignoring copying it!"));
                    continue;
                }
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    if (!fromLocale.exists()) continue;
                    in = new File(fromLocale, generatedSiteFile);
                    out = new File(new File(to, locale.getLanguage()), generatedSiteFile);
                    out.getParentFile().mkdirs();
                    FileUtils.copyFile((File)in, (File)out);
                    continue;
                }
                in = new File(from, generatedSiteFile);
                out = new File(to, generatedSiteFile);
                out.getParentFile().mkdirs();
                FileUtils.copyFile((File)in, (File)out);
            }
        }
    }

    private DocumentModel getDocumentModel(Locale locale) throws MojoExecutionException {
        if (this.docDescriptor.exists()) {
            DocumentModel doc = this.getDocumentModelFromDescriptor(locale);
            this.appendGeneratedReports(doc, locale);
            return doc;
        }
        DocumentModel model = new DocumentModelBuilder(this.project, this.getDefaultDecorationModel()).getDocumentModel();
        model.getMeta().setGenerator(this.getDefaultGenerator());
        model.getMeta().setLanguage(locale.getLanguage());
        model.getCover().setCoverType(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.type"));
        model.getToc().setName(this.i18n.getString("pdf-plugin", this.getDefaultLocale(), "toc.title"));
        this.appendGeneratedReports(model, locale);
        this.debugLogGeneratedModel(model);
        return model;
    }

    private DocumentModel getDocumentModelFromDescriptor(Locale locale) throws MojoExecutionException {
        DocumentModel model;
        try {
            model = new DocumentDescriptorReader(this.project, this.getLog()).readAndFilterDocumentDescriptor(this.docDescriptor);
        }
        catch (XmlPullParserException ex) {
            throw new MojoExecutionException("Error reading DocumentDescriptor!", (Exception)((Object)ex));
        }
        catch (IOException io) {
            throw new MojoExecutionException("Error opening DocumentDescriptor!", (Exception)io);
        }
        if (model.getMeta() == null) {
            model.setMeta(new DocumentMeta());
        }
        if (StringUtils.isEmpty((String)model.getMeta().getLanguage())) {
            model.getMeta().setLanguage(locale.getLanguage());
        }
        if (StringUtils.isEmpty((String)model.getMeta().getGenerator())) {
            model.getMeta().setGenerator(this.getDefaultGenerator());
        }
        return model;
    }

    private File getLocaleDirectory(File basedir, Locale locale) {
        if (locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
            return basedir;
        }
        return new File(basedir, locale.getLanguage());
    }

    private Locale getDefaultLocale() {
        if (this.defaultLocale == null) {
            this.defaultLocale = this.getAvailableLocales().get(0);
        }
        return this.defaultLocale;
    }

    private List<Locale> getAvailableLocales() {
        if (this.localesList == null) {
            this.localesList = this.siteTool.getSiteLocales(this.locales);
        }
        return this.localesList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DecorationModel getDefaultDecorationModel() throws MojoExecutionException {
        if (this.defaultDecorationModel == null) {
            Locale locale = this.getDefaultLocale();
            File descriptorFile = this.siteTool.getSiteDescriptor(this.siteDirectory, locale);
            DecorationModel decoration = null;
            if (descriptorFile.exists()) {
                org.apache.commons.io.input.XmlStreamReader reader = null;
                try {
                    reader = new org.apache.commons.io.input.XmlStreamReader(descriptorFile);
                    String siteDescriptorContent = IOUtil.toString((Reader)reader);
                    reader.close();
                    reader = null;
                    siteDescriptorContent = this.siteTool.getInterpolatedSiteDescriptorContent(new HashMap(2), this.project, siteDescriptorContent);
                    decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
                }
                catch (XmlPullParserException e) {
                    try {
                        throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
                        catch (IOException e2) {
                            throw new MojoExecutionException("Error reading site descriptor", (Exception)e2);
                        }
                        catch (SiteToolException e3) {
                            throw new MojoExecutionException("Error when interpoling site descriptor", (Exception)((Object)e3));
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(reader);
                        throw throwable;
                    }
                }
                IOUtil.close((Reader)reader);
            }
            this.defaultDecorationModel = decoration;
        }
        return this.defaultDecorationModel;
    }

    private void copyResources(Locale locale) throws MojoExecutionException {
        Artifact skinFile;
        DecorationModel decorationModel = this.getDefaultDecorationModel();
        if (decorationModel == null) {
            return;
        }
        try {
            skinFile = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.project.getRemoteArtifactRepositories(), decorationModel);
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (skinFile == null) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Copy resources from skin artifact: '" + skinFile + "'..."));
        }
        try {
            SiteRenderingContext context = this.siteRenderer.createContextForSkin(skinFile, new HashMap(2), decorationModel, this.project.getName(), locale);
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            this.siteRenderer.copyResources(context, this.workingDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("RendererException: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getDefaultGenerator() {
        return "Maven PDF Plugin v. " + this.pluginVersion + ", '" + this.implementation + "' implementation.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugLogGeneratedModel(DocumentModel docModel) {
        if (this.getLog().isDebugEnabled() && this.project != null) {
            File outputDir = new File(this.project.getBuild().getDirectory(), "pdf");
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File doc = FileUtils.createTempFile((String)"pdf", (String)".xml", (File)outputDir);
            DocumentXpp3Writer xpp3 = new DocumentXpp3Writer();
            XmlStreamWriter w = null;
            try {
                w = WriterFactory.newXmlWriter((File)doc);
                xpp3.write((Writer)w, docModel);
                w.close();
                w = null;
                this.getLog().debug((CharSequence)("Generated a default document model: " + doc.getAbsolutePath()));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to write document model: " + e.getMessage()));
                this.getLog().debug((Throwable)e);
            }
            finally {
                IOUtil.close((Writer)w);
            }
        }
    }

    private void generateMavenReports(Locale locale) throws MojoExecutionException, IOException {
        if (!this.includeReports) {
            this.getLog().info((CharSequence)"Skipped report generation.");
            return;
        }
        if (this.project.getReporting() == null) {
            this.getLog().info((CharSequence)"No report was specified.");
            return;
        }
        for (ReportPlugin reportPlugin : this.project.getReporting().getPlugins()) {
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(reportPlugin);
            if (pluginDescriptor == null) continue;
            ArrayList<String> goals = new ArrayList<String>(8);
            for (ReportSet reportSet : reportPlugin.getReportSets()) {
                for (String goal : reportSet.getReports()) {
                    goals.add(goal);
                }
            }
            List mojoDescriptors = pluginDescriptor.getMojos();
            for (Object mojoDescriptor1 : mojoDescriptors) {
                MojoDescriptor mojoDescriptor = (MojoDescriptor)mojoDescriptor1;
                if (!goals.isEmpty() && (goals.isEmpty() || !goals.contains(mojoDescriptor.getGoal()))) continue;
                MavenReport report = this.getMavenReport(mojoDescriptor);
                this.generateMavenReport(report, mojoDescriptor.getPluginDescriptor().getPluginArtifact(), locale);
            }
        }
        if (!this.getGeneratedMavenReports(locale).isEmpty()) {
            File outDir = new File(this.getGeneratedSiteDirectoryTmp(), "xdoc");
            if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
                outDir = new File(new File(this.getGeneratedSiteDirectoryTmp(), locale.getLanguage()), "xdoc");
            }
            outDir.mkdirs();
            File piReport = new File(outDir, "project-info.xml");
            StringWriter sw = new StringWriter();
            PdfSink sink = new PdfSink(sw);
            ProjectInfoRenderer r = new ProjectInfoRenderer((org.apache.maven.doxia.sink.Sink)sink, this.getGeneratedMavenReports(locale), this.i18n, locale);
            r.render();
            PdfMojo.writeGeneratedReport(sw.toString(), piReport);
        }
        this.copySiteDir(this.getGeneratedSiteDirectoryTmp(), this.getSiteDirectoryTmp());
        this.copySiteDir(this.generatedSiteDirectory, this.getSiteDirectoryTmp());
    }

    private PluginDescriptor getPluginDescriptor(ReportPlugin reportPlugin) throws MojoExecutionException {
        try {
            return this.pluginManager.verifyReportPlugin(reportPlugin, this.project, this.session);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("ArtifactResolutionException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("ArtifactNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginNotFoundException e) {
            throw new MojoExecutionException("PluginNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginVersionResolutionException e) {
            throw new MojoExecutionException("PluginVersionResolutionException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("InvalidVersionSpecificationException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidPluginException e) {
            throw new MojoExecutionException("InvalidPluginException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginManagerException e) {
            throw new MojoExecutionException("PluginManagerException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginVersionNotFoundException e) {
            throw new MojoExecutionException("PluginVersionNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (NoSuchMethodError e) {
            this.getLog().info((CharSequence)"Ignoring api call removed in maven 3, no reports are generated!");
            this.getLog().debug((Throwable)e);
            return null;
        }
    }

    private MavenReport getMavenReport(MojoDescriptor mojoDescriptor) throws MojoExecutionException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mojoDescriptor.getPluginDescriptor().getClassRealm().getClassLoader());
            MojoExecution mojoExecution = new MojoExecution(mojoDescriptor);
            MavenReport mavenReport = this.pluginManager.getReport(this.project, mojoExecution, this.session);
            return mavenReport;
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("ArtifactNotFoundException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("ArtifactResolutionException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginConfigurationException e) {
            throw new MojoExecutionException("PluginConfigurationException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (PluginManagerException e) {
            throw new MojoExecutionException("PluginManagerException: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void generateMavenReport(MavenReport report, Artifact pluginArtifact, Locale locale) throws IOException, MojoExecutionException {
        Object generatedReport2;
        if (report == null) {
            return;
        }
        String localReportName = report.getName(locale);
        if (!report.canGenerateReport()) {
            this.getLog().info((CharSequence)("Skipped \"" + localReportName + "\" report."));
            this.getLog().debug((CharSequence)"canGenerateReport() was false.");
            return;
        }
        if (report.isExternalReport()) {
            this.getLog().info((CharSequence)("Skipped external \"" + localReportName + "\" report."));
            this.getLog().debug((CharSequence)"isExternalReport() was false.");
            return;
        }
        for (Object generatedReport2 : this.getGeneratedMavenReports(locale)) {
            if (!report.getName(locale).equals(generatedReport2.getName(locale))) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(report.getName(locale) + " was already generated."));
            }
            return;
        }
        File outDir = new File(this.getGeneratedSiteDirectoryTmp(), "xdoc");
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            outDir = new File(new File(this.getGeneratedSiteDirectoryTmp(), locale.getLanguage()), "xdoc");
        }
        outDir.mkdirs();
        generatedReport2 = new File(outDir, report.getOutputName() + ".xml");
        String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
        List files = FileUtils.getFileNames((File)this.siteDirectory, (String)("*/" + report.getOutputName() + ".*"), (String)excludes, (boolean)false);
        if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            files = FileUtils.getFileNames((File)new File(this.siteDirectory, locale.getLanguage()), (String)("*/" + report.getOutputName() + ".*"), (String)excludes, (boolean)false);
        }
        if (files.size() != 0) {
            String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report, file \"" + report.getOutputName() + "\" already exists for the " + displayLanguage + " version."));
            }
            return;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Generating \"" + localReportName + "\" report."));
        }
        StringWriter sw = new StringWriter();
        try (PdfSink sink = null;){
            sink = new PdfSink(sw);
            Sink proxy = (Sink)Proxy.newProxyInstance(Sink.class.getClassLoader(), new Class[]{Sink.class}, (InvocationHandler)new SinkDelegate((org.apache.maven.doxia.sink.Sink)sink));
            report.generate(proxy, locale);
        }
        PdfMojo.writeGeneratedReport(sw.toString(), (File)generatedReport2);
        if (this.isValidGeneratedReport(pluginArtifact, (File)generatedReport2, localReportName)) {
            this.getGeneratedMavenReports(locale).add(report);
        }
    }

    private List<MavenReport> getGeneratedMavenReports(Locale locale) {
        if (this.generatedMavenReports == null) {
            this.generatedMavenReports = new HashMap<Locale, List<MavenReport>>(2);
        }
        if (this.generatedMavenReports.get(locale) == null) {
            this.generatedMavenReports.put(locale, new ArrayList(2));
        }
        return this.generatedMavenReports.get(locale);
    }

    private void appendGeneratedReports(DocumentModel model, Locale locale) {
        if (!this.includeReports) {
            return;
        }
        if (this.getGeneratedMavenReports(locale).isEmpty()) {
            return;
        }
        DocumentTOCItem documentTOCItem = new DocumentTOCItem();
        documentTOCItem.setName(this.i18n.getString("pdf-plugin", locale, "toc.project-info.item"));
        documentTOCItem.setRef("/project-info");
        ArrayList<String> addedRef = new ArrayList<String>(4);
        ArrayList<DocumentTOCItem> items = new ArrayList<DocumentTOCItem>(4);
        for (MavenReport report : this.getGeneratedMavenReports(locale)) {
            DocumentTOCItem reportItem = new DocumentTOCItem();
            reportItem.setName(report.getName(locale));
            reportItem.setRef("/" + report.getOutputName());
            items.add(reportItem);
            addedRef.add(report.getOutputName());
        }
        try {
            if (this.generatedSiteDirectory.exists()) {
                String excludes = PdfMojo.getDefaultExcludesWithLocales(this.getAvailableLocales(), this.getDefaultLocale());
                List generatedDirs = FileUtils.getDirectoryNames((File)this.generatedSiteDirectory, (String)"*", (String)excludes, (boolean)true);
                if (!locale.getLanguage().equals(this.getDefaultLocale().getLanguage())) {
                    generatedDirs = FileUtils.getFileNames((File)new File(this.generatedSiteDirectory, locale.getLanguage()), (String)"*", (String)excludes, (boolean)true);
                }
                for (String generatedDir : generatedDirs) {
                    List generatedFiles = FileUtils.getFileNames((File)new File(generatedDir), (String)"**.*", (String)excludes, (boolean)false);
                    for (String generatedFile : generatedFiles) {
                        String title;
                        String ref = generatedFile.substring(0, generatedFile.lastIndexOf(46));
                        if (addedRef.contains(ref) || (title = this.getGeneratedDocumentTitle(new File(generatedDir, generatedFile))) == null) continue;
                        DocumentTOCItem reportItem = new DocumentTOCItem();
                        reportItem.setName(title);
                        reportItem.setRef("/" + ref);
                        items.add(reportItem);
                    }
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
        documentTOCItem.setItems(items);
        model.getToc().addItem(documentTOCItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGeneratedDocumentTitle(File f) throws IOException {
        IndexEntry entry = new IndexEntry("index");
        IndexingSink titleSink = new IndexingSink(entry);
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)f);
            this.doxia.parse((Reader)reader, f.getParentFile().getName(), (org.apache.maven.doxia.sink.Sink)titleSink);
            reader.close();
            reader = null;
        }
        catch (ParseException e) {
            this.getLog().error((CharSequence)("ParseException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            String string = null;
            return string;
        }
        catch (ParserNotFoundException e) {
            this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return titleSink.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidGeneratedReport(Artifact pluginArtifact, File generatedReport, String localReportName) {
        SinkAdapter sinkAdapter = new SinkAdapter();
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)generatedReport);
            this.doxia.parse((Reader)reader, generatedReport.getParentFile().getName(), (org.apache.maven.doxia.sink.Sink)sinkAdapter);
            reader.close();
            reader = null;
        }
        catch (ParseException e) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append(EOL).append(EOL);
            sb.append("Error when parsing the generated report: ").append(generatedReport.getAbsolutePath());
            sb.append(EOL);
            sb.append(e.getMessage());
            sb.append(EOL).append(EOL);
            sb.append("You could:").append(EOL);
            sb.append("  * exclude all reports using -DincludeReports=false").append(EOL);
            sb.append("  * remove the ");
            sb.append(pluginArtifact.getGroupId());
            sb.append(":");
            sb.append(pluginArtifact.getArtifactId());
            sb.append(":");
            sb.append(pluginArtifact.getVersion());
            sb.append(" from the <reporting/> part. To not affect the site generation, ");
            sb.append("you could create a PDF profile.").append(EOL);
            sb.append(EOL);
            MavenProject pluginProject = this.getReportPluginProject(pluginArtifact);
            if (pluginProject == null) {
                sb.append("You could also contact the Plugin team.").append(EOL);
            } else {
                sb.append("You could also contact the Plugin team:").append(EOL);
                if (pluginProject.getMailingLists() != null && !pluginProject.getMailingLists().isEmpty()) {
                    boolean appended = false;
                    for (Object o : pluginProject.getMailingLists()) {
                        MailingList mailingList = (MailingList)o;
                        if (!StringUtils.isNotEmpty((String)mailingList.getName()) || !StringUtils.isNotEmpty((String)mailingList.getPost())) continue;
                        if (!appended) {
                            sb.append("  Mailing Lists:").append(EOL);
                            appended = true;
                        }
                        sb.append("    ").append(mailingList.getName());
                        sb.append(": ").append(mailingList.getPost());
                        sb.append(EOL);
                    }
                }
                if (StringUtils.isNotEmpty((String)pluginProject.getUrl())) {
                    sb.append("  Web Site:").append(EOL);
                    sb.append("    ").append(pluginProject.getUrl());
                    sb.append(EOL);
                }
                if (pluginProject.getIssueManagement() != null && StringUtils.isNotEmpty((String)pluginProject.getIssueManagement().getUrl())) {
                    sb.append("  Issue Tracking:").append(EOL);
                    sb.append("    ").append(pluginProject.getIssueManagement().getUrl());
                    sb.append(EOL);
                }
            }
            sb.append(EOL).append("Ignoring the \"").append(localReportName).append("\" report in the PDF.").append(EOL);
            this.getLog().error((CharSequence)sb.toString());
            this.getLog().debug((Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (ParserNotFoundException e) {
            this.getLog().error((CharSequence)("ParserNotFoundException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return true;
    }

    private MavenProject getReportPluginProject(Artifact pluginArtifact) {
        try {
            return this.mavenProjectBuilder.buildFromRepository(pluginArtifact, this.remoteRepositories, this.localRepository);
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)("ProjectBuildingException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
            return null;
        }
    }

    protected List<MavenReportExecution> getReports() throws MojoExecutionException {
        if (PdfMojo.isMaven3OrMore()) {
            MavenReportExecutor mavenReportExecutor;
            MavenReportExecutorRequest mavenReportExecutorRequest = new MavenReportExecutorRequest();
            mavenReportExecutorRequest.setLocalRepository(this.localRepository);
            mavenReportExecutorRequest.setMavenSession(this.session);
            mavenReportExecutorRequest.setProject(this.project);
            mavenReportExecutorRequest.setReportPlugins(this.reportPlugins);
            try {
                mavenReportExecutor = (MavenReportExecutor)this.container.lookup(MavenReportExecutor.class.getName());
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("could not get MavenReportExecutor component", (Exception)((Object)e));
            }
            return mavenReportExecutor.buildMavenReports(mavenReportExecutorRequest);
        }
        ArrayList<MavenReportExecution> reportExecutions = new ArrayList<MavenReportExecution>(this.reports.length);
        for (MavenReport report : this.reports) {
            if (!report.canGenerateReport()) continue;
            reportExecutions.add(new MavenReportExecution(report));
        }
        return reportExecutions;
    }

    protected static boolean isMaven3OrMore() {
        try {
            DefaultArtifactVersion mavenVersion = new DefaultArtifactVersion(PdfMojo.getMavenVersion());
            return VersionRange.createFromVersionSpec((String)"[3.0,)").containsVersion((ArtifactVersion)mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getMavenVersion() {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = MavenProject.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
            properties.load(in);
            in.close();
            in = null;
        }
        catch (IOException ioe) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close((InputStream)in);
            return string;
        }
        IOUtil.close((InputStream)in);
        return properties.getProperty("version").trim();
    }

    private static void writeGeneratedReport(String content, File toFile) throws IOException {
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)toFile);
            writer.write(StringUtils.replace((String)content, (String)"<table><table", (String)"<table"));
            writer.close();
            writer = null;
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private static String getDefaultExcludesWithLocales(List<Locale> locales, Locale defaultLocale) {
        String excludesLocales = FileUtils.getDefaultExcludesAsString();
        for (Locale locale : locales) {
            if (locale.getLanguage().equals(defaultLocale.getLanguage())) continue;
            excludesLocales = excludesLocales + ",**/" + locale.getLanguage() + "/*";
        }
        return excludesLocales;
    }

    private static class SinkDelegate
    implements InvocationHandler {
        private final org.apache.maven.doxia.sink.Sink sink;

        SinkDelegate(org.apache.maven.doxia.sink.Sink sink) {
            this.sink = sink;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int i;
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (i = parameterTypes.length - 1; i >= 0; --i) {
                if (!AttributeSet.class.isAssignableFrom(parameterTypes[i])) continue;
                parameterTypes[i] = SinkEventAttributes.class;
            }
            if (args != null) {
                for (i = args.length - 1; i >= 0; --i) {
                    if (!AttributeSet.class.isInstance(args[i])) continue;
                    args[i] = new SinkEventAttributeSet((AttributeSet)args[i]);
                }
            }
            Method target = org.apache.maven.doxia.sink.Sink.class.getMethod(method.getName(), parameterTypes);
            return target.invoke((Object)this.sink, args);
        }
    }

    private static class ProjectInfoRenderer
    extends AbstractMavenReportRenderer {
        private final List<MavenReport> generatedReports;
        private final I18N i18n;
        private final Locale locale;

        ProjectInfoRenderer(org.apache.maven.doxia.sink.Sink sink, List<MavenReport> generatedReports, I18N i18n, Locale locale) {
            super(sink);
            this.generatedReports = generatedReports;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("pdf-plugin", this.locale, "report.project-info.title");
        }

        public void renderBody() {
            this.sink.section1();
            this.sink.sectionTitle1();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.title"));
            this.sink.sectionTitle1_();
            this.sink.paragraph();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.description1") + " ");
            this.sink.link("http://maven.apache.org");
            this.sink.text("Maven");
            this.sink.link_();
            this.sink.text(" " + this.i18n.getString("pdf-plugin", this.locale, "report.project-info.description2"));
            this.sink.paragraph_();
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.text(this.i18n.getString("pdf-plugin", this.locale, "report.project-info.sectionTitle"));
            this.sink.sectionTitle2_();
            this.sink.table();
            this.sink.tableRows(new int[]{1, 1}, false);
            String name = this.i18n.getString("pdf-plugin", this.locale, "report.project-info.column.document");
            String description = this.i18n.getString("pdf-plugin", this.locale, "report.project-info.column.description");
            this.sink.tableRow();
            this.sink.tableHeaderCell(SinkEventAttributeSet.CENTER);
            this.sink.text(name);
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell(SinkEventAttributeSet.CENTER);
            this.sink.text(description);
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            if (this.generatedReports != null) {
                for (MavenReport report : this.generatedReports) {
                    this.sink.tableRow();
                    this.sink.tableCell();
                    this.sink.link(report.getOutputName() + ".html");
                    this.sink.text(report.getName(this.locale));
                    this.sink.link_();
                    this.sink.tableCell_();
                    this.sink.tableCell();
                    this.sink.text(report.getDescription(this.locale));
                    this.sink.tableCell_();
                    this.sink.tableRow_();
                }
            }
            this.sink.tableRows_();
            this.sink.table_();
            this.sink.section2_();
            this.sink.section1_();
        }
    }

    private static class PdfSink
    extends XdocSink {
        protected PdfSink(Writer writer) {
            super(writer);
        }

        public void text(String text) {
            super.text(StringUtils.replace((String)text, (String)"\u0092", (String)"'"));
        }
    }
}

