/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoAggregateSink;
import org.apache.maven.doxia.sink.SinkEventAttributes;

public class DocumentStructureExtractionSink
extends FoAggregateSink {
    int stackCtr = 0;
    private LocalTOCItem root = null;
    private LocalTOCItem currentItem = null;
    private boolean titleOpen = false;
    private int currentLevel = -1;
    private String titleString = null;

    public DocumentStructureExtractionSink(Writer writer) {
        super(writer);
    }

    @Override
    public void head(SinkEventAttributes attributes) {
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void head() {
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void head_() {
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void title(SinkEventAttributes attributes) {
        this.currentLevel = 0;
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void title() {
        this.currentLevel = 0;
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void title_() {
        this.currentLevel = 0;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void author(SinkEventAttributes attributes) {
        ++this.stackCtr;
    }

    @Override
    public void author() {
        ++this.stackCtr;
    }

    @Override
    public void author_() {
        --this.stackCtr;
    }

    @Override
    public void date(SinkEventAttributes attributes) {
        ++this.stackCtr;
    }

    @Override
    public void date() {
        ++this.stackCtr;
    }

    @Override
    public void date_() {
        --this.stackCtr;
    }

    @Override
    public void body(SinkEventAttributes attributes) {
        ++this.stackCtr;
    }

    @Override
    public void body() {
        ++this.stackCtr;
    }

    @Override
    public void body_() {
        --this.stackCtr;
    }

    @Override
    public void sectionTitle() {
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle_() {
        this.currentLevel = 0;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        --this.stackCtr;
    }

    @Override
    public void section(int level, SinkEventAttributes attributes) {
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void section_(int level) {
        --this.stackCtr;
    }

    @Override
    public void sectionTitle(int level, SinkEventAttributes attributes) {
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle_(int level) {
        this.currentLevel = 0;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        this.currentLevel = -1;
        ++this.stackCtr;
    }

    @Override
    public void section1() {
        this.currentLevel = 1;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle1() {
        this.currentLevel = 1;
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle1_() {
        this.currentLevel = 1;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section1_() {
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section2() {
        this.currentLevel = 2;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle2() {
        this.currentLevel = 2;
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle2_() {
        this.currentLevel = 2;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section2_() {
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section3() {
        this.currentLevel = 3;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle3() {
        this.currentLevel = 3;
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle3_() {
        this.currentLevel = 3;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section3_() {
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section4() {
        this.currentLevel = 4;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle4() {
        this.currentLevel = 4;
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle4_() {
        this.currentLevel = 4;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section4_() {
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section5() {
        this.currentLevel = 5;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle5() {
        this.currentLevel = 5;
        this.titleOpen = true;
        ++this.stackCtr;
    }

    @Override
    public void sectionTitle5_() {
        this.currentLevel = 5;
        if (this.titleString != null) {
            this.createNewTOCItem(this.titleString);
        }
        this.titleString = null;
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void section5_() {
        this.currentLevel = -1;
        this.titleOpen = false;
        --this.stackCtr;
    }

    @Override
    public void write(String str) {
        if (this.validTitle(str)) {
            this.titleString = this.titleString == null ? str : this.titleString + str;
        }
    }

    private boolean validTitle(String str) {
        boolean res = false;
        if (this.titleOpen && !str.trim().isEmpty() && !str.startsWith("<") && !str.endsWith(">")) {
            res = true;
        }
        return res;
    }

    public void enrichTOCItemWithSubstructure(DocumentTOCItem docTOCItem) {
        if (this.root != null && docTOCItem != null) {
            this.commitChildrenToTOCItem(this.root, docTOCItem);
        }
    }

    private void commitChildrenToTOCItem(LocalTOCItem lti, DocumentTOCItem matchingTOCItem) {
        List<LocalTOCItem> ltiChildren;
        if (lti != null && matchingTOCItem != null && (ltiChildren = lti.getChildren()) != null) {
            for (LocalTOCItem ltiC : ltiChildren) {
                if (ltiC == null) continue;
                DocumentTOCItem dtiChild = new DocumentTOCItem();
                dtiChild.setName(ltiC.getName());
                matchingTOCItem.addItem(dtiChild);
                this.commitChildrenToTOCItem(ltiC, dtiChild);
            }
        }
    }

    private void createNewTOCItem(String name) {
        LocalTOCItem current = this.currentItem;
        int lvl = this.currentLevel;
        if (lvl >= 0) {
            if (current != null) {
                while (current != null && current.level > lvl - 1) {
                    current = current.parent;
                }
            }
            this.addNewTOCItem(lvl, current, name);
        }
    }

    private void addNewTOCItem(int level, LocalTOCItem parent, String name) {
        LocalTOCItem lti = new LocalTOCItem(level, parent);
        lti.name = name;
        if (parent == null) {
            if (this.root == null) {
                this.root = lti;
            } else {
                this.root.addChild(lti);
                parent = this.root;
            }
        } else {
            parent.addChild(lti);
        }
        this.currentItem = lti;
    }

    public void reset() {
        this.root = null;
        this.currentItem = null;
        this.titleOpen = false;
        this.currentLevel = -1;
    }

    private class LocalTOCItem {
        LocalTOCItem parent = null;
        private Vector<LocalTOCItem> children;
        String name = null;
        int level = -1;

        public LocalTOCItem(int lvl, LocalTOCItem _parent) {
            this.level = lvl;
            this.parent = _parent;
            this.children = new Vector();
        }

        private LocalTOCItem getItem(String itemName) {
            LocalTOCItem res = null;
            if (itemName != null && this.children != null) {
                for (LocalTOCItem ti : this.children) {
                    if (ti == null || res != null || !ti.getName().equals(itemName)) continue;
                    res = ti;
                }
            }
            return res;
        }

        public List<LocalTOCItem> getChildren() {
            return this.children;
        }

        public void addChild(LocalTOCItem child) {
            this.addTOCItem(child);
            child.parent = this;
        }

        private boolean addTOCItem(LocalTOCItem ti) {
            boolean res = false;
            if (ti != null && this.children != null && !this.children.contains(ti)) {
                res = this.children.add(ti);
            }
            return res;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

