/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoConfiguration;
import org.apache.maven.doxia.module.fo.FoSink;
import org.apache.maven.doxia.module.fo.NumberedListItem;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class FoAggregateSink
extends FoSink {
    public static final int TOC_NONE = 0;
    public static final int TOC_START = 1;
    public static final int TOC_END = 2;
    private static final String COVER_HEADER_HEIGHT = "0.5in";
    private DocumentModel docModel;
    private int chapter = 0;
    private String docName;
    private String docTitle = "";
    private boolean ignoreText;
    private int tocPosition;
    private Object context = null;
    private boolean writingPriorPage = false;
    private boolean resetPageCounter = false;
    private final Stack<NumberedListItem> tocStack = new Stack();
    private double availablePageWidthInInch = 0.0;
    private double tocColWidthC1 = 0.22;
    private double tocColWidthC2 = 0.38;
    private double tocColWidthC3 = 0.58;
    private double tocColWidthC4 = 0.76;
    private double tocColWidthC5 = 0.94;
    private double tocColWidthC6 = 1.12;
    private double tocColWidthC7 = 1.85;
    private double tocColWidthC8 = 0.1;
    private double tocColWidthC9 = 0.3;

    public FoAggregateSink(Writer writer) {
        super(writer);
    }

    public FoAggregateSink(Writer writer, Object context) {
        this(writer);
        this.context = context;
    }

    @Override
    public void head() {
        this.head(null);
    }

    @Override
    public void head(SinkEventAttributes attributes) {
        this.init();
        this.ignoreText = true;
    }

    @Override
    public void head_() {
        this.ignoreText = false;
        this.writeEOL();
    }

    @Override
    public void title() {
        this.title(null);
    }

    @Override
    public void title(SinkEventAttributes attributes) {
    }

    @Override
    public void title_() {
    }

    @Override
    public void author() {
        this.author(null);
    }

    @Override
    public void author(SinkEventAttributes attributes) {
    }

    @Override
    public void author_() {
    }

    @Override
    public void date() {
        this.date(null);
    }

    @Override
    public void date(SinkEventAttributes attributes) {
    }

    @Override
    public void date_() {
    }

    @Override
    public void body() {
        this.body(null);
    }

    @Override
    public void body(SinkEventAttributes attributes) {
        ++this.chapter;
        this.resetSectionCounter();
        if (!this.writingPriorPage) {
            this.startPageSequence(this.getChapterName(), this.getHeaderText(), this.getFooterText());
        }
        if (this.docName == null) {
            this.getLog().warn((CharSequence)"No document root specified, local links will not be resolved correctly!");
        } else {
            this.writeStartTag(BLOCK_TAG, "");
        }
    }

    @Override
    public void body_() {
        this.writeEOL();
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.writeEOL();
        this.writeEOL();
        this.docName = null;
    }

    public void setDocumentTitle(String title) {
        this.docTitle = title;
        if (title == null) {
            this.docTitle = "";
        }
    }

    public void setDocumentName(String name) {
        this.docName = this.getIdName(name);
    }

    public void setDocumentModel(DocumentModel model) {
        this.setDocumentModel(model, 1);
    }

    public void setDocumentModel(DocumentModel model, int tocPos) {
        this.docModel = model;
        if (tocPos != 0 && tocPos != 1 && tocPos != 2) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Unrecognized value for tocPosition: " + tocPos + ", using no toc."));
            }
            tocPos = 0;
        }
        this.tocPosition = tocPos;
        if (this.docModel != null && this.docModel.getToc() != null && this.tocPosition != 0) {
            DocumentTOCItem tocItem = new DocumentTOCItem();
            tocItem.setName(this.docModel.getToc().getName());
            tocItem.setRef("./toc");
            LinkedList<DocumentTOCItem> items = new LinkedList<DocumentTOCItem>();
            if (this.tocPosition == 1) {
                items.add(tocItem);
            }
            items.addAll(this.docModel.getToc().getItems());
            if (this.tocPosition == 2) {
                items.add(tocItem);
            }
            this.docModel.getToc().setItems(items);
        }
    }

    private String getIdName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            this.getLog().warn((CharSequence)"Empty document reference, links will not be resolved correctly!");
            return "";
        }
        String idName = name.replace('\\', '/');
        if (!idName.startsWith("./")) {
            idName = "./" + idName;
        }
        if (idName.substring(2).lastIndexOf(".") != -1) {
            idName = idName.substring(0, idName.lastIndexOf("."));
        }
        while (idName.indexOf("//") != -1) {
            idName = StringUtils.replace((String)idName, (String)"//", (String)"/");
        }
        return idName;
    }

    private String findAbsolutePath(String subpath) {
        if (subpath == null) {
            return null;
        }
        String res = new String(subpath);
        if (!(subpath.contains("://") || subpath.contains(":\\") || subpath.startsWith("/"))) {
            String absPath;
            File targetFile;
            String tmpPath = StringUtils.replace((String)subpath, (String)"\\", (String)"/");
            String[] levels = StringUtils.split((String)tmpPath, (String)"/");
            File tmp = new File(".");
            if (levels != null && (targetFile = this.findTargetFile(tmp, levels, levels[levels.length - 1])) != null && (absPath = targetFile.getAbsolutePath()) != null) {
                res = StringUtils.replace((String)absPath, (String)"\\.\\", (String)"/");
                res = StringUtils.replace((String)res, (String)"/./", (String)"/");
                res = StringUtils.replace((String)res, (String)"\\", (String)"/");
            }
        }
        return res;
    }

    private File findTargetFile(File currentPosition, String[] pathlevels, String targetFilename) {
        File[] children;
        File res = null;
        if (currentPosition != null && targetFilename != null && (children = currentPosition.listFiles()) != null) {
            for (File f : children) {
                if (res != null || f == null) continue;
                if (f.getName().equals(targetFilename)) {
                    res = f;
                } else if (f.isDirectory()) {
                    res = this.findTargetFile(f, pathlevels, targetFilename);
                }
                if (res == null || pathlevels == null || pathlevels.length <= 1) continue;
                File tmp = res;
                boolean match = true;
                for (int i = pathlevels.length - 2; i >= 0 && match && tmp != null; --i) {
                    File tmpUp = tmp.getParentFile();
                    if (tmpUp == null || !tmpUp.getName().equals(pathlevels[i])) {
                        match = false;
                    }
                    tmp = tmpUp;
                }
                if (match) continue;
                res = null;
            }
        }
        return res;
    }

    @Override
    public void figureGraphics(String name) {
        this.figureGraphics(name, null);
    }

    @Override
    public void figureGraphics(String src, SinkEventAttributes attributes) {
        String anchor = src;
        while (anchor.startsWith("./")) {
            anchor = anchor.substring(2);
        }
        if (anchor.startsWith("../") && this.docName != null) {
            anchor = this.resolveLinkRelativeToBase(anchor);
        }
        super.figureGraphics(anchor, attributes);
    }

    @Override
    public void anchor(String name) {
        this.anchor(name, null);
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        String anchor = name;
        if (!DoxiaUtils.isValidId((String)anchor)) {
            anchor = DoxiaUtils.encodeId((String)name, (boolean)true);
            String msg = "Modified invalid anchor name: '" + name + "' to '" + anchor + "'";
            this.logMessage("modifiedLink", msg);
        }
        anchor = "#" + anchor;
        if (this.docName != null) {
            anchor = this.docName + anchor;
        }
        this.writeStartTag(INLINE_TAG, "id", anchor);
    }

    @Override
    public void link(String name) {
        this.link(name, null);
    }

    @Override
    public void link(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.writeStartTag(BASIC_LINK_TAG, "external-destination", HtmlTools.escapeHTML((String)name));
            this.writeStartTag(INLINE_TAG, "href.external");
            return;
        }
        while (name.indexOf("//") != -1) {
            name = StringUtils.replace((String)name, (String)"//", (String)"/");
        }
        if (DoxiaUtils.isInternalLink((String)name)) {
            String anchor = name.substring(1);
            if (!DoxiaUtils.isValidId((String)anchor)) {
                String tmp = anchor;
                anchor = DoxiaUtils.encodeId((String)anchor, (boolean)true);
                String msg = "Modified invalid anchor name: '" + tmp + "' to '" + anchor + "'";
                this.logMessage("modifiedLink", msg);
            }
            if (this.docName != null) {
                anchor = this.docName + "#" + anchor;
            }
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else if (name.startsWith("../")) {
            if (this.docName == null) {
                this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)name));
                this.writeStartTag(INLINE_TAG, "href.internal");
                return;
            }
            String anchor = this.resolveLinkRelativeToBase(this.chopExtension(name));
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else {
            String anchor = name;
            if (anchor.startsWith("./")) {
                this.link(anchor.substring(2));
                return;
            }
            anchor = this.chopExtension(anchor);
            String base = this.docName.substring(0, this.docName.lastIndexOf("/"));
            anchor = base + "/" + anchor;
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        }
    }

    private String resolveLinkRelativeToBase(String name) {
        String anchor = name;
        String base = this.docName.substring(0, this.docName.lastIndexOf("/"));
        if (base.indexOf("/") != -1) {
            while (anchor.startsWith("../")) {
                base = base.substring(0, base.lastIndexOf("/"));
                anchor = anchor.substring(3);
                if (base.lastIndexOf("/") != -1) continue;
                while (anchor.startsWith("../")) {
                    anchor = anchor.substring(3);
                }
                break block0;
            }
        }
        return base + "/" + anchor;
    }

    private String chopExtension(String name) {
        String anchor = name;
        int dot = anchor.lastIndexOf(".");
        if (dot != -1 && dot != anchor.length() && anchor.charAt(dot + 1) != '/') {
            int dot2;
            int hash = anchor.indexOf("#", dot);
            anchor = hash != -1 ? ((dot2 = anchor.indexOf(".", hash)) != -1 ? anchor.substring(0, dot) + "#" + HtmlTools.encodeId((String)anchor.substring(hash + 1, dot2)) : anchor.substring(0, dot) + "#" + HtmlTools.encodeId((String)anchor.substring(hash + 1, anchor.length()))) : anchor.substring(0, dot);
        }
        return anchor;
    }

    @Override
    protected void writeStartTag(HTML.Tag tag, String attributeId) {
        if (!this.ignoreText) {
            super.writeStartTag(tag, attributeId);
        }
    }

    @Override
    protected void writeStartTag(HTML.Tag tag, String id, String name) {
        if (!this.ignoreText) {
            super.writeStartTag(tag, id, name);
        }
    }

    @Override
    protected void writeEndTag(HTML.Tag t) {
        if (!this.ignoreText) {
            super.writeEndTag(t);
        }
    }

    @Override
    protected void writeEmptyTag(HTML.Tag tag, String attributeId) {
        if (!this.ignoreText) {
            super.writeEmptyTag(tag, attributeId);
        }
    }

    @Override
    protected void write(String text) {
        if (!this.ignoreText) {
            super.write(text);
        }
    }

    @Override
    protected void writeln(String text) {
        if (!this.ignoreText) {
            super.writeln(text);
        }
    }

    @Override
    protected void content(String text) {
        if (!this.ignoreText) {
            super.content(text);
        }
    }

    protected void newline() {
        if (!this.ignoreText) {
            this.writeEOL();
        }
    }

    protected void startPageSequence(String chapterName, String headerText, String footerText) {
        if (this.chapter == 1 || this.resetPageCounter) {
            this.startPageSequence("0", chapterName, headerText, footerText);
            this.resetPageCounter = false;
        } else {
            this.startPageSequence("auto", chapterName, headerText, footerText);
        }
    }

    protected String getHeaderText() {
        Object tmp;
        DocumentRendererContext drContext;
        String res = "";
        if (this.context != null && (drContext = this.getRendererContext()) != null && (tmp = drContext.get("pdfHeader")) != null) {
            res = tmp.toString();
        }
        return res;
    }

    protected String getChapterName() {
        return Integer.toString(this.chapter) + "   " + this.docTitle;
    }

    protected String getFooterText() {
        String res = "";
        if (this.context != null) {
            Object tmp;
            DocumentRendererContext drContext;
            if (this.context != null && (drContext = this.getRendererContext()) != null && (tmp = drContext.get("pdfFooter")) != null) {
                res = tmp.toString();
            }
        } else {
            int actualYear;
            String add = " &#8226; " + this.getBundle(Locale.US).getString("footer.rights");
            String companyName = "";
            if (this.docModel != null && this.docModel.getMeta() != null && this.docModel.getMeta().isConfidential()) {
                add = add + " &#8226; " + this.getBundle(Locale.US).getString("footer.confidential");
            }
            if (this.docModel != null && this.docModel.getCover() != null && this.docModel.getCover().getCompanyName() != null) {
                companyName = this.docModel.getCover().getCompanyName();
            }
            if (this.docModel != null && this.docModel.getMeta() != null && this.docModel.getMeta().getDate() != null) {
                Calendar date = Calendar.getInstance();
                date.setTime(this.docModel.getMeta().getDate());
                actualYear = date.get(1);
            } else {
                actualYear = Calendar.getInstance().get(1);
            }
            res = "&#169;" + actualYear + ", " + FoAggregateSink.escaped(companyName, false) + add;
        }
        return res;
    }

    public String getPomProperty(String propertyName) {
        if (this.context != null && this.context.getClass().getCanonicalName().equals("org.apache.maven.doxia.docrenderer.DocumentRendererContext")) {
            try {
                Method method = this.context.getClass().getMethod("get", String.class);
                Method containsKey = this.context.getClass().getMethod("containsKey", Object.class);
                boolean hasOverride = (Boolean)containsKey.invoke(this.context, propertyName);
                if (hasOverride) {
                    return FoAggregateSink.escaped((String)method.invoke(this.context, propertyName), false);
                }
            }
            catch (NoSuchMethodException ex) {
                this.getLog().debug((CharSequence)"error trapped looking for footer override", (Throwable)ex);
            }
            catch (SecurityException ex) {
                this.getLog().debug((CharSequence)"error trapped looking for footer override", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                this.getLog().debug((CharSequence)"error trapped looking for footer override", (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                this.getLog().debug((CharSequence)"error trapped looking for footer override", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                this.getLog().debug((CharSequence)"error trapped looking for footer override", (Throwable)ex);
            }
        }
        return "";
    }

    @Override
    protected String getChapterString() {
        return Integer.toString(this.chapter) + ".";
    }

    @Override
    protected void regionBefore(String chapterName, String headerText) {
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-before");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.1666in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.1666in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.1666in");
        this.writeStartTag(TABLE_BODY_TAG, "");
        this.writeStartTag(TABLE_ROW_TAG, "");
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "header.style");
        if (chapterName != null) {
            this.write(chapterName);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "header.style");
        if (headerText != null) {
            this.write(headerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        if (!this.writingPriorPage) {
            this.writeStartTag(TABLE_CELL_TAG, "");
            this.writeStartTag(BLOCK_TAG, "page.number");
            this.writeEmptyTag(PAGE_NUMBER_TAG, "");
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
        }
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    @Override
    protected void regionAfter(String footerText) {
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-after");
        this.writeStartTag(BLOCK_TAG, "footer.style");
        if (footerText != null) {
            this.write(footerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    @Override
    protected void chapterHeading(String headerText, boolean chapterNumber) {
        if (this.docName == null) {
            this.getLog().warn((CharSequence)"No document root specified, local links will not be resolved correctly!");
            this.writeStartTag(BLOCK_TAG, "");
        } else {
            this.writeStartTag(BLOCK_TAG, "id", this.docName);
        }
        this.writeStartTag(LIST_BLOCK_TAG, "");
        this.writeStartTag(LIST_ITEM_TAG, "");
        this.writeln("<fo:list-item-label end-indent=\"6.375in\" start-indent=\"-1in\">");
        this.writeStartTag(BLOCK_TAG, "outdented.number.style");
        if (chapterNumber) {
            this.writeStartTag(BLOCK_TAG, "chapter.title");
            this.write(Integer.toString(this.chapter));
            this.writeEndTag(BLOCK_TAG);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(LIST_ITEM_LABEL_TAG);
        this.writeln("<fo:list-item-body end-indent=\"1in\" start-indent=\"0in\">");
        this.writeStartTag(BLOCK_TAG, "chapter.title");
        if (headerText == null) {
            this.text(this.docTitle);
        } else {
            this.text(headerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(LIST_ITEM_BODY_TAG);
        this.writeEndTag(LIST_ITEM_TAG);
        this.writeEndTag(LIST_BLOCK_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeStartTag(BLOCK_TAG, "space-after.optimum", "0em");
        this.writeEmptyTag(LEADER_TAG, "chapter.rule");
        this.writeEndTag(BLOCK_TAG);
    }

    @Override
    public void beginDocument() {
        if (this.docModel != null && this.docModel.getToc() != null) {
            this.generateMissingInternalReferences(this.docModel.getToc());
        }
        super.beginDocument();
    }

    public void toc() {
        if (this.docModel == null || this.docModel.getToc() == null || this.docModel.getToc().getItems() == null || this.tocPosition == 0) {
            return;
        }
        if (this.availablePageWidthInInch != 0.0) {
            this.tocColWidthC7 = this.availablePageWidthInInch - this.tocColWidthC1 - this.tocColWidthC2 - this.tocColWidthC3 - this.tocColWidthC4 - this.tocColWidthC5 - this.tocColWidthC6 - this.tocColWidthC8 - this.tocColWidthC9;
        }
        DocumentTOC toc = this.docModel.getToc();
        this.setDocTOC(toc);
        this.writeln("<fo:page-sequence master-reference=\"toc\" initial-page-number=\"1\" format=\"i\">");
        this.regionBefore(toc.getName(), this.getHeaderText());
        this.regionAfter(this.getFooterText());
        this.writeStartTag(FLOW_TAG, "flow-name", "xsl-region-body");
        this.writeStartTag(BLOCK_TAG, "id", "./toc");
        this.chapterHeading(toc.getName(), false);
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC1 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC2 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC3 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC4 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC5 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC6 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC7 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC8 + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + this.tocColWidthC9 + "in");
        this.writeStartTag(TABLE_BODY_TAG);
        this.writeTocItems(toc.getItems(), 1);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.writeEOL();
        this.writeEOL();
    }

    private void generateMissingInternalReferences(DocumentTOC toc) {
        if (toc != null) {
            String pathToItem = ".";
            List tocElements = toc.getItems();
            Vector<String> usedReferences = new Vector<String>();
            if (tocElements != null) {
                for (DocumentTOCItem child : tocElements) {
                    this.fixReferenceIfNeeded(child, new String(pathToItem), usedReferences);
                }
            }
        }
    }

    private void fixReferenceIfNeeded(DocumentTOCItem tocItem, String pathToItem, Vector<String> usedReferences) {
        if (tocItem != null) {
            List children;
            String tocName = tocItem.getName();
            if (tocName != null) {
                tocName = StringUtils.replace((String)tocName, (String)".", (String)"_");
                tocName = StringUtils.replace((String)tocName, (String)"\\", (String)"_");
            }
            String itemID = new String(pathToItem + "/" + tocName);
            if (tocItem.getRef() == null) {
                itemID = this.ensureReferenceIsValid(itemID, usedReferences);
                tocItem.setRef(itemID);
                usedReferences.addElement(itemID);
            }
            if ((children = tocItem.getItems()) != null) {
                for (DocumentTOCItem child : children) {
                    this.fixReferenceIfNeeded(child, itemID, usedReferences);
                }
            }
        }
    }

    private String ensureReferenceIsValid(String reference, Vector<String> usedReferences) {
        String res = reference;
        if (reference != null && usedReferences != null) {
            boolean invalidReference = false;
            for (String tmp : usedReferences) {
                if (tmp == null || !tmp.equals(res)) continue;
                invalidReference = true;
            }
            while (invalidReference) {
                res = res + "_";
                invalidReference = false;
                for (String tmp : usedReferences) {
                    if (tmp == null || !tmp.equals(res)) continue;
                    invalidReference = true;
                }
            }
        }
        return res;
    }

    private void writeTocItems(List<DocumentTOCItem> tocItems, int level) {
        DocumentRendererContext context;
        double indentation;
        Object tmp;
        int maxTocLevel = 4;
        int numberOfColumns = 9;
        double spaceBeforeAtAdditionalLine = 0.0;
        MutableAttributeSet attsIndentation = this.getFoConfiguration().getAttributeSet("toc.hanging.indentation");
        if (attsIndentation != null && (tmp = attsIndentation.getAttribute("indentation")) != null && !Double.isNaN(indentation = this.inchFromString(tmp.toString()).doubleValue()) && !Double.isInfinite(indentation) && indentation >= 0.0) {
            spaceBeforeAtAdditionalLine = indentation;
        }
        if ((context = this.getRendererContext()) != null) {
            Object oMaxDepth = context.get("tocMaxDepthToPrint");
            if (oMaxDepth != null) {
                try {
                    maxTocLevel = Integer.parseInt(oMaxDepth.toString());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                int tmpTocLevel;
                DocumentTOC tmpToc = this.getDocTOC();
                if (tmpToc != null && (tmpTocLevel = tmpToc.getDepth()) > 0) {
                    maxTocLevel = tmpTocLevel;
                }
            }
        }
        if (maxTocLevel == 0) {
            this.writeStartTag(TABLE_ROW_TAG, "keep-with-next", "auto");
            this.skipTableCells(1);
            this.writeEndTag(TABLE_ROW_TAG);
        }
        if (level < 1 || level > maxTocLevel) {
            return;
        }
        this.tocStack.push(new NumberedListItem(0));
        for (DocumentTOCItem tocItem : tocItems) {
            if (tocItem == null) continue;
            String ref = this.getIdName(tocItem.getRef());
            MutableAttributeSet atts = this.getFoConfiguration().getAttributeSet("toc.h" + level + ".style");
            String tocItemName = tocItem.getName();
            String[] tocItemNameSplitted = this.splitToFit(tocItemName, level, atts, spaceBeforeAtAdditionalLine);
            for (int i = 0; i < tocItemNameSplitted.length; ++i) {
                if (i == 0) {
                    this.writeStartTag(TABLE_ROW_TAG, "keep-with-next", "auto");
                    this.skipTableCells(level - 1);
                } else {
                    this.writeStartTag(TABLE_ROW_TAG, "keep-with-next", "always");
                    this.skipTableCells(level);
                }
                NumberedListItem current = this.tocStack.peek();
                if (current != null && i == 0) {
                    this.writeStartTag(TABLE_CELL_TAG, "toc.cell");
                    this.writeStartTag(BLOCK_TAG, "toc.number.style");
                    current.next();
                    if (level < 5) {
                        this.write(this.currentTocNumber());
                    }
                    this.writeEndTag(BLOCK_TAG);
                    this.writeEndTag(TABLE_CELL_TAG);
                }
                int iSpan = numberOfColumns - level - 1;
                String span = Integer.toString(iSpan);
                this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", span, "toc.cell");
                if (atts != null) {
                    if (i != 0) {
                        atts.addAttribute("text-align", "left");
                        atts.addAttribute("text-align-last", "start");
                        double tmpColWidth = this.tocColWidthC7 - spaceBeforeAtAdditionalLine;
                        if (iSpan > 1) {
                            tmpColWidth += this.tocColWidthC6;
                        }
                        if (iSpan > 2) {
                            tmpColWidth += this.tocColWidthC5;
                        }
                        if (iSpan > 3) {
                            tmpColWidth += this.tocColWidthC4;
                        }
                        if (iSpan > 4) {
                            tmpColWidth += this.tocColWidthC3;
                        }
                        if (iSpan > 5) {
                            tmpColWidth += this.tocColWidthC2;
                        }
                        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
                        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + spaceBeforeAtAdditionalLine + "in");
                        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + tmpColWidth + "in");
                        this.writeStartTag(TABLE_BODY_TAG);
                        this.writeStartTag(TABLE_ROW_TAG, "keep-with-next", "always");
                        this.skipTableCells(1);
                        this.writeStartTag(TABLE_CELL_TAG);
                    } else {
                        atts.addAttribute("text-align", "justify");
                        atts.addAttribute("text-align-last", "justify");
                    }
                } else {
                    atts = new SimpleAttributeSet();
                    atts.addAttribute("text-align", "justify");
                    atts.addAttribute("text-align-last", "justify");
                }
                this.writeStartTag(BLOCK_TAG, atts);
                this.writeStartTag(BASIC_LINK_TAG, "internal-destination", ref);
                this.text(tocItemNameSplitted[i]);
                this.writeEndTag(BASIC_LINK_TAG);
                if (i == 0) {
                    this.writeEmptyTag(LEADER_TAG, "toc.leader.style");
                }
                this.writeEndTag(BLOCK_TAG);
                if (i != 0) {
                    this.writeEndTag(TABLE_CELL_TAG);
                    this.writeEndTag(TABLE_ROW_TAG);
                    this.writeEndTag(TABLE_BODY_TAG);
                    this.writeEndTag(TABLE_TAG);
                }
                this.writeEndTag(TABLE_CELL_TAG);
                this.writeStartTag(TABLE_CELL_TAG, "text-align", "right");
                this.writeStartTag(BLOCK_TAG);
                if (i == 0) {
                    this.writeStartTag(INLINE_TAG, "page.number");
                    this.writeEmptyTag(PAGE_NUMBER_CITATION_TAG, "ref-id", ref);
                    this.writeEndTag(INLINE_TAG);
                }
                this.writeEndTag(BLOCK_TAG);
                this.writeEndTag(TABLE_CELL_TAG);
                this.writeEndTag(TABLE_ROW_TAG);
            }
            if (tocItem.getItems() == null) continue;
            this.writeTocItems(tocItem.getItems(), level + 1);
        }
        this.tocStack.pop();
    }

    private String[] splitToFit(String tocItemName, int level, MutableAttributeSet atts, double spaceBeforeAtAdditionalLine) {
        String breakmark = "\u01de";
        String[] res = new String[]{tocItemName};
        double spaceAvailableAtFirstLine = this.availablePageWidthInInch;
        double spaceAvailableAtAdditionalLine = this.availablePageWidthInInch;
        double offsetLine1 = 0.0;
        switch (level) {
            case 6: {
                offsetLine1 += this.tocColWidthC5;
            }
            case 5: {
                offsetLine1 += this.tocColWidthC4;
            }
            case 4: {
                offsetLine1 += this.tocColWidthC3;
            }
            case 3: {
                offsetLine1 += this.tocColWidthC2;
            }
            case 2: {
                offsetLine1 += this.tocColWidthC1;
            }
            case 1: {
                break;
            }
        }
        spaceAvailableAtFirstLine -= offsetLine1 + this.tocColWidthC9;
        spaceAvailableAtAdditionalLine -= offsetLine1 + spaceBeforeAtAdditionalLine + this.tocColWidthC9;
        if (atts != null) {
            double fontWidth = this.extractFontHeightInInch(atts, 2) * 0.45;
            String[] words = StringUtils.split((String)tocItemName, (String)" ");
            if (words != null && words.length > 0) {
                StringBuffer tmp = new StringBuffer();
                double availableSpaceInLine = spaceAvailableAtFirstLine;
                boolean firstWordInLine = true;
                for (String word : words) {
                    double wordLengthInInch;
                    if (word == null) continue;
                    int letters = word.length();
                    if (!firstWordInLine) {
                        ++letters;
                    }
                    if ((wordLengthInInch = (double)letters * fontWidth) > availableSpaceInLine) {
                        tmp.append(breakmark).append(" ");
                        availableSpaceInLine = spaceAvailableAtAdditionalLine;
                        firstWordInLine = true;
                    }
                    if (!firstWordInLine) {
                        tmp.append(" ");
                    } else {
                        firstWordInLine = false;
                    }
                    tmp.append(word);
                    availableSpaceInLine -= wordLengthInInch;
                }
                res = StringUtils.split((String)tmp.toString(), (String)breakmark);
                for (int i = 0; i < res.length; ++i) {
                    if (res[i] == null) continue;
                    res[i] = res[i].trim();
                }
            }
        }
        return res;
    }

    private void skipTableCells(int numberOfCellsToSkip) {
        for (int i = 0; i < numberOfCellsToSkip; ++i) {
            this.writeStartTag(TABLE_CELL_TAG);
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
        }
    }

    private String currentTocNumber() {
        StringBuilder ch = new StringBuilder(((NumberedListItem)this.tocStack.get(0)).getListItemSymbol());
        for (int i = 1; i < this.tocStack.size(); ++i) {
            ch.append(((NumberedListItem)this.tocStack.get(i)).getListItemSymbol());
        }
        return ch.toString();
    }

    @Override
    protected void pdfBookmarks() {
        if (this.docModel == null || this.docModel.getToc() == null) {
            return;
        }
        this.writeStartTag(BOOKMARK_TREE_TAG);
        this.renderBookmarkItems(this.docModel.getToc().getItems());
        this.writeEndTag(BOOKMARK_TREE_TAG);
    }

    private void renderBookmarkItems(List<DocumentTOCItem> items) {
        for (DocumentTOCItem tocItem : items) {
            String ref = this.getIdName(tocItem.getRef());
            this.writeStartTag(BOOKMARK_TAG, "internal-destination", ref);
            this.writeStartTag(BOOKMARK_TITLE_TAG);
            this.text(tocItem.getName());
            this.writeEndTag(BOOKMARK_TITLE_TAG);
            if (tocItem.getItems() != null) {
                this.renderBookmarkItems(tocItem.getItems());
            }
            this.writeEndTag(BOOKMARK_TAG);
        }
    }

    private Double inchFromString(String inch) {
        Double res = null;
        if (inch != null && inch.endsWith("in")) {
            res = Double.parseDouble(inch.substring(0, inch.length() - 2));
        }
        return res;
    }

    public void execSum(DocumentModel model, String exsumName) {
        this.writeln("<fo:page-sequence master-reference=\"body\" initial-page-number=\"0\" format=\"i\">");
        this.regionBefore(exsumName, this.getHeaderText());
        this.regionAfter(this.getFooterText());
        this.writeStartTag(FLOW_TAG, "flow-name", "xsl-region-body");
        this.chapterHeading(null, false);
    }

    public DocumentRendererContext getRendererContext() {
        DocumentRendererContext res = null;
        if (this.context != null && this.context instanceof DocumentRendererContext) {
            res = (DocumentRendererContext)this.context;
        }
        return res;
    }

    public void closeExecSum() {
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.writeEOL();
        this.writeEOL();
    }

    public void coverPage() {
        Object tmp;
        DocumentRendererContext drContext;
        if (this.docModel == null) {
            return;
        }
        DocumentCover cover = this.docModel.getCover();
        DocumentMeta meta = this.docModel.getMeta();
        if (cover == null && meta == null) {
            return;
        }
        String pageSize = "USLetter";
        String titleHeader = "";
        if (meta != null) {
            pageSize = meta.getPageSize();
        }
        if ((drContext = this.getRendererContext()) != null && (tmp = drContext.get("titleHeader")) != null) {
            titleHeader = tmp.toString();
        }
        MutableAttributeSet attBase = this.getFoConfiguration().getAttributeSet("layout.master.set.base");
        double paperWidthInInch = 8.5;
        double paperHeightInInch = 11.0;
        double marginTopInInch = 0.625;
        double marginBottomInInch = 0.6;
        double marginLeftInInch = 1.0;
        double marginRightInInch = 1.0;
        if (pageSize != null) {
            if (pageSize.equalsIgnoreCase("A4")) {
                paperWidthInInch = 8.26;
                paperHeightInInch = 11.69;
            } else if (pageSize.equalsIgnoreCase("US")) {
                paperWidthInInch = 8.5;
                paperHeightInInch = 14.0;
            }
        }
        if (attBase != null) {
            Double tmpWidth = this.inchFromString(attBase.getAttribute("page-width").toString());
            Double tmpHeight = this.inchFromString(attBase.getAttribute("page-height").toString());
            Double tmpBaseMarginTop = this.inchFromString(attBase.getAttribute("margin-top").toString());
            Double tmpBaseMarginBottom = this.inchFromString(attBase.getAttribute("margin-bottom").toString());
            Double tmpBaseMarginLeft = this.inchFromString(attBase.getAttribute("margin-left").toString());
            Double tmpBaseMarginRight = this.inchFromString(attBase.getAttribute("margin-right").toString());
            if (tmpWidth != null && tmpWidth >= 0.0) {
                paperWidthInInch = tmpWidth;
            }
            if (tmpHeight != null && tmpHeight >= 0.0) {
                paperHeightInInch = tmpHeight;
            }
            if (tmpBaseMarginTop != null && tmpBaseMarginTop >= 0.0) {
                marginTopInInch = tmpBaseMarginTop;
            }
            if (tmpBaseMarginBottom != null && tmpBaseMarginBottom >= 0.0) {
                marginBottomInInch = tmpBaseMarginBottom;
            }
            if (tmpBaseMarginLeft != null && tmpBaseMarginLeft >= 0.0) {
                marginLeftInInch = tmpBaseMarginLeft;
            }
            if (tmpBaseMarginRight != null && tmpBaseMarginRight >= 0.0) {
                marginRightInInch = tmpBaseMarginRight;
            }
        }
        double availableWidthInInch = paperWidthInInch - marginLeftInInch - marginRightInInch;
        double availableHeightInInch = paperHeightInInch - marginTopInInch - marginBottomInInch;
        this.availablePageWidthInInch = availableWidthInInch;
        this.writeln("<fo:page-sequence master-reference=\"cover-page\">");
        this.writeCoverHead(cover, availableWidthInInch, titleHeader);
        this.writeCoverFooter(titleHeader);
        this.writeCoverBody(cover, availableWidthInInch, availableHeightInInch, meta);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.writeEOL();
        this.writeEOL();
    }

    private void writeCoverHead(DocumentCover cover, double availableWidth, String titleHeader) {
        if (cover == null) {
            return;
        }
        double columnWidth5Cols = availableWidth / 5.0;
        MutableAttributeSet att = this.getFoConfiguration().getAttributeSet("cover.subtitle");
        att.addAttribute("height", "2in");
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-before");
        this.writeStartTag(BLOCK_TAG, "text-align", "center");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + columnWidth5Cols + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + columnWidth5Cols + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + columnWidth5Cols + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + columnWidth5Cols + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + columnWidth5Cols + "in");
        this.writeStartTag(TABLE_BODY_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "5");
        this.writeStartTag(BLOCK_TAG, "cover.header");
        this.writeln(titleHeader);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "height", "0.3in");
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    private void writeCoverBody(DocumentCover cover, double availableWidthInInch, double availableHeightInInch, DocumentMeta meta) {
        SinkEventAttributeSet atts;
        double leftColumnWidth;
        if (cover == null && meta == null) {
            return;
        }
        String subtitle = null;
        String title = null;
        String type = null;
        String compLogo = null;
        String projLogo = null;
        String date = null;
        String poc = null;
        String distStatement = null;
        String effectiveDate = null;
        distStatement = "";
        DocumentRendererContext drContext = this.getRendererContext();
        if (drContext != null) {
            Object tmp = drContext.get("distributionStatement");
            if (tmp != null) {
                distStatement = tmp.toString();
            }
            if ((tmp = drContext.get("coverDate")) != null) {
                effectiveDate = tmp.toString();
            }
        }
        if (cover == null) {
            this.getLog().debug((CharSequence)"The DocumentCover is not defined, using the DocumentMeta title as cover title.");
            title = meta.getTitle();
        } else {
            subtitle = cover.getCoverSubTitle();
            title = cover.getCoverTitle();
            type = cover.getCoverType();
            compLogo = cover.getCompanyLogo();
            projLogo = cover.getProjectLogo();
            String tmpAuthor = cover.getAuthor();
            poc = tmpAuthor != null && !tmpAuthor.trim().isEmpty() ? "POC: " + tmpAuthor : "";
            if (cover.getCoverdate() == null) {
                cover.setCoverDate(new Date());
                date = cover.getCoverdate();
                cover.setCoverDate(null);
            } else {
                date = cover.getCoverdate();
            }
        }
        if (effectiveDate != null && effectiveDate.equalsIgnoreCase("auto")) {
            effectiveDate = date;
        }
        double rightColumnWidth = leftColumnWidth = 0.0;
        double midColumnWidth = availableWidthInInch - leftColumnWidth - rightColumnWidth;
        double logoCol1Width = availableWidthInInch / 5.0 * 2.0;
        double logoCol2Width = availableWidthInInch - logoCol1Width;
        boolean containsCLogo = StringUtils.isNotEmpty((String)compLogo);
        boolean containsPLogo = StringUtils.isNotEmpty((String)projLogo);
        boolean containsType = StringUtils.isNotEmpty((String)type);
        boolean containsPoc = StringUtils.isNotEmpty((String)poc);
        boolean containsDistStatement = StringUtils.isNotEmpty((String)distStatement);
        double compLogoHeight = 0.0;
        double projLogoHeight = 0.0;
        double titleHeight = 0.0;
        double subtitleHeight = 0.0;
        double typeHeight = 0.0;
        double dateHeight = 0.0;
        double pocHeight = 0.0;
        double distStateHeight = 0.0;
        if (containsCLogo) {
            compLogo = StringUtils.replace((String)compLogo, (char)'\\', (char)'/');
            compLogo = this.findAbsolutePath(compLogo);
            atts = this.getGraphicsAttributes(compLogo);
            atts.addAttribute((Object)"content-width", (Object)("" + logoCol1Width + "in"));
            compLogoHeight = this.calculateImageHeight(atts);
        }
        if (containsPLogo) {
            projLogo = StringUtils.replace((String)projLogo, (char)'\\', (char)'/');
            projLogo = this.findAbsolutePath(projLogo);
            atts = this.getGraphicsAttributes(projLogo);
            atts.addAttribute((Object)"content-width", (Object)("" + midColumnWidth + "in"));
            projLogoHeight = this.calculateImageHeight(atts);
        }
        FoConfiguration foConf = this.getFoConfiguration();
        MutableAttributeSet attTitle = null;
        MutableAttributeSet attSubtitle = null;
        MutableAttributeSet attDate = null;
        MutableAttributeSet attPOC = null;
        MutableAttributeSet attDistStat = null;
        if (foConf != null) {
            attTitle = foConf.getAttributeSet("cover.title");
            attSubtitle = foConf.getAttributeSet("cover.subtitle");
            attDate = foConf.getAttributeSet("cover.date");
            attPOC = foConf.getAttributeSet("cover.poc");
            attDistStat = foConf.getAttributeSet("cover.distributionstatement");
            titleHeight = this.extractFontHeightInInch(attTitle, 2);
            subtitleHeight = this.extractFontHeightInInch(attSubtitle, 2);
            typeHeight = this.extractFontHeightInInch(attSubtitle, 2);
            dateHeight = this.extractFontHeightInInch(attDate, 2);
            pocHeight = this.extractFontHeightInInch(attPOC, 2);
            distStateHeight = this.extractFontHeightInInch(attDistStat, 2);
        }
        double spcHdrCLogo = 0.675;
        double spcCLogoPLogo = 0.5;
        double spcPLogoTitle = 0.5;
        double spcTitleSubT = 0.15;
        double spcSubTType = 0.3;
        double spcTypeDate = 0.5;
        double spcDatePoc = 0.6;
        double spcPocDist = 1.0;
        double spcDistFooter = 1.0;
        double adjustableSpacers = spcCLogoPLogo + spcPLogoTitle + spcTitleSubT;
        double overAllHeightOfText = titleHeight + subtitleHeight;
        if (containsType) {
            adjustableSpacers += spcSubTType;
            overAllHeightOfText += typeHeight;
        }
        if (containsPoc) {
            adjustableSpacers += spcDatePoc;
            overAllHeightOfText += pocHeight;
        }
        if (containsDistStatement) {
            adjustableSpacers += spcPocDist;
            overAllHeightOfText += distStateHeight * 3.0;
        }
        if (effectiveDate != null) {
            adjustableSpacers += spcTypeDate;
            overAllHeightOfText += dateHeight;
        }
        double tmpAvailableHeight = availableHeightInInch - spcHdrCLogo - spcDistFooter - overAllHeightOfText - compLogoHeight - projLogoHeight;
        double spacersFactor = tmpAvailableHeight / adjustableSpacers;
        spcCLogoPLogo *= spacersFactor;
        spcPLogoTitle *= spacersFactor;
        spcTitleSubT *= spacersFactor;
        spcSubTType *= spacersFactor;
        spcTypeDate *= spacersFactor;
        spcDatePoc *= spacersFactor;
        spcPocDist *= spacersFactor;
        this.writeStartTag(FLOW_TAG, "flow-name", "xsl-region-body");
        this.writeStartTag(BLOCK_TAG, "text-align", "center");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + leftColumnWidth + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + midColumnWidth + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + rightColumnWidth + "in");
        this.writeStartTag(TABLE_BODY_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcHdrCLogo + "in");
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "3");
        this.writeStartTag(BLOCK_TAG);
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + logoCol1Width + "in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "" + logoCol2Width + "in");
        this.writeStartTag(TABLE_BODY_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "height", "" + compLogoHeight + "in");
        if (StringUtils.isNotEmpty((String)compLogo)) {
            SinkEventAttributeSet atts2 = this.getGraphicsAttributes(compLogo);
            atts2.removeAttribute((Object)"height");
            atts2.removeAttribute((Object)"width");
            atts2.addAttribute((Object)"width", (Object)(logoCol1Width + "in"));
            atts2.addAttribute((Object)"height", (Object)(compLogoHeight + "in"));
            atts2.addAttribute((Object)"text-align", (Object)"left");
            atts2.addAttribute((Object)"vertical-align", (Object)"top");
            this.writeStartTag(BLOCK_TAG, (MutableAttributeSet)atts2);
            this.figureGraphics(compLogo, (SinkEventAttributes)atts2);
            this.writeEndTag(BLOCK_TAG);
        } else {
            this.writeSimpleTag(BLOCK_TAG);
        }
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcCLogoPLogo + "in");
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        if (StringUtils.isNotEmpty((String)projLogo)) {
            this.writeStartTag(TABLE_CELL_TAG, "height", "" + projLogoHeight + "in");
            SinkEventAttributeSet sea = this.getGraphicsAttributes(projLogo);
            if (sea != null) {
                sea.addAttribute((Object)"width", (Object)("" + midColumnWidth + "in"));
                sea.addAttribute((Object)"content-width", (Object)("" + midColumnWidth + "in"));
                sea.addAttribute((Object)"height", (Object)(projLogoHeight + "in"));
                this.writeStartTag(BLOCK_TAG);
                this.figureGraphics(projLogo, (SinkEventAttributes)sea);
            }
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
        } else {
            this.writeStartTag(TABLE_CELL_TAG);
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
        }
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcPLogoTitle + "in");
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        this.writeStartTag(BLOCK_TAG, attTitle);
        this.text(title == null ? "" : title);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcTitleSubT + "in");
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        this.writeSimpleTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG);
        this.writeStartTag(BLOCK_TAG, attSubtitle);
        this.text(subtitle == null ? "" : subtitle);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        if (containsType) {
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcSubTType + "in");
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG);
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeStartTag(TABLE_CELL_TAG);
            this.writeStartTag(BLOCK_TAG, attSubtitle);
            this.text(type == null ? "" : type);
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
        }
        if (effectiveDate != null) {
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcTypeDate + "in");
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG);
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeStartTag(TABLE_CELL_TAG);
            this.writeStartTag(BLOCK_TAG, attDate);
            this.text(date == null ? "" : effectiveDate);
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
        }
        if (containsPoc) {
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcDatePoc + "in");
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "3");
            this.writeStartTag(BLOCK_TAG, attPOC);
            this.text(poc == null ? "poc missing" : poc);
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
        }
        if (containsDistStatement) {
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG, "height", "" + spcPocDist + "in");
            this.writeSimpleTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_ROW_TAG);
            this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "3");
            this.writeStartTag(BLOCK_TAG, attDistStat);
            this.text(distStatement == null ? "no distribution statment set" : distStatement);
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
        }
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
    }

    private double extractFontHeightInInch(MutableAttributeSet mas, int spacing) {
        String strFtSize;
        Object oFtSize;
        double res = 0.0;
        if (mas != null && (oFtSize = mas.getAttribute("font-size")) != null && (strFtSize = oFtSize.toString()).endsWith("pt")) {
            try {
                double pxHeight = Double.parseDouble(strFtSize.substring(0, strFtSize.length() - 2));
                if (spacing > 0) {
                    pxHeight += (double)spacing;
                }
                if (pxHeight > 0.0) {
                    res = pxHeight / 72.0;
                }
            }
            catch (NumberFormatException nfe) {
                res = (double)spacing / 72.0;
            }
        }
        return res;
    }

    private double calculateImageHeight(SinkEventAttributeSet seas) {
        double res = 0.0;
        if (seas != null) {
            Object strPxWidth = seas.getAttribute((Object)"width");
            Object strPxHeight = seas.getAttribute((Object)"height");
            Object strContWidth = seas.getAttribute((Object)"content-width");
            if (strPxWidth != null && strPxHeight != null && strContWidth != null) {
                int pxWidth = Integer.parseInt(strPxWidth.toString());
                int pxHeight = Integer.parseInt(strPxHeight.toString());
                double contWidth = this.inchFromString(strContWidth.toString());
                res = this.calculateImageHeight(pxWidth, pxHeight, contWidth);
            }
        }
        return res;
    }

    private double calculateImageHeight(int pixelsWidth, int pixelsHeight, double contentWidth) {
        double res = 0.0;
        if (pixelsWidth > 0 && pixelsHeight > 0 && contentWidth > 0.0) {
            res = contentWidth / (double)pixelsWidth * (double)pixelsHeight;
        }
        return res;
    }

    private void writeCoverFooter(String titleHeader) {
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-after");
        this.writeStartTag(BLOCK_TAG, "cover.header");
        if (titleHeader != null) {
            this.write(titleHeader);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("doxia-fo", locale, this.getClass().getClassLoader());
    }

    private SinkEventAttributeSet getGraphicsAttributes(String logo) {
        MutableAttributeSet atts = null;
        try {
            atts = DoxiaUtils.getImageAttributes((String)logo);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
        }
        if (atts == null) {
            return new SinkEventAttributeSet(new String[]{"height", COVER_HEADER_HEIGHT});
        }
        int maxWidth = 225;
        if (Integer.parseInt(atts.getAttribute("width").toString()) > 225) {
            atts.addAttribute("content-width", "3.125in");
        }
        return new SinkEventAttributeSet((AttributeSet)atts);
    }

    public void activatePriorPageWriting(boolean skip) {
        this.writingPriorPage = skip;
    }

    public void resetPageCounter() {
        this.resetPageCounter = true;
    }

    public void setChapter(int chapterNumber) {
        this.chapter = chapterNumber;
    }
}

