/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoConfiguration;
import org.apache.maven.doxia.module.fo.FoMarkup;
import org.apache.maven.doxia.module.fo.NumberedListItem;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractXmlSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class FoSink
extends AbstractXmlSink
implements FoMarkup {
    private final PrintWriter out;
    private long rowCount = -1L;
    private final Stack<NumberedListItem> listStack;
    private final FoConfiguration config;
    private int section = 0;
    private int subsection = 0;
    private int subsubsection = 0;
    private int sub3section = 0;
    private int sub4section = 0;
    private int sub5section = 0;
    private boolean verbatim;
    private boolean inFigure;
    private final String encoding;
    private final String languageId;
    private final LinkedList<Boolean> tableGridStack;
    private final LinkedList<int[]> cellJustifStack;
    private final LinkedList<Boolean> isCellJustifStack;
    private final LinkedList<Integer> cellCountStack;
    private final LinkedList<StringWriter> tableContentWriterStack;
    private final LinkedList<StringWriter> tableCaptionWriterStack;
    private final LinkedList<PrettyPrintXMLWriter> tableCaptionXMLWriterStack;
    private final LinkedList<String> tableCaptionStack;
    protected Stack<List<HTML.Tag>> inlineStack = new Stack();
    protected Map<String, Set<String>> warnMessages;
    private DocumentTOC docTOC = null;
    private DocumentTOCItem lastTOCItem = null;
    private Vector<DocumentTOCItem>[] tocItemsPerLvl = null;
    int[] tocItemsListsCounters = null;
    private static final char UPPER_ALPHA = '\u0391';
    private static final char PIV = '\u03d6';
    private static final char OLINE = '\u203e';
    private static final char DIAMS = '\u2666';
    private static final char EURO = '\u20ac';
    private static final char TRADE = '\u2122';
    private static final char PRIME = '\u2032';
    private static final char PPRIME = '\u2033';

    protected FoSink(Writer writer) {
        this(writer, "UTF-8");
    }

    protected FoSink(Writer writer, String encoding) {
        this(writer, encoding, null);
    }

    protected FoSink(Writer writer, String encoding, String languageId) {
        if (writer == null) {
            throw new NullPointerException("Null writer in FO Sink!");
        }
        this.out = new PrintWriter(writer);
        this.encoding = encoding;
        this.languageId = languageId;
        this.config = new FoConfiguration();
        this.listStack = new Stack();
        this.tableGridStack = new LinkedList();
        this.cellJustifStack = new LinkedList();
        this.isCellJustifStack = new LinkedList();
        this.cellCountStack = new LinkedList();
        this.tableContentWriterStack = new LinkedList();
        this.tableCaptionWriterStack = new LinkedList();
        this.tableCaptionXMLWriterStack = new LinkedList();
        this.tableCaptionStack = new LinkedList();
        this.setNameSpace("fo");
    }

    public void load(File configFile) throws IOException {
        this.config.load(configFile);
    }

    public void head(SinkEventAttributes attributes) {
        this.init();
        this.startPageSequence("0", null, null, null);
    }

    public void head() {
        this.head(null);
    }

    public void head_() {
        this.writeEOL();
    }

    public void title(SinkEventAttributes attributes) {
        this.writeStartTag(BLOCK_TAG, "doc.header.title");
    }

    public void title() {
        this.title(null);
    }

    public void title_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void author(SinkEventAttributes attributes) {
        this.writeStartTag(BLOCK_TAG, "doc.header.author");
    }

    public void author() {
        this.author(null);
    }

    public void author_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void date(SinkEventAttributes attributes) {
        this.writeStartTag(BLOCK_TAG, "doc.header.date");
    }

    public void date() {
        this.date(null);
    }

    public void date_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void body(SinkEventAttributes attributes) {
    }

    public void body() {
        this.body(null);
    }

    public void body_() {
        this.writeEOL();
        this.writeEndTag(FLOW_TAG);
        this.writeEOL();
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.writeEOL();
        this.endDocument();
    }

    public void sectionTitle() {
    }

    public void sectionTitle_() {
    }

    public void section(int level, SinkEventAttributes attributes) {
        if (level == 1) {
            ++this.section;
            this.subsection = 0;
            this.subsubsection = 0;
        } else if (level == 2) {
            ++this.subsection;
            this.subsubsection = 0;
            this.sub3section = 0;
        } else if (level == 3) {
            ++this.subsubsection;
            this.sub3section = 0;
            this.sub4section = 0;
        } else if (level == 4) {
            ++this.sub3section;
            this.sub4section = 0;
        } else if (level == 5) {
            ++this.sub4section;
            this.sub5section = 0;
        } else if (level == 6) {
            ++this.sub5section;
        }
        this.onSection();
    }

    public void section_(int level) {
        this.onSection_();
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.onSectionTitle(level);
    }

    public void sectionTitle_(int level) {
        this.onSectionTitle_();
    }

    public void section1() {
        this.section(1, null);
    }

    public void sectionTitle1() {
        this.sectionTitle(1, null);
    }

    public void sectionTitle1_() {
        this.sectionTitle_(1);
    }

    public void section1_() {
        this.section_(1);
    }

    public void section2() {
        this.section(2, null);
    }

    public void sectionTitle2() {
        this.sectionTitle(2, null);
    }

    public void sectionTitle2_() {
        this.sectionTitle_(2);
    }

    public void section2_() {
        this.section_(2);
    }

    public void section3() {
        this.section(3, null);
    }

    public void sectionTitle3() {
        this.sectionTitle(3, null);
    }

    public void sectionTitle3_() {
        this.sectionTitle_(3);
    }

    public void section3_() {
        this.section_(3);
    }

    public void section4() {
        this.section(4, null);
    }

    public void sectionTitle4() {
        this.sectionTitle(4, null);
    }

    public void sectionTitle4_() {
        this.sectionTitle_(4);
    }

    public void section4_() {
        this.section_(4);
    }

    public void section5() {
        this.section(5, null);
    }

    public void sectionTitle5() {
        this.sectionTitle(5, null);
    }

    public void sectionTitle5_() {
        this.sectionTitle_(5);
    }

    public void section5_() {
        this.section_(5);
    }

    public void section6() {
        this.section(6, null);
    }

    public void sectionTitle6() {
        this.sectionTitle(6, null);
    }

    public void sectionTitle6_() {
        this.sectionTitle_(6);
    }

    public void section6_() {
        this.section_(6);
    }

    private void onSection() {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "body.text");
    }

    private void onSectionTitle(int depth) {
        StringBuilder title = new StringBuilder(16);
        title.append(this.getChapterString());
        String ref = null;
        this.writeEOL();
        if (depth == 1) {
            ref = this.getNextTitleReference(1);
            if (ref != null) {
                this.writeStartTag(BLOCK_TAG, "id", ref, "body.h1");
            } else {
                this.writeStartTag(BLOCK_TAG, "body.h1");
            }
            title.append(this.section).append("   ");
        } else if (depth == 2) {
            ref = this.getNextTitleReference(2);
            if (ref != null) {
                this.writeStartTag(BLOCK_TAG, "id", ref, "body.h2");
            } else {
                this.writeStartTag(BLOCK_TAG, "body.h2");
            }
            title.append(this.section).append(".");
            title.append(this.subsection).append("   ");
        } else if (depth == 3) {
            ref = this.getNextTitleReference(3);
            if (ref != null) {
                this.writeStartTag(BLOCK_TAG, "id", ref, "body.h3");
            } else {
                this.writeStartTag(BLOCK_TAG, "body.h3");
            }
            title.append(this.section).append(".");
            title.append(this.subsection).append(".");
            title.append(this.subsubsection).append("   ");
        } else if (depth == 4) {
            ref = this.getNextTitleReference(4);
            if (ref != null) {
                this.writeStartTag(BLOCK_TAG, "id", ref, "body.h4");
            } else {
                this.writeStartTag(BLOCK_TAG, "body.h4");
            }
            title.delete(0, title.length());
        } else if (depth == 5) {
            ref = this.getNextTitleReference(5);
            if (ref != null) {
                this.writeStartTag(BLOCK_TAG, "id", ref, "body.h5");
            } else {
                this.writeStartTag(BLOCK_TAG, "body.h5");
            }
            title.delete(0, title.length());
        } else if (depth == 6) {
            ref = this.getNextTitleReference(6);
            if (ref != null) {
                this.writeStartTag(BLOCK_TAG, "id", ref, "body.h6");
            } else {
                this.writeStartTag(BLOCK_TAG, "body.h6");
            }
            title.delete(0, title.length());
        }
        this.write(title.toString());
    }

    private String getNextTitleReference(int sectionLevel) {
        String res = null;
        int offset = 0;
        int localLvl = sectionLevel + offset;
        if (this.docTOC != null && localLvl >= 0 && localLvl < this.tocItemsPerLvl.length) {
            DocumentTOCItem tmp;
            Vector<DocumentTOCItem> relevantItems = this.tocItemsPerLvl[localLvl];
            int n = localLvl;
            int n2 = this.tocItemsListsCounters[n];
            this.tocItemsListsCounters[n] = n2 + 1;
            int itemIndex = n2;
            if (relevantItems != null && relevantItems.size() > itemIndex && (tmp = relevantItems.elementAt(itemIndex)) != null) {
                res = tmp.getRef();
            }
        }
        return res;
    }

    protected DocumentTOC getDocTOC() {
        return this.docTOC;
    }

    protected void setDocTOC(DocumentTOC docTOC) {
        this.docTOC = docTOC;
        this.tocItemsPerLvl = new Vector[6];
        this.tocItemsListsCounters = new int[this.tocItemsPerLvl.length];
        for (int i = 0; i < this.tocItemsPerLvl.length; ++i) {
            this.tocItemsPerLvl[i] = new Vector();
            this.tocItemsListsCounters[i] = 0;
        }
        if (docTOC != null) {
            List items = docTOC.getItems();
            int lvl = 0;
            for (DocumentTOCItem ti : items) {
                this.copyTOCItemIntoLists(ti, lvl);
            }
        }
    }

    private void copyTOCItemIntoLists(DocumentTOCItem ti, int lvl) {
        int levelOffset = 0;
        int localLevel = lvl + levelOffset;
        if (ti != null && localLevel >= 0 && localLevel < this.tocItemsPerLvl.length) {
            this.tocItemsPerLvl[localLevel].addElement(ti);
            List children = ti.getItems();
            if (children != null) {
                for (DocumentTOCItem tiC : children) {
                    this.copyTOCItemIntoLists(tiC, localLevel + 1);
                }
            }
        }
    }

    private void onSectionTitleOrig(int depth) {
        StringBuilder title = new StringBuilder(16);
        title.append(this.getChapterString());
        this.writeEOL();
        if (depth == 1) {
            this.writeStartTag(BLOCK_TAG, "body.h1");
            title.append(this.section).append("   ");
        } else if (depth == 2) {
            this.writeStartTag(BLOCK_TAG, "body.h2");
            title.append(this.section).append(".");
            title.append(this.subsection).append("   ");
        } else if (depth == 3) {
            this.writeStartTag(BLOCK_TAG, "body.h3");
            title.append(this.section).append(".");
            title.append(this.subsection).append(".");
            title.append(this.subsubsection).append("   ");
        } else if (depth == 4) {
            this.writeStartTag(BLOCK_TAG, "body.h4");
        } else {
            this.writeStartTag(BLOCK_TAG, "body.h5");
        }
        this.write(title.toString());
    }

    private void onSectionTitle_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    private void onSection_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    protected void resetSectionCounter() {
        this.section = 0;
    }

    protected String getChapterString() {
        return "";
    }

    public void list(SinkEventAttributes attributes) {
        this.writeEOL();
        this.writeStartTag(LIST_BLOCK_TAG, "list");
    }

    public void list() {
        this.list(null);
    }

    public void list_() {
        this.writeEndTag(LIST_BLOCK_TAG);
        this.writeEOL();
    }

    public void listItem(SinkEventAttributes attributes) {
        this.writeStartTag(LIST_ITEM_TAG, "list.item");
        this.writeStartTag(LIST_ITEM_LABEL_TAG);
        this.writeStartTag(BLOCK_TAG);
        this.write("&#8226;");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(LIST_ITEM_LABEL_TAG);
        this.writeEOL();
        this.writeStartTag(LIST_ITEM_BODY_TAG, "list.item");
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG);
    }

    public void listItem() {
        this.listItem(null);
    }

    public void listItem_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_BODY_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_TAG);
        this.writeEOL();
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        this.listStack.push(new NumberedListItem(numbering));
        this.writeEOL();
        this.writeStartTag(LIST_BLOCK_TAG, "list");
    }

    public void numberedList(int numbering) {
        this.numberedList(numbering, null);
    }

    public void numberedList_() {
        this.listStack.pop();
        this.writeEndTag(LIST_BLOCK_TAG);
        this.writeEOL();
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        NumberedListItem current = this.listStack.peek();
        current.next();
        this.writeStartTag(LIST_ITEM_TAG, "list.item.numbered");
        this.writeEOL();
        this.writeStartTag(LIST_ITEM_LABEL_TAG);
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG);
        this.write(current.getListItemSymbol());
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_LABEL_TAG);
        this.writeEOL();
        this.writeStartTag(LIST_ITEM_BODY_TAG, "list.item.numbered");
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG);
    }

    public void numberedListItem() {
        this.numberedListItem(null);
    }

    public void numberedListItem_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_BODY_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_TAG);
        this.writeEOL();
    }

    public void definitionList(SinkEventAttributes attributes) {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "dl");
    }

    public void definitionList() {
        this.definitionList(null);
    }

    public void definitionList_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void definitionListItem(SinkEventAttributes attributes) {
    }

    public void definitionListItem() {
        this.definitionListItem(null);
    }

    public void definitionListItem_() {
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.writeStartTag(BLOCK_TAG, "dt");
    }

    public void definedTerm() {
        this.definedTerm(null);
    }

    public void definedTerm_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void definition(SinkEventAttributes attributes) {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "dd");
    }

    public void definition() {
        this.definition(null);
    }

    public void definition_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void figure(SinkEventAttributes attributes) {
        this.inFigure = true;
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "figure.display");
    }

    public void figure() {
        this.figure(null);
    }

    public void figure_() {
        this.inFigure = false;
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void figureGraphics(String name) {
        this.figureGraphics(name, null);
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        MutableAttributeSet atts = this.config.getAttributeSet("figure.graphics");
        atts.addAttribute(HTML.Attribute.SRC.toString(), HtmlTools.escapeHTML((String)src));
        String[] valids = new String[]{"content-height", "content-width", "height", "width"};
        MutableAttributeSet filtered = SinkUtils.filterAttributes((AttributeSet)attributes, (String[])valids);
        if (filtered != null) {
            atts.addAttributes(filtered);
        }
        this.writeln("<fo:external-graphic" + SinkUtils.getAttributeString((AttributeSet)atts) + "/>");
    }

    protected boolean isFigure() {
        return this.inFigure;
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.writeStartTag(BLOCK_TAG, "figure.caption");
    }

    public void figureCaption() {
        this.figureCaption(null);
    }

    public void figureCaption_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void paragraph() {
        this.paragraph(null);
    }

    public void paragraph(SinkEventAttributes attributes) {
        MutableAttributeSet atts = this.config.getAttributeSet("normal.paragraph");
        if (attributes != null && attributes.isDefined((Object)"align")) {
            atts.addAttribute("text-align", attributes.getAttribute((Object)"align"));
        }
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, atts);
    }

    public void paragraph_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.verbatim = true;
        boolean boxed = false;
        if (attributes != null && attributes.isDefined((Object)"decoration")) {
            boxed = "boxed".equals(attributes.getAttribute((Object)"decoration").toString());
        }
        if (boxed) {
            this.writeStartTag(BLOCK_TAG, "body.source");
        } else {
            this.writeStartTag(BLOCK_TAG, "body.pre");
        }
    }

    public void verbatim(boolean boxed) {
        this.verbatim((SinkEventAttributes)(boxed ? SinkEventAttributeSet.BOXED : null));
    }

    public void verbatim_() {
        this.verbatim = false;
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.writeEOL();
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG);
        this.writeEmptyTag(LEADER_TAG, "body.rule");
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void horizontalRule() {
        this.horizontalRule(null);
    }

    public void pageBreak() {
        this.writeEmptyTag(BLOCK_TAG, "break-before", "page");
        this.writeEOL();
    }

    public void table(SinkEventAttributes attributes) {
        this.rowCount = -1L;
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "table.padding");
        this.tableContentWriterStack.addLast(new StringWriter());
        this.writeStartTag(TABLE_TAG, "table.layout");
    }

    public void table() {
        this.table(null);
    }

    public void table_() {
        String content = this.tableContentWriterStack.removeLast().toString();
        StringBuilder sb = new StringBuilder();
        int cellCount = Integer.parseInt(this.cellCountStack.removeLast().toString());
        for (int i = 0; i < cellCount; ++i) {
            sb.append("<fo:table-column column-width=\"proportional-column-width(1)\"/>");
            sb.append(EOL);
        }
        int index = content.indexOf(">") + 1;
        this.writeln(content.substring(0, index));
        this.write(sb.toString());
        this.write(content.substring(index));
        this.writeEndTag(TABLE_TAG);
        this.writeEOL();
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        if (!this.tableCaptionStack.isEmpty() && this.tableCaptionStack.getLast() != null) {
            this.paragraph(SinkEventAttributeSet.CENTER);
            this.write(this.tableCaptionStack.removeLast().toString());
            this.paragraph_();
        }
    }

    public void tableRows(int[] justification, boolean grid) {
        this.tableGridStack.addLast(grid);
        this.cellJustifStack.addLast(justification);
        this.isCellJustifStack.addLast(Boolean.TRUE);
        this.cellCountStack.addLast(0);
        this.writeEOL();
        this.writeStartTag(TABLE_BODY_TAG);
    }

    public void tableRows_() {
        this.tableGridStack.removeLast();
        this.cellJustifStack.removeLast();
        this.isCellJustifStack.removeLast();
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEOL();
    }

    public void tableRow(SinkEventAttributes attributes) {
        ++this.rowCount;
        this.writeStartTag(TABLE_ROW_TAG, "table.body.row");
        this.cellCountStack.removeLast();
        this.cellCountStack.addLast(0);
    }

    public void tableRow() {
        this.tableRow(null);
    }

    public void tableRow_() {
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEOL();
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell(false, attributes, this.rowCount);
    }

    public void tableCell() {
        this.tableCell((SinkEventAttributes)null);
    }

    public void tableCell(String width) {
        this.tableCell();
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(true, attributes, this.rowCount);
    }

    public void tableHeaderCell() {
        this.tableHeaderCell((SinkEventAttributes)null);
    }

    public void tableHeaderCell(String width) {
        this.tableHeaderCell();
    }

    private void tableCell(boolean headerRow, SinkEventAttributes attributes, long rowCount) {
        MutableAttributeSet cellAtts = headerRow ? this.config.getAttributeSet("table.heading.cell") : (rowCount % 2L == 0L ? this.config.getAttributeSet("table.body.cell") : this.config.getAttributeSet("table.body.cell.alternate"));
        int cellCount = Integer.parseInt(this.cellCountStack.getLast().toString());
        cellAtts.addAttribute("column-number", String.valueOf(cellCount + 1));
        if (this.tableGridStack.getLast().equals(Boolean.TRUE)) {
            cellAtts.addAttributes(this.config.getAttributeSet("table.body.cell.grid"));
        }
        MutableAttributeSet blockAtts = headerRow ? this.config.getAttributeSet("table.heading.block") : this.config.getAttributeSet("table.body.block");
        String justif = null;
        if (attributes == null) {
            attributes = new SinkEventAttributeSet(0);
        }
        if (attributes.isDefined((Object)HTML.Attribute.ALIGN.toString())) {
            justif = attributes.getAttribute((Object)HTML.Attribute.ALIGN.toString()).toString();
        }
        int[] cellJustif = this.cellJustifStack.getLast();
        if (justif == null && cellJustif != null && cellJustif.length > 0 && this.isCellJustifStack.getLast().equals(Boolean.TRUE)) {
            switch (cellJustif[Math.min(cellCount, cellJustif.length - 1)]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
        }
        if (justif != null) {
            blockAtts.addAttribute("text-align", justif);
        }
        this.writeStartTag(TABLE_CELL_TAG, cellAtts);
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, blockAtts);
        this.writeEOL();
    }

    public void tableCell_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEOL();
        if (this.isCellJustifStack.getLast().equals(Boolean.TRUE)) {
            int cellCount = Integer.parseInt(this.cellCountStack.removeLast().toString());
            this.cellCountStack.addLast(++cellCount);
        }
    }

    public void tableHeaderCell_() {
        this.tableCell_();
    }

    public void tableCaption(SinkEventAttributes attributes) {
        StringWriter sw = new StringWriter();
        this.tableCaptionWriterStack.addLast(sw);
        this.tableCaptionXMLWriterStack.addLast(new PrettyPrintXMLWriter((Writer)sw));
    }

    public void tableCaption() {
        this.tableCaption(null);
    }

    public void tableCaption_() {
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionStack.addLast(this.tableCaptionWriterStack.removeLast().toString());
            this.tableCaptionXMLWriterStack.removeLast();
        }
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        String anchor = name;
        if (!DoxiaUtils.isValidId((String)anchor)) {
            anchor = DoxiaUtils.encodeId((String)name, (boolean)true);
            String msg = "Modified invalid anchor name: '" + name + "' to '" + anchor + "'";
            this.logMessage("modifiedLink", msg);
        }
        anchor = "#" + name;
        this.writeStartTag(INLINE_TAG, "id", anchor);
    }

    public void anchor(String name) {
        this.anchor(name, null);
    }

    public void anchor_() {
        this.writeEndTag(INLINE_TAG);
    }

    public void link(String name, SinkEventAttributes attributes) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.writeStartTag(BASIC_LINK_TAG, "external-destination", HtmlTools.escapeHTML((String)name));
            this.writeStartTag(INLINE_TAG, "href.external");
        } else if (DoxiaUtils.isInternalLink((String)name)) {
            String anchor = name.substring(1);
            if (!DoxiaUtils.isValidId((String)anchor)) {
                anchor = DoxiaUtils.encodeId((String)anchor, (boolean)true);
                String msg = "Modified invalid anchor name: '" + name + "' to '" + anchor + "'";
                this.logMessage("modifiedLink", msg);
            }
            anchor = "#" + anchor;
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else {
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)name));
            this.writeStartTag(INLINE_TAG, "href.internal");
        }
    }

    public void link(String name) {
        this.link(name, null);
    }

    public void link_() {
        this.writeEndTag(INLINE_TAG);
        this.writeEndTag(BASIC_LINK_TAG);
    }

    public void inline() {
        this.inline(null);
    }

    public void inline(SinkEventAttributes attributes) {
        ArrayList<HTML.Tag> tags = new ArrayList<HTML.Tag>();
        if (attributes != null) {
            if (attributes.containsAttribute((Object)"semantics", (Object)"italic")) {
                this.writeStartTag(INLINE_TAG, "italic");
                tags.add(0, INLINE_TAG);
            }
            if (attributes.containsAttribute((Object)"semantics", (Object)"bold")) {
                this.writeStartTag(INLINE_TAG, "bold");
                tags.add(0, INLINE_TAG);
            }
            if (attributes.containsAttribute((Object)"semantics", (Object)"code")) {
                this.writeStartTag(INLINE_TAG, "monospace");
                tags.add(0, INLINE_TAG);
            }
        }
        this.inlineStack.push(tags);
    }

    public void inline_() {
        for (HTML.Tag tag : this.inlineStack.pop()) {
            this.writeEndTag(tag);
        }
    }

    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    public void italic_() {
        this.inline_();
    }

    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    public void bold_() {
        this.inline_();
    }

    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    public void monospaced_() {
        this.inline_();
    }

    public void lineBreak(SinkEventAttributes attributes) {
        this.writeEOL();
        this.writeEOL();
        this.writeSimpleTag(BLOCK_TAG);
    }

    public void lineBreak() {
        this.lineBreak(null);
    }

    public void nonBreakingSpace() {
        this.write("&#160;");
    }

    public void text(String text, SinkEventAttributes attributes) {
        this.content(text);
    }

    public void text(String text) {
        this.text(text, null);
    }

    public void rawText(String text) {
        this.write(text);
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
        if (this.getLog().isWarnEnabled() && this.warnMessages != null) {
            for (Map.Entry<String, Set<String>> entry : this.warnMessages.entrySet()) {
                for (String msg : entry.getValue()) {
                    this.getLog().warn((CharSequence)msg);
                }
            }
            this.warnMessages = null;
        }
        this.init();
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        String msg = "Unknown Sink event: '" + name + "', ignoring!";
        this.logMessage("unknownEvent", msg);
    }

    public void comment(String comment) {
        if (comment != null) {
            String originalComment = comment;
            while (comment.contains("--")) {
                comment = comment.replace("--", "- -");
            }
            if (comment.endsWith("-")) {
                comment = comment + " ";
            }
            if (!originalComment.equals(comment)) {
                String msg = "Modified invalid comment: '" + originalComment + "' to '" + comment + "'";
                this.logMessage("modifyComment", msg);
            }
            StringBuilder buffer = new StringBuilder(comment.length() + 7);
            buffer.append('<').append('!').append('-').append('-');
            buffer.append(comment);
            buffer.append('-').append('-').append('>');
            this.write(buffer.toString());
        }
    }

    public void beginDocument() {
        this.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.write(" encoding=\"" + this.encoding + "\"");
        }
        this.write("?>");
        this.writeEOL();
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute("xmlns:" + this.getNameSpace(), "http://www.w3.org/1999/XSL/Format");
        if (this.languageId != null) {
            atts.addAttribute("language", this.languageId);
        }
        this.writeStartTag(ROOT_TAG, (MutableAttributeSet)atts);
        this.writeStartTag(LAYOUT_MASTER_SET_TAG);
        this.writeStartTag(SIMPLE_PAGE_MASTER_TAG, "layout.master.set.cover-page");
        this.writeEmptyTag(REGION_BODY_TAG, "layout.master.set.cover-page.region-body");
        this.writeEmptyTag(REGION_BEFORE_TAG, "layout.master.set.cover-page.region-before");
        this.writeEmptyTag(REGION_AFTER_TAG, "layout.master.set.cover-page.region-after");
        this.writeEndTag(SIMPLE_PAGE_MASTER_TAG);
        this.writeEOL();
        this.writeStartTag(SIMPLE_PAGE_MASTER_TAG, "layout.master.set.toc");
        this.writeEmptyTag(REGION_BODY_TAG, "layout.master.set.toc.region-body");
        this.writeEmptyTag(REGION_BEFORE_TAG, "layout.master.set.toc.region-before");
        this.writeEmptyTag(REGION_AFTER_TAG, "layout.master.set.toc.region-after");
        this.writeEndTag(SIMPLE_PAGE_MASTER_TAG);
        this.writeEOL();
        this.writeStartTag(SIMPLE_PAGE_MASTER_TAG, "layout.master.set.body");
        this.writeEmptyTag(REGION_BODY_TAG, "layout.master.set.body.region-body");
        this.writeEmptyTag(REGION_BEFORE_TAG, "layout.master.set.body.region-before");
        this.writeEmptyTag(REGION_AFTER_TAG, "layout.master.set.body.region-after");
        this.writeEndTag(SIMPLE_PAGE_MASTER_TAG);
        this.writeEOL();
        this.writeEndTag(LAYOUT_MASTER_SET_TAG);
        this.writeEOL();
        this.pdfBookmarks();
    }

    public void endDocument() {
        this.writeEndTag(ROOT_TAG);
        this.writeEOL();
        this.flush();
        this.close();
    }

    protected FoConfiguration getFoConfiguration() {
        return this.config;
    }

    protected void writeStartTag(HTML.Tag tag, String attributeId) {
        this.writeEOL();
        this.writeStartTag(tag, this.config.getAttributeSet(attributeId));
    }

    protected void writeStartTag(HTML.Tag tag, String id, String name) {
        this.writeEOL();
        SinkEventAttributeSet att = new SinkEventAttributeSet(new String[]{id, name});
        this.writeStartTag(tag, (MutableAttributeSet)att);
    }

    protected void writeStartTag(HTML.Tag tag, String id, String name, String attributeId) {
        MutableAttributeSet att = this.config.getAttributeSet(attributeId);
        if (att.isDefined(id)) {
            att.removeAttribute(id);
        }
        att.addAttribute(id, name);
        this.writeEOL();
        this.writeStartTag(tag, att);
    }

    protected void writeEmptyTag(HTML.Tag tag, String id, String name) {
        SinkEventAttributeSet att = new SinkEventAttributeSet(new String[]{id, name});
        this.writeEOL();
        this.writeSimpleTag(tag, (MutableAttributeSet)att);
    }

    protected void writeEmptyTag(HTML.Tag tag, String attributeId) {
        this.writeEOL();
        this.writeSimpleTag(tag, this.config.getAttributeSet(attributeId));
    }

    protected void write(String text) {
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionXMLWriterStack.getLast().writeText(FoSink.unifyEOLs((String)text));
        } else if (!this.tableContentWriterStack.isEmpty() && this.tableContentWriterStack.getLast() != null) {
            this.tableContentWriterStack.getLast().write(FoSink.unifyEOLs((String)text));
        } else {
            this.out.write(FoSink.unifyEOLs((String)text));
        }
    }

    protected void writeln(String text) {
        this.write(text);
        this.writeEOL();
    }

    protected void content(String text) {
        this.write(FoSink.escaped(text, this.verbatim));
    }

    public static String escaped(String text, boolean verb) {
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block7: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    if (verb) {
                        buffer.append("&#160;");
                        continue block7;
                    }
                    buffer.append(c);
                    continue block7;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block7;
                }
                case '\n': {
                    buffer.append(EOL);
                    if (!verb) continue block7;
                    buffer.append("<fo:block/>").append(EOL);
                    continue block7;
                }
                default: {
                    if (FoSink.needsSymbolFont(c)) {
                        buffer.append("<fo:inline font-family=\"Symbol\">").append(c).append("</fo:inline>");
                        continue block7;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att, boolean isSimpleTag) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeStartTag(t, att, isSimpleTag);
        } else {
            String tag = (this.getNameSpace() != null ? this.getNameSpace() + ":" : "") + t.toString();
            this.tableCaptionXMLWriterStack.getLast().startElement(tag);
            if (att != null) {
                Enumeration<?> names = att.getAttributeNames();
                while (names.hasMoreElements()) {
                    Object key = names.nextElement();
                    Object value = att.getAttribute(key);
                    this.tableCaptionXMLWriterStack.getLast().addAttribute(key.toString(), value.toString());
                }
            }
            if (isSimpleTag) {
                this.tableCaptionXMLWriterStack.getLast().endElement();
            }
        }
    }

    protected void writeEndTag(HTML.Tag t) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeEndTag(t);
        } else {
            this.tableCaptionXMLWriterStack.getLast().endElement();
        }
    }

    private static boolean needsSymbolFont(char c) {
        return c >= '\u0391' && c <= '\u03d6' || c == '\u2032' || c == '\u2033' || c >= '\u203e' && c <= '\u2666' && c != '\u20ac' && c != '\u2122';
    }

    protected void startPageSequence(String initPageNumber, String chapterName, String headerText, String footerText) {
        this.writeln("<fo:page-sequence initial-page-number=\"" + initPageNumber + "\" master-reference=\"body\">");
        this.regionBefore(chapterName, headerText);
        this.regionAfter(footerText);
        this.writeln("<fo:flow flow-name=\"xsl-region-body\">");
        this.chapterHeading(null, true);
    }

    protected void regionBefore(String chapterName, String headerText) {
    }

    protected void regionAfter(String footerText) {
    }

    protected void chapterHeading(String headerText, boolean chapterNumber) {
    }

    protected void pdfBookmarks() {
    }

    protected void logMessage(String key, String msg) {
        Set<String> set;
        msg = "[FO Sink] " + msg;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)msg);
            return;
        }
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, Set<String>>();
        }
        if ((set = this.warnMessages.get(key)) == null) {
            set = new TreeSet<String>();
        }
        set.add(msg);
        this.warnMessages.put(key, set);
    }

    protected void init() {
        super.init();
        this.listStack.clear();
        this.tableGridStack.clear();
        this.cellJustifStack.clear();
        this.isCellJustifStack.clear();
        this.cellCountStack.clear();
        this.tableContentWriterStack.clear();
        this.tableCaptionWriterStack.clear();
        this.tableCaptionXMLWriterStack.clear();
        this.tableCaptionStack.clear();
        this.section = 0;
        this.subsection = 0;
        this.subsubsection = 0;
        this.verbatim = false;
        this.inFigure = false;
        this.warnMessages = null;
    }
}

