/*
 * Decompiled with CFR 0.152.
 */
package com.github.stanfordfuturedata.momentsketch;

import com.github.stanfordfuturedata.momentsketch.DMaxentLoss;
import com.github.stanfordfuturedata.momentsketch.MathUtil;
import com.github.stanfordfuturedata.momentsketch.MomentStruct;
import com.github.stanfordfuturedata.momentsketch.optimizer.NewtonOptimizer;

public class MomentSolver {
    private double[] c_moments;
    private double xCenter;
    private double xScale;
    private double xMin;
    private double xMax;
    private int gridSize = 1024;
    private int maxIter = 15;
    private boolean verbose = false;
    private double[] xs;
    private double[] lambd;
    private double[] weights;

    public MomentSolver(MomentStruct ms) {
        this.xMin = ms.min;
        this.xMax = ms.max;
        this.xCenter = (this.xMax + this.xMin) / 2.0;
        this.xScale = (this.xMax - this.xMin) / 2.0;
        this.c_moments = MathUtil.powerSumsToChebyMoments(this.xMin, this.xMax, ms.power_sums);
    }

    public void setGridSize(int gs) {
        this.gridSize = gs;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void solve() {
        int n = this.gridSize;
        DMaxentLoss P = new DMaxentLoss(this.c_moments, this.gridSize);
        double[] l0 = new double[this.c_moments.length];
        l0[0] = Math.log(1.0 / (double)n);
        for (int i = 1; i < l0.length; ++i) {
            l0[i] = 0.0;
        }
        NewtonOptimizer optimizer = new NewtonOptimizer(P);
        optimizer.setVerbose(this.verbose);
        optimizer.setMaxIter(this.maxIter);
        this.lambd = optimizer.solve(l0, 1.0E-6);
        P.computeAll(this.lambd, 0.0);
        this.weights = P.getWeights();
        this.xs = new double[this.gridSize];
        for (int i = 0; i < this.gridSize; ++i) {
            double scaledX = (double)i * 2.0 / (double)(this.gridSize - 1) - 1.0;
            this.xs[i] = scaledX * this.xScale + this.xCenter;
        }
    }

    public double[] getQuantiles(double[] ps) {
        double[] cdf = new double[this.gridSize];
        cdf[0] = 0.0;
        for (int i = 1; i < this.gridSize; ++i) {
            cdf[i] = cdf[i - 1] + this.weights[i];
        }
        double[] qs = new double[ps.length];
        block1: for (int i = 0; i < ps.length; ++i) {
            double p = ps[i];
            int leftIdx = 0;
            int rightIdx = this.gridSize - 1;
            if (p <= cdf[leftIdx]) {
                qs[i] = this.xs[leftIdx];
                continue;
            }
            if (cdf[rightIdx] <= p) {
                qs[i] = this.xs[rightIdx];
                continue;
            }
            while (true) {
                if (rightIdx - leftIdx <= 1) {
                    qs[i] = this.xs[rightIdx];
                    continue block1;
                }
                int midIdx = (leftIdx + rightIdx) / 2;
                if (p <= cdf[midIdx]) {
                    rightIdx = midIdx;
                    continue;
                }
                leftIdx = midIdx;
            }
        }
        return qs;
    }

    public double getQuantile(double p) {
        double[] cdf = new double[this.gridSize];
        cdf[0] = 0.0;
        for (int i = 1; i < this.gridSize; ++i) {
            cdf[i] = cdf[i - 1] + this.weights[i];
        }
        double lastRank = 0.0;
        double curRank = 0.0;
        int targetIdx = this.gridSize - 1;
        for (int curIdx = 0; curIdx < this.gridSize; ++curIdx) {
            lastRank = curRank;
            curRank = cdf[curIdx];
            if (!(curRank >= p)) continue;
            targetIdx = curIdx;
            break;
        }
        double q = this.xs[targetIdx];
        return q;
    }

    public double[] getXs() {
        return this.xs;
    }

    public double[] getWeights() {
        return this.weights;
    }
}

