/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.BaseExtension;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import test.InstrExtension;
import test.JSONGenerator;
import test.ProfPlugin;
import test.TestRunnerInfo;
import test.Transformer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Ltest/ProfPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "target", "NaviProf"})
public class ProfPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        InstrExtension extension = (InstrExtension)target.getExtensions().create("profilingPlugin", InstrExtension.class, new Object[0]);
        Object object = target.getExtensions().findByName("android");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
        }
        BaseExtension android = (BaseExtension)object;
        InstrExtension instrExtension = extension;
        Intrinsics.checkExpressionValueIsNotNull((Object)instrExtension, (String)"extension");
        android.registerTransform((Transform)new Transformer(android, instrExtension), new Object[0]);
        File file = android.getAdbExecutable();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"android.adbExecutable");
        File adb = file;
        Function1<String[], Unit> $fun$runCommand$1 = new Function1<String[], Unit>(target){
            final /* synthetic */ Project $target;

            public final void invoke(String ... args) {
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                this.$target.exec((Action)new Action<ExecSpec>(args){
                    final /* synthetic */ String[] $args;

                    public final void execute(ExecSpec it) {
                        it.workingDir((Object)"./..");
                        it.commandLine((Object[])Arrays.copyOf(this.$args, this.$args.length));
                    }
                    {
                        this.$args = stringArray;
                    }
                });
            }
            {
                this.$target = project;
                super(1);
            }
        };
        Function0 clearLogs2 = (Function0)new Function0<ExecResult>(target, adb){
            final /* synthetic */ Project $target;
            final /* synthetic */ File $adb;

            public final ExecResult invoke() {
                return this.$target.exec((Action)new Action<ExecSpec>(this){
                    final /* synthetic */ apply.clearLogs.1 this$0;

                    public final void execute(ExecSpec it) {
                        ExecSpec execSpec = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                        execSpec.setIgnoreExitValue(true);
                        it.commandLine(new Object[]{String.valueOf(this.this$0.$adb), "logcat", "-c"});
                        it.commandLine(new Object[]{String.valueOf(this.this$0.$adb), "logcat", "-c"});
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$target = project;
                this.$adb = file;
                super(0);
            }
        };
        Function1 getTestRunnerInfo2 = (Function1)new Function1<String, TestRunnerInfo>(target){
            final /* synthetic */ Project $target;

            @NotNull
            public final TestRunnerInfo invoke(@NotNull String apkPath) {
                Intrinsics.checkParameterIsNotNull((Object)apkPath, (String)"apkPath");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.$target.exec((Action)new Action<ExecSpec>(out, apkPath){
                    final /* synthetic */ ByteArrayOutputStream $out;
                    final /* synthetic */ String $apkPath;

                    public final void execute(ExecSpec it) {
                        ExecSpec execSpec = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                        execSpec.setStandardOutput((OutputStream)this.$out);
                        it.workingDir((Object)"./..");
                        it.commandLine(new Object[]{"aapt", "dump", "xmltree", this.$apkPath, "AndroidManifest.xml"});
                    }
                    {
                        this.$out = byteArrayOutputStream;
                        this.$apkPath = string;
                    }
                });
                String string = out.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
                return new TestRunnerInfo(string);
            }
            {
                this.$target = project;
                super(1);
            }
        };
        Function2 runTestClass2 = (Function2)new Function2<String, TestRunnerInfo, Unit>($fun$runCommand$1, adb){
            final /* synthetic */ apply.1 $runCommand$1;
            final /* synthetic */ File $adb;

            public final void invoke(@NotNull String testPath, @NotNull TestRunnerInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)testPath, (String)"testPath");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                this.$runCommand$1.invoke(String.valueOf(this.$adb), "shell", "am", "instrument", "-w", "-e", "class", info.getTargetPackage() + '.' + testPath, info.getTestPackage() + '/' + info.getRunnerName());
            }
            {
                this.$runCommand$1 = var1_1;
                this.$adb = file;
                super(2);
            }
        };
        Function3 runTestMethod2 = (Function3)new Function3<String, TestRunnerInfo, String, Unit>($fun$runCommand$1, adb){
            final /* synthetic */ apply.1 $runCommand$1;
            final /* synthetic */ File $adb;

            public final void invoke(@NotNull String testPath, @NotNull TestRunnerInfo info, @NotNull String methodName) {
                Intrinsics.checkParameterIsNotNull((Object)testPath, (String)"testPath");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                this.$runCommand$1.invoke(String.valueOf(this.$adb), "shell", "am", "instrument", "-w", "-e", "class", info.getTargetPackage() + '.' + testPath + '#' + methodName, info.getTestPackage() + '/' + info.getRunnerName());
            }
            {
                this.$runCommand$1 = var1_1;
                this.$adb = file;
                super(3);
            }
        };
        Function3 printLogsOfMethod2 = (Function3)new Function3<File, String, String, ExecResult>(target, adb){
            final /* synthetic */ Project $target;
            final /* synthetic */ File $adb;

            public final ExecResult invoke(@NotNull File profileOutput, @NotNull String pathName, @NotNull String method) {
                Intrinsics.checkParameterIsNotNull((Object)profileOutput, (String)"profileOutput");
                Intrinsics.checkParameterIsNotNull((Object)pathName, (String)"pathName");
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                return this.$target.exec((Action)new Action<ExecSpec>(this, profileOutput, pathName, method){
                    final /* synthetic */ apply.printLogsOfMethod.1 this$0;
                    final /* synthetic */ File $profileOutput;
                    final /* synthetic */ String $pathName;
                    final /* synthetic */ String $method;

                    public final void execute(ExecSpec it) {
                        it.commandLine(new Object[]{String.valueOf(this.this$0.$adb), "logcat", "-d", "-s", "TEST"});
                        ExecSpec execSpec = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                        execSpec.setStandardOutput((OutputStream)new FileOutputStream(this.$profileOutput.getAbsolutePath() + '/' + this.$pathName + '.' + this.$method + ".txt"));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$profileOutput = file;
                        this.$pathName = string;
                        this.$method = string2;
                    }
                });
            }
            {
                this.$target = project;
                this.$adb = file;
                super(3);
            }
        };
        Function2 printLogs2 = (Function2)new Function2<File, String, ExecResult>(target, adb){
            final /* synthetic */ Project $target;
            final /* synthetic */ File $adb;

            public final ExecResult invoke(@NotNull File profileOutput, @NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)profileOutput, (String)"profileOutput");
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                return this.$target.exec((Action)new Action<ExecSpec>(this, profileOutput, path){
                    final /* synthetic */ apply.printLogs.1 this$0;
                    final /* synthetic */ File $profileOutput;
                    final /* synthetic */ String $path;

                    public final void execute(ExecSpec it) {
                        it.commandLine(new Object[]{String.valueOf(this.this$0.$adb), "logcat", "-d", "-s", "TEST"});
                        ExecSpec execSpec = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"it");
                        execSpec.setStandardOutput((OutputStream)new FileOutputStream(this.$profileOutput.getAbsolutePath() + '/' + this.$path + ".txt"));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$profileOutput = file;
                        this.$path = string;
                    }
                });
            }
            {
                this.$target = project;
                this.$adb = file;
                super(2);
            }
        };
        Function3 execTests2 = (Function3)new Function3<Project, String, List<? extends String>, Unit>(getTestRunnerInfo2, target, clearLogs2, runTestClass2, printLogs2, runTestMethod2, printLogsOfMethod2, $fun$runCommand$1){
            final /* synthetic */ Function1 $getTestRunnerInfo;
            final /* synthetic */ Project $target;
            final /* synthetic */ Function0 $clearLogs;
            final /* synthetic */ Function2 $runTestClass;
            final /* synthetic */ Function2 $printLogs;
            final /* synthetic */ Function3 $runTestMethod;
            final /* synthetic */ Function3 $printLogsOfMethod;
            final /* synthetic */ apply.1 $runCommand$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void invoke(@NotNull Project project, @Nullable String testApkPath, @Nullable List<String> testPaths) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (testPaths != null && testApkPath != null) {
                    TestRunnerInfo testRunnerInfo = (TestRunnerInfo)this.$getTestRunnerInfo.invoke((Object)testApkPath);
                    File profileOutput = new File(this.$target.getProjectDir() + "/profileOutput");
                    if (!profileOutput.exists()) {
                        profileOutput.mkdirs();
                    }
                    if (project.hasProperty("granularity")) {
                        Object object = project.property("granularity");
                        if (Intrinsics.areEqual((Object)object, (Object)"class")) {
                            for (String path : testPaths) {
                                this.$clearLogs.invoke();
                                this.$runTestClass.invoke((Object)path, (Object)testRunnerInfo);
                                this.$printLogs.invoke((Object)profileOutput, (Object)path);
                            }
                            return;
                        } else {
                            if (!Intrinsics.areEqual((Object)object, (Object)"methods")) {
                                this.$runCommand$1.invoke("echo", "\n!Error at running tests: granularity must be either \"methods\" or \"class\"\n");
                                throw (Throwable)new GradleException("Wrong argument");
                            }
                            for (String path : testPaths) {
                                String pathName = StringsKt.substringBefore$default((String)path, (char)'#', null, (int)2, null);
                                List methods = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)path, (char)'#', null, (int)2, null), (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
                                for (String method : methods) {
                                    this.$clearLogs.invoke();
                                    this.$runTestMethod.invoke((Object)pathName, (Object)testRunnerInfo, (Object)method);
                                    this.$printLogsOfMethod.invoke((Object)profileOutput, (Object)pathName, (Object)method);
                                }
                            }
                        }
                        return;
                    }
                    for (String path : testPaths) {
                        this.$clearLogs.invoke();
                        this.$runTestClass.invoke((Object)path, (Object)testRunnerInfo);
                        this.$printLogs.invoke((Object)profileOutput, (Object)path);
                    }
                    return;
                }
                this.$runCommand$1.invoke("echo", "\n!Error at running tests: test_paths should be passed\n");
                throw (Throwable)new GradleException("Arguments are not passed");
            }
            {
                this.$getTestRunnerInfo = function1;
                this.$target = project;
                this.$clearLogs = function0;
                this.$runTestClass = function2;
                this.$printLogs = function22;
                this.$runTestMethod = function3;
                this.$printLogsOfMethod = function32;
                this.$runCommand$1 = var8_8;
                super(3);
            }
        };
        target.getTasks().register("customProfile", (Action)new Action<Task>(target){
            final /* synthetic */ Project $target;

            public final void execute(Task it) {
                it.doLast((Action)new Action<Task>(this){
                    final /* synthetic */ apply.2 this$0;

                    public final void execute(Task it) {
                        new JSONGenerator().generate(this.this$0.$target.getProjectDir() + "/profileOutput/");
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$target = project;
            }
        });
        target.getTasks().named("customProfile").configure((Action)apply.3.INSTANCE);
        target.getTasks().register("runCustomTests", (Action)new Action<Task>(execTests2){
            final /* synthetic */ Function3 $execTests;

            public final void execute(Task it) {
                it.doLast((Action)new Action<Task>(this){
                    final /* synthetic */ apply.4 this$0;

                    public final void execute(Task it) {
                        List list;
                        String testApkPath;
                        String string;
                        Task task = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                        if (task.getProject().hasProperty("test_apk_path")) {
                            Object object = it.getProject().property("test_apk_path");
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            string = (String)object;
                        } else {
                            string = testApkPath = null;
                        }
                        if (it.getProject().hasProperty("test_paths")) {
                            Object object = it.getProject().property("test_paths");
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            String paths = (String)object;
                            list = StringsKt.split$default((CharSequence)paths, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                        } else {
                            list = null;
                        }
                        List testPaths = list;
                        Function3 function3 = this.this$0.$execTests;
                        Project project = it.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it.project");
                        function3.invoke((Object)project, (Object)testApkPath, testPaths);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$execTests = function3;
            }
        });
        target.getTasks().register("profileBuild", (Action)new Action<Task>($fun$runCommand$1, adb, target){
            final /* synthetic */ apply.1 $runCommand$1;
            final /* synthetic */ File $adb;
            final /* synthetic */ Project $target;

            public final void execute(Task it) {
                it.dependsOn(new Object[]{"assembleDebug", "assembleDebugAndroidTest"});
                Function1 installApk2 = (Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ apply.5 this$0;

                    public final void invoke(@NotNull String apkPath) {
                        Intrinsics.checkParameterIsNotNull((Object)apkPath, (String)"apkPath");
                        this.this$0.$runCommand$1.invoke("echo", "APK Installing: ", apkPath);
                        this.this$0.$runCommand$1.invoke(String.valueOf(this.this$0.$adb), "install", "-r", apkPath);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                it.doLast((Action)new Action<Task>(this, installApk2){
                    final /* synthetic */ apply.5 this$0;
                    final /* synthetic */ Function1 $installApk;

                    public final void execute(Task it) {
                        Project project = this.this$0.$target.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"target.project");
                        String projectName = project.getName();
                        String apkPath = projectName + "/build/outputs/apk/debug/" + projectName + "-debug.apk";
                        String testApkPath = projectName + "/build/outputs/apk/androidTest/debug/" + projectName + "-debug-androidTest.apk";
                        this.$installApk.invoke((Object)apkPath);
                        this.$installApk.invoke((Object)testApkPath);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$installApk = function1;
                    }
                });
            }
            {
                this.$runCommand$1 = var1_1;
                this.$adb = file;
                this.$target = project;
            }
        });
        target.getTasks().register("defaultProfile", (Action)new Action<Task>(target){
            final /* synthetic */ Project $target;

            public final void execute(Task it) {
                it.doLast((Action)new Action<Task>(this){
                    final /* synthetic */ apply.6 this$0;

                    public final void execute(Task it) {
                        new JSONGenerator().generate(this.this$0.$target.getProjectDir() + "/profileOutput/");
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$target = project;
            }
        });
        target.getTasks().named("defaultProfile").configure((Action)apply.7.INSTANCE);
        target.getTasks().named("defaultProfile").configure((Action)apply.8.INSTANCE);
        target.getTasks().register("runTests", (Action)new Action<Task>(target, execTests2){
            final /* synthetic */ Project $target;
            final /* synthetic */ Function3 $execTests;

            public final void execute(Task it) {
                it.doLast((Action)new Action<Task>(this){
                    final /* synthetic */ apply.9 this$0;

                    public final void execute(Task it) {
                        List list;
                        Project project = this.this$0.$target.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"target.project");
                        String projectName = project.getName();
                        String testApkPath = projectName + "/build/outputs/apk/androidTest/debug/" + projectName + "-debug-androidTest.apk";
                        Task task = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                        if (task.getProject().hasProperty("test_paths")) {
                            Object object = it.getProject().property("test_paths");
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            String paths = (String)object;
                            list = StringsKt.split$default((CharSequence)paths, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                        } else {
                            list = null;
                        }
                        List testPaths = list;
                        Function3 function3 = this.this$0.$execTests;
                        Project project2 = it.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"it.project");
                        function3.invoke((Object)project2, (Object)testApkPath, testPaths);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$target = project;
                this.$execTests = function3;
            }
        });
        target.getTasks().named("runTests").configure((Action)apply.10.INSTANCE);
    }
}

