/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui.type.util;

import com.github.stefvanschie.inventoryframework.HumanEntityCache;
import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiListener;
import com.github.stefvanschie.inventoryframework.gui.type.AnvilGui;
import com.github.stefvanschie.inventoryframework.gui.type.BarrelGui;
import com.github.stefvanschie.inventoryframework.gui.type.BeaconGui;
import com.github.stefvanschie.inventoryframework.gui.type.BlastFurnaceGui;
import com.github.stefvanschie.inventoryframework.gui.type.BrewingStandGui;
import com.github.stefvanschie.inventoryframework.gui.type.CartographyTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.gui.type.CraftingTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.DispenserGui;
import com.github.stefvanschie.inventoryframework.gui.type.DropperGui;
import com.github.stefvanschie.inventoryframework.gui.type.EnchantingTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.EnderChestGui;
import com.github.stefvanschie.inventoryframework.gui.type.FurnaceGui;
import com.github.stefvanschie.inventoryframework.gui.type.GrindstoneGui;
import com.github.stefvanschie.inventoryframework.gui.type.HopperGui;
import com.github.stefvanschie.inventoryframework.gui.type.MerchantGui;
import com.github.stefvanschie.inventoryframework.gui.type.ShulkerBoxGui;
import com.github.stefvanschie.inventoryframework.gui.type.SmithingTableGui;
import com.github.stefvanschie.inventoryframework.gui.type.SmokerGui;
import com.github.stefvanschie.inventoryframework.gui.type.StonecutterGui;
import com.github.stefvanschie.inventoryframework.pane.MasonryPane;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.PaginatedPane;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.PatternPane;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import com.github.stefvanschie.inventoryframework.pane.component.CycleButton;
import com.github.stefvanschie.inventoryframework.pane.component.Label;
import com.github.stefvanschie.inventoryframework.pane.component.PagingButtons;
import com.github.stefvanschie.inventoryframework.pane.component.PercentageBar;
import com.github.stefvanschie.inventoryframework.pane.component.Slider;
import com.github.stefvanschie.inventoryframework.pane.component.ToggleButton;
import com.github.stefvanschie.inventoryframework.util.TriFunction;
import com.github.stefvanschie.inventoryframework.util.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Gui {
    @NotNull
    protected final Plugin plugin;
    protected Inventory inventory;
    @NotNull
    protected final HumanEntityCache humanEntityCache = new HumanEntityCache();
    @Nullable
    protected Consumer<InventoryClickEvent> onTopClick;
    @Nullable
    protected Consumer<InventoryClickEvent> onBottomClick;
    @Nullable
    protected Consumer<InventoryClickEvent> onGlobalClick;
    @Nullable
    protected Consumer<InventoryClickEvent> onOutsideClick;
    @Nullable
    protected Consumer<InventoryDragEvent> onTopDrag;
    @Nullable
    protected Consumer<InventoryDragEvent> onBottomDrag;
    @Nullable
    protected Consumer<InventoryDragEvent> onGlobalDrag;
    @Nullable
    protected Consumer<InventoryCloseEvent> onClose;
    boolean updating = false;
    @Nullable
    private Gui parent;
    @NotNull
    private static final Map<String, TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Pane>> PANE_MAPPINGS = new HashMap<String, TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Pane>>();
    @NotNull
    private static final Map<String, TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Gui>> GUI_MAPPINGS = new HashMap<String, TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Gui>>();
    @NotNull
    private static final Map<Inventory, Gui> GUI_INVENTORIES = new WeakHashMap<Inventory, Gui>();
    private static boolean hasRegisteredListeners;

    public Gui(@NotNull Plugin plugin) {
        this.plugin = plugin;
        if (!hasRegisteredListeners) {
            Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(plugin), plugin);
            hasRegisteredListeners = true;
        }
    }

    public abstract void show(@NotNull HumanEntity var1);

    @NotNull
    @Contract(pure=true)
    public abstract Gui copy();

    public abstract void click(@NotNull InventoryClickEvent var1);

    public abstract boolean isPlayerInventoryUsed();

    @Contract(pure=true)
    public abstract int getViewerCount();

    @NotNull
    @Contract(pure=true)
    public abstract List<HumanEntity> getViewers();

    public void update() {
        this.updating = true;
        for (HumanEntity viewer : this.getViewers()) {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.show(viewer);
            viewer.setItemOnCursor(cursor);
        }
        if (!this.updating) {
            throw new AssertionError((Object)"Gui#isUpdating became false before Gui#update finished");
        }
        this.updating = false;
    }

    protected void addInventory(@NotNull Inventory inventory, @NotNull Gui gui) {
        GUI_INVENTORIES.put(inventory, gui);
    }

    @Nullable
    @Contract(pure=true)
    public static Gui getGui(@NotNull Inventory inventory) {
        return GUI_INVENTORIES.get(inventory);
    }

    @NotNull
    @Contract(pure=true)
    public HumanEntityCache getHumanEntityCache() {
        return this.humanEntityCache;
    }

    @Nullable
    public static Gui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            if (!documentElement.hasAttribute("type")) {
                throw new XMLLoadException("Type attribute must be specified when loading via Gui.load");
            }
            String type = documentElement.getAttribute("type");
            TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Gui> mapping = GUI_MAPPINGS.get(type);
            if (mapping == null) {
                throw new XMLLoadException("Type attribute '" + type + "' is invalid");
            }
            return mapping.apply(instance, documentElement, (Plugin)plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Gui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return Gui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(Gui.class));
    }

    protected void initializeOrThrow(@NotNull Object instance, @NotNull Element element) {
        if (element.hasAttribute("field")) {
            XMLUtil.loadFieldAttribute(instance, element, this);
        }
        if (element.hasAttribute("onTopClick")) {
            this.setOnTopClick(XMLUtil.loadOnEventAttribute(instance, element, InventoryClickEvent.class, "onTopClick"));
        }
        if (element.hasAttribute("onBottomClick")) {
            this.setOnBottomClick(XMLUtil.loadOnEventAttribute(instance, element, InventoryClickEvent.class, "onBottomClick"));
        }
        if (element.hasAttribute("onGlobalClick")) {
            this.setOnGlobalClick(XMLUtil.loadOnEventAttribute(instance, element, InventoryClickEvent.class, "onGlobalClick"));
        }
        if (element.hasAttribute("onOutsideClick")) {
            this.setOnOutsideClick(XMLUtil.loadOnEventAttribute(instance, element, InventoryClickEvent.class, "onOutsideClick"));
        }
        if (element.hasAttribute("onTopDrag")) {
            this.setOnTopDrag(XMLUtil.loadOnEventAttribute(instance, element, InventoryDragEvent.class, "onTopDrag"));
        }
        if (element.hasAttribute("onBottomDrag")) {
            this.setOnBottomDrag(XMLUtil.loadOnEventAttribute(instance, element, InventoryDragEvent.class, "onBottomDrag"));
        }
        if (element.hasAttribute("onGlobalDrag")) {
            this.setOnGlobalDrag(XMLUtil.loadOnEventAttribute(instance, element, InventoryDragEvent.class, "onGlobalDrag"));
        }
        if (element.hasAttribute("onClose")) {
            this.setOnClose(XMLUtil.loadOnEventAttribute(instance, element, InventoryCloseEvent.class, "onClose"));
        }
        if (element.hasAttribute("populate")) {
            XMLUtil.invokeMethod(instance, element.getAttribute("populate"), this, Gui.class);
        }
    }

    public void setOnTopClick(@Nullable Consumer<InventoryClickEvent> onTopClick) {
        this.onTopClick = onTopClick;
    }

    public void callOnTopClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onTopClick, event, "onTopClick");
    }

    public void setOnBottomClick(@Nullable Consumer<InventoryClickEvent> onBottomClick) {
        this.onBottomClick = onBottomClick;
    }

    public void callOnBottomClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onBottomClick, event, "onBottomClick");
    }

    public void setOnGlobalClick(@Nullable Consumer<InventoryClickEvent> onGlobalClick) {
        this.onGlobalClick = onGlobalClick;
    }

    public void callOnGlobalClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onGlobalClick, event, "onGlobalClick");
    }

    public void setOnOutsideClick(@Nullable Consumer<InventoryClickEvent> onOutsideClick) {
        this.onOutsideClick = onOutsideClick;
    }

    public void callOnOutsideClick(@NotNull InventoryClickEvent event) {
        this.callCallback(this.onOutsideClick, event, "onOutsideClick");
    }

    public void setOnTopDrag(@Nullable Consumer<InventoryDragEvent> onTopDrag) {
        this.onTopDrag = onTopDrag;
    }

    public void callOnTopDrag(@NotNull InventoryDragEvent event) {
        this.callCallback(this.onTopDrag, event, "onTopDrag");
    }

    public void setOnBottomDrag(@Nullable Consumer<InventoryDragEvent> onBottomDrag) {
        this.onBottomDrag = onBottomDrag;
    }

    public void callOnBottomDrag(@NotNull InventoryDragEvent event) {
        this.callCallback(this.onBottomDrag, event, "onBottomDrag");
    }

    public void setOnGlobalDrag(@Nullable Consumer<InventoryDragEvent> onGlobalDrag) {
        this.onGlobalDrag = onGlobalDrag;
    }

    public void callOnGlobalDrag(@NotNull InventoryDragEvent event) {
        this.callCallback(this.onGlobalDrag, event, "onGlobalDrag");
    }

    public void setOnClose(@Nullable Consumer<InventoryCloseEvent> onClose) {
        this.onClose = onClose;
    }

    public void callOnClose(@NotNull InventoryCloseEvent event) {
        this.callCallback(this.onClose, event, "onClose");
    }

    protected <T extends InventoryEvent> void callCallback(@Nullable Consumer<? super T> callback, @NotNull T event, @NotNull String callbackName) {
        if (callback == null) {
            return;
        }
        try {
            callback.accept(event);
        }
        catch (Throwable t) {
            String message = "Exception while handling " + callbackName;
            if (event instanceof InventoryClickEvent) {
                InventoryClickEvent clickEvent = (InventoryClickEvent)event;
                message = message + ", slot=" + clickEvent.getSlot();
            }
            this.plugin.getLogger().log(Level.SEVERE, message, t);
        }
    }

    public void navigateToParent(@NotNull HumanEntity humanEntity) {
        if (this.parent == null) {
            return;
        }
        this.parent.show(humanEntity);
    }

    public void setParent(@NotNull Gui gui) {
        this.parent = gui;
    }

    @Contract(pure=true)
    public boolean isUpdating() {
        return this.updating;
    }

    public static void registerProperty(@NotNull String attributeName, @NotNull Function<String, Object> function) {
        Pane.registerProperty(attributeName, function);
    }

    public static void registerPane(@NotNull String name, @NotNull TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Pane> triFunction) {
        if (PANE_MAPPINGS.containsKey(name)) {
            throw new IllegalArgumentException("pane name '" + name + "' is already registered");
        }
        PANE_MAPPINGS.put(name, triFunction);
    }

    public static void registerPane(@NotNull String name, @NotNull BiFunction<Object, Element, Pane> biFunction) {
        Gui.registerPane(name, (? super Object object, ? super Element element, ? super Plugin plugin) -> (Pane)biFunction.apply(object, (Element)element));
    }

    public static void registerGui(@NotNull String name, @NotNull TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Gui> triFunction) {
        if (GUI_MAPPINGS.containsKey(name)) {
            throw new IllegalArgumentException("Gui name '" + name + "' is already registered");
        }
        GUI_MAPPINGS.put(name, triFunction);
    }

    @Deprecated
    public static void registerGui(@NotNull String name, @NotNull BiFunction<? super Object, ? super Element, ? extends Gui> biFunction) {
        Gui.registerGui(name, (? super Object object, ? super Element element, ? super Plugin plugin) -> (Gui)biFunction.apply(object, (Element)element));
    }

    @NotNull
    public static Pane loadPane(@NotNull Object instance, @NotNull Node node, @NotNull Plugin plugin) {
        String name = node.getNodeName();
        TriFunction<? super Object, ? super Element, ? super Plugin, ? extends Pane> mapping = PANE_MAPPINGS.get(name);
        if (mapping == null) {
            throw new XMLLoadException("Pane '" + name + "' is not registered or does not exist");
        }
        return mapping.apply(instance, (Element)node, (Plugin)plugin);
    }

    @NotNull
    public static Pane loadPane(@NotNull Object instance, @NotNull Node node) {
        return Gui.loadPane(instance, node, (Plugin)JavaPlugin.getProvidingPlugin(Gui.class));
    }

    static {
        Gui.registerPane("masonrypane", MasonryPane::load);
        Gui.registerPane("outlinepane", OutlinePane::load);
        Gui.registerPane("paginatedpane", PaginatedPane::load);
        Gui.registerPane("patternpane", PatternPane::load);
        Gui.registerPane("staticpane", StaticPane::load);
        Gui.registerPane("cyclebutton", CycleButton::load);
        Gui.registerPane("label", Label::load);
        Gui.registerPane("pagingbuttons", PagingButtons::load);
        Gui.registerPane("percentagebar", PercentageBar::load);
        Gui.registerPane("slider", Slider::load);
        Gui.registerPane("togglebutton", ToggleButton::load);
        Gui.registerGui("anvil", AnvilGui::load);
        Gui.registerGui("barrel", BarrelGui::load);
        Gui.registerGui("beacon", BeaconGui::load);
        Gui.registerGui("blast-furnace", BlastFurnaceGui::load);
        Gui.registerGui("brewing-stand", BrewingStandGui::load);
        Gui.registerGui("cartography-table", CartographyTableGui::load);
        Gui.registerGui("chest", ChestGui::load);
        Gui.registerGui("crafting-table", CraftingTableGui::load);
        Gui.registerGui("dispenser", DispenserGui::load);
        Gui.registerGui("dropper", DropperGui::load);
        Gui.registerGui("enchanting-table", EnchantingTableGui::load);
        Gui.registerGui("ender-chest", EnderChestGui::load);
        Gui.registerGui("furnace", FurnaceGui::load);
        Gui.registerGui("grindstone", GrindstoneGui::load);
        Gui.registerGui("hopper", HopperGui::load);
        Gui.registerGui("merchant", MerchantGui::load);
        Gui.registerGui("shulker-box", ShulkerBoxGui::load);
        Gui.registerGui("smithing-table", SmithingTableGui::load);
        Gui.registerGui("smoker", SmokerGui::load);
        Gui.registerGui("stonecutter", StonecutterGui::load);
    }
}

