/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class ContrastAdjustmentFilter
extends Filter {
    private static final Logger logger = Logger.getLogger(ContrastAdjustmentFilter.class.getName());
    public static final String assetPath = "MatDefs/filter/ContrastAdjustment.j3md";
    private float exponent;

    public ContrastAdjustmentFilter(float exponent) {
        super("ContrastAdjustmentFilter");
        Validate.positive(exponent, "exponent");
        this.setExponent(exponent);
    }

    public float getExponent() {
        assert (this.exponent > 0.0f) : this.exponent;
        return this.exponent;
    }

    public final void setExponent(float newExponent) {
        Validate.positive(newExponent, "exponent");
        if (this.material != null) {
            this.material.setFloat("Exponent", newExponent);
        }
        this.exponent = newExponent;
    }

    protected Material getMaterial() {
        assert (this.material != null);
        return this.material;
    }

    protected void initFilter(AssetManager assetManager, RenderManager renderManager, ViewPort viewPort, int width, int height) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(renderManager, "render manager");
        Validate.nonNull(viewPort, "view port");
        Validate.positive(width, "width");
        Validate.positive(height, "height");
        this.material = new Material(assetManager, assetPath);
        this.material.setFloat("Exponent", this.exponent);
    }

    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.exponent = capsule.readFloat("exponent", 1.0f);
    }

    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule oc = exporter.getCapsule((Savable)this);
        oc.write(this.exponent, "exponent", 1.0f);
    }
}

