/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.debug.SkeletonVisualizer;

public class InfluenceUtil {
    private static final int maxWeights = 4;
    private static final Logger logger = Logger.getLogger(InfluenceUtil.class.getName());

    private InfluenceUtil() {
    }

    public static void hideNonInfluencers(SkeletonVisualizer visualizer, SkeletonControl skeletonControl) {
        Spatial subtree = skeletonControl.getSpatial();
        Skeleton skeleton = skeletonControl.getSkeleton();
        BitSet influencers = InfluenceUtil.addAllInfluencers(subtree, skeleton);
        int numBones = skeleton.getBoneCount();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            if (influencers.get(boneIndex)) continue;
            visualizer.setHeadColor(boneIndex, ColorRGBA.BlackNoAlpha);
        }
    }

    public static void hideNonInfluencers(SkeletonVisualizer visualizer, SkinningControl skinningControl) {
        Spatial subtree = skinningControl.getSpatial();
        Armature armature = skinningControl.getArmature();
        BitSet influencers = InfluenceUtil.addAllInfluencers(subtree, armature);
        int numJoints = armature.getJointCount();
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            if (influencers.get(jointIndex)) continue;
            visualizer.setHeadColor(jointIndex, ColorRGBA.BlackNoAlpha);
        }
    }

    public static BitSet addAllInfluencers(Spatial subtree, Armature armature) {
        int numJoints = armature.getJointCount();
        BitSet result = new BitSet(numJoints);
        InfluenceUtil.addDirectInfluencers(subtree, result);
        for (int boneIndex = 0; boneIndex < numJoints; ++boneIndex) {
            if (!result.get(boneIndex)) continue;
            Joint joint = armature.getJoint(boneIndex);
            for (Joint parent = joint.getParent(); parent != null; parent = parent.getParent()) {
                int parentIndex = armature.getJointIndex(parent);
                result.set(parentIndex);
            }
        }
        return result;
    }

    public static BitSet addAllInfluencers(Spatial subtree, Skeleton skeleton) {
        int numBones = skeleton.getBoneCount();
        BitSet result = new BitSet(numBones);
        InfluenceUtil.addDirectInfluencers(subtree, result);
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            if (!result.get(boneIndex)) continue;
            Bone bone = skeleton.getBone(boneIndex);
            for (Bone parent = bone.getParent(); parent != null; parent = parent.getParent()) {
                int parentIndex = skeleton.getBoneIndex(parent);
                result.set(parentIndex);
            }
        }
        return result;
    }

    public static void addDirectInfluencers(Spatial subtree, BitSet addResult) {
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Mesh mesh = geometry.getMesh();
            if (MyMesh.isAnimated(mesh)) {
                InfluenceUtil.addDirectInfluencers(mesh, addResult);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                InfluenceUtil.addDirectInfluencers(child, addResult);
            }
        }
    }

    private static void addDirectInfluencers(Mesh mesh, BitSet addResult) {
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        assert (maxWeightsPerVert > 0) : maxWeightsPerVert;
        assert (maxWeightsPerVert <= 4) : maxWeightsPerVert;
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyMesh.readIndex(boneIndexBuffer);
                if (wIndex >= maxWeightsPerVert || weight == 0.0f) continue;
                addResult.set(boneIndex);
            }
        }
    }
}

