/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimTrack;
import com.jme3.anim.Joint;
import com.jme3.anim.MorphTrack;
import com.jme3.anim.TransformTrack;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.AudioTrack;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.EffectTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.Arrays;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyArray;

public class MyAnimation {
    private static final Logger logger = Logger.getLogger(MyAnimation.class.getName());

    private MyAnimation() {
    }

    public static <T extends Track> int countTracks(Animation animation, Class<T> trackType) {
        int result = 0;
        if (animation != null) {
            Track[] tracks;
            for (Track track : tracks = animation.getTracks()) {
                if (!trackType.isAssignableFrom(track.getClass())) continue;
                ++result;
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static String describe(Animation animation, AnimControl animControl) {
        String result;
        Validate.nonNull(animControl, "anim control");
        String name = animation.getName();
        Track[] tracks = animation.getTracks();
        int numTracks = tracks.length;
        if (numTracks > 2) {
            result = String.format("%s[%d]", MyString.quote(name), numTracks);
        } else {
            Object[] trackDescriptions = new String[numTracks];
            for (int trackIndex = 0; trackIndex < numTracks; ++trackIndex) {
                Track track = tracks[trackIndex];
                trackDescriptions[trackIndex] = MyAnimation.describe(track, animControl);
            }
            String joined = MyString.join(trackDescriptions);
            result = String.format("%s(%s)", name, joined);
        }
        return result;
    }

    public static String describe(Track track, AnimControl animControl) {
        Validate.nonNull(track, "track");
        Validate.nonNull(animControl, "anim control");
        StringBuilder builder = new StringBuilder(20);
        char typeChar = MyAnimation.describeTrackType(track);
        builder.append(typeChar);
        if (track instanceof BoneTrack || track instanceof SpatialTrack) {
            String targetName = MyAnimation.getTargetName(track, animControl);
            targetName = MyString.quote(targetName);
            builder.append(targetName);
            if (MyAnimation.getTranslations(track) != null) {
                builder.append("T");
            }
            if (MyAnimation.getRotations(track) != null) {
                builder.append("R");
            }
            if (MyAnimation.getScales(track) != null) {
                builder.append("S");
            }
        }
        String result = builder.toString();
        return result;
    }

    public static char describeTrackType(Track track) {
        if (track instanceof AudioTrack) {
            return 'a';
        }
        if (track instanceof BoneTrack) {
            return 'b';
        }
        if (track instanceof EffectTrack) {
            return 'e';
        }
        if (track instanceof SpatialTrack) {
            return 's';
        }
        return '?';
    }

    public static BoneTrack findBoneTrack(Animation animation, int boneIndex) {
        Track[] tracks;
        Validate.nonNegative(boneIndex, "bone index");
        for (Track track : tracks = animation.getTracks()) {
            BoneTrack boneTrack;
            int trackBoneIndex;
            if (!(track instanceof BoneTrack) || boneIndex != (trackBoneIndex = (boneTrack = (BoneTrack)track).getTargetBoneIndex())) continue;
            return boneTrack;
        }
        return null;
    }

    public static TransformTrack findJointTrack(AnimClip clip, int jointIndex) {
        AnimTrack[] tracks;
        Validate.nonNegative(jointIndex, "joint index");
        for (AnimTrack track : tracks = clip.getTracks()) {
            Joint joint;
            int trackJointIndex;
            TransformTrack transformTrack;
            HasLocalTransform target;
            if (!(track instanceof TransformTrack) || !((target = (transformTrack = (TransformTrack)track).getTarget()) instanceof Joint) || jointIndex != (trackJointIndex = (joint = (Joint)target).getId())) continue;
            return transformTrack;
        }
        return null;
    }

    public static int findKeyframeIndex(Track track, float time) {
        Validate.nonNegative(time, "time");
        float[] times = track.getKeyFrameTimes();
        int result = MyArray.findPreviousIndex(time, times);
        if (result >= 0 && times[result] != time) {
            result = -1;
        }
        return result;
    }

    public static int findKeyframeIndex(TransformTrack track, float time) {
        Validate.nonNegative(time, "time");
        float[] times = track.getTimes();
        int result = Arrays.binarySearch(times, time);
        if (result < 0) {
            result = -1;
        }
        return result;
    }

    public static float findLastKeyframe(Animation animation) {
        Track[] loadedTracks;
        float maxTime = 0.0f;
        for (Track track : loadedTracks = animation.getTracks()) {
            float[] frameTimes;
            for (float time : frameTimes = track.getKeyFrameTimes()) {
                if (!(time > maxTime)) continue;
                maxTime = time;
            }
        }
        return maxTime;
    }

    public static int findPreviousKeyframeIndex(Track track, float time) {
        Validate.nonNegative(time, "time");
        float[] times = track.getKeyFrameTimes();
        int result = MyArray.findPreviousIndex(time, times);
        assert (result >= 0) : result;
        return result;
    }

    public static int findPreviousKeyframeIndex(TransformTrack track, float time) {
        Validate.nonNegative(time, "time");
        float[] times = track.getTimes();
        int result = MyArray.findPreviousIndex(time, times);
        assert (result >= 0) : result;
        return result;
    }

    public static SpatialTrack findSpatialTrack(AnimControl animControl, Animation animation, Spatial spatial) {
        Track[] tracks;
        for (Track track : tracks = animation.getTracks()) {
            if (!(track instanceof SpatialTrack)) continue;
            SpatialTrack spatialTrack = (SpatialTrack)track;
            Spatial target = spatialTrack.getTrackSpatial();
            if (target == null) {
                target = animControl.getSpatial();
            }
            if (target != spatial) continue;
            return spatialTrack;
        }
        return null;
    }

    public static int findTrackIndex(Animation animation, Track track) {
        int result = -1;
        Track[] tracks = animation.getTracks();
        int numTracks = tracks.length;
        for (int index = 0; index < numTracks; ++index) {
            if (track != tracks[index]) continue;
            result = index;
            break;
        }
        return result;
    }

    public static TransformTrack findTransformTrack(AnimClip clip, int jointIndex) {
        AnimTrack[] animTracks;
        TransformTrack result = null;
        for (AnimTrack animTrack : animTracks = clip.getTracks()) {
            int targetIndex;
            TransformTrack track;
            HasLocalTransform target;
            if (!(animTrack instanceof TransformTrack) || !((target = (track = (TransformTrack)animTrack).getTarget()) instanceof Joint) || (targetIndex = ((Joint)target).getId()) != jointIndex) continue;
            result = track;
            break;
        }
        return result;
    }

    public static float[] getKeyFrameTimes(Object object) {
        float[] result;
        if (object instanceof MorphTrack) {
            MorphTrack morphTrack = (MorphTrack)object;
            result = morphTrack.getTimes();
        } else if (object instanceof Track) {
            Track t = (Track)object;
            result = t.getKeyFrameTimes();
        } else if (object instanceof TransformTrack) {
            TransformTrack transformTrack = (TransformTrack)object;
            result = transformTrack.getTimes();
        } else {
            String className = object.getClass().getSimpleName();
            throw new IllegalArgumentException(className);
        }
        assert (result != null);
        assert (result.length > 0) : result.length;
        return result;
    }

    public static Quaternion[] getRotations(Track track) {
        Quaternion[] result;
        if (track instanceof BoneTrack) {
            BoneTrack boneTrack = (BoneTrack)track;
            result = boneTrack.getRotations();
        } else if (track instanceof SpatialTrack) {
            SpatialTrack spatialTrack = (SpatialTrack)track;
            result = spatialTrack.getRotations();
        } else {
            String className = track.getClass().getSimpleName();
            throw new IllegalArgumentException(className);
        }
        return result;
    }

    public static Vector3f[] getScales(Track track) {
        Vector3f[] result;
        if (track instanceof BoneTrack) {
            BoneTrack boneTrack = (BoneTrack)track;
            result = boneTrack.getScales();
        } else if (track instanceof SpatialTrack) {
            SpatialTrack spatialTrack = (SpatialTrack)track;
            result = spatialTrack.getScales();
        } else {
            String className = track.getClass().getSimpleName();
            throw new IllegalArgumentException(className);
        }
        return result;
    }

    public static String getTargetName(Track track, AnimControl animControl) {
        String result;
        Validate.nonNull(track, "track");
        if (track instanceof BoneTrack) {
            BoneTrack boneTrack = (BoneTrack)track;
            int boneIndex = boneTrack.getTargetBoneIndex();
            Skeleton skeleton = animControl.getSkeleton();
            Bone bone = skeleton.getBone(boneIndex);
            result = bone.getName();
        } else if (track instanceof SpatialTrack) {
            SpatialTrack spatialTrack = (SpatialTrack)track;
            Spatial spatial = spatialTrack.getTrackSpatial();
            if (spatial == null) {
                spatial = animControl.getSpatial();
            }
            result = spatial.getName();
        } else {
            String className = track.getClass().getSimpleName();
            throw new IllegalArgumentException(className);
        }
        return result;
    }

    public static Vector3f[] getTranslations(Track track) {
        Vector3f[] result;
        if (track instanceof BoneTrack) {
            BoneTrack boneTrack = (BoneTrack)track;
            result = boneTrack.getTranslations();
        } else if (track instanceof SpatialTrack) {
            SpatialTrack spatialTrack = (SpatialTrack)track;
            result = spatialTrack.getTranslations();
        } else {
            String className = track.getClass().getSimpleName();
            throw new IllegalArgumentException(className);
        }
        return result;
    }

    public static boolean hasTrackForBone(Animation animation, int boneIndex) {
        Validate.nonNegative(boneIndex, "bone index");
        BoneTrack track = MyAnimation.findBoneTrack(animation, boneIndex);
        return track != null;
    }

    public static boolean isJointTrack(AnimTrack track) {
        TransformTrack transformTrack;
        HasLocalTransform target;
        boolean result = false;
        if (track instanceof TransformTrack && (target = (transformTrack = (TransformTrack)track).getTarget()) instanceof Joint) {
            result = true;
        }
        return result;
    }

    public static BoneTrack newBoneTrack(int boneIndex, Vector3f translation, Quaternion rotation, Vector3f scale) {
        Validate.nonNegative(boneIndex, "bone index");
        Vector3f copyTranslation = translation.clone();
        Quaternion copyRotation = rotation.clone();
        Vector3f copyScale = scale.clone();
        float[] times = new float[]{0.0f};
        Vector3f[] translations = new Vector3f[]{copyTranslation};
        Quaternion[] rotations = new Quaternion[]{copyRotation};
        Vector3f[] scales = new Vector3f[]{copyScale};
        BoneTrack result = MyAnimation.newBoneTrack(boneIndex, times, translations, rotations, scales);
        return result;
    }

    public static BoneTrack newBoneTrack(int boneIndex, float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        Validate.nonNull(times, "times");
        Validate.nonNull(translations, "translations");
        Validate.nonNull(rotations, "rotations");
        int numKeyframes = times.length;
        assert (translations.length == numKeyframes);
        assert (rotations.length == numKeyframes);
        assert (scales == null || scales.length == numKeyframes);
        BoneTrack result = scales == null ? new BoneTrack(boneIndex, times, translations, rotations) : new BoneTrack(boneIndex, times, translations, rotations, scales);
        return result;
    }

    public static BoneTrack newBoneTrack(int boneIndex, float[] frameTimes, Transform transform) {
        Validate.nonNegative(boneIndex, "bone index");
        int numFrames = frameTimes.length;
        float[] times = new float[numFrames];
        Vector3f[] translations = new Vector3f[numFrames];
        Quaternion[] rotations = new Quaternion[numFrames];
        Vector3f[] scales = new Vector3f[numFrames];
        transform = transform.clone();
        for (int frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
            times[frameIndex] = frameTimes[frameIndex];
            translations[frameIndex] = transform.getTranslation();
            rotations[frameIndex] = transform.getRotation();
            scales[frameIndex] = transform.getScale();
        }
        BoneTrack result = MyAnimation.newBoneTrack(boneIndex, times, translations, rotations, scales);
        return result;
    }
}

