/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.app.StatsView;
import com.jme3.cinematic.events.MotionEvent;
import com.jme3.effect.ParticleEmitter;
import com.jme3.input.ChaseCamera;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import jme3utilities.MyAnimation;
import jme3utilities.MyString;
import jme3utilities.Validate;

public class MyControl {
    private static final Logger logger = Logger.getLogger(MyControl.class.getName());

    private MyControl() {
    }

    public static boolean canDisable(Control sgc) {
        boolean result = sgc instanceof AbstractControl || sgc instanceof ChaseCamera || sgc instanceof MotionEvent || sgc instanceof ParticleEmitter.ParticleEmitterControl || sgc instanceof StatsView;
        return result;
    }

    public static String describe(Control control) {
        String result = MyControl.describeType(control);
        if (control instanceof AnimControl) {
            AnimControl animControl = (AnimControl)control;
            Collection nameCollection = animControl.getAnimationNames();
            int numAnimations = nameCollection.size();
            if (numAnimations > 2) {
                result = result + String.format("[%d]", numAnimations);
            } else {
                ArrayList<String> descs = new ArrayList<String>(numAnimations);
                for (String animationName : nameCollection) {
                    Animation animation = animControl.getAnim(animationName);
                    String desc = MyAnimation.describe(animation, animControl);
                    descs.add(desc);
                }
                String names = MyString.join(descs);
                result = result + String.format("[%s]", names);
            }
        } else if (control instanceof SkeletonControl) {
            SkeletonControl skeletonControl = (SkeletonControl)control;
            int boneCount = skeletonControl.getSkeleton().getBoneCount();
            boolean useHw = skeletonControl.isHardwareSkinningUsed();
            result = result + String.format("[%d %s]", boneCount, useHw ? "hw" : "sw");
        }
        return result;
    }

    public static String describeType(Control control) {
        String description = control.getClass().getSimpleName();
        if (description.endsWith("Control")) {
            description = MyString.removeSuffix(description, "Control");
        }
        return description;
    }

    public static int findIndex(Control sgc, Spatial spatial) {
        Validate.nonNull(sgc, "control");
        int result = -1;
        int numControls = spatial.getNumControls();
        for (int index = 0; index < numControls; ++index) {
            Control control = spatial.getControl(index);
            if (control != sgc) continue;
            result = index;
        }
        return result;
    }

    public static Skeleton findSkeleton(Control sgc) {
        Skeleton result = null;
        if (sgc instanceof AnimControl) {
            AnimControl animControl = (AnimControl)sgc;
            result = animControl.getSkeleton();
        } else if (sgc instanceof SkeletonControl) {
            SkeletonControl skeletonControl = (SkeletonControl)sgc;
            result = skeletonControl.getSkeleton();
        }
        return result;
    }

    public static boolean isEnabled(Control sgc) {
        boolean result;
        Validate.nonNull(sgc, "control");
        if (sgc instanceof AbstractControl) {
            AbstractControl abstractControl = (AbstractControl)sgc;
            result = abstractControl.isEnabled();
        } else if (sgc instanceof ChaseCamera) {
            ChaseCamera chaseCamera = (ChaseCamera)sgc;
            result = chaseCamera.isEnabled();
        } else if (sgc instanceof MotionEvent) {
            MotionEvent motionEvent = (MotionEvent)sgc;
            result = motionEvent.isEnabled();
        } else if (sgc instanceof ParticleEmitter.ParticleEmitterControl) {
            ParticleEmitter.ParticleEmitterControl pec = (ParticleEmitter.ParticleEmitterControl)sgc;
            result = pec.isEnabled();
        } else if (sgc instanceof StatsView) {
            StatsView statsView = (StatsView)sgc;
            result = statsView.isEnabled();
        } else {
            String message = sgc.getClass().getName();
            throw new IllegalArgumentException(message);
        }
        return result;
    }

    public static void setEnabled(Control sgc, boolean newState) {
        if (sgc instanceof AbstractControl) {
            AbstractControl abstractControl = (AbstractControl)sgc;
            abstractControl.setEnabled(newState);
        } else if (sgc instanceof ChaseCamera) {
            ChaseCamera chaseCamera = (ChaseCamera)sgc;
            chaseCamera.setEnabled(newState);
        } else if (sgc instanceof MotionEvent) {
            MotionEvent motionEvent = (MotionEvent)sgc;
            motionEvent.setEnabled(newState);
        } else if (sgc instanceof ParticleEmitter.ParticleEmitterControl) {
            ParticleEmitter.ParticleEmitterControl pec = (ParticleEmitter.ParticleEmitterControl)sgc;
            pec.setEnabled(newState);
        } else if (sgc instanceof StatsView) {
            StatsView statsView = (StatsView)sgc;
            statsView.setEnabled(newState);
        } else {
            String message = sgc.getClass().getName();
            throw new IllegalArgumentException(message);
        }
    }
}

