/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Element;
import jme3utilities.MyAsset;
import jme3utilities.Validate;
import jme3utilities.math.IntPair;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.VectorSet;
import jme3utilities.math.VectorSetUsingBuffer;

public class MyMesh {
    private static final int maxWeights = 4;
    private static final int numAxes = 3;
    public static final int vpe = 2;
    public static final int vpt = 3;
    private static final Logger logger = Logger.getLogger(MyMesh.class.getName());
    private static final Matrix4f matrixIdentity = new Matrix4f();
    private static final Vector3f scaleReverse = new Vector3f(-1.0f, -1.0f, -1.0f);

    private MyMesh() {
    }

    public static Mesh addIndices(Mesh input) {
        Buffer data;
        Validate.nonNull(input, "input");
        assert (!MyMesh.hasIndices(input));
        int oldN = input.getVertexCount();
        int[] old2new = new int[oldN];
        int[] new2old = new int[oldN];
        int newN = 0;
        for (int oldI = 0; oldI < oldN; ++oldI) {
            old2new[oldI] = -1;
            new2old[oldI] = -1;
            for (int newI = 0; newI < newN; ++newI) {
                if (!MyMesh.areIdentical(input, oldI, new2old[newI])) continue;
                old2new[oldI] = newI;
                break;
            }
            if (old2new[oldI] != -1) continue;
            old2new[oldI] = newN;
            new2old[newN] = oldI;
            ++newN;
        }
        Mesh result = input.clone();
        for (VertexBuffer oldVertexBuffer : input.getBufferList()) {
            VertexBuffer.Type type = oldVertexBuffer.getBufferType();
            result.clearBuffer(type);
            VertexBuffer.Format format = oldVertexBuffer.getFormat();
            int numCperE = oldVertexBuffer.getNumComponents();
            numCperE = MyMath.clamp(numCperE, 1, 4);
            data = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numCperE, (int)newN);
            result.setBuffer(type, numCperE, format, data);
        }
        for (int newI = 0; newI < newN; ++newI) {
            int oldI = new2old[newI];
            for (VertexBuffer newVB : result.getBufferList()) {
                VertexBuffer.Type type = newVB.getBufferType();
                VertexBuffer oldVB = input.getBuffer(type);
                assert (oldVB != newVB);
                Element.copy(oldVB, oldI, newVB, newI);
            }
        }
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)newN, (int)oldN);
        for (int oldI = 0; oldI < oldN; ++oldI) {
            int newI = old2new[oldI];
            ib.put(oldI, newI);
        }
        VertexBuffer.Format ibFormat = MyBuffer.getFormat(ib);
        Buffer ibData = ib.getBuffer();
        result.setBuffer(VertexBuffer.Type.Index, 1, ibFormat, ibData);
        for (VertexBuffer outVB : result.getBufferList()) {
            data = outVB.getData();
            int endPosition = data.capacity();
            data.position(endPosition);
            data.flip();
        }
        result.updateCounts();
        return result;
    }

    public static void addSphereNormals(Mesh mesh) {
        Validate.nonNull(mesh, "mesh");
        assert (!MyMesh.hasNormals(mesh));
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        FloatBuffer normals = BufferUtils.clone((FloatBuffer)positions);
        int numFloats = positions.limit();
        MyBuffer.normalize(normals, 0, numFloats);
        normals.flip();
        mesh.setBuffer(VertexBuffer.Type.Normal, 3, normals);
    }

    public static boolean areIdentical(Mesh mesh, int vi1, int vi2) {
        Validate.nonNull(mesh, "mesh");
        int numVertices = mesh.getVertexCount();
        Validate.inRange(vi1, "first vertex index", 0, numVertices - 1);
        Validate.inRange(vi2, "2nd vertex index", 0, numVertices - 1);
        if (vi1 == vi2) {
            return true;
        }
        for (VertexBuffer vertexBuffer : mesh.getBufferList()) {
            VertexBuffer.Type type = vertexBuffer.getBufferType();
            if (type == VertexBuffer.Type.Index || Element.equals(vertexBuffer, vi1, vi2)) continue;
            return false;
        }
        return true;
    }

    public static Material boneWeightMaterial(Mesh mesh, ColorRGBA[] boneIndexToColor, AssetManager assetManager) {
        if (!MyMesh.isAnimated(mesh)) {
            throw new IllegalArgumentException("Must be an animated mesh.");
        }
        int numVertices = mesh.getVertexCount();
        FloatBuffer colorBuf = BufferUtils.createFloatBuffer((int)(4 * numVertices));
        int[] biArray = new int[4];
        float[] bwArray = new float[4];
        ColorRGBA sum = new ColorRGBA();
        ColorRGBA term = new ColorRGBA();
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            MyMesh.vertexBoneIndices(mesh, vertexIndex, biArray);
            MyMesh.vertexBoneWeights(mesh, vertexIndex, bwArray);
            sum.set(0.0f, 0.0f, 0.0f, 1.0f);
            for (int j = 0; j < 4; ++j) {
                int boneI = biArray[j];
                if (boneI < 0 || boneI >= boneIndexToColor.length) continue;
                term.set(boneIndexToColor[boneI]);
                float weight = bwArray[j];
                term.multLocal(weight);
                sum.addLocal(term);
            }
            colorBuf.put(sum.r).put(sum.g).put(sum.b).put(1.0f);
        }
        mesh.setBuffer(VertexBuffer.Type.Color, 4, VertexBuffer.Format.Float, (Buffer)colorBuf);
        Material material = MyAsset.createUnshadedMaterial(assetManager);
        material.setBoolean("VertexColor", true);
        RenderState rs = material.getAdditionalRenderState();
        rs.setWireframe(true);
        return material;
    }

    public static int countBones(Mesh mesh) {
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        assert (maxWeightsPerVert > 0) : maxWeightsPerVert;
        assert (maxWeightsPerVert <= 4) : maxWeightsPerVert;
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        int result = 0;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                float weight = weightBuffer.get();
                int bIndex = MyMesh.readIndex(boneIndexBuffer);
                if (wIndex >= maxWeightsPerVert || weight == 0.0f || bIndex < result) continue;
                result = bIndex + 1;
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static Mesh expand(Mesh in) {
        Mesh.Mode outMode;
        Mesh.Mode inMode = in.getMode();
        switch (inMode) {
            case Points: 
            case Lines: 
            case Triangles: {
                outMode = inMode;
                break;
            }
            case LineLoop: 
            case LineStrip: {
                outMode = Mesh.Mode.Lines;
                break;
            }
            case TriangleFan: 
            case TriangleStrip: {
                outMode = Mesh.Mode.Triangles;
                break;
            }
            default: {
                String message = "mode = " + inMode;
                throw new IllegalArgumentException(message);
            }
        }
        IndexBuffer indexList = in.getIndicesAsList();
        int outVertexCount = indexList.size();
        Mesh out = in.clone();
        out.setMode(outMode);
        for (VertexBuffer inVertexBuffer : in.getBufferList()) {
            VertexBuffer.Type type = inVertexBuffer.getBufferType();
            out.clearBuffer(type);
            if (type == VertexBuffer.Type.Index) continue;
            VertexBuffer.Format format = inVertexBuffer.getFormat();
            int numCperE = inVertexBuffer.getNumComponents();
            numCperE = MyMath.clamp(numCperE, 1, 4);
            Buffer data = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numCperE, (int)outVertexCount);
            out.setBuffer(type, numCperE, format, data);
        }
        for (int outVI = 0; outVI < outVertexCount; ++outVI) {
            int inVI = indexList.get(outVI);
            for (VertexBuffer outVB : out.getBufferList()) {
                VertexBuffer.Type type = outVB.getBufferType();
                VertexBuffer inVB = in.getBuffer(type);
                assert (inVB != outVB);
                Element.copy(inVB, inVI, outVB, outVI);
            }
        }
        for (VertexBuffer outVB : out.getBufferList()) {
            Buffer data = outVB.getData();
            int endPosition = data.capacity();
            data.position(endPosition);
            data.flip();
        }
        out.updateCounts();
        return out;
    }

    public static void generateNormals(Mesh mesh) {
        assert (mesh.getMode() == Mesh.Mode.Triangles) : mesh.getMode();
        assert (!MyMesh.hasIndices(mesh));
        FloatBuffer positionBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        int numFloats = positionBuffer.limit();
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        mesh.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffer);
        Triangle triangle = new Triangle();
        Vector3f pos1 = new Vector3f();
        Vector3f pos2 = new Vector3f();
        Vector3f pos3 = new Vector3f();
        int numTriangles = numFloats / 3 / 3;
        for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
            int trianglePosition = triIndex * 3 * 3;
            MyBuffer.get(positionBuffer, trianglePosition, pos1);
            MyBuffer.get(positionBuffer, trianglePosition + 3, pos2);
            MyBuffer.get(positionBuffer, trianglePosition + 6, pos3);
            triangle.set(pos1, pos2, pos3);
            Vector3f normal = triangle.getNormal();
            for (int j = 0; j < 3; ++j) {
                normalBuffer.put(normal.x);
                normalBuffer.put(normal.y);
                normalBuffer.put(normal.z);
            }
        }
        normalBuffer.flip();
    }

    public static boolean hasIndices(Mesh mesh) {
        VertexBuffer buffer = mesh.getBuffer(VertexBuffer.Type.Index);
        return buffer != null;
    }

    public static boolean hasNormals(Mesh mesh) {
        VertexBuffer buffer = mesh.getBuffer(VertexBuffer.Type.Normal);
        return buffer != null;
    }

    public static boolean hasTriangles(Mesh mesh) {
        boolean result;
        Mesh.Mode mode = mesh.getMode();
        switch (mode) {
            case Points: 
            case Lines: 
            case LineLoop: 
            case LineStrip: {
                result = false;
                break;
            }
            case Triangles: 
            case TriangleFan: 
            case TriangleStrip: {
                result = true;
                break;
            }
            default: {
                String message = "mode = " + mode;
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static boolean hasUV(Mesh mesh) {
        VertexBuffer buffer = mesh.getBuffer(VertexBuffer.Type.TexCoord);
        return buffer != null;
    }

    public static boolean isAnimated(Mesh mesh) {
        VertexBuffer indices = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        boolean hasIndices = indices != null;
        VertexBuffer weights = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
        boolean hasWeights = weights != null;
        boolean result = hasIndices && hasWeights;
        return result;
    }

    public static List<Mesh> listMeshes(Spatial subtree, List<Mesh> storeResult) {
        if (storeResult == null) {
            storeResult = new ArrayList<Mesh>(10);
        }
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Mesh mesh = geometry.getMesh();
            if (!storeResult.contains(mesh)) {
                storeResult.add(mesh);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyMesh.listMeshes(child, storeResult);
            }
        }
        return storeResult;
    }

    public static VectorSet listVertexLocations(Spatial subtree, VectorSet storeResult) {
        VectorSet result;
        block6: {
            block5: {
                if (storeResult == null) {
                    int numVectors = 64;
                    boolean direct = false;
                    result = new VectorSetUsingBuffer(numVectors, direct);
                } else {
                    result = storeResult;
                }
                if (!(subtree instanceof Geometry)) break block5;
                Geometry geometry = (Geometry)subtree;
                Mesh mesh = geometry.getMesh();
                int numVertices = mesh.getVertexCount();
                Vector3f tempLocation = new Vector3f();
                for (int vertexI = 0; vertexI < numVertices; ++vertexI) {
                    MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Position, vertexI, tempLocation);
                    if (!geometry.isIgnoreTransform()) {
                        geometry.localToWorld(tempLocation, tempLocation);
                    }
                    result.add(tempLocation);
                }
                break block6;
            }
            if (!(subtree instanceof Node)) break block6;
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyMesh.listVertexLocations(child, result);
            }
        }
        return result;
    }

    public static int numInfluenced(Mesh mesh, int boneIndex) {
        Validate.nonNegative(boneIndex, "bone index");
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        assert (maxWeightsPerVert > 0) : maxWeightsPerVert;
        assert (maxWeightsPerVert <= 4) : maxWeightsPerVert;
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        int result = 0;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                float weight = weightBuffer.get();
                int bIndex = MyMesh.readIndex(boneIndexBuffer);
                if (wIndex >= maxWeightsPerVert || bIndex != boneIndex || weight == 0.0f) continue;
                ++result;
            }
        }
        return result;
    }

    public static int readIndex(Buffer buffer) {
        int result;
        Validate.nonNull(buffer, "buffer");
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byte b = byteBuffer.get();
            result = 0xFF & b;
        } else if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            result = intBuffer.get();
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            short s = shortBuffer.get();
            result = 0xFFFF & s;
        } else {
            String message = buffer.getClass().getName();
            throw new IllegalArgumentException(message);
        }
        assert (result >= 0) : result;
        return result;
    }

    public static void reverseNormals(Mesh mesh) {
        FloatBuffer buffer = mesh.getFloatBuffer(VertexBuffer.Type.Normal);
        if (buffer != null) {
            MyBuffer.scale(buffer, 0, buffer.limit(), scaleReverse);
        }
        if ((buffer = mesh.getFloatBuffer(VertexBuffer.Type.BindPoseNormal)) != null) {
            MyBuffer.scale(buffer, 0, buffer.limit(), scaleReverse);
        }
    }

    public static void reverseWinding(Mesh mesh) {
        assert (mesh.getMode() == Mesh.Mode.Triangles) : mesh.getMode();
        mesh.updateCounts();
        int numTriangles = mesh.getTriangleCount();
        IndexBuffer indexBuffer = mesh.getIndexBuffer();
        if (indexBuffer != null) {
            int numIndices = 3 * numTriangles;
            assert (indexBuffer.size() == numIndices) : indexBuffer.size();
            for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
                int v1Index = 3 * triIndex;
                int v3Index = 3 * triIndex + 3 - 1;
                int i1 = indexBuffer.get(v1Index);
                int i3 = indexBuffer.get(v3Index);
                indexBuffer.put(v1Index, i3);
                indexBuffer.put(v3Index, i1);
            }
        } else {
            int numVertices = 3 * numTriangles;
            for (VertexBuffer vb : mesh.getBufferList()) {
                assert (vb.getNumElements() == numVertices) : vb.getNumElements();
                for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
                    int v1Index = 3 * triIndex;
                    int v3Index = 3 * triIndex + 3 - 1;
                    Element.swap(vb, v1Index, v3Index);
                }
            }
        }
    }

    public static void setBoneIndexBuffer(Mesh mesh, int wpv, IndexBuffer indexBuffer) {
        Validate.nonNull(mesh, "mesh");
        Validate.inRange(wpv, "weights per vertex", 1, 4);
        Buffer buffer = indexBuffer.getBuffer();
        VertexBuffer.Type type = VertexBuffer.Type.BoneIndex;
        if (buffer instanceof ByteBuffer) {
            mesh.setBuffer(type, wpv, (ByteBuffer)buffer);
        } else if (buffer instanceof IntBuffer) {
            mesh.setBuffer(type, wpv, (IntBuffer)buffer);
        } else if (buffer instanceof ShortBuffer) {
            mesh.setBuffer(type, wpv, (ShortBuffer)buffer);
        } else {
            String message = buffer.getClass().getName();
            throw new IllegalArgumentException(message);
        }
    }

    public static void smoothNormals(Mesh mesh) {
        Validate.nonNull(mesh, "mesh");
        assert (MyMesh.hasNormals(mesh));
        FloatBuffer positionBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        int numVertices = positionBuffer.limit() / 3;
        HashMap<Vector3f, Integer> mapPosToDpid = new HashMap<Vector3f, Integer>(numVertices);
        int numDistinctPositions = 0;
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            int start = vertexIndex * 3;
            Vector3f position = new Vector3f();
            MyBuffer.get(positionBuffer, start, position);
            MyVector3f.standardize(position, position);
            if (mapPosToDpid.containsKey(position)) continue;
            mapPosToDpid.put(position, numDistinctPositions);
            ++numDistinctPositions;
        }
        Vector3f[] normalSum = new Vector3f[numDistinctPositions];
        for (int dpid = 0; dpid < numDistinctPositions; ++dpid) {
            normalSum[dpid] = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        IndexBuffer indexList = mesh.getIndicesAsList();
        int numIndices = indexList.size();
        FloatBuffer normalBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Normal);
        Vector3f tmpPosition = new Vector3f();
        Vector3f tmpNormal = new Vector3f();
        for (int ibPosition = 0; ibPosition < numIndices; ++ibPosition) {
            int vertexIndex = indexList.get(ibPosition);
            int start = vertexIndex * 3;
            MyBuffer.get(positionBuffer, start, tmpPosition);
            MyVector3f.standardize(tmpPosition, tmpPosition);
            int dpid = (Integer)mapPosToDpid.get(tmpPosition);
            MyBuffer.get(normalBuffer, start, tmpNormal);
            normalSum[dpid].addLocal(tmpNormal);
        }
        for (int dpid = 0; dpid < normalSum.length; ++dpid) {
            MyVector3f.normalizeLocal(normalSum[dpid]);
        }
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            int start = vertexIndex * 3;
            MyBuffer.get(positionBuffer, start, tmpPosition);
            MyVector3f.standardize(tmpPosition, tmpPosition);
            int dpid = (Integer)mapPosToDpid.get(tmpPosition);
            MyBuffer.put(normalBuffer, start, normalSum[dpid]);
        }
    }

    public static void trianglesToLines(Mesh mesh) {
        Validate.nonNull(mesh, "mesh");
        assert (MyMesh.hasTriangles(mesh));
        IndexBuffer indexList = mesh.getIndicesAsList();
        int numTriangles = indexList.size() / 3;
        HashSet<IntPair> edgeSet = new HashSet<IntPair>(3 * numTriangles);
        for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
            int intOffset = 3 * triIndex;
            int ti0 = indexList.get(intOffset);
            int ti1 = indexList.get(intOffset + 1);
            int ti2 = indexList.get(intOffset + 2);
            edgeSet.add(new IntPair(ti0, ti1));
            edgeSet.add(new IntPair(ti0, ti2));
            edgeSet.add(new IntPair(ti1, ti2));
        }
        int numEdges = edgeSet.size();
        int numIndices = 2 * numEdges;
        int numVertices = mesh.getVertexCount();
        mesh.clearBuffer(VertexBuffer.Type.Index);
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        for (IntPair edge : edgeSet) {
            MyBuffer.putRelative(ib, edge.smaller());
            MyBuffer.putRelative(ib, edge.larger());
        }
        VertexBuffer.Format ibFormat = MyBuffer.getFormat(ib);
        Buffer ibData = ib.getBuffer();
        ibData.flip();
        mesh.setBuffer(VertexBuffer.Type.Index, 2, ibFormat, ibData);
        mesh.setMode(Mesh.Mode.Lines);
    }

    public static int[] vertexBoneIndices(Mesh mesh, int vertexIndex, int[] storeResult) {
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        if (storeResult == null) {
            storeResult = new int[4];
        } else assert (storeResult.length >= 4) : storeResult.length;
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.position(4 * vertexIndex);
        for (int wIndex = 0; wIndex < maxWeightsPerVert; ++wIndex) {
            int boneIndex;
            storeResult[wIndex] = boneIndex = MyMesh.readIndex(boneIndexBuffer);
        }
        int length = storeResult.length;
        for (int wIndex = maxWeightsPerVert; wIndex < length; ++wIndex) {
            storeResult[wIndex] = -1;
        }
        return storeResult;
    }

    public static float[] vertexBoneWeights(Mesh mesh, int vertexIndex, float[] storeResult) {
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        if (storeResult == null) {
            storeResult = new float[4];
        } else assert (storeResult.length >= 4) : storeResult.length;
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        int startIndex = 4 * vertexIndex;
        for (int wIndex = 0; wIndex < maxWeightsPerVert; ++wIndex) {
            storeResult[wIndex] = weightBuffer.get(startIndex + wIndex);
        }
        int length = storeResult.length;
        for (int wIndex = maxWeightsPerVert; wIndex < length; ++wIndex) {
            storeResult[wIndex] = 0.0f;
        }
        return storeResult;
    }

    public static ColorRGBA vertexColor(Mesh mesh, int vertexIndex, ColorRGBA storeResult) {
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        if (storeResult == null) {
            storeResult = new ColorRGBA();
        }
        VertexBuffer vertexBuffer = mesh.getBuffer(VertexBuffer.Type.Color);
        FloatBuffer floatBuffer = (FloatBuffer)vertexBuffer.getDataReadOnly();
        int floatIndex = 4 * vertexIndex;
        storeResult.r = floatBuffer.get(floatIndex);
        storeResult.g = floatBuffer.get(floatIndex + 1);
        storeResult.b = floatBuffer.get(floatIndex + 2);
        storeResult.a = floatBuffer.get(floatIndex + 3);
        return storeResult;
    }

    public static Vector3f vertexLocation(Mesh mesh, int vertexIndex, Matrix4f[] skinningMatrices, Vector3f storeResult) {
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        if (storeResult == null) {
            storeResult = new Vector3f();
        }
        if (MyMesh.isAnimated(mesh)) {
            Vector3f b = MyMesh.vertexVector3f(mesh, VertexBuffer.Type.BindPosePosition, vertexIndex, null);
            FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
            weightBuffer.position(4 * vertexIndex);
            VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            Buffer boneIndexBuffer = biBuf.getDataReadOnly();
            boneIndexBuffer.position(4 * vertexIndex);
            storeResult.zero();
            int maxWeightsPerVertex = mesh.getMaxNumWeights();
            for (int wIndex = 0; wIndex < maxWeightsPerVertex; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyMesh.readIndex(boneIndexBuffer);
                if (weight == 0.0f) continue;
                Matrix4f s = boneIndex < skinningMatrices.length ? skinningMatrices[boneIndex] : matrixIdentity;
                float xOf = s.m00 * b.x + s.m01 * b.y + s.m02 * b.z + s.m03;
                float yOf = s.m10 * b.x + s.m11 * b.y + s.m12 * b.z + s.m13;
                float zOf = s.m20 * b.x + s.m21 * b.y + s.m22 * b.z + s.m23;
                storeResult.x += weight * xOf;
                storeResult.y += weight * yOf;
                storeResult.z += weight * zOf;
            }
        } else {
            MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Position, vertexIndex, storeResult);
        }
        return storeResult;
    }

    public static Vector3f vertexNormal(Mesh mesh, int vertexIndex, Matrix4f[] skinningMatrices, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (MyMesh.isAnimated(mesh)) {
            Vector3f b = MyMesh.vertexVector3f(mesh, VertexBuffer.Type.BindPoseNormal, vertexIndex, null);
            FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
            weightBuffer.position(4 * vertexIndex);
            VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            Buffer boneIndexBuffer = biBuf.getDataReadOnly();
            boneIndexBuffer.position(4 * vertexIndex);
            result.zero();
            int maxWeightsPerVertex = mesh.getMaxNumWeights();
            for (int wIndex = 0; wIndex < maxWeightsPerVertex; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyMesh.readIndex(boneIndexBuffer);
                if (weight == 0.0f) continue;
                Matrix4f s = boneIndex < skinningMatrices.length ? skinningMatrices[boneIndex] : matrixIdentity;
                float xOf = s.m00 * b.x + s.m01 * b.y + s.m02 * b.z;
                float yOf = s.m10 * b.x + s.m11 * b.y + s.m12 * b.z;
                float zOf = s.m20 * b.x + s.m21 * b.y + s.m22 * b.z;
                result.x += weight * xOf;
                result.y += weight * yOf;
                result.z += weight * zOf;
            }
            MyVector3f.normalizeLocal(result);
        } else {
            MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Normal, vertexIndex, result);
        }
        return result;
    }

    public static float vertexSize(Mesh mesh, int vertexIndex) {
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Size);
        float result = floatBuffer.get(vertexIndex);
        return result;
    }

    public static Vector4f vertexTangent(Mesh mesh, int vertexIndex, Matrix4f[] skinningMatrices, Vector4f storeResult) {
        Vector4f result;
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        Vector4f vector4f = result = storeResult == null ? new Vector4f() : storeResult;
        if (MyMesh.isAnimated(mesh)) {
            Vector4f b = MyMesh.vertexVector4f(mesh, VertexBuffer.Type.BindPoseTangent, vertexIndex, null);
            FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
            weightBuffer.position(4 * vertexIndex);
            VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            Buffer boneIndexBuffer = biBuf.getDataReadOnly();
            boneIndexBuffer.position(4 * vertexIndex);
            result.zero();
            int maxWeightsPerVertex = mesh.getMaxNumWeights();
            for (int wIndex = 0; wIndex < maxWeightsPerVertex; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyMesh.readIndex(boneIndexBuffer);
                if (weight == 0.0f) continue;
                Matrix4f s = boneIndex < skinningMatrices.length ? skinningMatrices[boneIndex] : matrixIdentity;
                float xOf = s.m00 * b.x + s.m01 * b.y + s.m02 * b.z;
                float yOf = s.m10 * b.x + s.m11 * b.y + s.m12 * b.z;
                float zOf = s.m20 * b.x + s.m21 * b.y + s.m22 * b.z;
                result.x += weight * xOf;
                result.y += weight * yOf;
                result.z += weight * zOf;
            }
            result.normalizeLocal();
            result.w = b.w;
        } else {
            MyMesh.vertexVector4f(mesh, VertexBuffer.Type.Tangent, vertexIndex, result);
        }
        return result;
    }

    public static Vector2f vertexVector2f(Mesh mesh, VertexBuffer.Type bufferType, int vertexIndex, Vector2f storeResult) {
        assert (bufferType == VertexBuffer.Type.TexCoord || bufferType == VertexBuffer.Type.TexCoord2 || bufferType == VertexBuffer.Type.TexCoord3 || bufferType == VertexBuffer.Type.TexCoord4 || bufferType == VertexBuffer.Type.TexCoord5 || bufferType == VertexBuffer.Type.TexCoord6 || bufferType == VertexBuffer.Type.TexCoord7 || bufferType == VertexBuffer.Type.TexCoord8) : bufferType;
        Validate.nonNegative(vertexIndex, "vertex index");
        if (storeResult == null) {
            storeResult = new Vector2f();
        }
        FloatBuffer floatBuffer = mesh.getFloatBuffer(bufferType);
        int floatIndex = 2 * vertexIndex;
        storeResult.x = floatBuffer.get(floatIndex);
        storeResult.y = floatBuffer.get(floatIndex + 1);
        return storeResult;
    }

    public static Vector3f vertexVector3f(Mesh mesh, VertexBuffer.Type bufferType, int vertexIndex, Vector3f storeResult) {
        assert (bufferType == VertexBuffer.Type.BindPoseNormal || bufferType == VertexBuffer.Type.BindPosePosition || bufferType == VertexBuffer.Type.Binormal || bufferType == VertexBuffer.Type.Normal || bufferType == VertexBuffer.Type.Position) : bufferType;
        Validate.nonNegative(vertexIndex, "vertex index");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        FloatBuffer floatBuffer = mesh.getFloatBuffer(bufferType);
        int floatIndex = 3 * vertexIndex;
        MyBuffer.get(floatBuffer, floatIndex, result);
        return result;
    }

    public static Vector4f vertexVector4f(Mesh mesh, VertexBuffer.Type bufferType, int vertexIndex, Vector4f storeResult) {
        assert (bufferType == VertexBuffer.Type.BindPoseTangent || bufferType == VertexBuffer.Type.BoneWeight || bufferType == VertexBuffer.Type.Color || bufferType == VertexBuffer.Type.HWBoneWeight || bufferType == VertexBuffer.Type.Tangent) : bufferType;
        Validate.nonNegative(vertexIndex, "vertex index");
        if (storeResult == null) {
            storeResult = new Vector4f();
        }
        FloatBuffer floatBuffer = mesh.getFloatBuffer(bufferType);
        int floatIndex = 4 * vertexIndex;
        storeResult.x = floatBuffer.get(floatIndex);
        storeResult.y = floatBuffer.get(floatIndex + 1);
        storeResult.z = floatBuffer.get(floatIndex + 2);
        storeResult.w = floatBuffer.get(floatIndex + 3);
        return storeResult;
    }

    public static Vector3f vertexWorldLocation(Geometry geometry, int vertexIndex, Matrix4f[] skinningMatrices, Vector3f storeResult) {
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        if (storeResult == null) {
            storeResult = new Vector3f();
        }
        Mesh mesh = geometry.getMesh();
        Vector3f meshLocation = MyMesh.vertexLocation(mesh, vertexIndex, skinningMatrices, null);
        if (geometry.isIgnoreTransform()) {
            storeResult.set(meshLocation);
        } else {
            geometry.localToWorld(meshLocation, storeResult);
        }
        return storeResult;
    }
}

