/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.bounding.BoundingVolume;
import com.jme3.font.BitmapText;
import com.jme3.light.LightList;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.opengl.GLRenderer;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.SafeArrayList;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import jme3utilities.MyRender;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.debug.Describer;
import jme3utilities.math.MyColor;

public class Dumper
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Dumper.class.getName());
    private boolean dumpBoundsFlag = false;
    private boolean dumpBucketFlag = false;
    private boolean dumpCullFlag = false;
    private boolean dumpMatParamFlag = false;
    private boolean dumpOverrideFlag = false;
    private boolean dumpShadowFlag = false;
    private boolean dumpTransformFlag = false;
    private boolean dumpUserFlag = true;
    private boolean dumpVertexFlag = false;
    private Describer describer;
    private int maxChildren = Integer.MAX_VALUE;
    protected final PrintStream stream;
    private String indentIncrement = "  ";

    public Dumper() {
        this.describer = new Describer();
        this.stream = System.out;
    }

    public Dumper(PrintStream printStream) {
        Validate.nonNull(printStream, "print stream");
        this.describer = new Describer();
        this.stream = printStream;
    }

    public void dump(AppStateManager manager) {
        int index;
        AppState[] terminating;
        AppState[] active;
        AppState[] initializing;
        Method getTerminating;
        Method getStates;
        Method getInitializing;
        try {
            getInitializing = AppStateManager.class.getDeclaredMethod("getInitializing", new Class[0]);
            getStates = AppStateManager.class.getDeclaredMethod("getStates", new Class[0]);
            getTerminating = AppStateManager.class.getDeclaredMethod("getTerminating", new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException(exception);
        }
        getInitializing.setAccessible(true);
        getStates.setAccessible(true);
        getTerminating.setAccessible(true);
        try {
            initializing = (AppState[])getInitializing.invoke((Object)manager, new Object[0]);
            active = (AppState[])getStates.invoke((Object)manager, new Object[0]);
            terminating = (AppState[])getTerminating.invoke((Object)manager, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
        this.stream.println();
        String className = manager.getClass().getSimpleName();
        this.stream.print(className);
        int numInitializing = initializing.length;
        int numActive = active.length;
        int numTerminating = terminating.length;
        int total = numInitializing + numActive + numTerminating;
        this.stream.printf(" with %d state", total);
        if (total == 0) {
            this.stream.println("s.");
            return;
        }
        if (total == 1) {
            this.stream.print(':');
        } else {
            this.stream.print("s:");
            String separator = "";
            if (numInitializing > 0) {
                this.stream.printf(" %d initializing", numInitializing);
                separator = ",";
            }
            if (numActive > 0) {
                this.stream.printf("%s %d active", separator, numActive);
            }
            if (numTerminating > 0) {
                this.stream.printf("%s %d terminating", separator, numTerminating);
            }
        }
        for (index = 0; index < numInitializing; ++index) {
            this.stream.printf("%n initializing[%d]: ", index);
            this.dump(initializing[index], this.indentIncrement);
        }
        for (index = 0; index < numActive; ++index) {
            this.stream.printf("%n active[%d]: ", index);
            this.dump(active[index], this.indentIncrement);
        }
        for (index = 0; index < numTerminating; ++index) {
            this.stream.printf("%n terminating[%d]: ", index);
            this.dump(terminating[index], this.indentIncrement);
        }
        this.stream.println();
    }

    public void dump(Bone bone, String indent) {
        Validate.nonNull(bone, "bone");
        this.stream.print(indent);
        String description = this.describer.describe(bone);
        this.stream.println(description);
        ArrayList children = bone.getChildren();
        String moreIndent = indent + this.indentIncrement;
        for (Bone childBone : children) {
            this.dump(childBone, moreIndent);
        }
    }

    public void dump(Camera camera) {
        Validate.nonNull(camera, "camera");
        this.dump(camera, "");
        this.stream.flush();
    }

    public void dump(Camera camera, String indent) {
        Validate.nonNull(camera, "camera");
        this.stream.print(indent);
        String description = this.describer.describe(camera);
        this.stream.print(description);
        if (camera != null) {
            this.addLine(indent);
            String desc2 = this.describer.describeMore(camera);
            this.stream.print(' ');
            this.stream.print(desc2);
        }
    }

    public void dump(List<Spatial> sceneList, String indent) {
        Validate.nonNull(indent, "indent");
        int numScenes = sceneList.size();
        if (numScenes == 0) {
            this.stream.print("no scenes");
        } else if (numScenes == 1) {
            this.stream.print("one scene:");
        } else {
            this.stream.printf("%d scenes:", numScenes);
        }
        this.stream.println();
        for (Spatial scene : sceneList) {
            this.dump(scene, indent + this.indentIncrement);
        }
    }

    public void dump(RenderManager renderManager) {
        int index;
        String className = renderManager.getClass().getSimpleName();
        this.stream.println();
        this.stream.print(className);
        Renderer renderer = renderManager.getRenderer();
        className = renderer.getClass().getSimpleName();
        this.stream.print(" renderer=");
        this.stream.print(className);
        if (renderer instanceof GLRenderer) {
            GLRenderer glRenderer = (GLRenderer)renderer;
            int factor = MyRender.defaultAnisotropicFilter(glRenderer);
            boolean atoc = MyRender.isAlphaToCoverage(glRenderer);
            String atocString = atoc ? "" : "NO";
            this.stream.printf("[aniso=%d, %satoc]", factor, atocString);
        }
        List pres = renderManager.getPreViews();
        int numPres = pres.size();
        List mains = renderManager.getMainViews();
        int numMains = mains.size();
        List posts = renderManager.getPostViews();
        int numPosts = posts.size();
        this.stream.printf(" with %d preView%s, %d mainView%s, and ", numPres, numPres == 1 ? "" : "s", numMains, numMains == 1 ? "" : "s");
        this.stream.printf("%d postView%s%n", numPosts, numPosts == 1 ? "" : "s");
        for (index = 0; index < numPres; ++index) {
            this.stream.printf("preView[%d]:%n", index);
            this.dump((ViewPort)pres.get(index), this.indentIncrement);
        }
        for (index = 0; index < numMains; ++index) {
            this.stream.printf("mainView[%d]:%n", index);
            this.dump((ViewPort)mains.get(index), this.indentIncrement);
        }
        for (index = 0; index < numPosts; ++index) {
            this.stream.printf("postView[%d]:%n", index);
            this.dump((ViewPort)posts.get(index), this.indentIncrement);
        }
    }

    public void dump(Skeleton skeleton, String indent) {
        Validate.nonNull(skeleton, "skeleton");
        this.stream.print(indent);
        String description = this.describer.describe(skeleton);
        this.stream.print(description);
        this.stream.println(':');
        Bone[] rootBones = skeleton.getRoots();
        String moreIndent = indent + this.indentIncrement;
        for (Bone rootBone : rootBones) {
            this.dump(rootBone, moreIndent);
        }
        this.stream.println();
        this.stream.flush();
    }

    public void dump(Spatial spatial) {
        this.dump(spatial, "");
        this.stream.flush();
    }

    public void dump(Spatial spatial, String indent) {
        Validate.nonNull(indent, "indent");
        if (spatial == null) {
            return;
        }
        this.stream.print(indent);
        int elementCount = spatial.getTriangleCount();
        this.stream.printf("%c[%d] ", Character.valueOf(this.describer.describeType(spatial)), elementCount);
        String name = MyString.quoteName(spatial.getName());
        this.stream.print(name);
        if (indent.isEmpty() && spatial.getParent() != null) {
            this.stream.print(" (has parent)");
        }
        String description = this.describer.describeControls(spatial);
        this.addDescription(description);
        LightList lights = spatial.getLocalLightList();
        description = this.describer.describe(lights);
        this.addDescription(description);
        if (this.dumpTransformFlag) {
            description = this.describer.describeLocation(spatial);
            this.addDescription(description);
            description = this.describer.describeOrientation(spatial);
            this.addDescription(description);
            description = this.describer.describeScale(spatial);
            this.addDescription(description);
        }
        if (this.dumpBoundsFlag) {
            this.stream.print(" bound[");
            BoundingVolume worldBound = spatial.getWorldBound();
            String desc = this.describer.describe(worldBound);
            this.stream.print(desc);
            this.stream.print(']');
        }
        if (this.dumpUserFlag) {
            description = this.describer.describeUserData(spatial);
            this.addDescription(description);
        }
        if (this.dumpBucketFlag) {
            description = this.describer.describeBucket(spatial);
            this.addDescription(description);
        }
        if (this.dumpShadowFlag) {
            description = this.describer.describeShadow(spatial);
            this.addDescription(description);
        }
        if (this.dumpCullFlag) {
            description = this.describer.describeCull(spatial);
            this.addDescription(description);
        }
        if (this.dumpOverrideFlag) {
            description = this.describer.describeOverrides(spatial);
            this.addDescription(description);
        }
        if (spatial instanceof BitmapText) {
            this.stream.print(" text=");
            String text = ((BitmapText)spatial).getText();
            this.stream.print(MyString.quote(text));
        }
        if (spatial instanceof Geometry) {
            this.dumpGeometry((Geometry)spatial, indent);
        }
        this.stream.println();
        if (spatial instanceof Node) {
            this.dumpChildren((Node)spatial, indent + this.indentIncrement);
        }
    }

    public void dump(ViewPort viewPort) {
        Validate.nonNull(viewPort, "view port");
        this.dump(viewPort, "");
        this.stream.flush();
    }

    public void dump(ViewPort viewPort, String indent) {
        Validate.nonNull(indent, "indent");
        String className = viewPort.getClass().getSimpleName();
        String name = viewPort.getName();
        this.stream.printf("%s%s %s ", indent, className, MyString.quoteName(name));
        if (viewPort.isEnabled()) {
            this.stream.print("enabled ");
            String desc = this.describer.describeFlags(viewPort);
            this.stream.print(desc);
            if (viewPort.isClearColor()) {
                ColorRGBA backColor = viewPort.getBackgroundColor();
                this.stream.printf(" bg(%s)", MyColor.describe(backColor));
            }
            String descP = this.describer.describeProcessors(viewPort);
            this.stream.print(" procs[");
            this.stream.print(descP);
            this.stream.println(']');
            Camera camera = viewPort.getCamera();
            this.dump(camera, indent + "  ");
            this.addLine(indent);
            this.stream.print(" with ");
            SafeArrayList scenes = viewPort.getScenes();
            this.dump((List<Spatial>)scenes, indent);
        } else {
            this.stream.println("disabled");
        }
    }

    public Describer getDescriber() {
        assert (this.describer != null);
        return this.describer;
    }

    public String indentIncrement() {
        assert (this.indentIncrement != null);
        return this.indentIncrement;
    }

    public boolean isDumpBounds() {
        return this.dumpBoundsFlag;
    }

    public boolean isDumpBucket() {
        return this.dumpBucketFlag;
    }

    public boolean isDumpCull() {
        return this.dumpCullFlag;
    }

    public boolean isDumpMatParam() {
        return this.dumpMatParamFlag;
    }

    public boolean isDumpOverride() {
        return this.dumpOverrideFlag;
    }

    public boolean isDumpShadow() {
        return this.dumpShadowFlag;
    }

    public boolean isDumpTransform() {
        return this.dumpTransformFlag;
    }

    public boolean isDumpUser() {
        return this.dumpUserFlag;
    }

    public boolean isDumpVertex() {
        return this.dumpVertexFlag;
    }

    public int maxChildren() {
        assert (this.maxChildren >= 0) : this.maxChildren;
        return this.maxChildren;
    }

    public Dumper setDescriber(Describer newDescriber) {
        Validate.nonNull(newDescriber, "new describer");
        this.describer = newDescriber;
        return this;
    }

    public Dumper setDumpBounds(boolean newValue) {
        this.dumpBoundsFlag = newValue;
        return this;
    }

    public Dumper setDumpBucket(boolean newValue) {
        this.dumpBucketFlag = newValue;
        return this;
    }

    public Dumper setDumpCull(boolean newValue) {
        this.dumpCullFlag = newValue;
        return this;
    }

    public Dumper setDumpMatParam(boolean newValue) {
        this.dumpMatParamFlag = newValue;
        return this;
    }

    public Dumper setDumpOverride(boolean newValue) {
        this.dumpOverrideFlag = newValue;
        return this;
    }

    public Dumper setDumpShadow(boolean newValue) {
        this.dumpShadowFlag = newValue;
        return this;
    }

    public Dumper setDumpTransform(boolean newValue) {
        this.dumpTransformFlag = newValue;
        return this;
    }

    public Dumper setDumpUser(boolean newValue) {
        this.dumpUserFlag = newValue;
        return this;
    }

    public Dumper setDumpVertex(boolean newValue) {
        this.dumpVertexFlag = newValue;
        return this;
    }

    public Dumper setIndentIncrement(String newValue) {
        Validate.nonNull(newValue, "increment");
        this.indentIncrement = newValue;
        return this;
    }

    public Dumper setMaxChildren(int newLimit) {
        Validate.nonNegative(newLimit, "newLimit");
        this.maxChildren = newLimit;
        return this;
    }

    protected void addDescription(String description) {
        Validate.nonNull(description, "description");
        if (!description.isEmpty()) {
            this.stream.print(' ');
            this.stream.print(description);
        }
    }

    protected void addLine(String indent) {
        Validate.nonNull(indent, "indent");
        this.stream.println();
        this.stream.print(indent);
    }

    protected void dump(AppState appState, String indent) {
        String id;
        Validate.nonNull(indent, "indent");
        String className = appState.getClass().getSimpleName();
        this.stream.print(className);
        if (appState instanceof AbstractAppState && (id = ((AbstractAppState)appState).getId()) != null) {
            this.stream.print(" id=");
            this.stream.print(id);
        }
        if (appState.isEnabled()) {
            this.stream.print(" en");
        } else {
            this.stream.print(" dis");
        }
        this.stream.print("abled");
        this.addLine(indent);
    }

    public Dumper clone() throws CloneNotSupportedException {
        Dumper clone = (Dumper)super.clone();
        this.describer = this.describer.clone();
        return clone;
    }

    private void dump(Map<String, MatParam> map, String indent) {
        if (!map.isEmpty()) {
            this.stream.print(':');
            TreeSet<String> names = new TreeSet<String>(map.keySet());
            for (String name : names) {
                this.addLine(indent);
                MatParam matParam = map.get(name);
                String description = this.describer.describe(matParam);
                this.stream.print(description);
            }
        }
    }

    private void dumpChildren(Node node, String childIndent) {
        List children = node.getChildren();
        int numChildren = children.size();
        if (numChildren <= this.maxChildren) {
            for (Spatial child : children) {
                this.dump(child, childIndent);
            }
        } else {
            int numTail = this.maxChildren / 3;
            int numHead = this.maxChildren - numTail;
            for (int childI = 0; childI < numHead; ++childI) {
                Spatial child = (Spatial)children.get(childI);
                this.dump(child, childIndent);
            }
            int numSkipped = numChildren - numHead - numTail;
            this.stream.printf("%s... %d child spatial%s", childIndent, numSkipped, numSkipped == 1 ? "" : "s");
            this.stream.println(" skipped ...");
            for (int i = numChildren - numTail; i < numChildren; ++i) {
                Spatial child = (Spatial)children.get(i);
                this.dump(child, childIndent);
            }
        }
    }

    private void dumpGeometry(Geometry geometry, String indent) {
        Material material = geometry.getMaterial();
        String description = this.describer.describe(material);
        if (!description.isEmpty()) {
            this.addLine(indent);
            this.stream.print(" mat");
            this.stream.print(description);
            if (this.dumpMatParamFlag) {
                this.dump((Map<String, MatParam>)material.getParamsMap(), indent + this.indentIncrement);
            }
        }
        Mesh mesh = geometry.getMesh();
        description = this.describer.describe(mesh);
        this.addLine(indent);
        this.addDescription(description);
        if (this.dumpVertexFlag) {
            IndexBuffer indexBuffer = mesh.getIndexBuffer();
            Mesh.Mode mode = mesh.getMode();
            if (indexBuffer != null) {
                this.addLine(indent);
                this.stream.print(this.indentIncrement);
                this.stream.print("index[");
                for (int ibPos = 0; ibPos < indexBuffer.size(); ++ibPos) {
                    if (ibPos > 0) {
                        if (mode == Mesh.Mode.Triangles && ibPos % 3 == 0 || mode == Mesh.Mode.Lines && ibPos % 2 == 0) {
                            this.stream.print('|');
                        } else {
                            this.stream.print(' ');
                        }
                    }
                    int index = indexBuffer.get(ibPos);
                    this.stream.print(index);
                }
                this.stream.print(']');
            }
            int numVertices = mesh.getVertexCount();
            for (int vertexI = 0; vertexI < numVertices; ++vertexI) {
                this.addLine(indent);
                this.stream.print(this.indentIncrement);
                description = this.describer.describeVertexData(mesh, vertexI);
                this.stream.print(description);
            }
        }
    }
}

