/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.asset.AssetManager;
import com.jme3.export.JmeImporter;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MyAsset;
import jme3utilities.Validate;
import jme3utilities.mesh.PointMesh;

public class PointVisualizer
extends Geometry {
    public static final Logger logger = Logger.getLogger(PointVisualizer.class.getName());
    private AssetManager assetManager;

    protected PointVisualizer() {
        this.assetManager = null;
    }

    public PointVisualizer(AssetManager assetManager, int size, ColorRGBA color, String shapeName) {
        super(shapeName, (Mesh)new PointMesh());
        Validate.nonNull(assetManager, "asset manager");
        Validate.positive(size, "size");
        this.assetManager = assetManager;
        Material mat = MyAsset.createMulticolor2Material(assetManager, null, size);
        mat.setName("point");
        if (color != null) {
            mat.setColor("Color", color.clone());
        }
        RenderState renderState = mat.getAdditionalRenderState();
        renderState.setBlendMode(RenderState.BlendMode.Alpha);
        renderState.setDepthTest(false);
        this.setMaterial(mat);
        this.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.setShadowMode(RenderQueue.ShadowMode.Off);
        if (shapeName != null) {
            this.setShape(shapeName);
        }
    }

    public ColorRGBA copyColor(ColorRGBA storeResult) {
        ColorRGBA result = storeResult == null ? new ColorRGBA() : storeResult;
        MatParam parameter = this.material.getParam("Color");
        Object value = parameter.getValue();
        result.set((ColorRGBA)value);
        return result;
    }

    public boolean isEnabled() {
        boolean isEnabled = this.cullHint == Spatial.CullHint.Never || this.cullHint == Spatial.CullHint.Dynamic;
        return isEnabled;
    }

    public void setColor(ColorRGBA desiredColor) {
        ColorRGBA colorClone = desiredColor.clone();
        this.material.setColor("Color", colorClone);
    }

    public void setDepthTest(boolean enable) {
        RenderState renderState = this.material.getAdditionalRenderState();
        renderState.setDepthTest(enable);
    }

    public void setEnabled(boolean enable) {
        this.cullHint = enable ? Spatial.CullHint.Never : Spatial.CullHint.Always;
    }

    public void setShape(String shapeName) {
        Validate.nonEmpty(shapeName, "shape name");
        String shapePath = String.format("Textures/shapes/%s.png", shapeName);
        boolean mipmaps = false;
        Texture texture = MyAsset.loadTexture(this.assetManager, shapePath, mipmaps);
        this.setShape(texture);
    }

    public void setShape(Texture desiredTexture) {
        Validate.nonNull(desiredTexture, "desired texture");
        this.material.setTexture("PointShape", desiredTexture);
    }

    public void setSize(int desiredSize) {
        Validate.positive(desiredSize, "desired size");
        this.material.setFloat("PointSize", (float)desiredSize);
    }

    public int size() {
        MatParam parameter = this.material.getParam("PointSize");
        Object value = parameter.getValue();
        Float floatValue = (Float)value;
        int result = Math.round(floatValue.floatValue());
        return result;
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        this.assetManager = im.getAssetManager();
    }
}

