/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.MySkeleton;
import jme3utilities.debug.SkeletonVisualizer;
import jme3utilities.math.MyBuffer;

class SkeletonMesh
extends Mesh {
    private static final int numAxes = 3;
    private static final Logger logger = Logger.getLogger(SkeletonMesh.class.getName());

    SkeletonMesh(Armature armature, Skeleton skeleton, Mesh.Mode mode) {
        assert (armature == null || skeleton == null);
        int boneCount = 0;
        int numRoots = 0;
        if (armature != null) {
            boneCount = armature.getJointCount();
            numRoots = MySkeleton.countRootJoints(armature);
        } else if (skeleton != null) {
            boneCount = skeleton.getBoneCount();
            numRoots = MySkeleton.countRootBones(skeleton);
        }
        int numConnections = boneCount - numRoots;
        this.createColors(boneCount);
        this.createPositions(boneCount);
        if (mode == Mesh.Mode.Lines) {
            IndexBuffer ib = this.createLineIndices(boneCount, numConnections);
            for (int boneIndex = 0; boneIndex < boneCount; ++boneIndex) {
                int parentIndex;
                Bone parent;
                Bone child;
                if (armature == null) {
                    child = skeleton.getBone(boneIndex);
                    parent = child.getParent();
                    if (parent == null) continue;
                    parentIndex = skeleton.getBoneIndex(parent);
                    MyBuffer.putRelative(ib, parentIndex);
                    MyBuffer.putRelative(ib, boneIndex);
                    continue;
                }
                child = armature.getJoint(boneIndex);
                parent = child.getParent();
                if (parent == null) continue;
                parentIndex = parent.getId();
                MyBuffer.putRelative(ib, parentIndex);
                MyBuffer.putRelative(ib, boneIndex);
            }
            ib.getBuffer().flip();
        }
        this.setMode(mode);
    }

    void updateColors(SkeletonVisualizer sv) {
        FloatBuffer fColors = this.getFloatBuffer(VertexBuffer.Type.Color);
        fColors.clear();
        int boneCount = sv.countBones();
        ColorRGBA color = new ColorRGBA();
        for (int boneIndex = 0; boneIndex < boneCount; ++boneIndex) {
            sv.copyHeadColor(boneIndex, color);
            fColors.put(color.r).put(color.g).put(color.b).put(color.a);
        }
        fColors.flip();
        VertexBuffer vColors = this.getBuffer(VertexBuffer.Type.Color);
        vColors.updateData((Buffer)fColors);
    }

    void updatePositions(Armature armature, Skeleton skeleton) {
        FloatBuffer floats = this.getFloatBuffer(VertexBuffer.Type.Position);
        floats.clear();
        int boneCount = 0;
        if (armature != null) {
            boneCount = armature.getJointCount();
        } else if (skeleton != null) {
            boneCount = skeleton.getBoneCount();
        }
        for (int boneIndex = 0; boneIndex < boneCount; ++boneIndex) {
            Vector3f location;
            if (armature == null) {
                Bone bone = skeleton.getBone(boneIndex);
                location = bone.getModelSpacePosition();
            } else {
                Joint joint = armature.getJoint(boneIndex);
                location = joint.getModelTransform().getTranslation();
            }
            floats.put(location.x).put(location.y).put(location.z);
        }
        floats.flip();
        VertexBuffer positions = this.getBuffer(VertexBuffer.Type.Position);
        positions.updateData((Buffer)floats);
        this.updateBound();
    }

    public SkeletonMesh clone() {
        SkeletonMesh clone = (SkeletonMesh)super.clone();
        return clone;
    }

    private void createColors(int numVertices) {
        assert (numVertices >= 0) : numVertices;
        FloatBuffer floats = BufferUtils.createFloatBuffer((int)(4 * numVertices));
        VertexBuffer vColors = new VertexBuffer(VertexBuffer.Type.Color);
        vColors.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.Float, (Buffer)floats);
        this.setBuffer(vColors);
    }

    private IndexBuffer createLineIndices(int numBones, int numLines) {
        assert (numLines >= 0) : numLines;
        int numIndices = 2 * numLines;
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)numBones, (int)numIndices);
        VertexBuffer.Format ibFormat = MyBuffer.getFormat(ib);
        Buffer ibData = ib.getBuffer();
        this.setBuffer(VertexBuffer.Type.Index, 1, ibFormat, ibData);
        return ib;
    }

    private void createPositions(int numVertices) {
        assert (numVertices >= 0) : numVertices;
        FloatBuffer floats = BufferUtils.createFloatBuffer((int)(3 * numVertices));
        VertexBuffer positions = new VertexBuffer(VertexBuffer.Type.Position);
        positions.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, (Buffer)floats);
        this.setBuffer(positions);
    }
}

