/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.WireSphere;
import com.jme3.scene.shape.Sphere;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.mesh.Icosphere;
import jme3utilities.mesh.LoopMesh;
import jme3utilities.mesh.Octasphere;

public final class SphereMeshes
extends Enum<SphereMeshes> {
    public static final /* enum */ SphereMeshes Icosphere = new SphereMeshes();
    public static final /* enum */ SphereMeshes LoopMesh = new SphereMeshes();
    public static final /* enum */ SphereMeshes Octasphere = new SphereMeshes();
    public static final /* enum */ SphereMeshes PoleSphere = new SphereMeshes();
    public static final /* enum */ SphereMeshes WireSphere = new SphereMeshes();
    private static final /* synthetic */ SphereMeshes[] $VALUES;

    public static SphereMeshes[] values() {
        return (SphereMeshes[])$VALUES.clone();
    }

    public static SphereMeshes valueOf(String name) {
        return Enum.valueOf(SphereMeshes.class, name);
    }

    public boolean isInstance(Mesh mesh) {
        boolean result;
        switch (this) {
            case Icosphere: {
                result = mesh instanceof Icosphere;
                break;
            }
            case LoopMesh: {
                result = mesh instanceof LoopMesh;
                break;
            }
            case Octasphere: {
                result = mesh instanceof Octasphere;
                break;
            }
            case PoleSphere: {
                result = mesh instanceof Sphere;
                break;
            }
            case WireSphere: {
                result = mesh instanceof WireSphere;
                break;
            }
            default: {
                String message = "enum value = " + (Object)((Object)this);
                throw new IllegalStateException(message);
            }
        }
        return result;
    }

    public Mesh makeSphere(float radius, boolean wantNormals, boolean wantUVs) {
        Object result;
        Validate.positive(radius, "radius");
        switch (this) {
            case Icosphere: {
                int numRefineSteps = 1;
                result = new Icosphere(numRefineSteps, radius);
                break;
            }
            case LoopMesh: {
                int numVertices = 32;
                result = new LoopMesh(numVertices, radius);
                break;
            }
            case Octasphere: {
                int numRefineSteps = 2;
                result = new Octasphere(numRefineSteps, radius);
                break;
            }
            case PoleSphere: {
                int zSamples = 12;
                int radialSamples = 16;
                result = new Sphere(zSamples, radialSamples, radius);
                break;
            }
            case WireSphere: {
                result = new WireSphere(radius);
                break;
            }
            default: {
                String message = "enum value = " + (Object)((Object)this);
                throw new IllegalStateException(message);
            }
        }
        boolean hasNormals = MyMesh.hasNormals((Mesh)result);
        if (hasNormals && !wantNormals) {
            result.clearBuffer(VertexBuffer.Type.Normal);
        } else if (wantNormals && !hasNormals) {
            MyMesh.addSphereNormals((Mesh)result);
        }
        boolean hasUVs = MyMesh.hasUV((Mesh)result);
        if (hasUVs && !wantUVs) {
            result.clearBuffer(VertexBuffer.Type.TexCoord);
        } else if (wantUVs && !hasUVs) {
            String message = "Texture coordinates not available for " + (Object)((Object)this);
            throw new IllegalArgumentException(message);
        }
        assert (this.isInstance((Mesh)result));
        return result;
    }

    static {
        $VALUES = new SphereMeshes[]{Icosphere, LoopMesh, Octasphere, PoleSphere, WireSphere};
    }
}

