/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public final class MyArray {
    public static final Logger logger = Logger.getLogger(MyArray.class.getName());

    private MyArray() {
    }

    public static BoundingBox aabb(Vector3f[] array, BoundingBox storeResult) {
        BoundingBox result;
        Validate.nonEmpty(array, "array");
        Vector3f maxima = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Vector3f minima = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        for (Vector3f tempVector : array) {
            if (!Vector3f.isValidVector((Vector3f)tempVector)) {
                logger.log(Level.WARNING, "Invalid vector {0} in array", tempVector);
            }
            MyVector3f.accumulateMinima(minima, tempVector);
            MyVector3f.accumulateMaxima(maxima, tempVector);
        }
        if (storeResult == null) {
            result = new BoundingBox(minima, maxima);
        } else {
            storeResult.setMinMax(minima, maxima);
            result = storeResult;
        }
        return result;
    }

    public static Matrix3f covarianceVector3f(float[] input, Matrix3f storeResult) {
        float sum;
        int columnIndex;
        int rowIndex;
        Validate.nonEmpty(input, "input");
        int length = input.length;
        assert (length % 3 == 0) : length;
        assert (length >= 6) : length;
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        Vector3f sampleMean = MyArray.meanVector3f(input, null);
        result.zero();
        float[] aboveMean = new float[3];
        int vectorCount = length / 3;
        for (int vectorIndex = 0; vectorIndex < vectorCount; ++vectorIndex) {
            aboveMean[0] = input[3 * vectorIndex] - sampleMean.x;
            aboveMean[1] = input[3 * vectorIndex + 1] - sampleMean.y;
            aboveMean[2] = input[3 * vectorIndex + 2] - sampleMean.z;
            for (rowIndex = 0; rowIndex < 3; ++rowIndex) {
                for (columnIndex = rowIndex; columnIndex < 3; ++columnIndex) {
                    sum = result.get(rowIndex, columnIndex);
                    result.set(rowIndex, columnIndex, sum += aboveMean[rowIndex] * aboveMean[columnIndex]);
                }
            }
        }
        float nMinus1 = vectorCount - 1;
        for (rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (columnIndex = rowIndex; columnIndex < 3; ++columnIndex) {
                sum = result.get(rowIndex, columnIndex);
                float element = sum / nMinus1;
                result.set(rowIndex, columnIndex, element);
                result.set(columnIndex, rowIndex, element);
            }
        }
        return result;
    }

    public static int countNe(Vector3f[] array) {
        int length = array.length;
        HashSet<Vector3f> distinct = new HashSet<Vector3f>(length);
        for (Vector3f vector : array) {
            Vector3f standard = MyVector3f.standardize(vector, null);
            distinct.add(standard);
        }
        int count = distinct.size();
        return count;
    }

    public static boolean distinct(float[] vector, int n) {
        Validate.nonNull(vector, "vector");
        Validate.inRange(n, "length", 0, vector.length);
        boolean result = false;
        if (n > 1) {
            float firstValue = vector[0];
            for (int i = 1; i < n; ++i) {
                float value = vector[i];
                if (value == firstValue) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static int findPreviousIndex(float value, float[] array) {
        int result;
        block5: {
            int testIndex;
            Validate.nonNull(array, "array");
            int lowerBound = -1;
            int upperBound = array.length - 1;
            while (true) {
                if (upperBound == lowerBound) {
                    result = lowerBound;
                    break block5;
                }
                testIndex = (lowerBound + upperBound + 1) / 2;
                float testValue = array[testIndex];
                if (value > testValue) {
                    lowerBound = testIndex;
                    continue;
                }
                if (value < testValue) {
                    upperBound = testIndex - 1;
                    continue;
                }
                if (value == testValue) break;
            }
            result = testIndex;
        }
        assert (result >= -1) : result;
        return result;
    }

    public static int first(boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean isSorted(Comparable[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] >= array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static Vector3f meanVector3f(float[] input, Vector3f storeResult) {
        Validate.nonEmpty(input, "input");
        int length = input.length;
        assert (length % 3 == 0) : length;
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        int vectorCount = length / 3;
        for (int vectorIndex = 0; vectorIndex < vectorCount; ++vectorIndex) {
            result.x += input[3 * vectorIndex];
            result.y += input[3 * vectorIndex + 1];
            result.z += input[3 * vectorIndex + 2];
        }
        result.divideLocal((float)vectorCount);
        return result;
    }

    public static Vector3f mean(Vector3f[] array, Vector3f storeResult) {
        Validate.nonEmpty(array, "array");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        for (Vector3f location : array) {
            result.addLocal(location);
        }
        int count = array.length;
        result.divideLocal((float)count);
        return result;
    }

    public static void normalize(float[] dataset, float min, float max) {
        Validate.nonNull(dataset, "dataset");
        for (int i = 0; i < dataset.length; ++i) {
            dataset[i] = min == max ? 0.5f : (dataset[i] - min) / (max - min);
        }
    }
}

