/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.mesh.IndexByteBuffer;
import com.jme3.scene.mesh.IndexIntBuffer;
import com.jme3.scene.mesh.IndexShortBuffer;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.VectorSet;
import jme3utilities.math.VectorSetUsingBuffer;
import jme3utilities.math.VectorSetUsingCollection;

public final class MyBuffer {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(MyBuffer.class.getName());

    private MyBuffer() {
    }

    public static VectorSet distinct(FloatBuffer buffer, int startPosition, int endPosition) {
        VectorSet result;
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        if (numVectors > 20) {
            result = new VectorSetUsingCollection(numVectors);
        } else {
            boolean direct = false;
            result = new VectorSetUsingBuffer(numVectors, direct);
        }
        Vector3f tmpVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            result.add(tmpVector);
        }
        return result;
    }

    public static Matrix3f covariance(FloatBuffer buffer, int startPosition, int endPosition, Matrix3f storeResult) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition - 6);
        Validate.inRange(endPosition, "end position", startPosition + 6, buffer.capacity());
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        Vector3f sampleMean = MyBuffer.mean(buffer, startPosition, endPosition, null);
        result.zero();
        float[] aboveMean = new float[3];
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            aboveMean[0] = x - sampleMean.x;
            aboveMean[1] = y - sampleMean.y;
            aboveMean[2] = z - sampleMean.z;
            for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
                for (int colIndex = rowIndex; colIndex < 3; ++colIndex) {
                    float sum = result.get(rowIndex, colIndex);
                    result.set(rowIndex, colIndex, sum += aboveMean[rowIndex] * aboveMean[colIndex]);
                }
            }
        }
        float nMinus1 = numVectors - 1;
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int colIndex = rowIndex; colIndex < 3; ++colIndex) {
                float sum = result.get(rowIndex, colIndex);
                float element = sum / nMinus1;
                result.set(rowIndex, colIndex, element);
                result.set(colIndex, rowIndex, element);
            }
        }
        return result;
    }

    public static float cylinderRadius(FloatBuffer buffer, int startPosition, int endPosition, int axisIndex) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        Validate.inRange(axisIndex, "axis index", 0, 2);
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        double maxRadiusSquared = 0.0;
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            float radiusSquared;
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            switch (axisIndex) {
                case 0: {
                    radiusSquared = y * y + z * z;
                    break;
                }
                case 1: {
                    radiusSquared = x * x + z * z;
                    break;
                }
                case 2: {
                    radiusSquared = x * x + y * y;
                    break;
                }
                default: {
                    String message = Integer.toString(axisIndex);
                    throw new RuntimeException(message);
                }
            }
            if (!((double)radiusSquared > maxRadiusSquared)) continue;
            maxRadiusSquared = radiusSquared;
        }
        float result = (float)Math.sqrt(maxRadiusSquared);
        assert (result >= 0.0f) : result;
        return result;
    }

    public static FloatBuffer ensureCapacity(int minFloats, FloatBuffer bufferToReuse) {
        FloatBuffer result;
        Validate.nonNegative(minFloats, "minimum number of elements");
        if (bufferToReuse == null) {
            result = BufferUtils.createFloatBuffer((int)minFloats);
        } else {
            int capacityFloats = bufferToReuse.capacity();
            if (capacityFloats < minFloats) {
                logger.log(Level.SEVERE, "capacity={0}", capacityFloats);
                String message = String.format("Buffer capacity must be greater than or equal to %d.", minFloats);
                throw new IllegalArgumentException(message);
            }
            result = bufferToReuse;
        }
        return result;
    }

    public static int frequency(IntBuffer buffer, int startPosition, int endPosition, int intValue) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int result = 0;
        for (int position = startPosition; position < endPosition; ++position) {
            int bufferValue = buffer.get(position);
            if (bufferValue != intValue) continue;
            ++result;
        }
        return result;
    }

    public static void get(FloatBuffer buffer, int startPosition, Vector3f storeVector) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNegative(startPosition, "start position");
        Validate.nonNull(storeVector, "store vector");
        storeVector.x = buffer.get(startPosition + 0);
        storeVector.y = buffer.get(startPosition + 1);
        storeVector.z = buffer.get(startPosition + 2);
    }

    public static VertexBuffer.Format getFormat(IndexBuffer indexBuffer) {
        if (indexBuffer instanceof IndexByteBuffer) {
            return VertexBuffer.Format.UnsignedByte;
        }
        if (indexBuffer instanceof IndexShortBuffer) {
            return VertexBuffer.Format.UnsignedShort;
        }
        if (indexBuffer instanceof IndexIntBuffer) {
            return VertexBuffer.Format.UnsignedInt;
        }
        String message = "class=" + indexBuffer.getClass().getSimpleName();
        throw new IllegalArgumentException(message);
    }

    public static Vector3f maxAbs(FloatBuffer buffer, int startPosition, int endPosition, Vector3f storeResult) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        result.zero();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            result.x = Math.max(result.x, Math.abs(x));
            result.y = Math.max(result.y, Math.abs(y));
            result.z = Math.max(result.z, Math.abs(z));
        }
        return result;
    }

    public static float maxLength(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        double maxLengthSquared = 0.0;
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            float[] fArray = new float[]{x, y, z};
            double lengthSquared = MyMath.sumOfSquares(fArray);
            if (!(lengthSquared > maxLengthSquared)) continue;
            maxLengthSquared = lengthSquared;
        }
        float result = (float)Math.sqrt(maxLengthSquared);
        assert (result >= 0.0f) : result;
        return result;
    }

    public static void maxMin(FloatBuffer buffer, int startPosition, int endPosition, Vector3f storeMaxima, Vector3f storeMinima) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        storeMaxima.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        storeMinima.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f tmpVector = new Vector3f();
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            MyVector3f.accumulateMinima(storeMinima, tmpVector);
            MyVector3f.accumulateMaxima(storeMaxima, tmpVector);
        }
    }

    public static Vector3f mean(FloatBuffer buffer, int startPosition, int endPosition, Vector3f storeResult) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition - 3);
        Validate.inRange(endPosition, "end position", startPosition + 3, buffer.capacity());
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        result.zero();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            float x = buffer.get(position + 0);
            float y = buffer.get(position + 1);
            float z = buffer.get(position + 2);
            result.addLocal(x, y, z);
        }
        result.divideLocal((float)numVectors);
        return result;
    }

    public static void normalize(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition - 3);
        Validate.inRange(endPosition, "end position", startPosition + 3, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        Vector3f tmpVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            MyVector3f.normalizeLocal(tmpVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }

    public static void put(FloatBuffer buffer, int startPosition, Vector3f vector) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNegative(startPosition, "start position");
        Validate.nonNull(vector, "vector");
        buffer.put(startPosition + 0, vector.x);
        buffer.put(startPosition + 1, vector.y);
        buffer.put(startPosition + 2, vector.z);
    }

    public static void putRelative(IndexBuffer indexBuffer, int value) {
        if (indexBuffer instanceof IndexByteBuffer) {
            ((ByteBuffer)indexBuffer.getBuffer()).put((byte)value);
        } else if (indexBuffer instanceof IndexShortBuffer) {
            ((ShortBuffer)indexBuffer.getBuffer()).put((short)value);
        } else if (indexBuffer instanceof IndexIntBuffer) {
            ((IntBuffer)indexBuffer.getBuffer()).put(value);
        } else {
            String message = "class=" + indexBuffer.getClass().getSimpleName();
            throw new IllegalArgumentException(message);
        }
    }

    public static void rotate(FloatBuffer buffer, int startPosition, int endPosition, Quaternion rotation) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNull(rotation, "rotation");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        Vector3f tmpVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            rotation.mult(tmpVector, tmpVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }

    public static void scale(FloatBuffer buffer, int startPosition, int endPosition, Vector3f scale) {
        Validate.nonNull(buffer, "buffer");
        Validate.finite(scale, "scale factors");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        Vector3f tmpVector = new Vector3f();
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            scale.mult(tmpVector, tmpVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }

    public static float[] toFloatArray(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        float[] result = new float[numFloats];
        for (int floatIndex = 0; floatIndex < numFloats; ++floatIndex) {
            int position = startPosition + floatIndex;
            result[floatIndex] = buffer.get(position);
        }
        return result;
    }

    public static int[] toIntArray(IntBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numInts = endPosition - startPosition;
        int[] result = new int[numInts];
        for (int intIndex = 0; intIndex < numInts; ++intIndex) {
            int position = startPosition + intIndex;
            result[intIndex] = buffer.get(position);
        }
        return result;
    }

    public static void transform(FloatBuffer buffer, int startPosition, int endPosition, Transform transform) {
        Validate.nonNull(buffer, "buffer");
        Validate.nonNull(transform, "transform");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        Vector3f tmpVector = new Vector3f();
        int numVectors = numFloats / 3;
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            transform.transformVector(tmpVector, tmpVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }

    public static void translate(FloatBuffer buffer, int startPosition, int endPosition, Vector3f offsetVector) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        Validate.finite(offsetVector, "offset vector");
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        Vector3f tmpVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = startPosition + vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            tmpVector.addLocal(offsetVector);
            MyBuffer.put(buffer, position, tmpVector);
        }
    }
}

