/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math.noise;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public class Generator
extends Random {
    private static final Logger logger = Logger.getLogger(Generator.class.getName());
    static final long serialVersionUID = 37705297950129619L;

    public Generator() {
    }

    public Generator(long seed) {
        super(seed);
    }

    @Override
    public float nextFloat(float e1, float e2) {
        float result = e1 + this.nextFloat() * (e2 - e1);
        assert (MyMath.isBetween(e1, result, e2));
        return result;
    }

    @Override
    public int nextInt(int e1, int e2) {
        int max = Math.max(e1, e2);
        int min = Math.min(e1, e2);
        int result = min + this.nextInt(max - min + 1);
        assert (MyMath.isBetween(e1, result, e2));
        return result;
    }

    public int nextPoisson(double lambda) {
        double expMinusLambda = Math.exp(-lambda);
        double p = 1.0;
        int result = -1;
        do {
            ++result;
        } while ((p *= this.nextDouble()) > expMinusLambda);
        return result;
    }

    public Quaternion nextQuaternion() {
        Quaternion result = this.nextQuaternion(null);
        return result;
    }

    public Quaternion nextQuaternion(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        double lengthSquared = 0.0;
        while (lengthSquared < 0.1 || lengthSquared > 1.0) {
            float x = this.nextFloat(-1.0f, 1.0f);
            float y = this.nextFloat(-1.0f, 1.0f);
            float z = this.nextFloat(-1.0f, 1.0f);
            float w = this.nextFloat(-1.0f, 1.0f);
            result.set(x, y, z, w);
            lengthSquared = MyQuaternion.lengthSquared(result);
        }
        double scaleFactor = 1.0 / Math.sqrt(lengthSquared);
        result.multLocal((float)scaleFactor);
        return result;
    }

    public Vector3f nextUnitVector3f() {
        Vector3f result = this.nextUnitVector3f(null);
        return result;
    }

    public Vector3f nextUnitVector3f(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        double lengthSquared = 0.0;
        while (lengthSquared < 0.1 || lengthSquared > 1.0) {
            float x = this.nextFloat(-1.0f, 1.0f);
            float y = this.nextFloat(-1.0f, 1.0f);
            float z = this.nextFloat(-1.0f, 1.0f);
            result.set(x, y, z);
            lengthSquared = MyVector3f.lengthSquared(result);
        }
        double scaleFactor = 1.0 / Math.sqrt(lengthSquared);
        result.multLocal((float)scaleFactor);
        assert (result.isUnitVector());
        return result;
    }

    public Vector3f nextVector3f() {
        Vector3f result = this.nextVector3f(null);
        return result;
    }

    public Vector3f nextVector3f(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        double lengthSquared = 2.0;
        while (lengthSquared > 1.0) {
            float x = this.nextFloat(-1.0f, 1.0f);
            float y = this.nextFloat(-1.0f, 1.0f);
            float z = this.nextFloat(-1.0f, 1.0f);
            result.set(x, y, z);
            lengthSquared = MyVector3f.lengthSquared(result);
        }
        return result;
    }

    public Vector3f ortho(Vector3f input) {
        Validate.nonZero(input, "input");
        Vector3f ref = input.normalize();
        Vector3f result = new Vector3f();
        double lengthSquared = 0.0;
        while (lengthSquared < 0.1) {
            Vector3f sample = this.nextUnitVector3f();
            ref.cross(sample, result);
            lengthSquared = MyVector3f.lengthSquared(result);
        }
        double scaleFactor = 1.0 / Math.sqrt(lengthSquared);
        result.multLocal((float)scaleFactor);
        assert (result.isUnitVector());
        return result;
    }

    public Object pick(Object[] array) {
        Validate.nonNull(array, "array");
        int count = array.length;
        assert (count >= 0) : count;
        if (count == 0) {
            return null;
        }
        int index = this.nextInt(count);
        Object result = array[index];
        return result;
    }

    public int pick(BitSet bitset, int maxIndex, boolean bitValue) {
        int lastIndex;
        int firstIndex;
        Validate.nonNull(bitset, "bit set");
        Validate.inRange(maxIndex, "max index", 0, bitset.size() - 1);
        if (bitValue) {
            firstIndex = bitset.nextSetBit(0);
            lastIndex = bitset.previousSetBit(maxIndex);
        } else {
            firstIndex = bitset.nextClearBit(0);
            lastIndex = bitset.previousClearBit(maxIndex);
        }
        if (firstIndex == -1) {
            assert (lastIndex == -1) : lastIndex;
            return -1;
        }
        if (firstIndex == lastIndex) {
            return firstIndex;
        }
        int numPossibilties = lastIndex - firstIndex + 1;
        int bitIndex = firstIndex + this.nextInt(numPossibilties);
        while (bitset.get(bitIndex) != bitValue) {
            bitIndex = firstIndex + this.nextInt(numPossibilties);
        }
        return bitIndex;
    }

    public Object pick(List list) {
        Validate.nonNull(list, "list");
        int count = list.size();
        assert (count >= 0) : count;
        if (count == 0) {
            return null;
        }
        int index = this.nextInt(count);
        Object result = list.get(index);
        return result;
    }
}

