/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Cone
extends Mesh {
    private static final int numAxes = 3;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(Cone.class.getName());

    protected Cone() {
    }

    public Cone(int numSides, float radius, float yHeight, boolean generatePyramid) {
        Validate.inRange(numSides, "number of sides", 3, Integer.MAX_VALUE);
        Validate.positive(radius, "radius");
        Validate.positive(yHeight, "height");
        int numBaseTriangles = numSides - 2;
        int numTriangles = numBaseTriangles + numSides;
        int numFloats = numTriangles * 3 * 3;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        this.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffer);
        float yApex = yHeight / 2.0f;
        float yBase = -yHeight / 2.0f;
        float interiorAngle = (float)Math.PI * 2 / (float)numSides;
        Triangle triangle = new Triangle();
        Vector3f p1 = new Vector3f();
        Vector3f p2 = new Vector3f();
        Vector3f p3 = new Vector3f();
        for (int sideIndex = 0; sideIndex < numSides; ++sideIndex) {
            float theta1 = (float)sideIndex * interiorAngle;
            float x1 = radius * FastMath.sin((float)theta1);
            float z1 = radius * FastMath.cos((float)theta1);
            int nextSideIndex = sideIndex + 1;
            float theta2 = (float)nextSideIndex * interiorAngle;
            float x2 = radius * FastMath.sin((float)theta2);
            float z2 = radius * FastMath.cos((float)theta2);
            p1.set(x1, yBase, z1);
            p2.set(x2, yBase, z2);
            p3.set(0.0f, yApex, 0.0f);
            positionBuffer.put(p1.x).put(p1.y).put(p1.z);
            positionBuffer.put(p2.x).put(p2.y).put(p2.z);
            positionBuffer.put(p3.x).put(p3.y).put(p3.z);
            if (generatePyramid) {
                triangle.set(p1, p2, p3);
                Vector3f n = triangle.getNormal();
                for (int j = 0; j < 3; ++j) {
                    normalBuffer.put(n.x).put(n.y).put(n.z);
                }
            } else {
                float tangent = radius / yHeight;
                float cosine = 1.0f / MyMath.hypotenuse(1.0f, tangent);
                float ny = cosine * tangent;
                float nx = cosine * x1 / radius;
                float nz = cosine * z1 / radius;
                normalBuffer.put(nx).put(ny).put(nz);
                nx = cosine * x2 / radius;
                nz = cosine * z2 / radius;
                normalBuffer.put(nx).put(ny).put(nz);
                float theta3 = (theta1 + theta2) / 2.0f;
                nx = cosine * FastMath.sin((float)theta3);
                nz = cosine * FastMath.cos((float)theta3);
                normalBuffer.put(nx).put(ny).put(nz);
            }
            if (sideIndex >= numBaseTriangles) continue;
            float theta3 = (float)(numSides - 1) * interiorAngle;
            float x3 = radius * FastMath.sin((float)theta3);
            float z3 = radius * FastMath.cos((float)theta3);
            positionBuffer.put(x3).put(yBase).put(z3);
            positionBuffer.put(x2).put(yBase).put(z2);
            positionBuffer.put(x1).put(yBase).put(z1);
            normalBuffer.put(0.0f).put(-1.0f).put(0.0f);
            normalBuffer.put(0.0f).put(-1.0f).put(0.0f);
            normalBuffer.put(0.0f).put(-1.0f).put(0.0f);
        }
        positionBuffer.flip();
        assert (positionBuffer.limit() == positionBuffer.capacity());
        normalBuffer.flip();
        assert (normalBuffer.limit() == positionBuffer.capacity());
        this.updateBound();
        this.setStatic();
    }
}

