/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;

public class Icosphere
extends Mesh {
    private static final float phi = MyMath.phi;
    private static final int numAxes = 3;
    private static final int vpt = 3;
    private static final int[] icoIndices = new int[]{0, 11, 5, 0, 5, 1, 0, 1, 7, 0, 7, 10, 0, 10, 11, 1, 5, 9, 5, 11, 4, 11, 10, 2, 10, 7, 6, 7, 1, 8, 3, 9, 4, 3, 4, 2, 3, 2, 6, 3, 6, 8, 3, 8, 9, 4, 9, 5, 2, 4, 11, 6, 2, 10, 8, 6, 7, 9, 8, 1};
    public static final Logger logger = Logger.getLogger(Icosphere.class.getName());
    private static final Vector3f[] icoLocations = new Vector3f[]{new Vector3f(-1.0f, phi, 0.0f), new Vector3f(1.0f, phi, 0.0f), new Vector3f(-1.0f, -phi, 0.0f), new Vector3f(1.0f, -phi, 0.0f), new Vector3f(0.0f, -1.0f, phi), new Vector3f(0.0f, 1.0f, phi), new Vector3f(0.0f, -1.0f, -phi), new Vector3f(0.0f, 1.0f, -phi), new Vector3f(phi, 0.0f, -1.0f), new Vector3f(phi, 0.0f, 1.0f), new Vector3f(-phi, 0.0f, -1.0f), new Vector3f(-phi, 0.0f, 1.0f)};
    private final float radius;
    private int nextVertexIndex = 0;
    private final List<Vector3f> locations = new ArrayList<Vector3f>(162);
    private final Map<Long, Integer> midpointCache = new HashMap<Long, Integer>(480);

    protected Icosphere() {
        this.radius = 1.0f;
    }

    public Icosphere(int numRefineSteps, float radius) {
        Validate.nonNegative(numRefineSteps, "number of refinement steps");
        Validate.positive(radius, "radius");
        this.radius = radius;
        for (Vector3f icoLocation : icoLocations) {
            this.addVertex(icoLocation);
        }
        ArrayList<Integer> faces = new ArrayList<Integer>();
        for (int icoIndex : icoIndices) {
            faces.add(icoIndex);
        }
        for (int stepIndex = 0; stepIndex < numRefineSteps; ++stepIndex) {
            ArrayList<Integer> newFaces = new ArrayList<Integer>();
            for (int j = 0; j < faces.size(); j += 3) {
                int v1 = (Integer)faces.get(j);
                int v2 = (Integer)faces.get(j + 1);
                int v3 = (Integer)faces.get(j + 2);
                int a = this.midpointIndex(v1, v2);
                int b = this.midpointIndex(v2, v3);
                int c = this.midpointIndex(v3, v1);
                newFaces.add(v1);
                newFaces.add(a);
                newFaces.add(c);
                newFaces.add(v2);
                newFaces.add(b);
                newFaces.add(a);
                newFaces.add(v3);
                newFaces.add(c);
                newFaces.add(b);
                newFaces.add(a);
                newFaces.add(b);
                newFaces.add(c);
            }
            faces = newFaces;
        }
        this.midpointCache.clear();
        int numVertices = this.locations.size();
        int numFloats = 3 * numVertices;
        FloatBuffer posBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        for (Vector3f pos : this.locations) {
            posBuffer.put(pos.x).put(pos.y).put(pos.z);
        }
        posBuffer.flip();
        this.setBuffer(VertexBuffer.Type.Position, 3, posBuffer);
        int numIndices = faces.size();
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        for (int i = 0; i < numIndices; ++i) {
            int vertexIndex = (Integer)faces.get(i);
            MyBuffer.putRelative(ib, vertexIndex);
        }
        VertexBuffer.Format ibFormat = MyBuffer.getFormat(ib);
        Buffer ibData = ib.getBuffer();
        ibData.flip();
        this.setBuffer(VertexBuffer.Type.Index, 3, ibFormat, ibData);
        FloatBuffer uvBuffer = BufferUtils.createFloatBuffer((int)(2 * numVertices));
        for (Vector3f pos : this.locations) {
            Vector2f longLat = this.cartesianToSpherical(pos);
            float u = 0.5f + longLat.x / ((float)Math.PI * 2);
            float v = 0.5f + longLat.y / (float)Math.PI;
            uvBuffer.put(u).put(v);
        }
        uvBuffer.flip();
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, uvBuffer);
        MyMesh.addSphereNormals(this);
        this.locations.clear();
        this.updateBound();
        this.setStatic();
    }

    private int addVertex(Vector3f location) {
        float length = location.length();
        this.locations.add(location.mult(this.radius / length));
        int result = this.nextVertexIndex++;
        return result;
    }

    private Vector2f cartesianToSpherical(Vector3f input) {
        Vector2f result = new Vector2f();
        float length = input.length();
        result.x = input.x != 0.0f || input.y != 0.0f ? -FastMath.atan2((float)input.y, (float)input.x) : 0.0f;
        result.y = length > 0.0f ? FastMath.asin((float)(input.z / length)) : 0.0f;
        return result;
    }

    private int midpointIndex(int p1, int p2) {
        long greaterIndex;
        boolean firstIsSmaller = p1 < p2;
        long smallerIndex = firstIsSmaller ? (long)p1 : (long)p2;
        long key = (smallerIndex << 32) + (greaterIndex = firstIsSmaller ? (long)p2 : (long)p1);
        Integer cachedIndex = this.midpointCache.get(key);
        if (cachedIndex != null) {
            return cachedIndex;
        }
        Vector3f loc1 = this.locations.get(p1);
        Vector3f loc2 = this.locations.get(p2);
        Vector3f middleLocation = MyVector3f.midpoint(loc1, loc2, null);
        int newIndex = this.addVertex(middleLocation);
        this.midpointCache.put(key, newIndex);
        return newIndex;
    }
}

