/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.font.Rectangle;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RectangleMesh
extends Mesh {
    private static final int vpt = 3;
    private static final Logger logger = Logger.getLogger(RectangleMesh.class.getName());

    public RectangleMesh() {
        this(0.0f, 1.0f, 0.0f, 1.0f, 1.0f);
    }

    public RectangleMesh(Rectangle rect, float zNorm) {
        this(0.0f, 1.0f, 0.0f, 1.0f, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, zNorm);
    }

    public RectangleMesh(float x1, float x2, float y1, float y2, float zNorm) {
        this(0.0f, 1.0f, 0.0f, 1.0f, x1, x2, y1, y2, zNorm);
    }

    public RectangleMesh(float s1, float s2, float t1, float t2, float x1, float x2, float y1, float y2, float zNorm) {
        if (zNorm != -1.0f && zNorm != 1.0f) {
            logger.log(Level.SEVERE, "zNorm={0}", Float.valueOf(zNorm));
            throw new IllegalArgumentException("zNorm must be +1 or -1.");
        }
        this.setMode(Mesh.Mode.TriangleFan);
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{x1, y1, 0.0f, x1, y2, 0.0f, x2, y2, 0.0f, x2, y1, 0.0f});
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{s1, t1, s1, t2, s2, t2, s2, t1});
        this.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, zNorm, 0.0f, 0.0f, zNorm, 0.0f, 0.0f, zNorm, 0.0f, 0.0f, zNorm});
        if ((x2 - x1) * (y2 - y1) * zNorm > 0.0f) {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 3, 2, 1});
        } else {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 1, 2, 3});
        }
        this.updateBound();
        this.setStatic();
    }
}

