/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.AnimLayer;
import com.jme3.anim.MorphControl;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.tween.action.Action;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import jme3utilities.Heart;
import jme3utilities.MyAnimation;
import jme3utilities.MyString;
import jme3utilities.Validate;

public class MyControl {
    private static final Logger logger = Logger.getLogger(MyControl.class.getName());

    private MyControl() {
    }

    public static boolean canDisable(Control sgc) {
        boolean result = sgc instanceof AbstractControl;
        if (!result) {
            Class<?> sgcClass = sgc.getClass();
            try {
                sgcClass.getMethod("isEnabled", new Class[0]);
                result = true;
            }
            catch (NoSuchMethodException exception) {
                String message = sgcClass.getName();
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static String describe(Control control) {
        StringBuilder result = new StringBuilder(80);
        String typeString = MyControl.describeType(control);
        result.append(typeString);
        if (control instanceof AnimComposer) {
            AnimComposer composer = (AnimComposer)control;
            result.append("[clips=");
            Set nameCollection = composer.getAnimClipsNames();
            int numClips = nameCollection.size();
            result.append(numClips);
            float gSpeed = composer.getGlobalSpeed();
            if (gSpeed != 1.0f) {
                result.append(" gSpeed=");
                result.append(MyString.describe(gSpeed));
            }
            result.append(" layers");
            nameCollection = composer.getLayerNames();
            int numLayers = nameCollection.size();
            if (numLayers == 1) {
                String name = (String)Heart.first(nameCollection);
                AnimLayer layer = composer.getLayer(name);
                result.append("[t=");
                double animTime = layer.getTime();
                result.append(MyString.describeFraction((float)animTime));
                result.append(" action=");
                Action action = layer.getCurrentAction();
                if (action == null) {
                    result.append("null");
                } else {
                    result.append(action.getClass().getSimpleName());
                    result.append(MyString.quote(action.toString()));
                }
                result.append(']');
            } else {
                result.append('=');
                result.append(numLayers);
            }
            result.append(']');
        } else if (control instanceof AnimControl) {
            AnimControl animControl = (AnimControl)control;
            result.append('[');
            Collection nameCollection = animControl.getAnimationNames();
            int numAnimations = nameCollection.size();
            if (numAnimations > 2) {
                result.append(numAnimations);
            } else {
                boolean isFirst = true;
                for (String animationName : nameCollection) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        result.append(',');
                    }
                    Animation animation = animControl.getAnim(animationName);
                    String desc = MyAnimation.describe(animation, animControl);
                    result.append(desc);
                }
            }
            result.append(']');
        } else if (control instanceof MorphControl) {
            MorphControl morph = (MorphControl)control;
            result.append('[');
            boolean approx = morph.isApproximateTangents();
            result.append(approx ? " approx" : " vbuf");
            result.append(']');
        } else if (control instanceof SkeletonControl) {
            SkeletonControl skeletonControl = (SkeletonControl)control;
            result.append('[');
            int boneCount = skeletonControl.getSkeleton().getBoneCount();
            result.append(boneCount);
            boolean useHw = skeletonControl.isHardwareSkinningUsed();
            result.append(useHw ? " hw]" : " sw]");
        } else if (control instanceof SkinningControl) {
            SkinningControl skinningControl = (SkinningControl)control;
            result.append('[');
            int jointCount = skinningControl.getArmature().getJointCount();
            result.append(jointCount);
            boolean useHw = skinningControl.isHardwareSkinningUsed();
            result.append(useHw ? " hw]" : " sw]");
        }
        return result.toString();
    }

    public static String describeType(Control control) {
        String description = control.getClass().getSimpleName();
        if (description.endsWith("Control")) {
            description = MyString.removeSuffix(description, "Control");
        }
        return description;
    }

    public static int findIndex(Control sgc, Spatial spatial) {
        Validate.nonNull(sgc, "control");
        int result = -1;
        int numControls = spatial.getNumControls();
        for (int index = 0; index < numControls; ++index) {
            Control control = spatial.getControl(index);
            if (control != sgc) continue;
            result = index;
        }
        return result;
    }

    public static Skeleton findSkeleton(Control sgc) {
        Skeleton result = null;
        if (sgc instanceof AnimControl) {
            AnimControl animControl = (AnimControl)sgc;
            result = animControl.getSkeleton();
        } else if (sgc instanceof SkeletonControl) {
            SkeletonControl skeletonControl = (SkeletonControl)sgc;
            result = skeletonControl.getSkeleton();
        }
        return result;
    }

    public static boolean isEnabled(Control sgc) {
        boolean result;
        Validate.nonNull(sgc, "control");
        if (sgc instanceof AbstractControl) {
            AbstractControl abstractControl = (AbstractControl)sgc;
            result = abstractControl.isEnabled();
        } else {
            Class<?> sgcClass = sgc.getClass();
            try {
                Method isEnabled = sgcClass.getMethod("isEnabled", new Class[0]);
                result = (Boolean)isEnabled.invoke((Object)sgc, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
                String message = sgcClass.getName();
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static void setEnabled(Control sgc, boolean newState) {
        if (sgc instanceof AbstractControl) {
            AbstractControl abstractControl = (AbstractControl)sgc;
            abstractControl.setEnabled(newState);
        } else {
            Class<?> sgcClass = sgc.getClass();
            try {
                Method setEnabled = sgcClass.getMethod("setEnabled", new Class[0]);
                setEnabled.invoke((Object)sgc, newState);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
                String message = sgcClass.getName();
                throw new IllegalArgumentException(message);
            }
        }
    }
}

