/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3utilities.Validate;

public class MyString {
    private static final Logger logger = Logger.getLogger(MyString.class.getName());
    private static final Pattern sciPattern = Pattern.compile("[Ee][+-]?\\d+$");
    private static final String[] axisNames = new String[]{"X", "Y", "Z"};

    private MyString() {
    }

    public static List<String> addMatchPrefix(Collection<String> collection, String prefix, List<String> addResult) {
        List<String> result;
        Validate.nonNull(collection, "input collection");
        Validate.nonNull(prefix, "prefix");
        if (addResult == null) {
            int size = collection.size();
            result = new ArrayList<String>(size);
        } else {
            result = addResult;
        }
        for (String string : collection) {
            if (!string.startsWith(prefix)) continue;
            result.add(string);
        }
        return result;
    }

    public static int axisIndex(String axisName) {
        for (int axisIndex = 0; axisIndex < axisNames.length; ++axisIndex) {
            if (!axisNames[axisIndex].equals(axisName)) continue;
            return axisIndex;
        }
        String quoted = MyString.quote(axisName);
        throw new IllegalArgumentException(quoted);
    }

    public static String axisName(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        String axisName = axisNames[axisIndex];
        return axisName;
    }

    public static void dedup(List<String> list, String separator) {
        Validate.nonNull(list, "list");
        for (String string : list) {
            int numInstances = 0;
            for (String s : list) {
                if (!s.equals(string)) continue;
                ++numInstances;
            }
            if (numInstances <= true) continue;
            int numElements = list.size();
            int nextSuffix = 1;
            for (int index = 0; index < numElements; ++index) {
                String originalName = list.get(index);
                if (!originalName.equals(string)) continue;
                String withSuffix = String.format("%s%s%d", originalName, separator, nextSuffix);
                ++nextSuffix;
                list.set(index, withSuffix);
            }
        }
    }

    public static String describe(float fValue) {
        String raw = String.format(Locale.US, "%g", Float.valueOf(fValue));
        String result = MyString.trimFloat(raw);
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public static String describeFraction(float fValue) {
        String raw = String.format(Locale.US, "%.3f", Float.valueOf(fValue));
        String result = MyString.trimFloat(raw);
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public static String escape(CharSequence unescaped) {
        int length = unescaped.length();
        StringBuilder result = new StringBuilder(length + 10);
        block6: for (int i = 0; i < length; ++i) {
            char ch = unescaped.charAt(i);
            switch (ch) {
                case '\n': {
                    result.append("\\n");
                    continue block6;
                }
                case '\t': {
                    result.append("\\t");
                    continue block6;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static int findIndex(String[] array, String value) {
        Validate.nonNull(array, "array");
        Validate.nonNull(value, "value");
        for (int index = 0; index < array.length; ++index) {
            if (!value.equals(array[index])) continue;
            return index;
        }
        return -1;
    }

    public static String findLongestPrefix(Collection<String> collection) {
        CharSequence longest = "";
        int longestLength = 0;
        String[] array = MyString.toArray(collection);
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            String si = array[i];
            for (int j = i + 1; j < count; ++j) {
                String sj = array[j];
                int prefixLength = MyString.sharedPrefixLength(si, sj);
                if (prefixLength <= longestLength) continue;
                longestLength = prefixLength;
                longest = si.subSequence(0, prefixLength);
            }
        }
        return longest.toString();
    }

    public static String firstToLower(String input) {
        String result = input;
        if (!input.isEmpty()) {
            String first = input.substring(0, 1);
            first = first.toLowerCase(Locale.ROOT);
            String rest = input.substring(1);
            result = first + rest;
        }
        return result;
    }

    public static Map<String, String> invert(Map<String, String> input) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            String key = entry.getKey();
            if (result.containsKey(key)) {
                throw new IllegalArgumentException("Non-invertible map.");
            }
            String value = entry.getValue();
            result.put(value, key);
        }
        return result;
    }

    public static boolean isSorted(List<String> list) {
        int len = list.size();
        for (int i = 0; i < len - 1; ++i) {
            if (list.get(i).compareTo(list.get(i + 1)) < 0) continue;
            return false;
        }
        return true;
    }

    public static String join(CharSequence separator, Iterable objects) {
        Validate.nonNull(separator, "separator");
        Validate.nonNull(objects, "list");
        StringBuilder result = new StringBuilder(80);
        for (Object item : objects) {
            if (item == null) continue;
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(item);
        }
        return result.toString();
    }

    public static String join(Iterable objects) {
        Validate.nonNull(objects, "objects");
        String result = MyString.join(" ", objects);
        return result;
    }

    public static String join(Object[] array) {
        Validate.nonNull(array, "array");
        StringBuilder result = new StringBuilder(80);
        for (Object element : array) {
            if (element == null) continue;
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(element);
        }
        return result.toString();
    }

    public static void matchPrefix(Collection<String> collection, String prefix) {
        Validate.nonNull(collection, "collection");
        Validate.nonNull(prefix, "prefix");
        for (String element : MyString.toArray(collection)) {
            if (element.startsWith(prefix)) continue;
            collection.remove(element);
        }
    }

    public static String quote(CharSequence text) {
        String result = text == null ? "null" : "\"" + MyString.escape(text) + "\"";
        return result;
    }

    public static String quoteName(CharSequence name) {
        String result = name == null ? "(no name)" : "\"" + MyString.escape(name) + "\"";
        return result;
    }

    public static void reduce(Collection<String> collection, int sizeGoal) {
        Validate.positive(sizeGoal, "size goal");
        while (collection.size() > sizeGoal) {
            String longestPrefix = MyString.findLongestPrefix(collection);
            if (longestPrefix.isEmpty()) {
                return;
            }
            for (String string : MyString.toArray(collection)) {
                if (!string.startsWith(longestPrefix)) continue;
                collection.remove(string);
            }
            collection.add(longestPrefix);
        }
    }

    public static String remainder(String input, String prefix) {
        Validate.nonNull(prefix, "prefix");
        if (!input.startsWith(prefix)) {
            logger.log(Level.SEVERE, "input={0}, prefix={1}", new Object[]{MyString.quote(input), MyString.quote(prefix)});
            throw new IllegalArgumentException("input must start with prefix.");
        }
        int endPosition = prefix.length();
        String result = input.substring(endPosition);
        assert (result != null);
        return result;
    }

    public static String removeSuffix(String input, String suffix) {
        Validate.nonNull(suffix, "suffix");
        if (!input.endsWith(suffix)) {
            logger.log(Level.SEVERE, "input={0}, suffix={1}", new Object[]{MyString.quote(input), MyString.quote(suffix)});
            throw new IllegalArgumentException("input must end with suffix.");
        }
        int endPosition = input.length() - suffix.length();
        String result = input.substring(0, endPosition);
        assert (result != null);
        return result;
    }

    public static String repeat(CharSequence sequence, int numTimes) {
        Validate.nonNull(sequence, "sequence");
        Validate.nonNegative(numTimes, "number of times");
        int length = numTimes * sequence.length();
        StringBuilder builder = new StringBuilder(length);
        for (int index = 0; index < numTimes; ++index) {
            builder.append(sequence);
        }
        return builder.toString();
    }

    public static int sharedPrefixLength(CharSequence s1, CharSequence s2) {
        char c2;
        char c1;
        int spLength;
        int length1 = s1.length();
        int length2 = s2.length();
        int maxPrefixLength = Math.min(length1, length2);
        for (spLength = 0; spLength < maxPrefixLength && (c1 = s1.charAt(spLength)) == (c2 = s2.charAt(spLength)); ++spLength) {
        }
        return spLength;
    }

    public static String[] toArray(Collection<String> collection) {
        int count = collection.size();
        String[] array = new String[count];
        collection.toArray(array);
        return array;
    }

    public static String trimFloat(String input) {
        String result;
        Matcher matcher = sciPattern.matcher(input);
        if (matcher.find()) {
            int suffixPos = matcher.start();
            String suffix = input.substring(suffixPos);
            String number = input.substring(0, suffixPos);
            result = MyString.trimFloat(number) + suffix;
        } else if (input.contains(".")) {
            int end;
            char[] chars = input.toCharArray();
            for (end = input.length(); end >= 1 && chars[end - 1] == '0'; --end) {
            }
            if (end >= 1 && chars[end - 1] == '.') {
                --end;
            }
            result = input.substring(0, end);
        } else {
            result = input;
        }
        if ("-0".equals(result)) {
            result = "0";
        }
        return result;
    }

    public static String unEscape(CharSequence escaped) {
        int length = escaped.length();
        StringBuilder result = new StringBuilder(length);
        boolean inEscape = false;
        for (int i = 0; i < length; ++i) {
            char ch = escaped.charAt(i);
            if (inEscape) {
                if (ch == '\\' || ch == '\"') {
                    result.append(ch);
                } else if (ch == 'n') {
                    result.append('\n');
                } else {
                    assert (ch == 't');
                    result.append('\t');
                }
                inEscape = false;
                continue;
            }
            if (ch == '\\') {
                inEscape = true;
                continue;
            }
            assert (ch != '\t');
            assert (ch != '\n');
            result.append(ch);
        }
        assert (!inEscape);
        return result.toString();
    }
}

