/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;

public class MyVolume {
    public static final Logger logger = Logger.getLogger(MyVolume.class.getName());

    private MyVolume() {
    }

    public static float boxVolume(Vector3f halfExtents) {
        Validate.nonNegative(halfExtents, "half extents");
        float volume = 8.0f * halfExtents.x * halfExtents.y * halfExtents.z;
        return volume;
    }

    public static float capsuleVolume(float radius, float height) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        float halfHeight = 0.5f * height;
        Vector3f cylinderHalfExtents = new Vector3f(halfHeight, radius, radius);
        float cylinderVolume = MyVolume.cylinderVolume(cylinderHalfExtents);
        float volume = cylinderVolume + MyVolume.sphereVolume(radius);
        return volume;
    }

    public static float coneVolume(float radius, float height) {
        Validate.nonNegative(radius, "radius");
        Validate.nonNegative(height, "height");
        float volume = 1.0471976f * radius * radius * height;
        return volume;
    }

    public static float cylinderVolume(Vector3f halfExtents) {
        Validate.nonNegative(halfExtents, "half extents");
        float volume = (float)Math.PI * 2 * halfExtents.x * halfExtents.y * halfExtents.z;
        return volume;
    }

    public static float sphereVolume(float radius) {
        Validate.nonNegative(radius, "radius");
        float volume = 4.1887903f * MyMath.cube(radius);
        return volume;
    }

    public static double tetrahedronVolume(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4) {
        Validate.finite(v1, "first vertex");
        Validate.finite(v2, "2nd vertex");
        Validate.finite(v3, "3rd vertex");
        Validate.finite(v4, "4th vertex");
        Triangle baseTriangle = new Triangle(v1, v2, v3);
        Vector3f offset = v4.subtract(v1);
        Vector3f normal = baseTriangle.getNormal();
        double altitude = MyVector3f.dot(offset, normal);
        altitude = Math.abs(altitude);
        double baseArea = MyMath.area(baseTriangle);
        assert (baseArea >= 0.0) : baseArea;
        double volume = baseArea * altitude / 3.0;
        return volume;
    }
}

