/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.VectorSet;

public class VectorSetUsingBuffer
implements VectorSet {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(VectorSetUsingBuffer.class.getName());
    private final boolean useDirectBuffers;
    private FloatBuffer buffer;
    private int[] endPosition;
    private static int numEnlargements = 0;
    private static int numReads = 0;
    private static int numSearches = 0;
    private int[] startPositionPlus1;
    private static long resetMillis = 0L;

    public VectorSetUsingBuffer(int numVectors, boolean direct) {
        Validate.positive(numVectors, "number of vectors");
        this.useDirectBuffers = direct;
        this.allocate(numVectors);
        this.flip();
    }

    public static void clearStats() {
        numEnlargements = 0;
        numReads = 0;
        numSearches = 0;
        resetMillis = System.currentTimeMillis();
    }

    public static void dumpStats(String tag) {
        long msec = System.currentTimeMillis() - resetMillis;
        String msg = String.format("%s %d enlargement%s, %d search%s, and %d read%s in %d msec", tag, numEnlargements, numEnlargements == 1 ? "" : "s", numSearches, numSearches == 1 ? "" : "es", numReads, numReads == 1 ? "" : "s", msec);
        System.out.println(msg);
    }

    @Override
    public void add(float x, float y, float z) {
        if (this.startPositionPlus1 == null) {
            throw new IllegalStateException("toBuffer() has been invoked.");
        }
        int hashCode = VectorSetUsingBuffer.hash(x, y, z);
        if (!this.contains(x, y, z, hashCode)) {
            this.unflip();
            if (this.buffer.remaining() < 3) {
                this.enlarge();
                assert (this.buffer.remaining() >= 3);
            }
            this.add(x, y, z, hashCode);
            this.flip();
        }
    }

    @Override
    public void add(Vector3f vector) {
        if (this.startPositionPlus1 == null) {
            throw new IllegalStateException("toBuffer() has been invoked.");
        }
        this.add(vector.x, vector.y, vector.z);
    }

    @Override
    public void addAll(Iterable<? extends Vector3f> vectors) {
        for (Vector3f vector3f : vectors) {
            this.add(vector3f.x, vector3f.y, vector3f.z);
        }
    }

    @Override
    public void clear() {
        int numFloats = this.buffer.capacity();
        if (this.startPositionPlus1 == null) {
            int numVectors = (numFloats - 1) / 3;
            this.allocate(numVectors);
            assert (this.endPosition.length == numFloats);
        } else {
            for (int floatIndex = 0; floatIndex < numFloats; ++floatIndex) {
                this.startPositionPlus1[floatIndex] = 0;
            }
        }
        this.buffer.rewind();
        this.buffer.limit(0);
        assert (this.isFlipped());
    }

    @Override
    public boolean contains(float x, float y, float z) {
        int hashCode = VectorSetUsingBuffer.hash(x, y, z);
        boolean result = this.contains(x, y, z, hashCode);
        return result;
    }

    @Override
    public boolean contains(Vector3f vector) {
        boolean result = this.contains(vector.x, vector.y, vector.z);
        return result;
    }

    @Override
    public Matrix3f covariance(Matrix3f storeResult) {
        Matrix3f result = MyBuffer.covariance(this.buffer, 0, this.buffer.limit(), storeResult);
        return result;
    }

    @Override
    public Vector3f maxAbs(Vector3f storeResult) {
        Vector3f result = MyBuffer.maxAbs(this.buffer, 0, this.buffer.limit(), storeResult);
        return result;
    }

    @Override
    public float maxLength() {
        float length = MyBuffer.maxLength(this.buffer, 0, this.buffer.limit());
        return length;
    }

    @Override
    public void maxMin(Vector3f storeMaxima, Vector3f storeMinima) {
        Validate.nonNull(storeMaxima, "store maxima");
        Validate.nonNull(storeMinima, "store minima");
        MyBuffer.maxMin(this.buffer, 0, this.buffer.limit(), storeMaxima, storeMinima);
    }

    @Override
    public Vector3f mean(Vector3f storeResult) {
        Vector3f result = MyBuffer.mean(this.buffer, 0, this.buffer.limit(), storeResult);
        return result;
    }

    @Override
    public int numVectors() {
        int numFloats;
        int limit = this.buffer.limit();
        int n = numFloats = limit < this.buffer.capacity() ? limit : this.buffer.position();
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        assert (numVectors >= 0) : numVectors;
        return numVectors;
    }

    @Override
    public FloatBuffer toBuffer() {
        this.startPositionPlus1 = null;
        this.endPosition = null;
        return this.buffer;
    }

    @Override
    public float[] toFloatArray() {
        int numFloats = 3 * this.numVectors();
        float[] result = new float[numFloats];
        for (int floatIndex = 0; floatIndex < numFloats; ++floatIndex) {
            result[floatIndex] = this.buffer.get(floatIndex);
        }
        return result;
    }

    @Override
    public Vector3f[] toVectorArray() {
        int numVectors = this.numVectors();
        Vector3f[] result = new Vector3f[numVectors];
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int startPosition = 3 * vectorIndex;
            result[vectorIndex] = new Vector3f();
            MyBuffer.get(this.buffer, startPosition, result[vectorIndex]);
        }
        return result;
    }

    private void add(float x, float y, float z, int hashCode) {
        assert (this.buffer.limit() == this.buffer.capacity());
        int position = this.buffer.position();
        int hashIndex = MyMath.modulo(hashCode, this.startPositionPlus1.length);
        int spp1 = this.startPositionPlus1[hashIndex];
        if (spp1 == 0) {
            this.startPositionPlus1[hashIndex] = position + 1;
        }
        this.endPosition[hashIndex] = position;
        this.buffer.put(x);
        this.buffer.put(y);
        this.buffer.put(z);
    }

    private void allocate(int numVectors) {
        assert (numVectors > 0) : numVectors;
        int numFloats = 3 * numVectors + 1;
        this.buffer = this.useDirectBuffers ? BufferUtils.createFloatBuffer((int)numFloats) : FloatBuffer.wrap(new float[numFloats]);
        this.startPositionPlus1 = new int[numFloats];
        this.endPosition = new int[numFloats];
    }

    private boolean contains(float x, float y, float z, int hashCode) {
        boolean result = false;
        int hashIndex = MyMath.modulo(hashCode, this.startPositionPlus1.length);
        int spp1 = this.startPositionPlus1[hashIndex];
        if (spp1 != 0) {
            int end = this.endPosition[hashIndex];
            this.buffer.position(spp1 - 1);
            while (this.buffer.position() <= end) {
                float bx = this.buffer.get();
                float by = this.buffer.get();
                float bz = this.buffer.get();
                if (Float.compare(bx, x) != 0 || Float.compare(by, y) != 0 || Float.compare(bz, z) != 0) continue;
                result = true;
                break;
            }
            ++numSearches;
            numReads += (end - spp1 + 1) / 3;
        }
        return result;
    }

    private void enlarge() {
        int numVectors = this.numVectors();
        FloatBuffer oldBuffer = this.toBuffer();
        this.allocate(4 * numVectors);
        oldBuffer.flip();
        while (oldBuffer.hasRemaining()) {
            float x = oldBuffer.get();
            float y = oldBuffer.get();
            float z = oldBuffer.get();
            int hashCode = VectorSetUsingBuffer.hash(x, y, z);
            this.add(x, y, z, hashCode);
        }
        assert (this.numVectors() == numVectors);
        ++numEnlargements;
    }

    private void flip() {
        assert (!this.isFlipped());
        this.buffer.limit(this.buffer.position());
        assert (this.isFlipped());
    }

    private static int hash(float x, float y, float z) {
        int hashCode = 37;
        hashCode += 37 * hashCode + Float.floatToIntBits(x);
        hashCode += 37 * hashCode + Float.floatToIntBits(y);
        hashCode += 37 * hashCode + Float.floatToIntBits(z);
        return hashCode;
    }

    private boolean isFlipped() {
        boolean result = this.buffer.limit() != this.buffer.capacity();
        return result;
    }

    private void unflip() {
        assert (this.isFlipped());
        this.buffer.position(this.buffer.limit());
        this.buffer.limit(this.buffer.capacity());
        assert (!this.isFlipped());
    }
}

