/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Icosahedron
extends Mesh {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(Icosahedron.class.getName());

    protected Icosahedron() {
    }

    public Icosahedron(float radius, boolean generateNormals) {
        Validate.positive(radius, "radius");
        float denom = MyMath.hypotenuse(1.0f, MyMath.phi) / radius;
        float a = 1.0f / denom;
        float b = MyMath.phi / denom;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((float[])new float[]{-a, b, 0.0f, -b, 0.0f, a, 0.0f, a, b, -a, b, 0.0f, 0.0f, a, b, a, b, 0.0f, -a, b, 0.0f, a, b, 0.0f, 0.0f, a, -b, -a, b, 0.0f, 0.0f, a, -b, -b, 0.0f, -a, -a, b, 0.0f, -b, 0.0f, -a, -b, 0.0f, a, a, b, 0.0f, 0.0f, a, b, b, 0.0f, a, 0.0f, a, b, -b, 0.0f, a, 0.0f, -a, b, -b, 0.0f, a, -b, 0.0f, -a, -a, -b, 0.0f, -b, 0.0f, -a, 0.0f, a, -b, 0.0f, -a, -b, 0.0f, a, -b, a, b, 0.0f, b, 0.0f, -a, a, -b, 0.0f, b, 0.0f, a, 0.0f, -a, b, a, -b, 0.0f, 0.0f, -a, b, -a, -b, 0.0f, a, -b, 0.0f, -a, -b, 0.0f, 0.0f, -a, -b, a, -b, 0.0f, 0.0f, -a, -b, b, 0.0f, -a, a, -b, 0.0f, b, 0.0f, -a, b, 0.0f, a, 0.0f, -a, b, b, 0.0f, a, 0.0f, a, b, -a, -b, 0.0f, 0.0f, -a, b, -b, 0.0f, a, 0.0f, -a, -b, -a, -b, 0.0f, -b, 0.0f, -a, b, 0.0f, -a, 0.0f, -a, -b, 0.0f, a, -b, b, 0.0f, a, b, 0.0f, -a, a, b, 0.0f});
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        positionBuffer.clear();
        if (generateNormals) {
            MyMesh.generateNormals(this);
        }
        this.updateBound();
        this.setStatic();
    }
}

