/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;

public class Octahedron
extends Mesh {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(Octahedron.class.getName());

    protected Octahedron() {
    }

    public Octahedron(float radius, boolean generateNormals) {
        Validate.positive(radius, "radius");
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((float[])new float[]{-radius, 0.0f, 0.0f, 0.0f, 0.0f, radius, 0.0f, radius, 0.0f, radius, 0.0f, 0.0f, 0.0f, radius, 0.0f, 0.0f, 0.0f, radius, 0.0f, 0.0f, -radius, 0.0f, radius, 0.0f, radius, 0.0f, 0.0f, -radius, 0.0f, 0.0f, 0.0f, radius, 0.0f, 0.0f, 0.0f, -radius, 0.0f, -radius, 0.0f, 0.0f, 0.0f, -radius, radius, 0.0f, 0.0f, 0.0f, -radius, 0.0f, radius, 0.0f, 0.0f, 0.0f, 0.0f, radius, -radius, 0.0f, 0.0f, 0.0f, -radius, 0.0f, 0.0f, 0.0f, radius, -radius, 0.0f, 0.0f, 0.0f, 0.0f, -radius, 0.0f, -radius, 0.0f});
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        positionBuffer.clear();
        if (generateNormals) {
            MyMesh.generateNormals(this);
        }
        this.updateBound();
        this.setStatic();
    }
}

