/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class Octasphere
extends Mesh {
    private static final int numAxes = 3;
    private static final int[] octaIndices = new int[]{6, 2, 8, 1, 4, 3, 0, 3, 9, 1, 5, 2, 6, 7, 2, 1, 3, 5, 0, 10, 3, 1, 2, 4};
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(Octasphere.class.getName());
    private static final Vector3f[] octaLocations = new Vector3f[]{new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
    private final float radius;
    private int nextVertexIndex = 0;
    private final List<Float> uOverrides = new ArrayList<Float>(305);
    private final List<Vector3f> locations = new ArrayList<Vector3f>(305);
    private final Map<Long, Integer> midpointCache = new HashMap<Long, Integer>(294);

    protected Octasphere() {
        this.radius = 1.0f;
    }

    public Octasphere(int numRefineSteps, float radius) {
        Validate.inRange(numRefineSteps, "number of refinement steps", 0, 13);
        Validate.positive(radius, "radius");
        this.radius = radius;
        this.addVertex(octaLocations[0], Float.valueOf(0.0f));
        this.addVertex(octaLocations[1], Float.valueOf(0.5f));
        this.addVertex(octaLocations[2], null);
        this.addVertex(octaLocations[3], null);
        this.addVertex(octaLocations[4], Float.valueOf(0.5f));
        this.addVertex(octaLocations[5], Float.valueOf(0.5f));
        this.addVertex(octaLocations[0], Float.valueOf(1.0f));
        this.addVertex(octaLocations[4], Float.valueOf(1.0f));
        this.addVertex(octaLocations[5], Float.valueOf(1.0f));
        this.addVertex(octaLocations[4], Float.valueOf(0.0f));
        this.addVertex(octaLocations[5], Float.valueOf(0.0f));
        ArrayList<Integer> faces = new ArrayList<Integer>(24);
        for (int octaIndex : octaIndices) {
            faces.add(octaIndex);
        }
        for (int stepIndex = 0; stepIndex < numRefineSteps; ++stepIndex) {
            ArrayList<Integer> newFaces = new ArrayList<Integer>(4 * faces.size());
            for (int j = 0; j < faces.size(); j += 3) {
                int v1 = (Integer)faces.get(j);
                int v2 = (Integer)faces.get(j + 1);
                int v3 = (Integer)faces.get(j + 2);
                int a = this.midpointIndex(v1, v2);
                int b = this.midpointIndex(v2, v3);
                int c = this.midpointIndex(v3, v1);
                newFaces.add(v1);
                newFaces.add(a);
                newFaces.add(c);
                newFaces.add(v2);
                newFaces.add(b);
                newFaces.add(a);
                newFaces.add(v3);
                newFaces.add(c);
                newFaces.add(b);
                newFaces.add(a);
                newFaces.add(b);
                newFaces.add(c);
            }
            faces = newFaces;
        }
        this.midpointCache.clear();
        assert (faces.size() == 3 << 3 + 2 * numRefineSteps);
        int numVertices = this.locations.size();
        int numFloats = 3 * numVertices;
        FloatBuffer posBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        for (Vector3f pos : this.locations) {
            posBuffer.put(pos.x).put(pos.y).put(pos.z);
        }
        posBuffer.flip();
        this.setBuffer(VertexBuffer.Type.Position, 3, posBuffer);
        int numIndices = faces.size();
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        Iterator v3 = faces.iterator();
        while (v3.hasNext()) {
            int vertexIndex = (Integer)v3.next();
            ib.put(vertexIndex);
        }
        VertexBuffer.Format ibFormat = ib.getFormat();
        Buffer ibData = ib.getBuffer();
        ibData.flip();
        this.setBuffer(VertexBuffer.Type.Index, 3, ibFormat, ibData);
        FloatBuffer uvBuffer = BufferUtils.createFloatBuffer((int)(2 * numVertices));
        for (int i = 0; i < numVertices; ++i) {
            float u;
            Vector3f pos = this.locations.get(i);
            Vector2f longLat = Octasphere.cartesianToSpherical(pos);
            if (pos.y == 0.0f) {
                u = this.uOverrides.get(i).floatValue();
            } else {
                assert (this.uOverrides.get(i) == null);
                u = 0.5f + longLat.x / ((float)Math.PI * 2);
            }
            float v = 0.5f + longLat.y / (float)Math.PI;
            uvBuffer.put(u).put(v);
        }
        uvBuffer.flip();
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, uvBuffer);
        this.locations.clear();
        this.uOverrides.clear();
        MyMesh.addSphereNormals(this);
        this.updateBound();
        this.setStatic();
    }

    private int addVertex(Vector3f location, Float uOverride) {
        float length = location.length();
        this.locations.add(location.mult(this.radius / length));
        this.uOverrides.add(uOverride);
        assert (this.locations.size() == this.uOverrides.size());
        int result = this.nextVertexIndex++;
        return result;
    }

    private static Vector2f cartesianToSpherical(Vector3f input) {
        Vector2f result = new Vector2f();
        float length = input.length();
        result.x = input.x != 0.0f || input.y != 0.0f ? -FastMath.atan2((float)input.y, (float)input.x) : 0.0f;
        result.y = length > 0.0f ? FastMath.asin((float)(input.z / length)) : 0.0f;
        return result;
    }

    private int midpointIndex(int p1, int p2) {
        long greaterIndex;
        boolean firstIsSmaller = p1 < p2;
        long smallerIndex = firstIsSmaller ? (long)p1 : (long)p2;
        long key = (smallerIndex << 32) + (greaterIndex = firstIsSmaller ? (long)p2 : (long)p1);
        Integer cachedIndex = this.midpointCache.get(key);
        if (cachedIndex != null) {
            return cachedIndex;
        }
        Vector3f loc1 = this.locations.get(p1);
        Vector3f loc2 = this.locations.get(p2);
        Vector3f middleLocation = MyVector3f.midpoint(loc1, loc2, null);
        Float middleUOverride = null;
        if (middleLocation.y == 0.0f) {
            middleUOverride = this.uOverrides.get(p1);
            assert (this.uOverrides.get(p2).equals(middleUOverride));
        } else assert (this.uOverrides.get(p1) == null || this.uOverrides.get(p2) == null);
        int newIndex = this.addVertex(middleLocation, middleUOverride);
        this.midpointCache.put(key, newIndex);
        return newIndex;
    }
}

