/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.scene.VertexBuffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Element {
    private static final Logger logger = Logger.getLogger(Element.class.getName());

    private Element() {
    }

    public static void copy(VertexBuffer source, int sourceIndex, VertexBuffer target, int targetIndex) {
        int sourceCount = source.getNumElements();
        Validate.inRange(sourceIndex, "source index", 0, sourceCount - 1);
        int targetCount = target.getNumElements();
        Validate.inRange(targetIndex, "target index", 0, targetCount - 1);
        Validate.require(source.getBufferType() == target.getBufferType(), "same buffer type");
        Validate.require(source.getFormat() == target.getFormat(), "same format");
        Validate.require(source.getNumComponents() == target.getNumComponents(), "same number of components");
        int numComponents = target.getNumComponents();
        VertexBuffer.Format format = target.getFormat();
        if (format == VertexBuffer.Format.Half) {
            numComponents *= 2;
        }
        int sourceStart = numComponents * sourceIndex;
        int targetStart = numComponents * targetIndex;
        switch (format) {
            case Byte: 
            case Half: 
            case UnsignedByte: {
                ByteBuffer sbBuf = (ByteBuffer)source.getData();
                ByteBuffer tbBuf = (ByteBuffer)target.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    byte b = sbBuf.get(sourceStart + cIndex);
                    tbBuf.put(targetStart + cIndex, b);
                }
                break;
            }
            case Double: {
                DoubleBuffer sdBuf = (DoubleBuffer)source.getData();
                DoubleBuffer tdBuf = (DoubleBuffer)target.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    double d = sdBuf.get(sourceStart + cIndex);
                    tdBuf.put(targetStart + cIndex, d);
                }
                break;
            }
            case Float: {
                FloatBuffer sfBuf = (FloatBuffer)source.getData();
                FloatBuffer tfBuf = (FloatBuffer)target.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    float f = sfBuf.get(sourceStart + cIndex);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Int: 
            case UnsignedInt: {
                IntBuffer siBuf = (IntBuffer)source.getData();
                IntBuffer tiBuf = (IntBuffer)target.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    int i = siBuf.get(sourceStart + cIndex);
                    tiBuf.put(targetStart + cIndex, i);
                }
                break;
            }
            case Short: 
            case UnsignedShort: {
                ShortBuffer ssBuf = (ShortBuffer)source.getData();
                ShortBuffer tsBuf = (ShortBuffer)target.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    short s = ssBuf.get(sourceStart + cIndex);
                    tsBuf.put(targetStart + cIndex, s);
                }
                break;
            }
            default: {
                String message = "Unrecognized buffer format: " + format;
                throw new UnsupportedOperationException(message);
            }
        }
    }

    public static boolean equals(VertexBuffer vertexBuffer, int index1, int index2) {
        int numElements = vertexBuffer.getNumElements();
        Validate.inRange(index1, "index1", 0, numElements - 1);
        Validate.inRange(index2, "index2", 0, numElements - 1);
        if (index1 == index2) {
            return true;
        }
        int numCperE = vertexBuffer.getNumComponents();
        VertexBuffer.Format format = vertexBuffer.getFormat();
        if (format == VertexBuffer.Format.Half) {
            numCperE *= 2;
        }
        int startPos1 = numCperE * index1;
        int startPos2 = numCperE * index2;
        switch (format) {
            case Byte: 
            case Half: 
            case UnsignedByte: {
                ByteBuffer byteBuf = (ByteBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numCperE; ++cIndex) {
                    byte b2;
                    byte b1 = byteBuf.get(startPos1 + cIndex);
                    if (b1 == (b2 = byteBuf.get(startPos2 + cIndex))) continue;
                    return false;
                }
                break;
            }
            case Double: {
                DoubleBuffer doubleBuffer = (DoubleBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numCperE; ++cIndex) {
                    double d2;
                    double d1 = doubleBuffer.get(startPos1 + cIndex);
                    if (d1 == (d2 = doubleBuffer.get(startPos2 + cIndex))) continue;
                    return false;
                }
                break;
            }
            case Float: {
                FloatBuffer floatBuf = (FloatBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numCperE; ++cIndex) {
                    float f2;
                    float f1 = floatBuf.get(startPos1 + cIndex);
                    if (f1 == (f2 = floatBuf.get(startPos2 + cIndex))) continue;
                    return false;
                }
                break;
            }
            case Int: 
            case UnsignedInt: {
                IntBuffer intBuf = (IntBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numCperE; ++cIndex) {
                    int i2;
                    int i1 = intBuf.get(startPos1 + cIndex);
                    if (i1 == (i2 = intBuf.get(startPos2 + cIndex))) continue;
                    return false;
                }
                break;
            }
            case Short: 
            case UnsignedShort: {
                ShortBuffer shortBuf = (ShortBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numCperE; ++cIndex) {
                    short s2;
                    short s1 = shortBuf.get(startPos1 + cIndex);
                    if (s1 == (s2 = shortBuf.get(startPos2 + cIndex))) continue;
                    return false;
                }
                break;
            }
            default: {
                String message = "Unrecognized buffer format: " + format;
                throw new UnsupportedOperationException(message);
            }
        }
        return true;
    }

    public static void lerp(float t, VertexBuffer source, int sourceIndex0, int sourceIndex1, VertexBuffer target, int targetIndex) {
        int sourceCount = source.getNumElements();
        Validate.inRange(sourceIndex0, "source index(t=0)", 0, sourceCount - 1);
        Validate.inRange(sourceIndex1, "source index(t=1)", 0, sourceCount - 1);
        int targetCount = target.getNumElements();
        Validate.inRange(targetIndex, "target index", 0, targetCount - 1);
        Validate.require(source.getBufferType() == target.getBufferType(), "same buffer type");
        Validate.require(source.getNumComponents() == target.getNumComponents(), "same number of components");
        Validate.require(target.getFormat() == VertexBuffer.Format.Float, "Float format");
        int numComponents = target.getNumComponents();
        VertexBuffer.Format format = target.getFormat();
        if (format == VertexBuffer.Format.Half) {
            numComponents *= 2;
        }
        int sourceStart0 = numComponents * sourceIndex0;
        int sourceStart1 = numComponents * sourceIndex1;
        int targetStart = numComponents * targetIndex;
        FloatBuffer tfBuf = (FloatBuffer)target.getData();
        switch (format) {
            case Byte: {
                ByteBuffer sbBuf = (ByteBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    byte b0 = sbBuf.get(sourceStart0 + cIndex);
                    byte b1 = sbBuf.get(sourceStart1 + cIndex);
                    float f = MyMath.lerp(t, b0, b1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case UnsignedByte: {
                ByteBuffer sbBuf = (ByteBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    byte b0 = sbBuf.get(sourceStart0 + cIndex);
                    byte b1 = sbBuf.get(sourceStart1 + cIndex);
                    int i0 = 0xFF & b0;
                    int i1 = 0xFF & b1;
                    float f = MyMath.lerp(t, i0, i1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Double: {
                DoubleBuffer sdBuf = (DoubleBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    double d0 = sdBuf.get(sourceStart0 + cIndex);
                    double d1 = sdBuf.get(sourceStart1 + cIndex);
                    float f = MyMath.lerp(t, (float)d0, (float)d1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Float: {
                FloatBuffer sfBuf = (FloatBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    float f0 = sfBuf.get(sourceStart0 + cIndex);
                    float f1 = sfBuf.get(sourceStart1 + cIndex);
                    float f = MyMath.lerp(t, f0, f1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Int: {
                IntBuffer siBuf = (IntBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    int i0 = siBuf.get(sourceStart0 + cIndex);
                    int i1 = siBuf.get(sourceStart1 + cIndex);
                    float f = MyMath.lerp(t, i0, i1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case UnsignedInt: {
                IntBuffer siBuf = (IntBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    int i0 = siBuf.get(sourceStart0 + cIndex);
                    int i1 = siBuf.get(sourceStart1 + cIndex);
                    long l0 = 0xFFFFFFFFL & (long)i0;
                    long l1 = 0xFFFFFFFFL & (long)i1;
                    float f = MyMath.lerp(t, l0, l1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Short: {
                ShortBuffer ssBuf = (ShortBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    short s0 = ssBuf.get(sourceStart0 + cIndex);
                    short s1 = ssBuf.get(sourceStart1 + cIndex);
                    float f = MyMath.lerp(t, s0, s1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case UnsignedShort: {
                ShortBuffer ssBuf = (ShortBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    short s0 = ssBuf.get(sourceStart0 + cIndex);
                    short s1 = ssBuf.get(sourceStart1 + cIndex);
                    int i0 = 0xFFFF & s0;
                    int i1 = 0xFFFF & s1;
                    float f = MyMath.lerp(t, i0, i1);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            default: {
                String message = "Unrecognized buffer format: " + format;
                throw new UnsupportedOperationException(message);
            }
        }
    }

    public static void lerp3(float t1, float t2, VertexBuffer source, int sourceIndex0, int sourceIndex1, int sourceIndex2, VertexBuffer target, int targetIndex) {
        int sourceCount = source.getNumElements();
        Validate.inRange(sourceIndex0, "source index(0,0)", 0, sourceCount - 1);
        Validate.inRange(sourceIndex1, "source index(1,0)", 0, sourceCount - 1);
        Validate.inRange(sourceIndex2, "source index(0,1)", 0, sourceCount - 1);
        int targetCount = target.getNumElements();
        Validate.inRange(targetIndex, "target index", 0, targetCount - 1);
        Validate.require(source.getBufferType() == target.getBufferType(), "same buffer type");
        Validate.require(source.getNumComponents() == target.getNumComponents(), "same number of components");
        Validate.require(target.getFormat() == VertexBuffer.Format.Float, "Float format");
        int numComponents = target.getNumComponents();
        VertexBuffer.Format format = target.getFormat();
        if (format == VertexBuffer.Format.Half) {
            numComponents *= 2;
        }
        int sourceStart0 = numComponents * sourceIndex0;
        int sourceStart1 = numComponents * sourceIndex1;
        int sourceStart2 = numComponents * sourceIndex2;
        int targetStart = numComponents * targetIndex;
        FloatBuffer tfBuf = (FloatBuffer)target.getData();
        switch (format) {
            case Byte: {
                ByteBuffer sbBuf = (ByteBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    byte b0 = sbBuf.get(sourceStart0 + cIndex);
                    byte b1 = sbBuf.get(sourceStart1 + cIndex);
                    byte b2 = sbBuf.get(sourceStart2 + cIndex);
                    float f = MyMath.lerp3(t1, t2, b0, b1, b2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case UnsignedByte: {
                ByteBuffer sbBuf = (ByteBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    byte b0 = sbBuf.get(sourceStart0 + cIndex);
                    byte b1 = sbBuf.get(sourceStart1 + cIndex);
                    byte b2 = sbBuf.get(sourceStart2 + cIndex);
                    int i0 = 0xFF & b0;
                    int i1 = 0xFF & b1;
                    int i2 = 0xFF & b2;
                    float f = MyMath.lerp3(t1, t2, i0, i1, i2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Double: {
                DoubleBuffer sdBuf = (DoubleBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    double d0 = sdBuf.get(sourceStart0 + cIndex);
                    double d1 = sdBuf.get(sourceStart1 + cIndex);
                    double d2 = sdBuf.get(sourceStart2 + cIndex);
                    float f = MyMath.lerp3(t1, t2, (float)d0, (float)d1, (float)d2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Float: {
                FloatBuffer sfBuf = (FloatBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    float f0 = sfBuf.get(sourceStart0 + cIndex);
                    float f1 = sfBuf.get(sourceStart1 + cIndex);
                    float f2 = sfBuf.get(sourceStart2 + cIndex);
                    float f = MyMath.lerp3(t1, t2, f0, f1, f2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Int: {
                IntBuffer siBuf = (IntBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    int i0 = siBuf.get(sourceStart0 + cIndex);
                    int i1 = siBuf.get(sourceStart1 + cIndex);
                    int i2 = siBuf.get(sourceStart2 + cIndex);
                    float f = MyMath.lerp3(t1, t2, i0, i1, i2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case UnsignedInt: {
                IntBuffer siBuf = (IntBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    int i0 = siBuf.get(sourceStart0 + cIndex);
                    int i1 = siBuf.get(sourceStart1 + cIndex);
                    int i2 = siBuf.get(sourceStart2 + cIndex);
                    long l0 = 0xFFFFFFFFL & (long)i0;
                    long l1 = 0xFFFFFFFFL & (long)i1;
                    long l2 = 0xFFFFFFFFL & (long)i2;
                    float f = MyMath.lerp3(t1, t2, l0, l1, l2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case Short: {
                ShortBuffer ssBuf = (ShortBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    short s0 = ssBuf.get(sourceStart0 + cIndex);
                    short s1 = ssBuf.get(sourceStart1 + cIndex);
                    short s2 = ssBuf.get(sourceStart2 + cIndex);
                    float f = MyMath.lerp3(t1, t2, s0, s1, s2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            case UnsignedShort: {
                ShortBuffer ssBuf = (ShortBuffer)source.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    short s0 = ssBuf.get(sourceStart0 + cIndex);
                    short s1 = ssBuf.get(sourceStart1 + cIndex);
                    short s2 = ssBuf.get(sourceStart2 + cIndex);
                    int i0 = 0xFFFF & s0;
                    int i1 = 0xFFFF & s1;
                    int i2 = 0xFFFF & s2;
                    float f = MyMath.lerp3(t1, t2, i0, i1, i2);
                    tfBuf.put(targetStart + cIndex, f);
                }
                break;
            }
            default: {
                String message = "Unrecognized buffer format: " + format;
                throw new UnsupportedOperationException(message);
            }
        }
    }

    public static void swap(VertexBuffer vertexBuffer, int index1, int index2) {
        int numElements = vertexBuffer.getNumElements();
        Validate.inRange(index1, "index1", 0, numElements - 1);
        Validate.inRange(index2, "index2", 0, numElements - 1);
        if (index1 == index2) {
            return;
        }
        int numComponents = vertexBuffer.getNumComponents();
        VertexBuffer.Format format = vertexBuffer.getFormat();
        if (format == VertexBuffer.Format.Half) {
            numComponents *= 2;
        }
        int startPos1 = numComponents * index1;
        int startPos2 = numComponents * index2;
        switch (format) {
            case Byte: 
            case Half: 
            case UnsignedByte: {
                ByteBuffer byteBuf = (ByteBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    byte b1 = byteBuf.get(startPos1 + cIndex);
                    byte b2 = byteBuf.get(startPos2 + cIndex);
                    byteBuf.put(startPos1 + cIndex, b2);
                    byteBuf.put(startPos2 + cIndex, b1);
                }
                break;
            }
            case Short: 
            case UnsignedShort: {
                ShortBuffer shortBuf = (ShortBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    short s1 = shortBuf.get(startPos1 + cIndex);
                    short s2 = shortBuf.get(startPos2 + cIndex);
                    shortBuf.put(startPos1 + cIndex, s2);
                    shortBuf.put(startPos2 + cIndex, s1);
                }
                break;
            }
            case Int: 
            case UnsignedInt: {
                IntBuffer intBuf = (IntBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    int i1 = intBuf.get(startPos1 + cIndex);
                    int i2 = intBuf.get(startPos2 + cIndex);
                    intBuf.put(startPos1 + cIndex, i2);
                    intBuf.put(startPos2 + cIndex, i1);
                }
                break;
            }
            case Double: {
                DoubleBuffer doubleBuffer = (DoubleBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    double d1 = doubleBuffer.get(startPos1 + cIndex);
                    double d2 = doubleBuffer.get(startPos2 + cIndex);
                    doubleBuffer.put(startPos1 + cIndex, d2);
                    doubleBuffer.put(startPos2 + cIndex, d1);
                }
                break;
            }
            case Float: {
                FloatBuffer floatBuf = (FloatBuffer)vertexBuffer.getData();
                for (int cIndex = 0; cIndex < numComponents; ++cIndex) {
                    float f1 = floatBuf.get(startPos1 + cIndex);
                    float f2 = floatBuf.get(startPos2 + cIndex);
                    floatBuf.put(startPos1 + cIndex, f2);
                    floatBuf.put(startPos2 + cIndex, f1);
                }
                break;
            }
            default: {
                String message = "Unrecognized buffer format: " + format;
                throw new UnsupportedOperationException(message);
            }
        }
    }
}

