/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MySpatial;
import jme3utilities.MyString;
import jme3utilities.Validate;

public class MyLight {
    private static final Logger logger = Logger.getLogger(MyLight.class.getName());

    private MyLight() {
    }

    public static void clearLocalLights(Spatial spatial) {
        LightList list = spatial.getLocalLightList();
        int numLights = list.size();
        if (numLights > 0) {
            Light[] tmpArray = new Light[numLights];
            for (int i = 0; i < numLights; ++i) {
                tmpArray[i] = list.get(i);
            }
            for (Light light : tmpArray) {
                spatial.removeLight(light);
            }
        }
        assert (list.size() == 0) : list.size();
    }

    public static <T extends Light> int countLights(Spatial subtree, Class<T> lightType) {
        int result = 0;
        if (subtree != null) {
            LightList lights = subtree.getLocalLightList();
            int numLights = lights.size();
            for (int lightI = 0; lightI < numLights; ++lightI) {
                Light light = lights.get(lightI);
                if (!lightType.isAssignableFrom(light.getClass())) continue;
                ++result;
            }
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                result += MyLight.countLights(child, lightType);
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static String describeType(Light light) {
        String description = light.getClass().getSimpleName();
        if (description.endsWith("Light")) {
            description = MyString.removeSuffix(description, "Light");
        }
        return description;
    }

    public static int findIndex(Light light, Spatial owner) {
        Validate.nonNull(light, "light");
        int result = -1;
        LightList lights = owner.getLocalLightList();
        int numLights = lights.size();
        for (int index = 0; index < numLights; ++index) {
            Light indexedLight = lights.get(index);
            if (indexedLight != light) continue;
            result = index;
        }
        return result;
    }

    public static Light findLight(String lightName, Spatial subtree) {
        Validate.nonNull(lightName, "light name");
        Light light = MySpatial.findLight(subtree, lightName);
        if (light != null) {
            return light;
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                light = MyLight.findLight(lightName, child);
                if (light == null) continue;
                return light;
            }
        }
        return null;
    }

    public static Spatial findOwner(Light light, Spatial subtree) {
        Spatial result;
        block2: {
            Spatial child;
            block1: {
                Validate.nonNull(light, "light");
                Validate.nonNull(subtree, "subtree");
                result = null;
                int lightIndex = MyLight.findIndex(light, subtree);
                if (lightIndex == -1) break block1;
                result = subtree;
                break block2;
            }
            if (!(subtree instanceof Node)) break block2;
            Node node = (Node)subtree;
            List children = node.getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && (result = MyLight.findOwner(light, child = (Spatial)iterator.next())) == null) {
            }
        }
        return result;
    }

    public static <T extends Light> List<T> listLights(Spatial subtree, Class<T> lightType, List<T> storeResult) {
        Validate.nonNull(subtree, "subtree");
        ArrayList<Light> result = storeResult == null ? new ArrayList<Light>(4) : storeResult;
        LightList lights = subtree.getLocalLightList();
        int numLights = lights.size();
        for (int lightIndex = 0; lightIndex < numLights; ++lightIndex) {
            Light light = lights.get(lightIndex);
            if (!lightType.isAssignableFrom(light.getClass()) || result.contains(light)) continue;
            result.add(light);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyLight.listLights(child, lightType, result);
            }
        }
        return result;
    }
}

