/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.CollisionData;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Element;
import jme3utilities.MyAsset;
import jme3utilities.Validate;
import jme3utilities.math.IntPair;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.VectorSet;
import jme3utilities.math.VectorSetUsingBuffer;

public class MyMesh {
    private static final int maxWeights = 4;
    private static final int numAxes = 3;
    public static final int vpe = 2;
    public static final int vpt = 3;
    private static final Logger logger = Logger.getLogger(MyMesh.class.getName());
    private static final Matrix4f matrixIdentity = new Matrix4f();
    private static final Vector3f scaleReverse = new Vector3f(-1.0f, -1.0f, -1.0f);

    private MyMesh() {
    }

    public static Mesh addIndices(Mesh input) {
        Buffer data;
        Validate.nonNull(input, "input mesh");
        Validate.require(!MyMesh.hasIndices(input), "not have an index buffer");
        int oldN = input.getVertexCount();
        int[] old2new = new int[oldN];
        int[] new2old = new int[oldN];
        int newN = 0;
        for (int oldI = 0; oldI < oldN; ++oldI) {
            old2new[oldI] = -1;
            new2old[oldI] = -1;
            for (int newI = 0; newI < newN; ++newI) {
                if (!MyMesh.areIdentical(input, oldI, new2old[newI])) continue;
                old2new[oldI] = newI;
                break;
            }
            if (old2new[oldI] != -1) continue;
            old2new[oldI] = newN;
            new2old[newN] = oldI;
            ++newN;
        }
        Mesh result = input.clone();
        for (VertexBuffer oldVertexBuffer : input.getBufferList()) {
            VertexBuffer.Type type = oldVertexBuffer.getBufferType();
            result.clearBuffer(type);
            VertexBuffer.Format format = oldVertexBuffer.getFormat();
            if (format == null) {
                format = VertexBuffer.Format.Float;
            }
            int numCperE = oldVertexBuffer.getNumComponents();
            numCperE = MyMath.clamp(numCperE, 1, 4);
            data = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numCperE, (int)newN);
            result.setBuffer(type, numCperE, format, data);
        }
        for (int newI = 0; newI < newN; ++newI) {
            int oldI = new2old[newI];
            for (VertexBuffer newVB : result.getBufferList()) {
                VertexBuffer.Type type = newVB.getBufferType();
                VertexBuffer oldVB = input.getBuffer(type);
                assert (oldVB != newVB);
                if (oldVB.getNumElements() <= 0) continue;
                Element.copy(oldVB, oldI, newVB, newI);
            }
        }
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)newN, (int)oldN);
        for (int oldI = 0; oldI < oldN; ++oldI) {
            int newI = old2new[oldI];
            ib.put(oldI, newI);
        }
        VertexBuffer.Format ibFormat = ib.getFormat();
        Buffer ibData = ib.getBuffer();
        result.setBuffer(VertexBuffer.Type.Index, 1, ibFormat, ibData);
        for (VertexBuffer outVB : result.getBufferList()) {
            data = outVB.getData();
            int endPosition = data.capacity();
            data.position(endPosition);
            data.flip();
        }
        result.updateCounts();
        assert (MyMesh.hasIndices(result));
        return result;
    }

    public static void addSphereNormals(Mesh mesh) {
        Validate.nonNull(mesh, "mesh");
        Validate.require(!MyMesh.hasAnyNormals(mesh), "not have normals");
        MyMesh.generateSphereNormals(mesh, VertexBuffer.Type.Normal, VertexBuffer.Type.Position);
        VertexBuffer bpPosition = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        if (bpPosition != null) {
            MyMesh.generateSphereNormals(mesh, VertexBuffer.Type.BindPoseNormal, VertexBuffer.Type.BindPosePosition);
        }
    }

    public static boolean areIdentical(Mesh mesh, int vi1, int vi2) {
        Validate.nonNull(mesh, "mesh");
        int numVertices = mesh.getVertexCount();
        Validate.inRange(vi1, "first vertex index", 0, numVertices - 1);
        Validate.inRange(vi2, "2nd vertex index", 0, numVertices - 1);
        if (vi1 == vi2) {
            return true;
        }
        for (VertexBuffer vertexBuffer : mesh.getBufferList()) {
            VertexBuffer.Type type = vertexBuffer.getBufferType();
            if (type == VertexBuffer.Type.Index || vertexBuffer.getNumElements() <= 0 || Element.equals(vertexBuffer, vi1, vi2)) continue;
            return false;
        }
        return true;
    }

    public static Material boneWeightMaterial(Mesh mesh, ColorRGBA[] boneIndexToColor, AssetManager assetManager) {
        if (!MyMesh.isAnimated(mesh)) {
            throw new IllegalArgumentException("Must be an animated mesh.");
        }
        int numVertices = mesh.getVertexCount();
        FloatBuffer colorBuf = BufferUtils.createFloatBuffer((int)(4 * numVertices));
        int[] biArray = new int[4];
        float[] bwArray = new float[4];
        ColorRGBA sum = new ColorRGBA();
        ColorRGBA term = new ColorRGBA();
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            MyMesh.vertexBoneIndices(mesh, vertexIndex, biArray);
            MyMesh.vertexBoneWeights(mesh, vertexIndex, bwArray);
            sum.set(0.0f, 0.0f, 0.0f, 1.0f);
            for (int j = 0; j < 4; ++j) {
                int boneI = biArray[j];
                if (boneI < 0 || boneI >= boneIndexToColor.length) continue;
                term.set(boneIndexToColor[boneI]);
                float weight = bwArray[j];
                term.multLocal(weight);
                sum.addLocal(term);
            }
            colorBuf.put(sum.r).put(sum.g).put(sum.b).put(1.0f);
        }
        mesh.setBuffer(VertexBuffer.Type.Color, 4, VertexBuffer.Format.Float, (Buffer)colorBuf);
        Material material = MyAsset.createUnshadedMaterial(assetManager);
        material.setBoolean("VertexColor", true);
        RenderState rs = material.getAdditionalRenderState();
        rs.setWireframe(true);
        return material;
    }

    public static void centerBuffer(Mesh mesh, VertexBuffer.Type bufferType) {
        Validate.nonNull(bufferType, "buffer type");
        VertexBuffer vertexBuffer = mesh.getBuffer(bufferType);
        if (vertexBuffer != null) {
            FloatBuffer floatBuffer = (FloatBuffer)vertexBuffer.getData();
            Vector3f max = new Vector3f();
            Vector3f min = new Vector3f();
            int numVertices = mesh.getVertexCount();
            int numFloats = 3 * numVertices;
            MyBuffer.maxMin(floatBuffer, 0, numFloats, max, min);
            Vector3f offset = MyVector3f.midpoint(max, min, null).negateLocal();
            MyBuffer.translate(floatBuffer, 0, numFloats, offset);
            vertexBuffer.setUpdateNeeded();
        }
    }

    public static int countBones(Mesh mesh) {
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        Validate.inRange(maxWeightsPerVert, "mesh max num weights", 1, 4);
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        int result = 0;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyBuffer.readIndex(boneIndexBuffer);
                if (wIndex >= maxWeightsPerVert || weight == 0.0f || boneIndex < result) continue;
                result = boneIndex + 1;
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static Mesh expand(Mesh in) {
        IndexBuffer indexList = in.getIndicesAsList();
        int outVertexCount = indexList.size();
        Mesh.Mode outMode = MyMesh.expandedMode(in);
        Mesh out = in.clone();
        out.setMode(outMode);
        for (VertexBuffer inVertexBuffer : in.getBufferList()) {
            VertexBuffer.Type type = inVertexBuffer.getBufferType();
            out.clearBuffer(type);
            if (type == VertexBuffer.Type.Index) continue;
            VertexBuffer.Format format = inVertexBuffer.getFormat();
            if (format == null) {
                format = VertexBuffer.Format.Float;
            }
            int numCperE = inVertexBuffer.getNumComponents();
            numCperE = MyMath.clamp(numCperE, 1, 4);
            Buffer data = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numCperE, (int)outVertexCount);
            out.setBuffer(type, numCperE, format, data);
        }
        for (int outVI = 0; outVI < outVertexCount; ++outVI) {
            int inVI = indexList.get(outVI);
            for (VertexBuffer outVB : out.getBufferList()) {
                VertexBuffer.Type type = outVB.getBufferType();
                VertexBuffer inVB = in.getBuffer(type);
                assert (inVB != outVB);
                if (inVB.getNumElements() <= 0) continue;
                Element.copy(inVB, inVI, outVB, outVI);
            }
        }
        for (VertexBuffer outVB : out.getBufferList()) {
            Buffer data = outVB.getData();
            int endPosition = data.capacity();
            data.position(endPosition);
            data.flip();
        }
        out.updateCounts();
        assert (out.getMode().isListMode());
        assert (!MyMesh.hasIndices(out));
        return out;
    }

    public static Mesh.Mode expandedMode(Mesh inputMesh) {
        Mesh.Mode result;
        Mesh.Mode mode = inputMesh.getMode();
        switch (mode) {
            case Points: 
            case Lines: 
            case Triangles: {
                result = mode;
                break;
            }
            case LineLoop: 
            case LineStrip: {
                result = Mesh.Mode.Lines;
                break;
            }
            case TriangleFan: 
            case TriangleStrip: {
                result = Mesh.Mode.Triangles;
                break;
            }
            default: {
                throw new IllegalArgumentException("mode = " + mode);
            }
        }
        assert (result.isListMode());
        return result;
    }

    public static void generateFacetNormals(Mesh mesh, VertexBuffer.Type normalBufferType, VertexBuffer.Type positionBufferType) {
        Validate.nonNull(mesh, "mesh");
        Validate.require(mesh.getMode() == Mesh.Mode.Triangles, "be in Triangles mode");
        Validate.require(!MyMesh.hasIndices(mesh), "not have an index buffer");
        FloatBuffer positionBuffer = mesh.getFloatBuffer(positionBufferType);
        int numFloats = positionBuffer.limit();
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        mesh.setBuffer(normalBufferType, 3, normalBuffer);
        Triangle triangle = new Triangle();
        Vector3f pos1 = new Vector3f();
        Vector3f pos2 = new Vector3f();
        Vector3f pos3 = new Vector3f();
        int numTriangles = numFloats / 3 / 3;
        for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
            int trianglePosition = triIndex * 3 * 3;
            MyBuffer.get(positionBuffer, trianglePosition, pos1);
            MyBuffer.get(positionBuffer, trianglePosition + 3, pos2);
            MyBuffer.get(positionBuffer, trianglePosition + 6, pos3);
            triangle.set(pos1, pos2, pos3);
            Vector3f normal = triangle.getNormal();
            for (int j = 0; j < 3; ++j) {
                normalBuffer.put(normal.x);
                normalBuffer.put(normal.y);
                normalBuffer.put(normal.z);
            }
        }
        normalBuffer.flip();
    }

    public static void generateNormals(Mesh mesh) {
        Validate.require(mesh.getMode() == Mesh.Mode.Triangles, "be in Triangles mode");
        Validate.require(!MyMesh.hasIndices(mesh), "not have an index buffer");
        MyMesh.generateFacetNormals(mesh, VertexBuffer.Type.Normal, VertexBuffer.Type.Position);
        VertexBuffer bpPosition = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        if (bpPosition != null) {
            MyMesh.generateFacetNormals(mesh, VertexBuffer.Type.BindPoseNormal, VertexBuffer.Type.BindPosePosition);
        }
    }

    public static void generateSphereNormals(Mesh mesh, VertexBuffer.Type normalBufferType, VertexBuffer.Type positionBufferType) {
        Validate.nonNull(mesh, "mesh");
        FloatBuffer positionBuffer = mesh.getFloatBuffer(positionBufferType);
        int numFloats = positionBuffer.limit();
        FloatBuffer normalBuffer = BufferUtils.clone((FloatBuffer)positionBuffer);
        mesh.setBuffer(normalBufferType, 3, normalBuffer);
        MyBuffer.normalize(normalBuffer, 0, numFloats);
        normalBuffer.limit(numFloats);
    }

    public static CollisionData getCollisionTree(Mesh mesh) {
        CollisionData result;
        Field field;
        try {
            field = Mesh.class.getDeclaredField("collisionTree");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        field.setAccessible(true);
        try {
            result = (CollisionData)field.get(mesh);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public static boolean hasAnyNormals(Mesh mesh) {
        VertexBuffer buffer = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
        return buffer != null || MyMesh.hasNormals(mesh);
    }

    public static boolean hasIndices(Mesh mesh) {
        VertexBuffer buffer = mesh.getBuffer(VertexBuffer.Type.Index);
        return buffer != null;
    }

    public static boolean hasNormals(Mesh mesh) {
        VertexBuffer buffer = mesh.getBuffer(VertexBuffer.Type.Normal);
        return buffer != null;
    }

    public static boolean hasTriangles(Mesh mesh) {
        boolean result;
        Mesh.Mode mode = mesh.getMode();
        switch (mode) {
            case Points: 
            case Lines: 
            case LineLoop: 
            case LineStrip: {
                result = false;
                break;
            }
            case Triangles: 
            case TriangleFan: 
            case TriangleStrip: {
                result = true;
                break;
            }
            default: {
                String message = "mode = " + mode;
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public static boolean hasUV(Mesh mesh) {
        VertexBuffer buffer = mesh.getBuffer(VertexBuffer.Type.TexCoord);
        return buffer != null;
    }

    public static boolean isAnimated(Mesh mesh) {
        VertexBuffer indices = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        boolean hasIndices = indices != null;
        VertexBuffer weights = mesh.getBuffer(VertexBuffer.Type.BoneWeight);
        boolean hasWeights = weights != null;
        boolean result = hasIndices && hasWeights;
        return result;
    }

    public static List<Mesh> listMeshes(Spatial subtree, List<Mesh> storeResult) {
        ArrayList<Mesh> result;
        ArrayList<Mesh> arrayList = result = storeResult == null ? new ArrayList<Mesh>(10) : storeResult;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Mesh mesh = geometry.getMesh();
            if (!result.contains(mesh)) {
                result.add(mesh);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyMesh.listMeshes(child, result);
            }
        }
        return result;
    }

    public static VectorSet listVertexLocations(Spatial subtree, VectorSet storeResult) {
        VectorSet result;
        block6: {
            block5: {
                if (storeResult == null) {
                    int numVectors = 64;
                    boolean direct = false;
                    result = new VectorSetUsingBuffer(numVectors, direct);
                } else {
                    result = storeResult;
                }
                if (!(subtree instanceof Geometry)) break block5;
                Geometry geometry = (Geometry)subtree;
                Mesh mesh = geometry.getMesh();
                int numVertices = mesh.getVertexCount();
                Vector3f tempLocation = new Vector3f();
                for (int vertexI = 0; vertexI < numVertices; ++vertexI) {
                    MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Position, vertexI, tempLocation);
                    if (!geometry.isIgnoreTransform()) {
                        geometry.localToWorld(tempLocation, tempLocation);
                    }
                    result.add(tempLocation);
                }
                break block6;
            }
            if (!(subtree instanceof Node)) break block6;
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MyMesh.listVertexLocations(child, result);
            }
        }
        return result;
    }

    public static Mesh merge(Mesh mesh1, Mesh mesh2) {
        int levels1 = mesh1.getNumLodLevels();
        Validate.require(levels1 == 0, "no LODs in mesh1");
        int levels2 = mesh1.getNumLodLevels();
        Validate.require(levels2 == 0, "no LODs in mesh2");
        Mesh.Mode outMode = MyMesh.expandedMode(mesh1);
        Mesh.Mode outMode2 = MyMesh.expandedMode(mesh2);
        Validate.require(outMode == outMode2, "same primitives");
        Mesh result = new Mesh();
        result.setMode(outMode);
        IndexBuffer indexList1 = mesh1.getIndicesAsList();
        IndexBuffer indexList2 = mesh2.getIndicesAsList();
        int numVertices1 = indexList1.size();
        int numVertices2 = indexList2.size();
        int outNumVertices = numVertices1 + numVertices2;
        for (VertexBuffer.Type type : VertexBuffer.Type.values()) {
            int vertexI;
            VertexBuffer.Format format2;
            if (type == VertexBuffer.Type.Index) continue;
            VertexBuffer vb1 = mesh1.getBuffer(type);
            VertexBuffer vb2 = mesh2.getBuffer(type);
            if (vb1 == null && vb2 == null) continue;
            Validate.nonNull(vb1, "mesh1's " + type);
            Validate.nonNull(vb2, "mesh2's " + type);
            int numCperE = vb1.getNumComponents();
            int numCperE2 = vb2.getNumComponents();
            assert (numCperE2 == numCperE) : "numComponents differ in " + type;
            VertexBuffer.Format format1 = vb1.getFormat();
            if (format1 == null) {
                format1 = VertexBuffer.Format.Float;
            }
            if ((format2 = vb2.getFormat()) == null) {
                format2 = VertexBuffer.Format.Float;
            }
            VertexBuffer.Format outFormat = format1.getComponentSize() > format2.getComponentSize() ? format1 : format2;
            numCperE = MyMath.clamp(numCperE, 1, 4);
            Buffer outBuffer = VertexBuffer.createBuffer((VertexBuffer.Format)outFormat, (int)numCperE, (int)outNumVertices);
            result.setBuffer(type, numCperE, outFormat, outBuffer);
            VertexBuffer outVb = result.getBuffer(type);
            for (vertexI = 0; vertexI < numVertices1; ++vertexI) {
                int elementIndex = indexList1.get(vertexI);
                for (int componentI = 0; componentI < numCperE; ++componentI) {
                    Object value = vb1.getElementComponent(elementIndex, componentI);
                    outVb.setElementComponent(vertexI, componentI, value);
                }
            }
            for (vertexI = 0; vertexI < numVertices2; ++vertexI) {
                int outIndex = numVertices1 + vertexI;
                int vb2Index = indexList2.get(vertexI);
                for (int componentI = 0; componentI < numCperE; ++componentI) {
                    Object value = vb2.getElementComponent(vb2Index, componentI);
                    outVb.setElementComponent(outIndex, componentI, value);
                }
            }
        }
        result.updateBound();
        int maxNumWeights1 = mesh1.getMaxNumWeights();
        int maxNumWeights2 = mesh2.getMaxNumWeights();
        int maxNumWeights = Math.max(maxNumWeights1, maxNumWeights2);
        result.setMaxNumWeights(maxNumWeights);
        assert (result.getMode().isListMode());
        assert (!MyMesh.hasIndices(result));
        return result;
    }

    public static int numInfluenced(Mesh mesh, int boneIndex) {
        Validate.nonNegative(boneIndex, "bone index");
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        assert (maxWeightsPerVert > 0) : maxWeightsPerVert;
        assert (maxWeightsPerVert <= 4) : maxWeightsPerVert;
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        int result = 0;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                float weight = weightBuffer.get();
                int bIndex = MyBuffer.readIndex(boneIndexBuffer);
                if (wIndex >= maxWeightsPerVert || bIndex != boneIndex || weight == 0.0f) continue;
                ++result;
            }
        }
        return result;
    }

    public static void reverseNormals(Mesh mesh) {
        FloatBuffer buffer = mesh.getFloatBuffer(VertexBuffer.Type.Normal);
        if (buffer != null) {
            MyBuffer.scale(buffer, 0, buffer.limit(), scaleReverse);
        }
        if ((buffer = mesh.getFloatBuffer(VertexBuffer.Type.BindPoseNormal)) != null) {
            MyBuffer.scale(buffer, 0, buffer.limit(), scaleReverse);
        }
    }

    public static void reverseWinding(Mesh mesh) {
        Validate.require(mesh.getMode() == Mesh.Mode.Triangles, "be in Triangles mode");
        mesh.updateCounts();
        int numTriangles = mesh.getTriangleCount();
        IndexBuffer indexBuffer = mesh.getIndexBuffer();
        if (indexBuffer != null) {
            int numIndices = 3 * numTriangles;
            assert (indexBuffer.size() == numIndices) : indexBuffer.size();
            for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
                int v1Index = 3 * triIndex;
                int v3Index = 3 * triIndex + 3 - 1;
                int i1 = indexBuffer.get(v1Index);
                int i3 = indexBuffer.get(v3Index);
                indexBuffer.put(v1Index, i3);
                indexBuffer.put(v3Index, i1);
            }
        } else {
            int numVertices = 3 * numTriangles;
            for (VertexBuffer vb : mesh.getBufferList()) {
                assert (vb.getNumElements() == numVertices) : vb.getNumElements();
                for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
                    int v1Index = 3 * triIndex;
                    int v3Index = 3 * triIndex + 3 - 1;
                    Element.swap(vb, v1Index, v3Index);
                }
            }
        }
    }

    public static void rotate(Mesh mesh, Quaternion rotation) {
        MyMesh.rotateBuffer(mesh, VertexBuffer.Type.Position, rotation);
        MyMesh.rotateBuffer(mesh, VertexBuffer.Type.BindPosePosition, rotation);
        MyMesh.rotateBuffer(mesh, VertexBuffer.Type.Normal, rotation);
        MyMesh.rotateBuffer(mesh, VertexBuffer.Type.BindPoseNormal, rotation);
        mesh.updateBound();
    }

    public static void rotateBuffer(Mesh mesh, VertexBuffer.Type bufferType, Quaternion rotation) {
        Validate.nonNull(bufferType, "buffer type");
        Validate.nonNull(rotation, "rotation");
        VertexBuffer vertexBuffer = mesh.getBuffer(bufferType);
        if (vertexBuffer != null) {
            FloatBuffer floatBuffer = (FloatBuffer)vertexBuffer.getData();
            int numVertices = mesh.getVertexCount();
            int numFloats = 3 * numVertices;
            MyBuffer.rotate(floatBuffer, 0, numFloats, rotation);
            vertexBuffer.setUpdateNeeded();
        }
    }

    public static void rotateTangentBuffer(Mesh mesh, VertexBuffer.Type bufferType, Quaternion rotation) {
        Validate.nonNull(bufferType, "buffer type");
        Validate.nonNull(rotation, "rotation");
        VertexBuffer vertexBuffer = mesh.getBuffer(bufferType);
        if (vertexBuffer != null) {
            FloatBuffer floatBuffer = (FloatBuffer)vertexBuffer.getData();
            int numVertices = mesh.getVertexCount();
            Vector3f tmpV3 = new Vector3f();
            Vector4f tmpV4 = new Vector4f();
            for (int vertexI = 0; vertexI < numVertices; ++vertexI) {
                MyMesh.vertexVector4f(mesh, bufferType, vertexI, tmpV4);
                tmpV3.x = tmpV4.x;
                tmpV3.y = tmpV4.y;
                tmpV3.z = tmpV4.z;
                rotation.mult(tmpV3, tmpV3);
                tmpV4.x = tmpV3.x;
                tmpV4.y = tmpV3.y;
                tmpV4.z = tmpV3.z;
                int floatIndex = 3 * vertexI;
                floatBuffer.put(floatIndex, tmpV4.x);
                floatBuffer.put(floatIndex + 1, tmpV4.y);
                floatBuffer.put(floatIndex + 2, tmpV4.z);
                floatBuffer.put(floatIndex + 3, tmpV4.w);
            }
            vertexBuffer.setUpdateNeeded();
        }
    }

    public static void scale(Mesh mesh, float factor) {
        int numVertices = mesh.getVertexCount();
        int numFloats = 3 * numVertices;
        Vector3f scale = new Vector3f(factor, factor, factor);
        VertexBuffer posBuffer = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer posFloats = (FloatBuffer)posBuffer.getData();
        MyBuffer.scale(posFloats, 0, numFloats, scale);
        posBuffer.setUpdateNeeded();
        VertexBuffer bindPosBuffer = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        if (bindPosBuffer != null) {
            FloatBuffer bpFloats = (FloatBuffer)bindPosBuffer.getData();
            MyBuffer.scale(bpFloats, 0, numFloats, scale);
            bindPosBuffer.setUpdateNeeded();
        }
        mesh.updateBound();
    }

    public static void setBoneIndexBuffer(Mesh mesh, int wpv, IndexBuffer indexBuffer) {
        Validate.nonNull(mesh, "mesh");
        Validate.inRange(wpv, "weights per vertex", 1, 4);
        Buffer buffer = indexBuffer.getBuffer();
        VertexBuffer.Type type = VertexBuffer.Type.BoneIndex;
        if (buffer instanceof ByteBuffer) {
            mesh.setBuffer(type, wpv, (ByteBuffer)buffer);
        } else if (buffer instanceof IntBuffer) {
            mesh.setBuffer(type, wpv, (IntBuffer)buffer);
        } else if (buffer instanceof ShortBuffer) {
            mesh.setBuffer(type, wpv, (ShortBuffer)buffer);
        } else {
            String message = buffer.getClass().getName();
            throw new IllegalArgumentException(message);
        }
    }

    public static void smoothNormals(Mesh mesh) {
        Validate.nonNull(mesh, "mesh");
        Validate.require(MyMesh.hasAnyNormals(mesh), "have normals");
        MyMesh.smoothNormals(mesh, VertexBuffer.Type.Normal, VertexBuffer.Type.Position);
        VertexBuffer bpNormal = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
        if (bpNormal != null) {
            MyMesh.smoothNormals(mesh, VertexBuffer.Type.BindPoseNormal, VertexBuffer.Type.BindPosePosition);
        }
    }

    public static void smoothNormals(Mesh mesh, VertexBuffer.Type normalBufferType, VertexBuffer.Type positionBufferType) {
        Validate.nonNull(mesh, "mesh");
        FloatBuffer positionBuffer = mesh.getFloatBuffer(positionBufferType);
        int numVertices = positionBuffer.limit() / 3;
        HashMap<Vector3f, Integer> mapPosToDpid = new HashMap<Vector3f, Integer>(numVertices);
        int numDistinctPositions = 0;
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            int start = vertexIndex * 3;
            Vector3f position = new Vector3f();
            MyBuffer.get(positionBuffer, start, position);
            MyVector3f.standardize(position, position);
            if (mapPosToDpid.containsKey(position)) continue;
            mapPosToDpid.put(position, numDistinctPositions);
            ++numDistinctPositions;
        }
        Vector3f[] normalSum = new Vector3f[numDistinctPositions];
        for (int dpid = 0; dpid < numDistinctPositions; ++dpid) {
            normalSum[dpid] = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        IndexBuffer indexList = mesh.getIndicesAsList();
        int numIndices = indexList.size();
        FloatBuffer normalBuffer = mesh.getFloatBuffer(normalBufferType);
        Vector3f tmpPosition = new Vector3f();
        Vector3f tmpNormal = new Vector3f();
        for (int ibPosition = 0; ibPosition < numIndices; ++ibPosition) {
            int vertexIndex = indexList.get(ibPosition);
            int start = vertexIndex * 3;
            MyBuffer.get(positionBuffer, start, tmpPosition);
            MyVector3f.standardize(tmpPosition, tmpPosition);
            int dpid = (Integer)mapPosToDpid.get(tmpPosition);
            MyBuffer.get(normalBuffer, start, tmpNormal);
            normalSum[dpid].addLocal(tmpNormal);
        }
        for (Vector3f vector3f : normalSum) {
            MyVector3f.normalizeLocal(vector3f);
        }
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            int start = vertexIndex * 3;
            MyBuffer.get(positionBuffer, start, tmpPosition);
            MyVector3f.standardize(tmpPosition, tmpPosition);
            int dpid = (Integer)mapPosToDpid.get(tmpPosition);
            MyBuffer.put(normalBuffer, start, normalSum[dpid]);
        }
    }

    public static Mesh subdivideLines(Mesh in, int ratio) {
        Validate.nonNull(in, "input mesh");
        Validate.require(in.getMode() == Mesh.Mode.Lines, "be in Lines mode");
        Validate.inRange(ratio, "ratio", 2, Integer.MAX_VALUE);
        IndexBuffer indexList = in.getIndicesAsList();
        int inEdgeCount = in.getTriangleCount();
        assert (inEdgeCount * 2 == indexList.size()) : inEdgeCount;
        int outVertexCount = indexList.size() * ratio;
        Mesh out = in.clone();
        for (VertexBuffer inVertexBuffer : in.getBufferList()) {
            VertexBuffer.Type type = inVertexBuffer.getBufferType();
            out.clearBuffer(type);
            if (type == VertexBuffer.Type.Index) continue;
            VertexBuffer.Format format = VertexBuffer.Format.Float;
            int numCperE = inVertexBuffer.getNumComponents();
            numCperE = MyMath.clamp(numCperE, 1, 4);
            Buffer data = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numCperE, (int)outVertexCount);
            out.setBuffer(type, numCperE, format, data);
        }
        int outVI = 0;
        for (int inEI = 0; inEI < inEdgeCount; ++inEI) {
            int inVI0 = indexList.get(2 * inEI);
            int inVI1 = indexList.get(2 * inEI + 1);
            for (int subI = 0; subI < ratio; ++subI) {
                float t0 = (float)subI / (float)ratio;
                float t1 = (float)(subI + 1) / (float)ratio;
                for (VertexBuffer outVB : out.getBufferList()) {
                    VertexBuffer.Type type = outVB.getBufferType();
                    VertexBuffer inVB = in.getBuffer(type);
                    assert (inVB != outVB);
                    if (inVB.getNumElements() <= 0) continue;
                    Element.lerp(t0, inVB, inVI0, inVI1, outVB, outVI);
                    Element.lerp(t1, inVB, inVI0, inVI1, outVB, ++outVI);
                    ++outVI;
                }
            }
        }
        for (VertexBuffer outVB : out.getBufferList()) {
            Buffer data = outVB.getData();
            int endPosition = data.capacity();
            data.position(endPosition);
            data.flip();
        }
        out.updateCounts();
        assert (out.getMode() == Mesh.Mode.Lines) : out.getMode();
        assert (!MyMesh.hasIndices(out));
        return out;
    }

    public static Mesh subdivideTriangles(Mesh in, int ratio) {
        Validate.nonNull(in, "input mesh");
        Validate.require(in.getMode() == Mesh.Mode.Triangles, "be in Triangles mode");
        Validate.inRange(ratio, "ratio", 2, Integer.MAX_VALUE);
        IndexBuffer indexList = in.getIndicesAsList();
        int inTriangleCount = in.getTriangleCount();
        assert (inTriangleCount * 3 == indexList.size()) : inTriangleCount;
        int outVertexCount = indexList.size() * ratio * ratio;
        Mesh out = in.clone();
        for (VertexBuffer inVertexBuffer : in.getBufferList()) {
            VertexBuffer.Type type = inVertexBuffer.getBufferType();
            out.clearBuffer(type);
            if (type == VertexBuffer.Type.Index) continue;
            VertexBuffer.Format format = VertexBuffer.Format.Float;
            int numCperE = inVertexBuffer.getNumComponents();
            numCperE = MyMath.clamp(numCperE, 1, 4);
            Buffer data = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numCperE, (int)outVertexCount);
            out.setBuffer(type, numCperE, format, data);
        }
        int outVI = 0;
        for (int inTI = 0; inTI < inTriangleCount; ++inTI) {
            VertexBuffer inVB;
            VertexBuffer.Type type;
            float t2b;
            float t2a;
            float t1b;
            float t1a;
            int subK;
            int subJ;
            int subI;
            int inVI0 = indexList.get(3 * inTI);
            int inVI1 = indexList.get(3 * inTI + 1);
            int inVI2 = indexList.get(3 * inTI + 2);
            for (subI = 0; subI < ratio; ++subI) {
                for (subJ = 0; subJ < ratio - subI; ++subJ) {
                    subK = ratio - subI - subJ - 1;
                    t1a = (float)subJ / (float)ratio;
                    t1b = (float)(subJ + 1) / (float)ratio;
                    t2a = (float)subK / (float)ratio;
                    t2b = (float)(subK + 1) / (float)ratio;
                    for (VertexBuffer outVB : out.getBufferList()) {
                        type = outVB.getBufferType();
                        inVB = in.getBuffer(type);
                        assert (inVB != outVB);
                        if (inVB.getNumElements() <= 0) continue;
                        Element.lerp3(t1a, t2a, inVB, inVI0, inVI1, inVI2, outVB, outVI);
                        Element.lerp3(t1b, t2a, inVB, inVI0, inVI1, inVI2, outVB, outVI + 1);
                        Element.lerp3(t1a, t2b, inVB, inVI0, inVI1, inVI2, outVB, outVI + 2);
                    }
                    outVI += 3;
                }
            }
            for (subI = 0; subI < ratio - 1; ++subI) {
                for (subJ = 0; subJ < ratio - subI - 1; ++subJ) {
                    subK = ratio - subI - subJ - 2;
                    t1a = (float)subJ / (float)ratio;
                    t1b = (float)(subJ + 1) / (float)ratio;
                    t2a = (float)subK / (float)ratio;
                    t2b = (float)(subK + 1) / (float)ratio;
                    for (VertexBuffer outVB : out.getBufferList()) {
                        type = outVB.getBufferType();
                        inVB = in.getBuffer(type);
                        assert (inVB != outVB);
                        if (inVB.getNumElements() <= 0) continue;
                        Element.lerp3(t1b, t2a, inVB, inVI0, inVI1, inVI2, outVB, outVI);
                        Element.lerp3(t1b, t2b, inVB, inVI0, inVI1, inVI2, outVB, outVI + 1);
                        Element.lerp3(t1a, t2b, inVB, inVI0, inVI1, inVI2, outVB, outVI + 2);
                    }
                    outVI += 3;
                }
            }
        }
        for (VertexBuffer outVB : out.getBufferList()) {
            Buffer data = outVB.getData();
            int endPosition = data.capacity();
            data.position(endPosition);
            data.flip();
        }
        out.updateCounts();
        assert (out.getMode() == Mesh.Mode.Triangles) : out.getMode();
        assert (!MyMesh.hasIndices(out));
        return out;
    }

    public static void transformBuffer(Mesh mesh, VertexBuffer.Type bufferType, Transform transform) {
        Validate.nonNull(bufferType, "buffer type");
        Validate.nonNull(transform, "transform");
        VertexBuffer vertexBuffer = mesh.getBuffer(bufferType);
        if (vertexBuffer != null) {
            FloatBuffer floatBuffer = (FloatBuffer)vertexBuffer.getData();
            int numVertices = mesh.getVertexCount();
            int numFloats = 3 * numVertices;
            MyBuffer.transform(floatBuffer, 0, numFloats, transform);
            vertexBuffer.setUpdateNeeded();
        }
    }

    public static void translate(Mesh mesh, Vector3f offset) {
        int numVertices = mesh.getVertexCount();
        int numFloats = 3 * numVertices;
        VertexBuffer posBuffer = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer posFloats = (FloatBuffer)posBuffer.getData();
        MyBuffer.translate(posFloats, 0, numFloats, offset);
        posBuffer.setUpdateNeeded();
        VertexBuffer bindPosBuffer = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        if (bindPosBuffer != null) {
            FloatBuffer bpFloats = (FloatBuffer)bindPosBuffer.getData();
            MyBuffer.translate(bpFloats, 0, numFloats, offset);
            bindPosBuffer.setUpdateNeeded();
        }
        mesh.updateBound();
    }

    public static void trianglesToLines(Mesh mesh) {
        Validate.nonNull(mesh, "mesh");
        Validate.require(MyMesh.hasTriangles(mesh), "contain triangles");
        IndexBuffer indexList = mesh.getIndicesAsList();
        int numTriangles = indexList.size() / 3;
        HashSet<IntPair> edgeSet = new HashSet<IntPair>(3 * numTriangles);
        for (int triIndex = 0; triIndex < numTriangles; ++triIndex) {
            int intOffset = 3 * triIndex;
            int ti0 = indexList.get(intOffset);
            int ti1 = indexList.get(intOffset + 1);
            int ti2 = indexList.get(intOffset + 2);
            edgeSet.add(new IntPair(ti0, ti1));
            edgeSet.add(new IntPair(ti0, ti2));
            edgeSet.add(new IntPair(ti1, ti2));
        }
        int numEdges = edgeSet.size();
        int numIndices = 2 * numEdges;
        int numVertices = mesh.getVertexCount();
        mesh.clearBuffer(VertexBuffer.Type.Index);
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        for (IntPair edge : edgeSet) {
            ib.put(edge.smaller());
            ib.put(edge.larger());
        }
        VertexBuffer.Format ibFormat = ib.getFormat();
        Buffer ibData = ib.getBuffer();
        ibData.flip();
        mesh.setBuffer(VertexBuffer.Type.Index, 2, ibFormat, ibData);
        mesh.setMode(Mesh.Mode.Lines);
    }

    public static int[] vertexBoneIndices(Mesh mesh, int vertexIndex, int[] storeResult) {
        int[] result;
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        if (storeResult == null) {
            result = new int[4];
        } else {
            assert (storeResult.length >= 4) : storeResult.length;
            result = storeResult;
        }
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.position(4 * vertexIndex);
        for (int wIndex = 0; wIndex < maxWeightsPerVert; ++wIndex) {
            int boneIndex;
            result[wIndex] = boneIndex = MyBuffer.readIndex(boneIndexBuffer);
        }
        int length = result.length;
        for (int wIndex = maxWeightsPerVert; wIndex < length; ++wIndex) {
            result[wIndex] = -1;
        }
        return result;
    }

    public static float[] vertexBoneWeights(Mesh mesh, int vertexIndex, float[] storeResult) {
        float[] result;
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        if (storeResult == null) {
            result = new float[4];
        } else {
            assert (storeResult.length >= 4) : storeResult.length;
            result = storeResult;
        }
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        int startIndex = 4 * vertexIndex;
        for (int wIndex = 0; wIndex < maxWeightsPerVert; ++wIndex) {
            result[wIndex] = weightBuffer.get(startIndex + wIndex);
        }
        int length = result.length;
        for (int wIndex = maxWeightsPerVert; wIndex < length; ++wIndex) {
            result[wIndex] = 0.0f;
        }
        return result;
    }

    public static ColorRGBA vertexColor(Mesh mesh, int vertexIndex, ColorRGBA storeResult) {
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        ColorRGBA result = storeResult == null ? new ColorRGBA() : storeResult;
        VertexBuffer vertexBuffer = mesh.getBuffer(VertexBuffer.Type.Color);
        int numComponents = vertexBuffer.getNumComponents();
        Validate.require(numComponents == 4, "4 components per element");
        int bufferPosition = numComponents * vertexIndex;
        Buffer data = vertexBuffer.getDataReadOnly();
        if (data instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)data;
            int r = byteBuffer.get(bufferPosition) & 0xFF;
            int g = byteBuffer.get(bufferPosition + 1) & 0xFF;
            int b = byteBuffer.get(bufferPosition + 2) & 0xFF;
            int a = byteBuffer.get(bufferPosition + 3) & 0xFF;
            result.set((float)r, (float)g, (float)b, (float)a);
            result.multLocal(0.003921569f);
        } else {
            FloatBuffer floatBuffer = (FloatBuffer)data;
            result.r = floatBuffer.get(bufferPosition);
            result.g = floatBuffer.get(bufferPosition + 1);
            result.b = floatBuffer.get(bufferPosition + 2);
            result.a = floatBuffer.get(bufferPosition + 3);
        }
        return result;
    }

    public static Vector3f vertexLocation(Mesh mesh, int vertexIndex, Matrix4f[] skinningMatrices, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (MyMesh.isAnimated(mesh)) {
            Vector3f b = MyMesh.vertexVector3f(mesh, VertexBuffer.Type.BindPosePosition, vertexIndex, null);
            FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
            weightBuffer.position(4 * vertexIndex);
            VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            Buffer boneIndexBuffer = biBuf.getDataReadOnly();
            boneIndexBuffer.position(4 * vertexIndex);
            result.zero();
            int maxWeightsPerVertex = mesh.getMaxNumWeights();
            for (int wIndex = 0; wIndex < maxWeightsPerVertex; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyBuffer.readIndex(boneIndexBuffer);
                if (weight == 0.0f) continue;
                Matrix4f s = boneIndex < skinningMatrices.length ? skinningMatrices[boneIndex] : matrixIdentity;
                float xOf = s.m00 * b.x + s.m01 * b.y + s.m02 * b.z + s.m03;
                float yOf = s.m10 * b.x + s.m11 * b.y + s.m12 * b.z + s.m13;
                float zOf = s.m20 * b.x + s.m21 * b.y + s.m22 * b.z + s.m23;
                result.x += weight * xOf;
                result.y += weight * yOf;
                result.z += weight * zOf;
            }
        } else {
            MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Position, vertexIndex, result);
        }
        return result;
    }

    public static Vector3f vertexNormal(Mesh mesh, int vertexIndex, Matrix4f[] skinningMatrices, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (MyMesh.isAnimated(mesh)) {
            Vector3f b = MyMesh.vertexVector3f(mesh, VertexBuffer.Type.BindPoseNormal, vertexIndex, null);
            FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
            weightBuffer.position(4 * vertexIndex);
            VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            Buffer boneIndexBuffer = biBuf.getDataReadOnly();
            boneIndexBuffer.position(4 * vertexIndex);
            result.zero();
            int maxWeightsPerVertex = mesh.getMaxNumWeights();
            for (int wIndex = 0; wIndex < maxWeightsPerVertex; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyBuffer.readIndex(boneIndexBuffer);
                if (weight == 0.0f) continue;
                Matrix4f s = boneIndex < skinningMatrices.length ? skinningMatrices[boneIndex] : matrixIdentity;
                float xOf = s.m00 * b.x + s.m01 * b.y + s.m02 * b.z;
                float yOf = s.m10 * b.x + s.m11 * b.y + s.m12 * b.z;
                float zOf = s.m20 * b.x + s.m21 * b.y + s.m22 * b.z;
                result.x += weight * xOf;
                result.y += weight * yOf;
                result.z += weight * zOf;
            }
            MyVector3f.normalizeLocal(result);
        } else {
            MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Normal, vertexIndex, result);
        }
        return result;
    }

    public static float vertexSize(Mesh mesh, int vertexIndex) {
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Size);
        float result = floatBuffer.get(vertexIndex);
        return result;
    }

    public static Vector4f vertexTangent(Mesh mesh, int vertexIndex, Matrix4f[] skinningMatrices, Vector4f storeResult) {
        Vector4f result;
        Validate.nonNull(mesh, "mesh");
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        Vector4f vector4f = result = storeResult == null ? new Vector4f() : storeResult;
        if (MyMesh.isAnimated(mesh)) {
            Vector4f b = MyMesh.vertexVector4f(mesh, VertexBuffer.Type.BindPoseTangent, vertexIndex, null);
            FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
            weightBuffer.position(4 * vertexIndex);
            VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
            Buffer boneIndexBuffer = biBuf.getDataReadOnly();
            boneIndexBuffer.position(4 * vertexIndex);
            result.zero();
            int maxWeightsPerVertex = mesh.getMaxNumWeights();
            for (int wIndex = 0; wIndex < maxWeightsPerVertex; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyBuffer.readIndex(boneIndexBuffer);
                if (weight == 0.0f) continue;
                Matrix4f s = boneIndex < skinningMatrices.length ? skinningMatrices[boneIndex] : matrixIdentity;
                float xOf = s.m00 * b.x + s.m01 * b.y + s.m02 * b.z;
                float yOf = s.m10 * b.x + s.m11 * b.y + s.m12 * b.z;
                float zOf = s.m20 * b.x + s.m21 * b.y + s.m22 * b.z;
                result.x += weight * xOf;
                result.y += weight * yOf;
                result.z += weight * zOf;
            }
            result.normalizeLocal();
            result.w = b.w;
        } else {
            MyMesh.vertexVector4f(mesh, VertexBuffer.Type.Tangent, vertexIndex, result);
        }
        return result;
    }

    public static Vector2f vertexVector2f(Mesh mesh, VertexBuffer.Type bufferType, int vertexIndex, Vector2f storeResult) {
        assert (Validate.require(bufferType == VertexBuffer.Type.TexCoord || bufferType == VertexBuffer.Type.TexCoord2 || bufferType == VertexBuffer.Type.TexCoord3 || bufferType == VertexBuffer.Type.TexCoord4 || bufferType == VertexBuffer.Type.TexCoord5 || bufferType == VertexBuffer.Type.TexCoord6 || bufferType == VertexBuffer.Type.TexCoord7 || bufferType == VertexBuffer.Type.TexCoord8, "legal VertexBuffer type"));
        Validate.nonNegative(vertexIndex, "vertex index");
        Vector2f result = storeResult == null ? new Vector2f() : storeResult;
        FloatBuffer floatBuffer = mesh.getFloatBuffer(bufferType);
        int floatIndex = 2 * vertexIndex;
        result.x = floatBuffer.get(floatIndex);
        result.y = floatBuffer.get(floatIndex + 1);
        return result;
    }

    public static Vector3f vertexVector3f(Mesh mesh, VertexBuffer.Type bufferType, int vertexIndex, Vector3f storeResult) {
        assert (Validate.require(bufferType == VertexBuffer.Type.BindPoseNormal || bufferType == VertexBuffer.Type.BindPosePosition || bufferType == VertexBuffer.Type.Binormal || bufferType == VertexBuffer.Type.Normal || bufferType == VertexBuffer.Type.Position, "legal VertexBuffer type"));
        Validate.nonNegative(vertexIndex, "vertex index");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        FloatBuffer floatBuffer = mesh.getFloatBuffer(bufferType);
        int floatIndex = 3 * vertexIndex;
        MyBuffer.get(floatBuffer, floatIndex, result);
        return result;
    }

    public static Vector4f vertexVector4f(Mesh mesh, VertexBuffer.Type bufferType, int vertexIndex, Vector4f storeResult) {
        assert (Validate.require(bufferType == VertexBuffer.Type.BindPoseTangent || bufferType == VertexBuffer.Type.BoneWeight || bufferType == VertexBuffer.Type.Color || bufferType == VertexBuffer.Type.HWBoneWeight || bufferType == VertexBuffer.Type.Tangent, "legal VertexBuffer type"));
        Validate.nonNegative(vertexIndex, "vertex index");
        Vector4f result = storeResult == null ? new Vector4f() : storeResult;
        FloatBuffer floatBuffer = mesh.getFloatBuffer(bufferType);
        int floatIndex = 4 * vertexIndex;
        result.x = floatBuffer.get(floatIndex);
        result.y = floatBuffer.get(floatIndex + 1);
        result.z = floatBuffer.get(floatIndex + 2);
        result.w = floatBuffer.get(floatIndex + 3);
        return result;
    }

    public static Vector3f vertexWorldLocation(Geometry geometry, int vertexIndex, Matrix4f[] skinningMatrices, Vector3f storeResult) {
        Validate.nonNegative(vertexIndex, "vertex index");
        Validate.nonNull(skinningMatrices, "skinning matrices");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        Mesh mesh = geometry.getMesh();
        Vector3f meshLocation = MyMesh.vertexLocation(mesh, vertexIndex, skinningMatrices, null);
        if (geometry.isIgnoreTransform()) {
            result.set(meshLocation);
        } else {
            geometry.localToWorld(meshLocation, result);
        }
        return result;
    }
}

