/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.ColorRGBA;
import com.jme3.texture.image.ColorSpace;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public final class MyColor {
    public static final Logger logger = Logger.getLogger(MyColor.class.getName());
    private static final Pattern colorPattern = Pattern.compile("Color\\[\\s*([^,]+),\\s*([^,]+),\\s*([^,]+),\\s*(\\S+)\\s*]");

    private MyColor() {
    }

    public static String describe(ColorRGBA color) {
        String result;
        if (color == null) {
            result = "null";
        } else {
            StringBuilder builder = new StringBuilder(40);
            if (color.r == color.g && color.g == color.b) {
                builder.append("rgb=");
                String rgb = MyString.describeFraction(color.r);
                builder.append(rgb);
            } else {
                builder.append("r=");
                String r = MyString.describeFraction(color.r);
                builder.append(r);
                builder.append(" g=");
                String g = MyString.describeFraction(color.g);
                builder.append(g);
                builder.append(" b=");
                String b = MyString.describeFraction(color.b);
                builder.append(b);
            }
            if (color.a != 1.0f) {
                builder.append(" a=");
                String a = MyString.describeFraction(color.a);
                builder.append(a);
            }
            result = builder.toString();
        }
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public static ColorRGBA interpolateLinear(float fraction, ColorRGBA start, ColorRGBA end) {
        Validate.fraction(fraction, "fraction");
        Validate.nonNull(start, "start");
        Validate.nonNull(end, "end");
        ColorRGBA result = MyColor.lerp(fraction, start, end, null);
        return result;
    }

    public static ColorRGBA lerp(float t, ColorRGBA c0, ColorRGBA c1, ColorRGBA storeResult) {
        Validate.nonNull(c0, "c0");
        Validate.nonNull(c1, "c1");
        ColorRGBA result = storeResult == null ? new ColorRGBA() : storeResult;
        result.r = MyMath.lerp(t, c0.r, c1.r);
        result.g = MyMath.lerp(t, c0.g, c1.g);
        result.b = MyMath.lerp(t, c0.b, c1.b);
        result.a = MyMath.lerp(t, c0.a, c1.a);
        return result;
    }

    public static ColorRGBA parse(String textString) {
        Validate.nonEmpty(textString, "text string");
        ColorRGBA result = null;
        Matcher matcher = colorPattern.matcher(textString);
        boolean valid = matcher.matches();
        if (valid) {
            String rText = matcher.group(1);
            float r = Float.parseFloat(rText);
            String gText = matcher.group(2);
            float g = Float.parseFloat(gText);
            String bText = matcher.group(3);
            float b = Float.parseFloat(bText);
            String aText = matcher.group(4);
            float a = Float.parseFloat(aText);
            result = new ColorRGBA(r, g, b, a);
        }
        return result;
    }

    public static ColorRGBA renderColor(ColorSpace colorSpace, ColorRGBA encodedColor) {
        ColorRGBA result = colorSpace == ColorSpace.sRGB ? encodedColor.clone() : encodedColor.getAsSrgb();
        return result;
    }

    public static ColorRGBA saturate(ColorRGBA baseColor) {
        float[] fArray = new float[]{baseColor.r, baseColor.g, baseColor.b};
        float max = MyMath.max(fArray);
        if (max <= 0.0f) {
            return new ColorRGBA(1.0f, 1.0f, 1.0f, baseColor.a);
        }
        ColorRGBA result = baseColor.mult(1.0f / max);
        return result;
    }
}

