/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public class MyMath {
    public static final double halfPi = 1.5707963267948966;
    public static final float phi = (1.0f + FastMath.sqrt((float)5.0f)) / 2.0f;
    public static final float root2 = FastMath.sqrt((float)2.0f);
    public static final float rootHalf = FastMath.sqrt((float)0.5f);
    public static final Logger logger = Logger.getLogger(MyMath.class.getName());

    private MyMath() {
    }

    public static double area(Triangle triangle) {
        Vector3f a = triangle.get1();
        Vector3f b = triangle.get2();
        Vector3f c = triangle.get3();
        Vector3f ab = b.subtract(a);
        Vector3f ac = c.subtract(a);
        Vector3f cross = ab.cross(ac);
        double areaSquared = MyVector3f.lengthSquared(cross) / 4.0;
        double area = Math.sqrt(areaSquared);
        return area;
    }

    public static boolean areWithinTolerance(float a, float b, float relativeTolerance) {
        Validate.nonNegative(relativeTolerance, "relative tolerance");
        if (a == b) {
            return true;
        }
        float maxAbsoluteValue = Math.max(FastMath.abs((float)a), FastMath.abs((float)b));
        float tolerance = relativeTolerance * maxAbsoluteValue;
        float absDiff = FastMath.abs((float)(a - b));
        return absDiff < tolerance;
    }

    public static double circle(double abscissa) {
        assert (Validate.inRange(abscissa, "abscissa", -1.0, 1.0));
        double y = Math.sqrt(1.0 - abscissa * abscissa);
        assert (y >= 0.0) : y;
        assert (y <= 1.0) : y;
        return y;
    }

    public static float circle(float abscissa) {
        assert (Validate.inRange(abscissa, "abscissa", -1.0f, 1.0f));
        double x = abscissa;
        float y = (float)MyMath.circle(x);
        assert (y >= 0.0f) : y;
        assert (y <= 1.0f) : y;
        return y;
    }

    public static float clamp(float fValue, float maxMagnitude) {
        assert (Validate.nonNegative(maxMagnitude, "limit"));
        float result = FastMath.clamp((float)fValue, (float)(-maxMagnitude), (float)maxMagnitude);
        assert (result >= -maxMagnitude) : result;
        assert (result <= maxMagnitude) : result;
        return result;
    }

    public static double clamp(double dValue, double maxMagnitude) {
        assert (Validate.nonNegative(maxMagnitude, "limit"));
        if (dValue < -maxMagnitude) {
            return -maxMagnitude;
        }
        if (dValue > maxMagnitude) {
            return maxMagnitude;
        }
        return dValue;
    }

    public static double clamp(double dValue, double min, double max) {
        double result = dValue < min ? min : (dValue > max ? max : dValue);
        return result;
    }

    public static int clamp(int iValue, int min, int max) {
        int result = iValue < min ? min : (iValue > max ? max : iValue);
        return result;
    }

    public static float cube(float fValue) {
        float result = fValue * fValue * fValue;
        if (Float.isInfinite(result)) {
            String message = String.format("Overflow from cubing %g.", Float.valueOf(fValue));
            logger.warning(message);
        }
        return result;
    }

    public static float cubeRoot(float fValue) {
        double dValue = fValue;
        float result = (float)Math.cbrt(dValue);
        return result;
    }

    public static double discriminant(double a, double b, double c) {
        double result = b * b - 4.0 * a * c;
        return result;
    }

    public static float easeInQuartic(float time, float start, float end, float duration) {
        assert (Validate.positive(duration, "duration"));
        float t = time / duration;
        float t2 = t * t;
        float fraction = t2 * t2;
        float result = MyMath.lerp(fraction, start, end);
        return result;
    }

    public static float easeOutQuartic(float time, float start, float end, float duration) {
        assert (Validate.positive(duration, "duration"));
        float t = time / duration - 1.0f;
        float t2 = t * t;
        float fraction = 1.0f - t2 * t2;
        float result = MyMath.lerp(fraction, start, end);
        return result;
    }

    public static float fade(float t) {
        assert (Validate.fraction(t, "t"));
        double tt = t;
        double ff = tt * tt * tt * (10.0 + tt * (-15.0 + 6.0 * tt));
        float result = (float)ff;
        assert (result >= 0.0f) : result;
        assert (result <= 1.0f) : result;
        return result;
    }

    public static double fourthRoot(double dValue) {
        assert (Validate.nonNegative(dValue, "dValue"));
        double sqrt = Math.sqrt(dValue);
        double result = Math.sqrt(sqrt);
        assert (result >= 0.0) : result;
        return result;
    }

    public static float hypotenuse(float ... fValues) {
        double sum = 0.0;
        for (float fValue : fValues) {
            double value = fValue;
            sum += value * value;
        }
        float result = (float)Math.sqrt(sum);
        assert (result >= 0.0f) : result;
        return result;
    }

    public static double hypotenuseDouble(double ... dValues) {
        double sum = 0.0;
        for (double value : dValues) {
            sum += value * value;
        }
        double result = Math.sqrt(sum);
        assert (result >= 0.0) : result;
        return result;
    }

    public static boolean isBetween(int a, int b, int c) {
        if (a > c) {
            return a >= b && b >= c;
        }
        if (a < c) {
            return a <= b && b <= c;
        }
        assert (a == c);
        return a == b;
    }

    public static boolean isBetween(float a, float b, float c) {
        if (a > c) {
            return a >= b && b >= c;
        }
        if (a < c) {
            return a <= b && b <= c;
        }
        if (a == c) {
            return a == b;
        }
        String message = "a = " + a + " c = " + c;
        throw new IllegalArgumentException(message);
    }

    public static boolean isBetween(double a, double b, double c) {
        if (a > c) {
            return a >= b && b >= c;
        }
        if (a < c) {
            return a <= b && b <= c;
        }
        if (a == c) {
            return a == b;
        }
        String message = "a = " + a + " c = " + c;
        throw new IllegalArgumentException(message);
    }

    public static boolean isIdentity(Transform transform) {
        Quaternion rotation;
        boolean result = false;
        Vector3f translation = transform.getTranslation();
        if (MyVector3f.isZero(translation) && MyQuaternion.isRotationIdentity(rotation = transform.getRotation())) {
            Vector3f scale = transform.getScale();
            result = MyVector3f.isScaleIdentity(scale);
        }
        return result;
    }

    public static boolean isOdd(int iValue) {
        boolean result = iValue % 2 != 0;
        return result;
    }

    public static float lerp(float t, float y0, float y1) {
        float result;
        if (y0 == y1) {
            result = y0;
        } else {
            float u = 1.0f - t;
            result = u * y0 + t * y1;
        }
        return result;
    }

    public static float lerp3(float t1, float t2, float y0, float y1, float y2) {
        float u = 1.0f - t1 - t2;
        float result = u * y0 + t1 * y1 + t2 * y2;
        return result;
    }

    public static float max(float ... fValues) {
        float result = Float.NEGATIVE_INFINITY;
        for (float value : fValues) {
            if (!(value > result)) continue;
            result = value;
        }
        return result;
    }

    public static double maxDouble(double ... dValues) {
        double result = Double.NEGATIVE_INFINITY;
        for (double value : dValues) {
            if (!(value > result)) continue;
            result = value;
        }
        return result;
    }

    public static int maxInt(int ... iValues) {
        int result = Integer.MIN_VALUE;
        for (int value : iValues) {
            if (value <= result) continue;
            result = value;
        }
        return result;
    }

    public static float mid(float a, float b, float c) {
        if (a >= b) {
            if (b >= c) {
                return b;
            }
            if (a >= c) {
                return c;
            }
            return a;
        }
        if (a >= c) {
            return a;
        }
        if (b >= c) {
            return c;
        }
        return b;
    }

    public static double mid(double a, double b, double c) {
        if (a >= b) {
            if (b >= c) {
                return b;
            }
            if (a >= c) {
                return c;
            }
            return a;
        }
        if (a >= c) {
            return a;
        }
        if (b >= c) {
            return c;
        }
        return b;
    }

    public static float min(float ... fValues) {
        float result = Float.POSITIVE_INFINITY;
        for (float value : fValues) {
            if (!(value < result)) continue;
            result = value;
        }
        return result;
    }

    public static double minDouble(double ... dValues) {
        double result = Double.POSITIVE_INFINITY;
        for (double value : dValues) {
            if (!(value < result)) continue;
            result = value;
        }
        return result;
    }

    public static int modulo(int iValue, int modulus) {
        assert (Validate.positive(modulus, "modulus"));
        int remainder = iValue % modulus;
        int result = iValue >= 0 ? remainder : (remainder + modulus) % modulus;
        assert ((float)result >= 0.0f) : result;
        assert (result < modulus) : result;
        return result;
    }

    public static float modulo(float fValue, float modulus) {
        assert (Validate.positive(modulus, "modulus"));
        float remainder = fValue % modulus;
        float result = fValue >= 0.0f ? remainder : (remainder + modulus) % modulus;
        assert (result >= 0.0f) : result;
        assert (result < modulus) : result;
        return result;
    }

    public static double modulo(double dValue, double modulus) {
        assert (Validate.positive(modulus, "modulus"));
        double remainder = dValue % modulus;
        double result = dValue >= 0.0 ? remainder : (remainder + modulus) % modulus;
        assert (result >= 0.0) : result;
        assert (result < modulus) : result;
        return result;
    }

    public static Transform slerp(float t, Transform t0, Transform t1, Transform storeResult) {
        assert (Validate.inRange(t, "t", 0.0f, 1.0f));
        assert (Validate.nonNull(t0, "t0"));
        assert (Validate.nonNull(t1, "t1"));
        Transform result = storeResult == null ? new Transform() : storeResult;
        MyVector3f.lerp(t, t0.getTranslation(), t1.getTranslation(), result.getTranslation());
        MyQuaternion.slerp(t, t0.getRotation(), t1.getRotation(), result.getRotation());
        MyVector3f.lerp(t, t0.getScale(), t1.getScale(), result.getScale());
        return result;
    }

    public static double sqr(double dValue) {
        double result = dValue * dValue;
        if (Double.isInfinite(result)) {
            String message = String.format("Overflow from squaring %g.", dValue);
            logger.warning(message);
        }
        assert (result >= 0.0) : result;
        return result;
    }

    public static float standardize(float fValue) {
        float result = fValue;
        if (Float.compare(fValue, -0.0f) == 0) {
            result = 0.0f;
        }
        return result;
    }

    public static float standardizeAngle(float angle) {
        Validate.finite(angle, "angle");
        float result = MyMath.modulo(angle, (float)Math.PI * 2);
        if (result >= (float)Math.PI) {
            result -= (float)Math.PI * 2;
        }
        assert (result >= (float)(-Math.PI)) : result;
        assert (result < (float)Math.PI) : result;
        return result;
    }

    public static double sumOfSquares(float ... fValues) {
        double result = 0.0;
        for (float fValue : fValues) {
            double value = fValue;
            result += value * value;
        }
        assert (result >= 0.0) : result;
        return result;
    }

    public static float toDegrees(float radians) {
        float result = radians * 57.295776f;
        return result;
    }

    public static float toRadians(float degrees) {
        float result = degrees * ((float)Math.PI / 180);
        return result;
    }

    public static Triangle transformInverse(Transform transform, Triangle input, Triangle storeResult) {
        Triangle result = storeResult == null ? new Triangle() : storeResult;
        Vector3f tmpVector = new Vector3f();
        for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
            Vector3f inputVector = input.get(vertexIndex);
            transform.transformInverseVector(inputVector, tmpVector);
            result.set(vertexIndex, tmpVector);
        }
        return result;
    }
}

