/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.bounding.BoundingBox;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Eigen3f;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.shape.AbstractBox;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyArray;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;

public class RectangularSolid
implements Savable {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(RectangularSolid.class.getName());
    private Quaternion localToWorld = new Quaternion();
    private Vector3f maxima = new Vector3f();
    private Vector3f minima = new Vector3f();

    public RectangularSolid() {
    }

    public RectangularSolid(AbstractBox mesh) {
        this.maxima.set(mesh.center);
        this.maxima.addLocal(mesh.xExtent, mesh.yExtent, mesh.zExtent);
        this.minima.set(mesh.center);
        this.minima.subtractLocal(mesh.xExtent, mesh.yExtent, mesh.zExtent);
    }

    public RectangularSolid(BoundingBox aabb) {
        aabb.getMax(this.maxima);
        aabb.getMin(this.minima);
    }

    public RectangularSolid(Collection<Vector3f> sampleLocations) {
        Validate.nonEmpty(sampleLocations, "sample locations");
        int numSamples = sampleLocations.size();
        assert (numSamples > 1) : numSamples;
        Matrix3f covariance = MyVector3f.covariance(sampleLocations, null);
        Eigen3f eigen = new Eigen3f(covariance);
        Vector3f[] basis = eigen.getEigenVectors();
        this.localToWorld.fromAxes(basis);
        this.maxima.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.minima.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Quaternion worldToLocal = this.localToWorld.inverse();
        Vector3f tempVector = new Vector3f();
        for (Vector3f world : sampleLocations) {
            worldToLocal.mult(world, tempVector);
            MyVector3f.accumulateMaxima(this.maxima, tempVector);
            MyVector3f.accumulateMinima(this.minima, tempVector);
        }
    }

    public RectangularSolid(float[] inputArray) {
        Validate.nonEmpty(inputArray, "input array");
        int numFloats = inputArray.length;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        assert (numVectors >= 2) : numVectors;
        Matrix3f covariance = MyArray.covarianceVector3f(inputArray, null);
        Eigen3f eigen = new Eigen3f(covariance);
        Vector3f[] basis = eigen.getEigenVectors();
        this.localToWorld.fromAxes(basis);
        this.maxima.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.minima.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Quaternion worldToLocal = this.localToWorld.inverse();
        Vector3f tempVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            tempVector.x = inputArray[vectorIndex * 3 + 0];
            tempVector.y = inputArray[vectorIndex * 3 + 1];
            tempVector.z = inputArray[vectorIndex * 3 + 2];
            worldToLocal.mult(tempVector, tempVector);
            MyVector3f.accumulateMaxima(this.maxima, tempVector);
            MyVector3f.accumulateMinima(this.minima, tempVector);
        }
    }

    public RectangularSolid(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition - 6);
        Validate.inRange(endPosition, "end position", startPosition + 6, buffer.capacity());
        int numFloats = endPosition - startPosition;
        assert (numFloats % 3 == 0) : numFloats;
        int numVectors = numFloats / 3;
        assert (numVectors >= 2) : numVectors;
        Matrix3f covariance = MyBuffer.covariance(buffer, 0, numFloats, null);
        Eigen3f eigen = new Eigen3f(covariance);
        Vector3f[] basis = eigen.getEigenVectors();
        this.localToWorld.fromAxes(basis);
        this.maxima.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.minima.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Quaternion worldToLocal = this.localToWorld.inverse();
        Vector3f tmpVector = new Vector3f();
        for (int vectorIndex = 0; vectorIndex < numVectors; ++vectorIndex) {
            int position = vectorIndex * 3;
            MyBuffer.get(buffer, position, tmpVector);
            worldToLocal.mult(tmpVector, tmpVector);
            MyVector3f.accumulateMaxima(this.maxima, tmpVector);
            MyVector3f.accumulateMinima(this.minima, tmpVector);
        }
    }

    public RectangularSolid(Vector3f halfExtents) {
        this.maxima.set(halfExtents);
        halfExtents.mult(-1.0f, this.minima);
    }

    public RectangularSolid(Vector3f min, Vector3f max, Quaternion orientation) {
        assert (min.x <= max.x);
        assert (min.y <= max.y);
        assert (min.z <= max.z);
        this.maxima.set(max);
        this.minima.set(min);
        this.localToWorld.set(orientation);
    }

    public RectangularSolid(RectangularSolid otherSolid, Vector3f scaleFactors) {
        Validate.nonNegative(scaleFactors, "scale factors");
        Vector3f center = MyVector3f.midpoint(otherSolid.minima, otherSolid.maxima, null);
        otherSolid.maxima.subtract(center, this.maxima);
        this.maxima.multLocal(scaleFactors);
        this.maxima.addLocal(center);
        otherSolid.minima.subtract(center, this.minima);
        this.minima.multLocal(scaleFactors);
        this.minima.addLocal(center);
        this.localToWorld.set(otherSolid.localToWorld);
    }

    public Vector3f halfExtents(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        this.maxima.subtract(this.minima, result);
        result.divideLocal(2.0f);
        assert (result.x >= 0.0f) : result.x;
        assert (result.y >= 0.0f) : result.y;
        assert (result.z >= 0.0f) : result.z;
        return result;
    }

    public List<Vector3f> listCorners() {
        ArrayList<Vector3f> cornerLocations = new ArrayList<Vector3f>(8);
        cornerLocations.add(new Vector3f(this.maxima.x, this.maxima.y, this.maxima.z));
        cornerLocations.add(new Vector3f(this.maxima.x, this.maxima.y, this.minima.z));
        cornerLocations.add(new Vector3f(this.maxima.x, this.minima.y, this.maxima.z));
        cornerLocations.add(new Vector3f(this.maxima.x, this.minima.y, this.minima.z));
        cornerLocations.add(new Vector3f(this.minima.x, this.maxima.y, this.maxima.z));
        cornerLocations.add(new Vector3f(this.minima.x, this.maxima.y, this.minima.z));
        cornerLocations.add(new Vector3f(this.minima.x, this.minima.y, this.maxima.z));
        cornerLocations.add(new Vector3f(this.minima.x, this.minima.y, this.minima.z));
        for (Vector3f location : cornerLocations) {
            this.localToWorld.mult(location, location);
        }
        return cornerLocations;
    }

    public Quaternion localToWorld(Quaternion storeResult) {
        Quaternion result = storeResult == null ? this.localToWorld.clone() : storeResult.set(this.localToWorld);
        return result;
    }

    public Vector3f localToWorld(Vector3f local, Vector3f storeResult) {
        Validate.finite(local, "local");
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        this.localToWorld.mult(local, result);
        return result;
    }

    public Vector3f maxima(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.maxima.clone() : storeResult.set(this.maxima);
        return result;
    }

    public Vector3f minima(Vector3f storeResult) {
        Vector3f result = storeResult == null ? this.minima.clone() : storeResult.set(this.minima);
        return result;
    }

    public float volume() {
        float dx = this.maxima.x - this.minima.x;
        float dy = this.maxima.y - this.minima.y;
        float dz = this.maxima.z - this.minima.z;
        float volume = dx * dy * dz;
        assert (volume >= 0.0f) : volume;
        return volume;
    }

    public String toString() {
        String description = "RectangularSolid[" + this.localToWorld + ", min=" + this.minima + ", max=" + this.maxima + "]";
        return description;
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.localToWorld = (Quaternion)capsule.readSavable("localToWorld", null);
        this.maxima = (Vector3f)capsule.readSavable("maxima", null);
        this.minima = (Vector3f)capsule.readSavable("minima", null);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.localToWorld, "localToWorld", null);
        capsule.write((Savable)this.maxima, "maxima", null);
        capsule.write((Savable)this.minima, "minima", null);
    }
}

