/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math.noise;

import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.noise.Noise2;
import jme3utilities.math.noise.Permutation;

public class Perlin2
implements Noise2 {
    private static final Logger logger = Logger.getLogger(Perlin2.class.getName());
    private final Permutation permutation;
    private Vector2f[] gradients = null;

    public Perlin2(int period, int numGradients, long gSeed, long pSeed) {
        if (period < numGradients) {
            logger.log(Level.SEVERE, "period={0}, numGradients={1}", new Object[]{period, numGradients});
            String message = "period shouldn't be less than numGradients";
            throw new IllegalArgumentException(message);
        }
        Validate.inRange(numGradients, "number of gradients", 2, Integer.MAX_VALUE);
        this.generateGradients(numGradients, gSeed);
        this.permutation = new Permutation(period, pSeed);
    }

    @Override
    public float sample(float sampleX, float sampleY) {
        int squareX = (int)Math.floor(sampleX);
        int squareY = (int)Math.floor(sampleY);
        float n00 = this.gradient(squareX, squareY, sampleX, sampleY);
        float n01 = this.gradient(squareX, squareY + 1, sampleX, sampleY);
        float n10 = this.gradient(squareX + 1, squareY, sampleX, sampleY);
        float n11 = this.gradient(squareX + 1, squareY + 1, sampleX, sampleY);
        float fadeX = MyMath.fade(sampleX - (float)squareX);
        float nx0 = MyMath.lerp(fadeX, n00, n10);
        float nx1 = MyMath.lerp(fadeX, n01, n11);
        float fadeY = MyMath.fade(sampleY - (float)squareY);
        float result = MyMath.lerp(fadeY, nx0, nx1);
        return result;
    }

    @Override
    public float sampleNormalized(float sampleX, float sampleY) {
        float noise = this.sample(sampleX, sampleY);
        assert ((noise /= MyMath.rootHalf) >= -1.0f) : noise;
        assert (noise <= 1.0f) : noise;
        return noise;
    }

    private void generateGradients(int numGradients, long seed) {
        Validate.inRange(numGradients, "number of gradients", 2, Integer.MAX_VALUE);
        this.gradients = new Vector2f[numGradients];
        Random thetaGenerator = new Random(seed);
        for (int index = 0; index < numGradients; ++index) {
            float theta = thetaGenerator.nextFloat() * ((float)Math.PI * 2);
            float x = FastMath.cos((float)theta);
            float y = FastMath.sin((float)theta);
            this.gradients[index] = new Vector2f(x, y);
        }
    }

    private float gradient(int gridX, int gridY, double sampleX, double sampleY) {
        int index = this.permutation.permute(gridX + this.permutation.permute(gridY));
        index = MyMath.modulo(index, this.gradients.length);
        Vector2f gradient = this.gradients[index];
        float offsetX = (float)(sampleX - (double)gridX);
        float offsetY = (float)(sampleY - (double)gridY);
        float result = gradient.x * offsetX + gradient.y * offsetY;
        return result;
    }
}

