/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;

public class ClothGrid
extends Mesh {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(ClothGrid.class.getName());
    private int numXLines;
    private int numZLines;

    protected ClothGrid() {
    }

    public ClothGrid(int xLines, int zLines, float lineSpacing) {
        Validate.inRange(xLines, "X lines", 2, Integer.MAX_VALUE);
        Validate.inRange(zLines, "Z lines", 2, Integer.MAX_VALUE);
        Validate.positive(lineSpacing, "line spacing");
        this.numXLines = xLines;
        this.numZLines = zLines;
        int numVertices = xLines * zLines;
        FloatBuffer posBuffer = BufferUtils.createFloatBuffer((int)(3 * numVertices));
        this.setBuffer(VertexBuffer.Type.Position, 3, posBuffer);
        for (int xIndex = 0; xIndex < zLines; ++xIndex) {
            float x = (float)(2 * xIndex - zLines + 1) * lineSpacing / 2.0f;
            for (int zIndex = 0; zIndex < xLines; ++zIndex) {
                float z = (float)(2 * zIndex - xLines + 1) * lineSpacing / 2.0f;
                posBuffer.put(x).put(0.0f).put(z);
            }
        }
        assert (posBuffer.position() == 3 * numVertices);
        posBuffer.flip();
        FloatBuffer normBuffer = BufferUtils.createFloatBuffer((int)(3 * numVertices));
        this.setBuffer(VertexBuffer.Type.Normal, 3, normBuffer);
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            normBuffer.put(0.0f).put(1.0f).put(0.0f);
        }
        assert (normBuffer.position() == 3 * numVertices);
        normBuffer.flip();
        int numTriangles = 2 * (xLines - 1) * (zLines - 1);
        int numIndices = 3 * numTriangles;
        IndexBuffer indexBuffer = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        VertexBuffer.Format ibFormat = indexBuffer.getFormat();
        Buffer ibData = indexBuffer.getBuffer();
        this.setBuffer(VertexBuffer.Type.Index, 1, ibFormat, ibData);
        for (int zIndex = 0; zIndex < xLines - 1; ++zIndex) {
            for (int xIndex = 0; xIndex < zLines - 1; ++xIndex) {
                int vi0 = zIndex + xLines * xIndex;
                int vi1 = vi0 + 1;
                int vi2 = vi0 + xLines;
                int vi3 = vi1 + xLines;
                if ((xIndex + zIndex) % 2 == 0) {
                    indexBuffer.put(vi0);
                    indexBuffer.put(vi1);
                    indexBuffer.put(vi2);
                    indexBuffer.put(vi3);
                    indexBuffer.put(vi2);
                    indexBuffer.put(vi1);
                    continue;
                }
                indexBuffer.put(vi0);
                indexBuffer.put(vi1);
                indexBuffer.put(vi3);
                indexBuffer.put(vi3);
                indexBuffer.put(vi2);
                indexBuffer.put(vi0);
            }
        }
        ibData.flip();
        assert (indexBuffer.size() == numIndices);
        this.updateBound();
        this.setDynamic();
    }

    public void reposition(int xIndex, int zIndex, Vector3f location) {
        Validate.inRange(xIndex, "x index", 0, this.numZLines - 1);
        Validate.inRange(zIndex, "z index", 0, this.numXLines - 1);
        Validate.nonNull(location, "desired location");
        FloatBuffer positions = this.getFloatBuffer(VertexBuffer.Type.Position);
        int vertexIndex = zIndex + this.numXLines * xIndex;
        int floatIndex = 3 * vertexIndex;
        MyBuffer.put(positions, floatIndex, location);
    }

    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.numXLines = capsule.readInt("xLines", 12);
        this.numZLines = capsule.readInt("zLines", 12);
    }

    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.numXLines, "xLines", 12);
        capsule.write(this.numZLines, "zLines", 12);
    }
}

