/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Prism
extends Mesh {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(Prism.class.getName());

    protected Prism() {
    }

    public Prism(int numSides, float radius, float yHeight, boolean generateNormals) {
        Validate.inRange(numSides, "number of sides", 3, Integer.MAX_VALUE);
        Validate.positive(radius, "radius");
        Validate.positive(yHeight, "height");
        int numEndTriangles = 2 * (numSides - 2);
        int numSideTriangles = 2 * numSides;
        int numTriangles = numEndTriangles + numSideTriangles;
        int numFloats = numTriangles * 3 * 3;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        float y = yHeight / 2.0f;
        float interiorAngle = (float)Math.PI * 2 / (float)numSides;
        for (int sideIndex = 0; sideIndex < numSides; ++sideIndex) {
            float theta1 = (float)sideIndex * interiorAngle;
            float x1 = radius * FastMath.sin((float)theta1);
            float z1 = radius * FastMath.cos((float)theta1);
            int nextSideIndex = MyMath.modulo(sideIndex + 1, numSides);
            float theta2 = (float)nextSideIndex * interiorAngle;
            float x2 = radius * FastMath.sin((float)theta2);
            float z2 = radius * FastMath.cos((float)theta2);
            positionBuffer.put(x2).put(y).put(z2);
            positionBuffer.put(x1).put(y).put(z1);
            positionBuffer.put(x2).put(-y).put(z2);
            positionBuffer.put(x1).put(y).put(z1);
            positionBuffer.put(x1).put(-y).put(z1);
            positionBuffer.put(x2).put(-y).put(z2);
            if (sideIndex >= numSides - 2) continue;
            float theta3 = (float)(numSides - 1) * interiorAngle;
            float x3 = radius * FastMath.sin((float)theta3);
            float z3 = radius * FastMath.cos((float)theta3);
            positionBuffer.put(x1).put(y).put(z1);
            positionBuffer.put(x2).put(y).put(z2);
            positionBuffer.put(x3).put(y).put(z3);
            positionBuffer.put(x3).put(-y).put(z3);
            positionBuffer.put(x2).put(-y).put(z2);
            positionBuffer.put(x1).put(-y).put(z1);
        }
        positionBuffer.flip();
        assert (positionBuffer.limit() == positionBuffer.capacity());
        if (generateNormals) {
            MyMesh.generateNormals(this);
        }
        this.updateBound();
        this.setStatic();
    }

    public Prism(float x, float yHeight, float z) {
        Validate.positive(x, "x length");
        Validate.positive(yHeight, "height");
        Validate.positive(z, "z length");
        int numTriangles = 8;
        int numFloats = numTriangles * 3 * 3;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        float y = yHeight / 2.0f;
        positionBuffer.put(0.0f).put(y).put(0.0f);
        positionBuffer.put(0.0f).put(y).put(z);
        positionBuffer.put(x).put(y).put(0.0f);
        positionBuffer.put(0.0f).put(-y).put(0.0f);
        positionBuffer.put(x).put(-y).put(0.0f);
        positionBuffer.put(0.0f).put(-y).put(z);
        positionBuffer.put(x).put(y).put(0.0f);
        positionBuffer.put(0.0f).put(y).put(z);
        positionBuffer.put(0.0f).put(-y).put(z);
        positionBuffer.put(0.0f).put(-y).put(z);
        positionBuffer.put(x).put(-y).put(0.0f);
        positionBuffer.put(x).put(y).put(0.0f);
        positionBuffer.put(0.0f).put(y).put(0.0f);
        positionBuffer.put(x).put(y).put(0.0f);
        positionBuffer.put(x).put(-y).put(0.0f);
        positionBuffer.put(x).put(-y).put(0.0f);
        positionBuffer.put(0.0f).put(-y).put(0.0f);
        positionBuffer.put(0.0f).put(y).put(0.0f);
        positionBuffer.put(0.0f).put(y).put(z);
        positionBuffer.put(0.0f).put(y).put(0.0f);
        positionBuffer.put(0.0f).put(-y).put(0.0f);
        positionBuffer.put(0.0f).put(-y).put(0.0f);
        positionBuffer.put(0.0f).put(-y).put(z);
        positionBuffer.put(0.0f).put(y).put(z);
        positionBuffer.flip();
        assert (positionBuffer.limit() == positionBuffer.capacity());
        this.updateBound();
        this.setStatic();
    }
}

